/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pd.ui.embed;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.IEmbedX;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.RectEmbedment;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class EmbedXControl
extends RectEmbedment
implements IEmbedX {
    private static final Logger logger = LogUtil.getPackageLogger(EmbedXControl.class);
    static final int DRAG_INSETS_LEFT_OFFSET = 3;
    static final int DRAG_INSETS_RIGHT_OFFSET = 6;
    protected JComponent ui;
    protected boolean physical = true;

    public EmbedXControl(Sheet sheet) {
        super(sheet);
    }

    @Override
    public Component getPhysicalUI() {
        if (!this.physical) {
            return null;
        }
        return this.ui;
    }

    @Override
    public void setUIPhysical(boolean physical) {
        this.physical = physical;
    }

    @Override
    public void paintData(Graphics g) {
        if (this.physical) {
            return;
        }
        this.ui.setBounds(this._x + 3, this._y + 3, this._width - 6, this._height - 6);
        this.ui.doLayout();
        this.paintWithoutPeer(this.ui, g);
    }

    private void paintWithoutPeer(Component comp, Graphics g) {
        g.translate(comp.getX(), comp.getY());
        if (comp instanceof JComponent) {
            ((JComponent)comp).setDoubleBuffered(false);
        }
        comp.paint(g);
        if (comp instanceof Container) {
            Container conRef = (Container)comp;
            for (int i = conRef.getComponentCount() - 1; i >= 0; --i) {
                Component c = conRef.getComponent(i);
                if (!c.isVisible()) continue;
                this.paintWithoutPeer(c, g);
            }
        }
        g.translate(-comp.getX(), -comp.getY());
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX() - 1;
        int y = (int)((RectangularShape)bounds).getY() - 1;
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        g2d.setColor(Color.black);
        g2d.drawRect(x, y, 4, 4);
        g2d.drawRect(x, y + h / 2 - 1, 4, 4);
        g2d.drawRect(x, y + h - 1, 4, 4);
        g2d.drawRect(x + w / 2 - 1, y - 1, 4, 4);
        g2d.drawRect(x + w / 2 - 1, y + h - 1, 4, 4);
        g2d.drawRect(x + w - 1, y, 4, 4);
        g2d.drawRect(x + w - 1, y + h / 2 - 1, 4, 4);
        g2d.drawRect(x + w - 1, y + h - 1, 4, 4);
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString("1.0");
            out.writeBoolean(this.physical);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            is.readString();
            this.physical = is.readBoolean();
            is.close();
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }
}

