/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.beans.editor;

import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.AbstractPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.VFPair;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxPropertyEditor
extends AbstractPropertyEditor {
    private Object oldValue;
    private Icon[] icons;
    private String[] texts;
    private KDComboBox cb;
    private FormulaComposer formulaEditPanel = new FormulaComposer();
    private Class type;
    private ActionListener editorAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, ComboBoxPropertyEditor.this.cb.getSelectedItem());
        }
    };

    public ComboBoxPropertyEditor(Class type) {
        if (!VFPair.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Value should be an implementation of VFPair");
        }
        this.type = type;
        this.cb = new KDComboBox(){

            public void setSelectedItem(Object anObject) {
                ComboBoxPropertyEditor.this.oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        this.cb.setRenderer((ListCellRenderer)new Renderer());
        this.cb.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ComboBoxPropertyEditor.this.firePropertyChange(ComboBoxPropertyEditor.this.oldValue, ComboBoxPropertyEditor.this.cb.getSelectedItem());
                }
            }
        });
        this.cb.setSelectedIndex(-1);
        this.editor.addEditor((JComponent)this.cb);
        this.editor.addEditor((JComponent)((Object)this.formulaEditPanel));
    }

    public void setEditable(boolean editable) {
        this.cb.setEditable(editable);
        if (editable) {
            this.cb.getEditor().addActionListener(this.editorAction);
        } else {
            this.cb.getEditor().removeActionListener(this.editorAction);
        }
    }

    @Override
    public Object getValue() {
        Object v = null;
        try {
            v = this.type.newInstance();
            if (this.cb.isDisplayable()) {
                Object newValue = this.cb.getSelectedItem();
                if (newValue == null) {
                    newValue = (VFPair)this.oldValue;
                } else if (!(newValue instanceof VFPair)) {
                    ((VFPair)v).setValue(newValue);
                } else {
                    ((VFPair)v).setValue(((VFPair)newValue).getValue());
                }
            } else {
                ((VFPair)v).setFormula(this.formulaEditPanel.getFormula());
                ((VFPair)v).setGlobalFormula(this.editor.getClientProperty("GlobalFormula") != null);
            }
            return v;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (value.getClass() != this.type) {
                throw new IllegalArgumentException("The type of value doesn't comply with the init editor type.");
            }
            Object v = ((VFPair)value).getValue();
            if (v != null) {
                Object current = null;
                int index = -1;
                int c = this.cb.getModel().getSize();
                for (int i = 0; i < c; ++i) {
                    current = this.cb.getModel().getElementAt(i);
                    if (v == current) {
                        index = i;
                        break;
                    }
                    if (v == null || current == null || ((VFPair)current).getValue() == null || !((VFPair)current).getValue().equals(v)) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    this.cb.setSelectedItem(v);
                } else {
                    this.cb.setSelectedIndex(index);
                }
            } else {
                this.formulaEditPanel.setFormula(((VFPair)value).getFormula());
                this.editor.switchEditor();
            }
        }
    }

    public void setAvailableValues(Object[] values) {
        this.cb.setModel(new DefaultComboBoxModel<Object>(values));
    }

    public void setAvailableTexts(String[] texts) {
        this.texts = texts;
    }

    public void setAvailableIcons(Icon[] icons) {
        this.icons = icons;
    }

    public class Renderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (ComboBoxPropertyEditor.this.icons != null && index >= 0 && component instanceof JLabel) {
                ((JLabel)component).setIcon(ComboBoxPropertyEditor.this.icons[index]);
            }
            if (ComboBoxPropertyEditor.this.texts != null && index >= 0 && component instanceof JLabel) {
                ((JLabel)component).setText(ComboBoxPropertyEditor.this.texts[index]);
            }
            return component;
        }
    }
}

