/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.ui.SimpleDialog;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.extend.HyperlinkBehaviorAssembler;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.formula.FormulaComposer;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile.PhoneNumModel;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PhoneNumPropertyDialog
extends SimpleDialog {
    private KDExt ext;
    private FormulaComposer formulaComp;
    private HyperlinkBehaviorAssembler behaviorPanel;

    PhoneNumPropertyDialog(Frame parent) {
        super(parent);
        this.ext = (KDExt)((Object)parent);
    }

    protected void todoInit() {
        this.initComps();
        this.initListeners();
    }

    private void initComps() {
        String title = CtrlEXTMessages.getMLS("phoneNum", "\u7535\u8bdd\u8bc6\u522b");
        this.setSize(380, 400);
        this.setTitle(title);
        this.setResizable(true);
        this.setLocationRelativeTo(null);
        KDPanel parentPanel = new KDPanel();
        this.setComponent((Component)parentPanel);
        TableLayout2 layout = new TableLayout2(2, 1);
        layout.setRatableHeight(0, 2);
        layout.setRatableHeight(1, 8);
        layout.setRowSpacing(0, 10);
        parentPanel.setLayout((LayoutManager)layout);
        KDPanel topPanel = new KDPanel();
        topPanel.setCustomInsets(new Insets(5, 10, 5, 10));
        topPanel.setBorder((Border)new TitledBorder(""));
        layout = new TableLayout2(3, 1);
        layout.setRatableHeight(0, 1);
        layout.setFixedHeight(1, 20);
        layout.setRatableHeight(2, 1);
        layout.setRatableWidth(0, 1);
        topPanel.setLayout((LayoutManager)layout);
        KDLabelContainer labelCon = new KDLabelContainer();
        labelCon.setBoundLabelUnderline(true);
        labelCon.setBoundLabelLength(60);
        labelCon.setBoundLabelText(title);
        this.formulaComp = new FormulaComposer();
        labelCon.setBoundEditor((JComponent)((Object)this.formulaComp));
        topPanel.add((Component)labelCon, (Object)TableLayout2.param((int)1, (int)0));
        this.behaviorPanel = new HyperlinkBehaviorAssembler();
        this.behaviorPanel.setDescription(title);
        this.behaviorPanel.setBorder(new TitledBorder(""));
        parentPanel.add((Component)topPanel, (Object)TableLayout2.param((int)0, (int)0));
        parentPanel.add((Component)((Object)this.behaviorPanel), (Object)TableLayout2.param((int)1, (int)0));
    }

    private void initListeners() {
    }

    PhoneNumModel syncModelFromUI() {
        PhoneNumModel model = new PhoneNumModel();
        String formula = this.formulaComp.getFormula();
        if (StringUtil.isEmptyString((String)formula) || Boolean.FALSE.toString().equalsIgnoreCase(formula)) {
            return model;
        }
        model.setFormula(formula);
        Object[] targets = new Object[]{model};
        this.behaviorPanel.commit(targets, MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet().getActiveCell());
        return model;
    }

    void syncUIFromModel(PhoneNumModel model) {
        if (model == null) {
            return;
        }
        String formula = model.getFormula();
        if (StringUtil.isEmptyString((String)formula)) {
            return;
        }
        this.formulaComp.setFormula(model.getFormula());
        if (Boolean.FALSE.toString().equalsIgnoreCase(formula)) {
            return;
        }
        Object[] targets = new Object[]{model};
        this.behaviorPanel.syncSettings(targets, MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet().getActiveCell());
    }
}

