/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.beans.renderer;

import com.kingdee.cosmic.ctrl.ext.pe.beans.renderer.DefaultCellRenderer;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ColorCellRenderer
extends DefaultCellRenderer {
    private PaintIcon iconCache = new PaintIcon(null);

    public static String toHex(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return ("#" + red + green + blue).toUpperCase(Locale.ENGLISH);
    }

    @Override
    protected String convertToString(Object value) {
        if (!(value instanceof ColorVFPair)) {
            return null;
        }
        Color color = (Color)((ColorVFPair)value).getValue();
        StringBuilder sb = new StringBuilder();
        sb.append("R:");
        sb.append(color.getRed());
        sb.append(" G:");
        sb.append(color.getGreen());
        sb.append(" B:");
        sb.append(color.getBlue());
        return sb.toString();
    }

    @Override
    protected Icon convertToIcon(Object value) {
        if (value == null) {
            return null;
        }
        this.iconCache.setPaint((Paint)((ColorVFPair)value).getValue());
        return this.iconCache;
    }

    public static class PaintIcon
    implements Icon {
        private Paint color;
        private final int width;
        private final int height;

        public PaintIcon(Paint color) {
            this(color, 20, 10);
        }

        public PaintIcon(Paint color, int width, int height) {
            this.color = color;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        public void setPaint(Paint paint) {
            this.color = paint;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            if (this.color != null) {
                g2d.setPaint(this.color);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g2d.setPaint(oldPaint);
        }
    }
}

