/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.propsheet;

import com.kingdee.cosmic.ctrl.ext.pe.beans.ExtendedPropertyDescriptor;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.AbstractProperty;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PropertyDescriptorAdapter
extends AbstractProperty {
    private PropertyDescriptor descriptor;

    public PropertyDescriptorAdapter() {
    }

    public PropertyDescriptorAdapter(PropertyDescriptor descriptor) {
        this();
        this.setDescriptor(descriptor);
    }

    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    @Override
    public Class getType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    public Object clone() {
        PropertyDescriptorAdapter clone = new PropertyDescriptorAdapter(this.descriptor);
        clone.setValue(this.getValue());
        return clone;
    }

    @Override
    public void readFromObject(Object object) {
        this.readFromObject(object, true);
    }

    @Override
    public void readFromObject(Object object, boolean fireEvent) {
        try {
            Method method = this.descriptor.getReadMethod();
            if (method != null) {
                this.setValue(method.invoke(object, null), fireEvent);
            }
        }
        catch (Exception e) {
            String message = "Got exception when reading property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public void writeToObject(Object object) {
        try {
            Method method = this.descriptor.getWriteMethod();
            if (method != null) {
                method.invoke(object, this.getValue());
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof PropertyVetoException) {
                throw new RuntimeException(((InvocationTargetException)e).getTargetException());
            }
            String message = "Got exception when writing property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public boolean isEditable() {
        return ((ExtendedPropertyDescriptor)this.descriptor).isEditable();
    }

    @Override
    public String getCategory() {
        if (this.descriptor instanceof ExtendedPropertyDescriptor) {
            return ((ExtendedPropertyDescriptor)this.descriptor).getCategory();
        }
        return null;
    }
}

