/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd;

import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ImageIcon;

class CellArrowRender
implements IBasicRender {
    private ImageIcon arrowD = ResourceManager.getImageIcon("arrowd_1.gif");
    private ImageIcon arrowDR = ResourceManager.getImageIcon("arrowd_2.gif");
    private ImageIcon arrowR = ResourceManager.getImageIcon("arrowr_1.gif");
    private ImageIcon arrowRR = ResourceManager.getImageIcon("arrowr_2.gif");

    CellArrowRender() {
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof Cell) {
            Cell cell = (Cell)object;
            boolean selected = cell.getSheet().getActiveCell() == cell;
            ExtProps ep = cell.getExtProps(false);
            if (ep == null || ep.getExtensible(false) != 2 && ep.getExtensible(false) != 1) {
                return;
            }
            CellBlock block = cell.getSheet().getMergeBlock(cell);
            if (block != null) {
                Rectangle _bufRect = new Rectangle();
                SheetBaseMath.getBlockRect(cell.getSheet(), block, false, _bufRect);
                clip = _bufRect;
            }
            Rectangle r = clip.getBounds();
            graphics.translate(r.x + r.width - 6, r.y - 3);
            if (ep.getExtensible(false) == 1) {
                if (!selected) {
                    graphics.drawImage(this.arrowR.getImage(), -1, 1, null);
                } else {
                    graphics.drawImage(this.arrowRR.getImage(), -1, 1, null);
                }
            } else if (!selected) {
                graphics.drawImage(this.arrowD.getImage(), 1, 1, null);
            } else {
                graphics.drawImage(this.arrowDR.getImage(), 1, 1, null);
            }
            graphics.translate(-(r.x + r.width - 6), -r.y + 3);
        }
    }
}

