/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.rd.model.style.StyleScheme;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SmallIconPanel
extends KDPanel {
    private boolean isSelected;
    private StyleScheme styleScheme;

    public SmallIconPanel(StyleScheme styleScheme) {
        this.styleScheme = styleScheme;
        KDLabel labelImg = new KDLabel();
        labelImg.setToolTipText(null);
        Image img = styleScheme.getSmallImage();
        if (img == null) {
            labelImg.setText(CtrlEXTMessages.getMLS("failedToLoadImage", "\u52a0\u8f7d\u56fe\u7247\u5931\u8d25"));
        } else {
            labelImg.setIcon((Icon)new ImageIcon(img));
        }
        labelImg.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.setSource((Object)SmallIconPanel.this);
                SmallIconPanel.this.processMouseEvent(e);
            }
        });
        this.setCustomInsets(new Insets(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)labelImg, "Center");
    }

    public StyleScheme getStyleScheme() {
        return this.styleScheme;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void refreshSelected(boolean selected) {
        if (!selected) {
            this.setSelected(false);
            this.setBackground(null);
        } else {
            this.setSelected(selected);
            this.setBackground(Color.CYAN);
        }
    }
}

