/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.Cell2UpdateConstraintMap;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.DeleteDataPlanCreator;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManagerLoader;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManagerSaver;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.InsertDataPlanCreator;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.UpdateDataPlanCreator;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.component.CommitablePlanDialog;
import com.kingdee.cosmic.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.cosmic.ctrl.ext.reporting.model.ValueEditorType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.editor.ExtReportingEditorManager;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.editor.IRuntimeEditorDefine;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ExtReportingDirtyManager {
    public static final String EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY = "EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY";
    private static final Logger logger = Logger.getLogger(ExtReportingDirtyManager.class);
    private TemplateMap _map = new TemplateMap();
    Cell2UpdateConstraintMap _cell2ConstraintMap;
    Book _book;
    ArrayList _records = new ArrayList();
    ArrayList _commitResults = new ArrayList();

    public ExtReportingDirtyManager(Book book) {
        this._book = book;
        this.initData();
        try {
            this.load();
        }
        catch (ExtReportingBizException ex) {
            logger.error((Object)"error ocurred when loading dirtyManager", (Throwable)ex);
        }
    }

    private void initData() {
        if (MiscUtil.isExecutedBook(this._book)) {
            this._cell2ConstraintMap = new Cell2UpdateConstraintMap();
            IReportingModel model = this._book.getReportingModel();
            if (model == null) {
                return;
            }
            IUpdateConstraint[] updateConstraintList = model.getUpdateConstraintList();
            if (updateConstraintList != null) {
                for (int i = 0; i < updateConstraintList.length; ++i) {
                    IUpdateConstraint constraint = updateConstraintList[i];
                    List usedCellList = constraint.getUsedCellList(false);
                    for (int j = 0; j < usedCellList.size(); ++j) {
                        Cell cell = (Cell)usedCellList.get(j);
                        this._cell2ConstraintMap.put(cell, constraint);
                    }
                }
            }
            this._cell2ConstraintMap.trim2Size();
        }
    }

    public Cell2UpdateConstraintMap getRef() {
        return this._cell2ConstraintMap;
    }

    public void save() throws ExtReportingBizException {
        new ExtReportingDirtyManagerSaver().save(this);
    }

    public void load() throws ExtReportingBizException {
        new ExtReportingDirtyManagerLoader().load(this);
    }

    public void addUpdateDataPlan(Cell hotSpot) {
        new UpdateDataPlanCreator(this).addUpdateDataPlan(hotSpot);
    }

    public void addInsertDataPlan(Cell hotSpot) {
        new InsertDataPlanCreator(this).addInsertDataPlan(hotSpot);
    }

    public void addDeleteDataPlan(Cell hotSpot) {
        new DeleteDataPlanCreator(this).addDeleteDataPlan(hotSpot);
    }

    public void commit() {
        ExecutionPlan[] plans = this.getAllExecutionPlans();
        if (plans != null) {
            for (int i = 0; i < plans.length; ++i) {
                if (plans[i].isLoaded()) continue;
                plans[i].generateSQL();
            }
            List results = ReportingFactory.fetchRuntimeProvider().commitEdit(plans, this._book.getReportingModel().isFastInvalid());
            if (results != null) {
                this._commitResults.addAll(results);
                this.clear();
            }
        }
    }

    public void showExecutionLogManagerDialog(SpreadContext context) {
        CommitablePlanDialog dialog = CommitablePlanDialog.getInstance(context);
        dialog.load(this.getAllExecutionPlans(), this._commitResults.toArray(new CommitResult[0]));
        dialog.show();
    }

    private void clear() {
        this._records.clear();
    }

    private ExecutionPlan[] getAllExecutionPlans() {
        if (this._records == null) {
            return null;
        }
        return this._records.toArray(new ExecutionPlan[0]);
    }

    public Cell[] findAllBrotherCells(int rowOffset, int colOffset, List allSrcCell) {
        Cell[] ret = new Cell[allSrcCell.size()];
        for (int i = 0; i < allSrcCell.size(); ++i) {
            Cell newCll;
            Cell srcCll = (Cell)allSrcCell.get(i);
            int rowIndex = srcCll.getRow() + rowOffset;
            int colIndex = srcCll.getCol() + colOffset;
            Sheet sheet = srcCll.getSheet();
            ret[i] = newCll = sheet.getCell(rowIndex, colIndex, true);
        }
        return ret;
    }

    public ExecutionPlan searchSameRecord(Cell[] all) {
        SortedCellBlockArray array = new SortedCellBlockArray();
        for (int j = 0; j < all.length; ++j) {
            array.insert(CellBlock.getCellBlock(all[j].getRow(), all[j].getCol()));
        }
        block1: for (int i = 0; i < this._records.size(); ++i) {
            ExecutionPlan r = (ExecutionPlan)this._records.get(i);
            Cell[] cells = r.getUsedCells();
            if (cells.length != all.length) continue;
            for (int j = 0; j < all.length; ++j) {
                if (!array.contains(CellBlock.getCellBlock(cells[j].getRow(), cells[j].getCol()))) continue block1;
            }
            return r;
        }
        return null;
    }

    public void refreshEmpty() {
        IReportingModel model = this._book.getReportingModel();
        if (model == null || !model.isEnabled()) {
            return;
        }
        try {
            for (int i = 0; i < this._book.getSheetCount(); ++i) {
                Sheet sheet = this._book.getSheet(i);
                ValidationList vList = sheet.getValidations();
                for (int j = 0; j < vList.size(); ++j) {
                    Validation validation = vList.getValidation(j);
                    if (!validation.isReportingValidation()) continue;
                    SortedCellBlockArray array = validation.getBlocks();
                    for (int k = 0; k < array.size(); ++k) {
                        boolean b;
                        IEditorDefine editorDefine;
                        IRuntimeEditorDefine define;
                        int col;
                        int row = array.getBlock(k).getRow();
                        Cell cell = sheet.getCell(row, col = array.getBlock(k).getCol(), true);
                        if (!StringUtil.isEmptyString((String)cell.getFormula()) || cell.getValue() == null || (define = (editorDefine = validation.getEditorDefine()).generateRuntimeEditorDefine()) == null || editorDefine.getValueEditorType() != ValueEditorType.PKGENERATOR) continue;
                        define.createEditor();
                        define.prepareToShow(sheet, row, col);
                        String commitFormula = define.getCommitFormula();
                        MessagedValidate mv = validation.getMessagedValidate();
                        boolean bl = b = commitFormula == null || mv == null || mv.isValidated(sheet, commitFormula) || mv.isErrorHide();
                        if (b && !StringUtil.isEmptyString((String)commitFormula)) {
                            define.commitValue();
                        }
                        ExtReportingEditorManager.applyText(editorDefine, sheet, row, col);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"-------------------failed to refresh reporting cells-------------------", (Throwable)ex);
        }
    }

    public CellBlock[] getReportingTemplateCellBlock(ExtProps reportingProps) {
        return this._map.get(reportingProps);
    }

    public void offsetReportingTemplateCellBlock(Sheet activeSheet, boolean yDir) {
        int len = this._map._propsArray.size();
        for (int i = 0; i < len; ++i) {
            int j;
            CellBlock[] blocks;
            ExtProps reportingProps = (ExtProps)this._map._propsArray.get(i);
            Cell cell = reportingProps.getCell();
            reportingProps.clearSubsBounds();
            if (cell == null || activeSheet != cell.getSheet() || (blocks = this._map.get(reportingProps)) == null) continue;
            if (yDir) {
                int row = reportingProps.getSubsBound().getRow();
                for (j = 0; j < blocks.length; ++j) {
                    int srcRow = blocks[j].getRow();
                    if (srcRow == row) continue;
                    blocks[j].setRow(row);
                    blocks[j].setRow2(blocks[j].getRow2() + row - srcRow);
                }
                continue;
            }
            int col = reportingProps.getSubsBound().getCol();
            for (j = 0; j < blocks.length; ++j) {
                int srcCol = blocks[j].getCol();
                if (srcCol == col) continue;
                blocks[j].setCol(col);
                blocks[j].setRow2(blocks[j].getCol2() + col - srcCol);
            }
        }
    }

    public void refreshReportingTemplateCellBlock(ExtProps reportingProps, int rowExtend, int colExtend) {
        CellBlock[] blocks = this._map.get(reportingProps);
        if (blocks != null && blocks.length > 0) {
            for (int i = 0; i < blocks.length; ++i) {
                if (rowExtend != 0) {
                    blocks[i].setRow(blocks[i].getRow() + rowExtend);
                    blocks[i].setRow2(blocks[i].getRow2() + rowExtend);
                }
                if (colExtend == 0) continue;
                blocks[i].setCol(blocks[i].getCol() + colExtend);
                blocks[i].setCol2(blocks[i].getCol2() + colExtend);
            }
        }
    }

    public void addReportingTemplateCellBlock(ExtProps reportingProps) {
        this._map.put(reportingProps);
    }

    public void copyResults(ExtReportingDirtyManager manager) {
        this._commitResults.addAll(manager._commitResults);
    }

    public void merge(ExtReportingDirtyManager dirtyManager) throws ExtReportingBizException {
        if (dirtyManager == null) {
            return;
        }
        for (ExecutionPlan plan : dirtyManager._records) {
            plan = plan.getBookDetachedCopy();
            plan.tagMerge();
            this._records.add(plan);
        }
        this._commitResults.addAll(dirtyManager._commitResults);
    }

    private static class TemplateMap {
        private ArrayList _propsArray = new ArrayList();
        private ArrayList _templatesArray = new ArrayList();

        private TemplateMap() {
        }

        void put(ExtProps reportingProps) {
            this._propsArray.add(reportingProps);
            CellBlock templateCB = reportingProps.getSubsBound();
            reportingProps.clearSubsBounds();
            SortedExtPropsArray subs = reportingProps.getSubs();
            ArrayList<CellBlock> templateList = new ArrayList<CellBlock>();
            templateList.add(templateCB);
            if (subs != null) {
                int len = subs.size();
                for (int i = 0; i < len; ++i) {
                    ExtProps sub = (ExtProps)subs.get(i);
                    if (!sub.isReportingGroupRootProps()) continue;
                    templateList.add(sub.getSubsBound());
                    sub.clearSubsBounds();
                }
            }
            this._templatesArray.add(templateList);
        }

        CellBlock[] get(ExtProps reportingProps) {
            int index = this._propsArray.indexOf(reportingProps);
            if (index >= 0) {
                ArrayList templateList = (ArrayList)this._templatesArray.get(index);
                CellBlock[] ret = new CellBlock[templateList.size()];
                templateList.toArray(ret);
                return ret;
            }
            return null;
        }
    }
}

