/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.cosmic.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.cosmic.ctrl.ext.util.VariantUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import java.util.Iterator;

public class ExtReportingDirtyManagerSaver {
    public void save(ExtReportingDirtyManager manager) throws ExtReportingBizException {
        IXmlElement root = XmlUtil.createNode((String)"ExtReportingDirtyManager");
        IXmlElement recodes = XmlUtil.createNode((String)"Recodes");
        root.addChild(recodes);
        if (manager._records != null) {
            Iterator iter = manager._records.iterator();
            while (iter.hasNext()) {
                IXmlElement recode = XmlUtil.createNode((String)"Recode");
                ExecutionPlan plan = (ExecutionPlan)iter.next();
                recode.setAttribute("constraintName", plan.getConstraintName());
                recode.setAttribute("identityKey", plan.getIdentityKey());
                recode.setAttribute("className", plan.getClass().getName());
                Cell[] cellList = plan.getUsedCells();
                if (cellList != null) {
                    for (int i = 0; i < cellList.length; ++i) {
                        IXmlElement cell = XmlUtil.createNode((String)"Cell");
                        cell.setAttribute("sheetName", cellList[i].getSheet().getSheetName());
                        cell.setAttribute("rowIndex", String.valueOf(cellList[i].getRow()));
                        cell.setAttribute("colIndex", String.valueOf(cellList[i].getCol()));
                        Variant value = cellList[i].getValue();
                        cell.setAttribute("valueType", String.valueOf(VariantUtil.parseVariantType(value)));
                        cell.setAttribute("value", VariantUtil.variant2PlainString(value));
                        recode.addChild(cell);
                    }
                }
                recodes.addChild(recode);
                if (!plan.isLoaded()) {
                    plan.generateSQL();
                }
                recode.setAttribute("sqlContent", plan.getSQL());
                Variant[] commitValues = plan.getValues();
                int[] jdbcTypes = plan.getJdbcTypes();
                for (int i = 0; i < commitValues.length; ++i) {
                    IXmlElement commitValue = XmlUtil.createNode((String)"CommitValue");
                    Variant value = commitValues[i];
                    commitValue.setAttribute("valueType", String.valueOf(VariantUtil.parseVariantType(value)));
                    commitValue.setAttribute("value", VariantUtil.variant2PlainString(value));
                    commitValue.setAttribute("jdbcType", String.valueOf(jdbcTypes[i]));
                    recode.addChild(commitValue);
                }
            }
        }
        IXmlElement results = XmlUtil.createNode((String)"Results");
        root.addChild(results);
        if (manager._commitResults != null) {
            Iterator iter = manager._commitResults.iterator();
            while (iter.hasNext()) {
                IXmlElement result = XmlUtil.createNode((String)"Result");
                CommitResult cr = (CommitResult)iter.next();
                result.setAttribute("className", cr.getClass().getName());
                result.setAttribute("identityKey", cr.getIdentityKey());
                result.setAttribute("level", cr.getLevel());
                result.addCData(cr.getResult());
                results.addChild(result);
            }
        }
        try {
            manager._book.setUserObject("EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY", XmlUtil.toString((IXmlElement)root));
        }
        catch (Throwable cause) {
            throw new ExtReportingBizException("error ocurred during saving dirty manager", cause);
        }
    }
}

