/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.model.design.validation;

import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;

public class ErrorTextPanel
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private final String message_heading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_heading", "\u8f93\u5165\u65e0\u6548\u6570\u636e\u65f6\u663e\u793a\u51fa\u9519\u8b66\u544a");
    private final String message_subheading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_subheading", "\u8f93\u5165\u65e0\u6548\u6570\u636e\u65f6\u663e\u793a\u4e0b\u5217\u51fa\u9519\u8b66\u544a");
    private final String message_title = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_title", "\u6807\u9898");
    private final String message_content = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_content", "\u9519\u8bef\u4fe1\u606f");
    private final String message_style = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_style", "\u6837\u5f0f");
    private final String message_stopstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_stopstyle", "\u505c\u6b62");
    private final String message_warningstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_warningstyle", "\u8b66\u544a");
    private final String message_informationstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_informationstyle", "\u4fe1\u606f");
    private KDCheckBox _ckbHeading;
    private KDLabel _lbSubheading;
    private KDLabel _lbTitle;
    private KDLabel _lbContent;
    private KDTextField _tfTitle;
    private KDScrollPane _scrollPane;
    private KDTextArea _taContent;
    private KDLabel _lbStyle;
    private KDComboBox _cbStyle;
    private KDLabel _lbIconStyle;
    private ItemListener _ckbActionListener;
    private ItemListener _cbActionListener;

    public ErrorTextPanel() {
        this.initComps();
        this.initListeners();
        this.layoutComps();
    }

    private void initComps() {
        this._ckbHeading = new KDCheckBox(this.message_heading);
        this._lbSubheading = new KDLabel(this.message_subheading + ":");
        this._lbTitle = new KDLabel(this.message_title + ":");
        this._lbContent = new KDLabel(this.message_content + ":");
        this._tfTitle = new KDTextField();
        this._taContent = new KDTextArea();
        this._scrollPane = new KDScrollPane((Component)this._taContent);
        this._lbStyle = new KDLabel(this.message_style + ":");
        this._cbStyle = new KDComboBox();
        this._cbStyle.addItem((Object)this.message_stopstyle);
        this._cbStyle.addItem((Object)this.message_warningstyle);
        this._cbStyle.addItem((Object)this.message_informationstyle);
        this._lbIconStyle = new KDLabel((Icon)ResourceManager.getImageIcon("validate_stop.gif"));
        this._ckbHeading.setSelected(true);
        this.add((Component)this._ckbHeading);
        this.add((Component)this._lbSubheading);
        this.add((Component)this._lbTitle);
        this.add((Component)this._lbContent);
        this.add((Component)this._tfTitle);
        this.add((Component)this._scrollPane);
        this.add((Component)this._lbStyle);
        this.add((Component)this._cbStyle);
        this.add((Component)this._lbIconStyle);
    }

    private void initListeners() {
        this._ckbActionListener = new CheckBoxItemListener();
        this._ckbHeading.addItemListener(this._ckbActionListener);
        this._cbActionListener = new ComboBoxItemListener();
        this._cbStyle.addItemListener(this._cbActionListener);
    }

    private void layoutComps() {
        this.setLayout(null);
        this._ckbHeading.setBounds(5, 5, 300, 20);
        this._lbSubheading.setBounds(10, 30, 300, 20);
        this._lbStyle.setBounds(20, 55, 100, 20);
        this._cbStyle.setBounds(20, 80, 100, 20);
        this._lbIconStyle.setBounds(40, 125, 34, 34);
        this._lbTitle.setBounds(130, 55, 290, 20);
        this._tfTitle.setBounds(130, 80, 290, 20);
        this._lbContent.setBounds(130, 105, 290, 20);
        this._scrollPane.setBounds(130, 130, 290, 100);
    }

    public void updatePanelByValidate(MessagedValidate mv) {
        if (mv != null) {
            this._ckbHeading.setSelected(!mv.isErrorHide());
            this._cbStyle.setSelectedIndex(mv.getErrorStyle() == MessagedValidate.STOP_STYLE ? 0 : (mv.getErrorStyle() == MessagedValidate.WARNING_STYLE ? 1 : 2));
            this._tfTitle.setText(mv.getErrorTitle());
            this._taContent.setText(mv.getErrorMessage());
        } else {
            this._ckbHeading.setSelected(true);
            this._cbStyle.setSelectedIndex(0);
            this._tfTitle.setText("");
            this._taContent.setText("");
        }
    }

    public void updateValidate(MessagedValidate validate, Sheet activeSheet) {
        if (validate == null) {
            return;
        }
        validate.setErrorHide(!this._ckbHeading.isSelected());
        switch (this._cbStyle.getSelectedIndex()) {
            case 0: {
                validate.setErrorStyle(MessagedValidate.STOP_STYLE);
                break;
            }
            case 1: {
                validate.setErrorStyle(MessagedValidate.WARNING_STYLE);
                break;
            }
            case 2: {
                validate.setErrorStyle(MessagedValidate.INFORMATION_STYLE);
                break;
            }
        }
        validate.setErrorTitle(this._tfTitle.getText());
        validate.setErrorMessage(this._taContent.getText());
    }

    public boolean isEmptyValidate() {
        return this._tfTitle.getText().equals("") && this._taContent.getText().equals("") && this._cbStyle.getSelectedIndex() == 0 && this._ckbHeading.isSelected();
    }

    private class ComboBoxItemListener
    implements ItemListener {
        private ComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getItem().equals(ErrorTextPanel.this.message_warningstyle)) {
                    ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_warning.gif"));
                } else if (e.getItem().equals(ErrorTextPanel.this.message_informationstyle)) {
                    ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_information.gif"));
                } else if (e.getItem().equals(ErrorTextPanel.this.message_stopstyle)) {
                    ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_stop.gif"));
                }
            }
        }
    }

    private class CheckBoxItemListener
    implements ItemListener {
        private CheckBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ErrorTextPanel.this._tfTitle.setEnabled(true);
                ErrorTextPanel.this._taContent.setEnabled(true);
                ErrorTextPanel.this._cbStyle.setEnabled(true);
                ErrorTextPanel.this._lbIconStyle.setVisible(true);
            } else {
                ErrorTextPanel.this._tfTitle.setEnabled(false);
                ErrorTextPanel.this._taContent.setEnabled(false);
                ErrorTextPanel.this._cbStyle.setEnabled(false);
                ErrorTextPanel.this._lbIconStyle.setVisible(false);
            }
        }
    }
}

