/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.propety.PropsSynchronizer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.List;
import org.apache.log4j.Logger;

public class CommonPropsSynchronizer
implements PropsSynchronizer {
    private static final Logger logger = LogUtil.getPackageLogger(CommonPropsSynchronizer.class);

    @Override
    public void sync2Model(AbstractFusionBean bean, FusionChartDataNode node) {
        node.setColorXML(bean.getChartColorTemplate().getXmlValue());
        node.setNumberFormatXML(bean.getChartNumberFormat().getXmlValue());
        StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='gbk'?><template>");
        sb.append("<x type='max' value='");
        String value = bean.getChartXStartValue();
        sb.append(value == null ? "" : value);
        sb.append("'/>");
        sb.append("<x type='min' value='");
        value = bean.getChartXEndValue();
        sb.append(value == null ? "" : value);
        sb.append("'/>");
        sb.append("<y type='max' value='");
        value = bean.getChartYStartValue();
        sb.append(value == null ? "" : value);
        sb.append("'/>");
        sb.append("<y type='min' value='");
        value = bean.getChartYEndValue();
        sb.append(value == null ? "" : value);
        sb.append("'/>");
        sb.append("<y type='unit' value='");
        value = bean.getChartYScaleUnit();
        if (StringUtil.isEmptyString((String)value) || value.trim().equals("0") || value.trim().startsWith("-")) {
            value = "";
        }
        sb.append(value);
        sb.append("'/>");
        sb.append("</template>");
        node.setXyRestrictionXML(sb.toString());
        this.setFormula(bean, node);
    }

    private void setFormula(AbstractFusionBean bean, FusionChartDataNode node) {
        String[] types = new String[5];
        String value = bean.getChartXStartValue();
        if (!StringUtil.isEmptyString((String)value)) {
            types[0] = value;
        }
        if (!StringUtil.isEmptyString((String)(value = bean.getChartXEndValue()))) {
            types[1] = value;
        }
        if (!StringUtil.isEmptyString((String)(value = bean.getChartYStartValue()))) {
            types[2] = value;
        }
        if (!StringUtil.isEmptyString((String)(value = bean.getChartYEndValue()))) {
            types[3] = value;
        }
        if (!StringUtil.isEmptyString((String)(value = bean.getChartYScaleUnit()))) {
            types[4] = value;
        }
        node.setFormula(types, FusionChartDataNode.XY_MAX_MIN);
    }

    @Override
    public void loadFromModel(AbstractFusionBean bean, FusionChartDataNode node) {
        bean.getChartColorTemplate().setXmlValue(node.getColorXML());
        bean.getChartNumberFormat().setXmlValue(node.getNumberFormatXML());
        String xyResitriction = node.getXyRestrictionXML();
        try {
            IXmlElement root = XmlUtil.loadXmlString((String)xyResitriction);
            List children = root.getChildren();
            for (Object obj : children) {
                if (!(obj instanceof IXmlElement)) continue;
                IXmlElement next = (IXmlElement)obj;
                String name = next.getName();
                String value = next.getAttribute("value");
                String valueType = next.getAttribute("type");
                if (StringUtil.isEmptyString((String)value)) continue;
                if ("x".equals(name)) {
                    if ("max".equals(valueType)) {
                        bean.setChartXStartValue(value);
                        continue;
                    }
                    bean.setChartXEndValue(value);
                    continue;
                }
                if ("max".equals(valueType)) {
                    bean.setChartYStartValue(value);
                    continue;
                }
                if ("min".equals(valueType)) {
                    bean.setChartYEndValue(value);
                    continue;
                }
                if (!"unit".equals(valueType)) continue;
                bean.setChartYScaleUnit(value);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }
}

