/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.AbstractFusionBeanPropertyEditor;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDatePicker;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class GanttGroupChooserEditor
extends AbstractFusionBeanPropertyEditor {
    KDPanel panel;
    private KDComboBox timeCombo = new KDComboBox((Object[])new String[]{CtrlEXTMessages.getMLS("yearMonthCombination", "\u5e74-\u6708\u7ec4\u5408"), CtrlEXTMessages.getMLS("yearQuarterCombination", "\u5e74-\u5b63\u5ea6\u7ec4\u5408"), CtrlEXTMessages.getMLS("yearWeekCombination", "\u5e74-\u5468\u7ec4\u5408"), CtrlEXTMessages.getMLS("quarterMonthCombination", "\u5b63\u5ea6-\u6708\u7ec4\u5408"), CtrlEXTMessages.getMLS("monthDayCombination", "\u6708-\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("weekDayCombination", "\u5468-\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("dayHourCombination", "\u65e5-\u5c0f\u65f6\u7ec4\u5408"), CtrlEXTMessages.getMLS("yearQuarterMonthCombination", "\u5e74-\u5b63\u5ea6-\u6708\u7ec4\u5408"), CtrlEXTMessages.getMLS("yearMonthDayCombination", "\u5e74-\u6708-\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("quarterMonthDayCombination", "\u5b63\u5ea6-\u6708-\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("monthWeekDayCombination", "\u6708-\u5468-\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("yearCombination", "\u5e74\u7ec4\u5408"), CtrlEXTMessages.getMLS("quarterCombination", "\u5b63\u5ea6\u7ec4\u5408"), CtrlEXTMessages.getMLS("monthCombination", "\u6708\u7ec4\u5408"), CtrlEXTMessages.getMLS("dayCombination", "\u65e5\u7ec4\u5408"), CtrlEXTMessages.getMLS("hourCombination", "\u5c0f\u65f6\u7ec4\u5408")});
    private KDLabelContainer comboContainer = new KDLabelContainer(CtrlEXTMessages.getMLS("headerGroupSelection", "\u8868\u5934\u5206\u7ec4\u9009\u62e9"), (JComponent)this.timeCombo);
    private KDCheckBox yearBox;
    private KDCheckBox seasonBox;
    private KDCheckBox monthBox;
    private KDCheckBox weekBox;
    private KDCheckBox dayBox;
    private KDCheckBox hourBox;
    private KDDatePicker start;
    private KDDatePicker end;
    private KDLabelContainer startContainer;
    private KDLabelContainer endContainer;
    private KDLabelContainer forceContainer;
    private KDButton confirm;
    private KDButton cancle;
    private KDWorkButton button;
    private KDCheckBox force;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-d");
    private KDTextField field;

    public GanttGroupChooserEditor() {
        this.panel = new KDPanel();
        this.yearBox = new KDCheckBox(CtrlEXTMessages.getMLS("year", "\u5e74"));
        this.seasonBox = new KDCheckBox(CtrlEXTMessages.getMLS("quarter", "\u5b63\u5ea6"));
        this.monthBox = new KDCheckBox(CtrlEXTMessages.getMLS("month", "\u6708"));
        this.monthBox.setSelected(true);
        this.weekBox = new KDCheckBox(CtrlEXTMessages.getMLS("week", "\u5468"));
        this.weekBox.setSelected(true);
        this.dayBox = new KDCheckBox(CtrlEXTMessages.getMLS("day", "\u65e5"));
        this.hourBox = new KDCheckBox(CtrlEXTMessages.getMLS("hour", "\u5c0f\u65f6"));
        this.force = new KDCheckBox();
        this.forceContainer = new KDLabelContainer(CtrlEXTMessages.getMLS("fixedHeaderTime", "\u662f\u5426\u56fa\u5b9a\u8868\u5934\u65f6\u95f4:   "), (JComponent)this.force);
        this.force.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enable = GanttGroupChooserEditor.this.force.isSelected();
                GanttGroupChooserEditor.this.start.setEnabled(enable);
                GanttGroupChooserEditor.this.end.setEnabled(enable);
            }
        });
        this.force.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.forceContainer.setBoundLabelUnderline(true);
        this.editor.add((Component)this.panel);
        this.button = new KDWorkButton();
        this.start = new KDDatePicker();
        this.startContainer = new KDLabelContainer(CtrlEXTMessages.getMLS("startTime2", "\u8d77\u59cb\u65f6\u95f4:    "), (JComponent)this.start);
        this.startContainer.setBoundLabelUnderline(true);
        this.confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this.end = new KDDatePicker();
        this.endContainer = new KDLabelContainer(CtrlEXTMessages.getMLS("endTime2", "\u7ed3\u675f\u65f6\u95f4:    "), (JComponent)this.end);
        this.endContainer.setBoundLabelUnderline(true);
        this.button.setOpaque(false);
        this.button.setBorder(null);
        this.button.setFocusable(false);
        this.button.setIcon((Icon)ResourceManager.getImageIcon("func_new.png"));
        this.panel.setLayout(null);
        this.button.setBounds(325, 0, 20, 20);
        this.field = new KDTextField();
        this.field.setAccessAuthority(1);
        this.start.setEnabled(false);
        this.end.setEnabled(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                Window parent = SwingUtilities.getWindowAncestor((Component)GanttGroupChooserEditor.this.panel);
                final KDDialog dialog = new KDDialog((Dialog)parent);
                dialog.setModal(true);
                Container c = dialog.getContentPane();
                c.setLayout(null);
                dialog.setSize(240, 210);
                dialog.setTitle(CtrlEXTMessages.getMLS("headerSettings", "\u8868\u5934\u8bbe\u7f6e"));
                GanttGroupChooserEditor.this.startContainer.setBounds(10, 10, 200, 20);
                c.add((Component)GanttGroupChooserEditor.this.startContainer);
                GanttGroupChooserEditor.this.endContainer.setBounds(10, 40, 200, 20);
                c.add((Component)GanttGroupChooserEditor.this.endContainer);
                GanttGroupChooserEditor.this.forceContainer.setBounds(10, 70, 200, 20);
                c.add((Component)GanttGroupChooserEditor.this.forceContainer);
                GanttGroupChooserEditor.this.comboContainer.setBoundLabelUnderline(true);
                GanttGroupChooserEditor.this.comboContainer.setBounds(10, 100, 200, 20);
                c.add((Component)GanttGroupChooserEditor.this.comboContainer);
                GanttGroupChooserEditor.this.confirm.setBounds(80, 160, 40, 20);
                final int status = GanttGroupChooserEditor.this.getStatus();
                EventListener[] l = GanttGroupChooserEditor.this.confirm.getListeners(ActionListener.class);
                for (i = 0; i < l.length; ++i) {
                    GanttGroupChooserEditor.this.confirm.removeActionListener((ActionListener)l[i]);
                }
                GanttGroupChooserEditor.this.confirm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        Container table = GanttGroupChooserEditor.this.panel.getParent();
                        if (!(table instanceof JTable)) {
                            table = table.getParent().getParent();
                        }
                        ((JTable)table).putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                        GanttGroupChooserEditor.this.field.setText((String)GanttGroupChooserEditor.this.getValue());
                    }
                });
                l = GanttGroupChooserEditor.this.cancle.getListeners(ActionListener.class);
                for (i = 0; i < l.length; ++i) {
                    GanttGroupChooserEditor.this.cancle.removeActionListener((ActionListener)l[i]);
                }
                GanttGroupChooserEditor.this.cancle.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        GanttGroupChooserEditor.this.resetStatus(status);
                    }
                });
                Object value = GanttGroupChooserEditor.this.getValue();
                GanttGroupChooserEditor.this.setValue(value);
                c.add((Component)GanttGroupChooserEditor.this.confirm);
                GanttGroupChooserEditor.this.cancle.setBounds(155, 160, 40, 20);
                c.add((Component)GanttGroupChooserEditor.this.cancle);
                dialog.setLocationRelativeTo((Component)parent);
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        GanttGroupChooserEditor.this.resetStatus(status);
                    }
                });
                dialog.setVisible(true);
            }
        });
        this.field.setBounds(0, 0, 325, 20);
        this.field.setEditable(false);
        this.panel.add((Component)this.button);
        this.panel.add((Component)this.field);
    }

    private int getStatus() {
        int startStatus = 0;
        if (this.yearBox.isSelected()) {
            startStatus |= 1;
        }
        if (this.seasonBox.isSelected()) {
            startStatus |= 2;
        }
        if (this.monthBox.isSelected()) {
            startStatus |= 4;
        }
        if (this.weekBox.isSelected()) {
            startStatus |= 8;
        }
        if (this.dayBox.isSelected()) {
            startStatus |= 0x10;
        }
        if (this.hourBox.isSelected()) {
            startStatus |= 0x20;
        }
        return startStatus;
    }

    private void resetStatus(int status) {
        if ((status | 1) == status) {
            this.yearBox.setSelected(true);
        } else {
            this.yearBox.setSelected(false);
        }
        if ((status | 2) == status) {
            this.seasonBox.setSelected(true);
        } else {
            this.seasonBox.setSelected(false);
        }
        if ((status | 4) == status) {
            this.monthBox.setSelected(true);
        } else {
            this.monthBox.setSelected(false);
        }
        if ((status | 8) == status) {
            this.weekBox.setSelected(true);
        } else {
            this.weekBox.setSelected(false);
        }
        if ((status | 0x10) == status) {
            this.dayBox.setSelected(true);
        } else {
            this.dayBox.setSelected(false);
        }
        if ((status | 0x20) == status) {
            this.hourBox.setSelected(true);
        } else {
            this.hourBox.setSelected(false);
        }
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public Object getValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.timeCombo.getSelectedItem());
        if (this.force.isSelected()) {
            builder.append(",");
            builder.append(CtrlEXTMessages.getMLS("fixedHeader", "\u56fa\u5b9a\u8868\u5934"));
            builder.append("&From:");
            builder.append(this.dateFormat.format(this.start.getValue()));
            builder.append("&To:");
            builder.append(this.dateFormat.format(this.end.getValue()));
        }
        return builder.toString();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        String result = (String)value;
        int forceTitle = result.indexOf(CtrlEXTMessages.getMLS("fixedHeader", "\u56fa\u5b9a\u8868\u5934"));
        if (forceTitle != -1) {
            this.force.setSelected(true);
            try {
                int index = result.indexOf(38);
                int last = result.lastIndexOf(38);
                String startValue = result.substring(index + 6, last);
                this.start.setValue((Object)this.dateFormat.parse(startValue));
                String endValue = result.substring(last + 4);
                this.end.setValue((Object)this.dateFormat.parse(endValue));
            }
            catch (ParseException ex) {
                this.force.setSelected(false);
            }
            result = result.substring(0, forceTitle - 1);
        } else {
            this.force.setSelected(false);
        }
        result = result.replaceAll(" ", "");
        this.timeCombo.setSelectedItem((Object)result);
        this.field.setText((String)value);
    }
}

