/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.AbstractFusionBeanPropertyEditor;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class TrendlineValueComboBoxEditor
extends AbstractFusionBeanPropertyEditor {
    private KDPanel panel = new KDPanel();
    private KDTextField field;
    private KDTextField numberField;
    private KDCheckBox constBox = new KDCheckBox(CtrlEXTMessages.getMLS("fixedValue", "\u56fa\u5b9a\u503c"));
    private KDCheckBox avgBox;
    private KDCheckBox mdmBox;
    private KDButton confirm;
    private KDButton cancle;
    private KDWorkButton button;

    public static final String getAvg() {
        return CtrlEXTMessages.getMLS("KEY_ClassifiedStatistics_FunctionName3", "\u5e73\u5747\u503c");
    }

    public static final String getMedian() {
        return CtrlEXTMessages.getMLS("median", "\u4e2d\u4f4d\u6570");
    }

    public TrendlineValueComboBoxEditor() {
        this.numberField = new KDTextField();
        this.numberField.setVisible(false);
        this.avgBox = new KDCheckBox(TrendlineValueComboBoxEditor.getAvg());
        this.mdmBox = new KDCheckBox(TrendlineValueComboBoxEditor.getMedian());
        this.field = new KDTextField();
        this.field.setEditable(false);
        this.button = new KDWorkButton();
        this.button.setOpaque(false);
        this.button.setBorder(null);
        this.button.setFocusable(false);
        this.button.setIcon((Icon)ResourceManager.getImageIcon("func_new.png"));
        this.panel.setLayout(null);
        this.button.setBounds(325, 0, 20, 20);
        this.field.setBounds(0, 0, 325, 20);
        this.panel.add((Component)this.field);
        this.panel.add((Component)this.button);
        this.editor.add((Component)this.panel);
        this.confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this.button.addActionListener(e -> {
            int i;
            Window parent = SwingUtilities.getWindowAncestor((Component)this.panel);
            KDDialog dialog = new KDDialog((Dialog)parent);
            dialog.setModal(true);
            Container c = dialog.getContentPane();
            c.setLayout(null);
            dialog.setSize(255, 180);
            dialog.setTitle(CtrlEXTMessages.getMLS("referenceLineSettings", "\u53c2\u8003\u7ebf\u8bbe\u7f6e"));
            EventListener[] l = this.confirm.getListeners(ActionListener.class);
            for (i = 0; i < l.length; ++i) {
                this.confirm.removeActionListener((ActionListener)l[i]);
            }
            this.confirm.addActionListener(e1 -> {
                dialog.setVisible(false);
                dialog.dispose();
                Container table = this.panel.getParent();
                if (!(table instanceof JTable)) {
                    table = table.getParent().getParent();
                }
                ((JTable)table).putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                this.field.setText((String)this.getValue());
            });
            l = this.cancle.getListeners(ActionListener.class);
            for (i = 0; i < l.length; ++i) {
                this.cancle.removeActionListener((ActionListener)l[i]);
            }
            this.cancle.addActionListener(e1 -> {
                dialog.setVisible(false);
                dialog.dispose();
            });
            this.numberField.addKeyListener((KeyListener)new InputNumListener());
            this.constBox.addActionListener(e1 -> {
                boolean selected = this.constBox.isSelected();
                if (selected) {
                    this.avgBox.setSelected(false);
                    this.mdmBox.setSelected(false);
                }
                this.numberField.setVisible(selected);
            });
            this.avgBox.addActionListener(e1 -> {
                boolean selected = this.avgBox.isSelected();
                if (selected) {
                    this.constBox.setSelected(false);
                    this.mdmBox.setSelected(false);
                }
                this.numberField.setVisible(false);
            });
            this.mdmBox.addActionListener(e1 -> {
                boolean selected = this.mdmBox.isSelected();
                if (selected) {
                    this.constBox.setSelected(false);
                    this.avgBox.setSelected(false);
                }
                this.numberField.setVisible(false);
            });
            Object value = this.getValue();
            this.setValue(value);
            this.confirm.setBounds(90, 120, 50, 20);
            this.confirm.setMargin(new Insets(0, 0, 0, 0));
            c.add((Component)this.confirm);
            this.cancle.setBounds(170, 120, 50, 20);
            this.cancle.setMargin(new Insets(0, 0, 0, 0));
            c.add((Component)this.cancle);
            this.constBox.setBounds(20, 20, 100, 20);
            c.add((Component)this.constBox);
            this.numberField.setBounds(90, 20, 80, 20);
            c.add((Component)this.numberField);
            this.avgBox.setBounds(20, 50, 100, 20);
            c.add((Component)this.avgBox);
            this.mdmBox.setBounds(20, 80, 100, 20);
            c.add((Component)this.mdmBox);
            dialog.setLocationRelativeTo((Component)parent);
            dialog.show();
        });
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public Object getValue() {
        String text = null;
        if (this.constBox.isSelected()) {
            text = this.numberField.getText();
            if (!this.isNum(text)) {
                text = null;
                this.numberField.setText(null);
            }
        } else if (this.avgBox.isSelected()) {
            text = TrendlineValueComboBoxEditor.getAvg();
        } else if (this.mdmBox.isSelected()) {
            text = TrendlineValueComboBoxEditor.getMedian();
        }
        this.field.setText(text);
        return text;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            String v = value.toString();
            this.field.setText(v);
            if (TrendlineValueComboBoxEditor.getAvg().equals(v)) {
                this.avgBox.setSelected(true);
                this.constBox.setSelected(false);
                this.mdmBox.setSelected(false);
            } else if (TrendlineValueComboBoxEditor.getMedian().equals(v)) {
                this.mdmBox.setSelected(true);
                this.avgBox.setSelected(false);
                this.constBox.setSelected(false);
            } else if (this.isNum(v)) {
                this.constBox.setSelected(true);
                this.numberField.setText(v);
                this.numberField.setVisible(true);
                this.mdmBox.setSelected(false);
                this.avgBox.setSelected(false);
            }
        }
    }

    private boolean isNum(String input) {
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isNumForStr(String input) {
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static class InputNumListener
    extends KeyAdapter {
        private InputNumListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (!Character.isDigit(keyChar) && keyChar != '\b' && keyChar != '\u007f' && keyChar != '.') {
                e.consume();
            }
        }
    }
}

