/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultCombinationSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StackedColumn3DLineDYBean
extends DefaultCombinationSeriesBean {
    public StackedColumn3DLineDYBean() {
        this.chart_showLabels = new BooleanVFPair(true, null);
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.fillChartNodes(dataNode);
    }

    @Override
    protected void fillChartNodesByCell(FusionChartDataNode dataNode) throws SyntaxErrorException {
        int i;
        int k;
        String[] yAxis;
        String[] types;
        String[][] series;
        double[][] dataValues;
        String[] groups;
        if (dataNode.getDataWithoutCalc() != null) {
            groups = dataNode.getGroupKeysWithoutCalc();
            dataValues = (double[][])dataNode.getDataWithoutCalc();
            series = (String[][])dataNode.getSeriesKeysWithoutCalc();
            types = dataNode.getChartShowTypesWithoutCalc();
            yAxis = dataNode.getYAxisPositionWithoutCalc();
        } else {
            boolean isFillNullWithZero = dataNode.isFillNullWithZero();
            groups = this.parseStrings(dataNode, dataNode.getGroupFormula(), FusionChartDataNode.COMBINATION_CHART_GROUP_FORMULA);
            Object[] seriesValues = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
            int sLen = seriesValues.length;
            series = new String[sLen][];
            for (int i2 = 0; i2 < sLen; ++i2) {
                series[i2] = ChartDataTransferUtil.parseValue2String((Variant[][])seriesValues[i2]).toArray(new String[((Variant[][])seriesValues[i2]).length]);
            }
            types = (String[])dataNode.getFormula(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE);
            yAxis = ChartDataTransferUtil.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_PARENTYAXIS));
            Object[] data = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            Object[] datas = new Object[data.length];
            if (dataNode.isSerialByCol()) {
                for (int i3 = 0; i3 < data.length; ++i3) {
                    datas[i3] = ChartDataTransferUtil.povitDoubles((Variant[][])data[i3]);
                }
                dataValues = ChartDataTransferUtil.parseValue2Double(datas, isFillNullWithZero);
                dataNode.setData(dataValues);
            } else {
                dataValues = ChartDataTransferUtil.parseValue2Double(data, isFillNullWithZero);
                dataNode.setData(dataValues);
            }
            dataNode.setGroupKeys(groups);
            dataNode.setSerieskeys(series);
            dataNode.setChartShowTypes(types);
            dataNode.setYAxisPosition(yAxis);
        }
        String lineNames = this.getCellSeriesKeys(dataNode);
        int gLen = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[gLen];
        for (int i4 = 0; i4 < gLen; ++i4) {
            Categories.Category category = new Categories.Category();
            category.label = groups[i4];
            this.categories.categories[i4] = category;
        }
        int tLen = types.length;
        for (k = 0; k < tLen; ++k) {
            if (!types[k].equals(FusionChartXmlBuilder.getColumnRenderDisplay())) continue;
            int row = series[k].length;
            this.datasets = new Dataset[row + 1];
            for (i = 0; i < row; ++i) {
                this.datasets[i] = new Dataset();
                this.datasets[i].seriesName = series[k][i];
                int col = groups.length;
                col = Math.min(dataValues[i].length, col);
                this.datasets[i].nodes = new NodeFunc[col];
                for (int j = 0; j < col; ++j) {
                    double data = dataValues[i][j];
                    Set set = new Set();
                    set.value = !Double.isNaN(data) ? (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(data)) : String.valueOf(data)) : "";
                    this.datasets[i].nodes[j] = set;
                    set.link = this.buildLinkProp(groups[j], series[k][i], String.valueOf(data));
                }
            }
            break;
        }
        tLen = types.length;
        for (k = 0; k < tLen; ++k) {
            if (!types[k].equals(FusionChartXmlBuilder.getLineRenderDisplay())) continue;
            String[] str = null;
            int row = dataValues.length;
            ArrayList<String> ret = new ArrayList<String>();
            for (int i5 = 0; i5 < row; ++i5) {
                int col = dataValues[i5].length;
                for (int j = 0; j < col; ++j) {
                    double data = dataValues[i5][j];
                    if (!Double.isNaN(data)) {
                        ret.add(String.valueOf(data));
                        continue;
                    }
                    ret.add("");
                }
            }
            str = new String[ret.size()];
            ret.toArray(str);
            int len = this.datasets.length - 1;
            this.datasets[len] = new Dataset();
            this.datasets[len].seriesName = lineNames;
            this.datasets[len].parentYAxis = "S";
            this.datasets[len].nodes = new NodeFunc[gLen];
            for (i = 0; i < gLen; ++i) {
                Set set = new Set();
                set.value = str[i * 2];
                set.displayValue = set.label = str[i * 2 + 1];
                this.datasets[len].nodes[i] = set;
                set.link = this.buildLinkProp(groups[i], lineNames, set.value);
            }
            break;
        }
        dataNode.setDirty(false);
    }

    protected String getCellSeriesKeys(FusionChartDataNode dataNode) {
        String lineName = "";
        Object[] data = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
        if (data.length > 2 && data[1] instanceof Variant[][]) {
            lineName = (String)((Variant[][])data[1])[0][0].getValue();
        }
        return lineName;
    }

    @Override
    protected void fillChartNodesByDataset(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] groups = dataNode.getGroupKeys();
        Object[] dataValues = (Object[])dataNode.getData();
        Object[] seriesNames = (Object[])dataNode.getSeriesKeys();
        String[] types = dataNode.getChartShowTypes();
        String[] yAxis = dataNode.getYAxisPostion();
        int lenGroup = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[lenGroup];
        for (int i = 0; i < lenGroup; ++i) {
            Categories.Category category = new Categories.Category();
            category.label = groups[i];
            this.categories.categories[i] = category;
        }
        int col = lenGroup;
        int lenSeries = seriesNames.length;
        for (int i = 0; i < lenSeries; ++i) {
            double[][] values = (double[][])dataValues[i];
            String[] series = (String[])seriesNames[i];
            if (types[i].equals("column")) {
                int row = series.length;
                this.datasets = new Dataset[row + 1];
                for (int r = 0; r < row; ++r) {
                    this.datasets[r] = new Dataset();
                    this.datasets[r].parentYAxis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
                    this.datasets[r].seriesName = series[r];
                    this.datasets[r].nodes = new NodeFunc[col];
                    for (int c = 0; c < col; ++c) {
                        Set set = new Set();
                        set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[r][c])) : String.valueOf(values[r][c]);
                        this.datasets[r].nodes[c] = set;
                        set.link = this.buildLinkProp(groups[c], series[r], String.valueOf(values[r][c]));
                    }
                }
                continue;
            }
            int len = this.datasets.length - 1;
            this.datasets[len] = new Dataset();
            this.datasets[len].seriesName = series[0];
            this.datasets[len].parentYAxis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            this.datasets[len].nodes = new NodeFunc[lenGroup];
            for (int g = 0; g < lenGroup; ++g) {
                Set set = new Set();
                set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[0][g])) : String.valueOf(values[0][g]);
                set.displayValue = set.label = set.value;
                this.datasets[len].nodes[g] = set;
                set.link = this.buildLinkProp(groups[g], series[0], String.valueOf(values[0][g]));
            }
        }
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
    }

    public String getDemoXML(List colors, HashMap numberFormats) {
        return super.getDemoXML(colors, numberFormats, new String[]{CtrlEXTMessages.getMLS("column", "\u67f1\u5f62"), CtrlEXTMessages.getMLS("column", "\u67f1\u5f62"), CtrlEXTMessages.getMLS("line", "\u6298\u7ebf")}, new String[]{CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38"), CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38"), CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74")});
    }

    @Override
    public void setChart_borderColor(ColorVFPair chartBorderColor) {
        this.chart_borderColor = chartBorderColor;
    }

    @Override
    public IntegerVFPair getChart_borderThickness() {
        return null;
    }

    @Override
    public void setDataLabelFormat(NumberFormatVFPair dataLabelFormat) {
        this.dataLabelFormat = dataLabelFormat;
    }

    @Override
    public void setYAxisFormat(NumberFormatVFPair yAxisFormat) {
        this.yAxisFormat = yAxisFormat;
    }

    @Override
    public void setXAxisFormat(NumberFormatVFPair xAxisFormat) {
        this.xAxisFormat = xAxisFormat;
    }

    @Override
    public void setChart_smoothCurve(BooleanVFPair chart_smoothCurve) {
        this.chart_smoothCurve = chart_smoothCurve;
    }

    @Override
    public void setChartXStartValue(String chartXStartValue) {
        this.chartXStartValue = chartXStartValue;
    }

    @Override
    public void setChartXEndValue(String chartXEndValue) {
        this.chartXEndValue = chartXEndValue;
    }
}

