/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.data.inner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ControlUtilities;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.inner.DatasetTypeChooser;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.inner.TextFileDatasetConfiger;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdesktop.layout.GroupLayout;

public class DatesetManagementWizzard
extends KDDialog
implements ISpreadWizzard {
    public static final String KEY_TITLE = "dataSetSetting";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_TEXT_TYPE = "textType";
    public static final String KEY_ADD = "add";
    public static final String KEY_DEL = "del";
    public static final String KEY_EDIT = "edit";
    public static final String KEY_BROWSE = "browse";
    public static final String KEY_DS_NAME = "dsName";
    public static final String KEY_DS_TYPE = "dsType";
    public static final String KEY_DS_DEFINE = "dsDefine";
    public static final String KEY_MSG_TITLE = "msgTitle";
    public static final String KEY_MSG1 = "dataSetExistInPath";
    public static final String KEY_MSG2 = "dataSetExistInTable";
    private KDWorkButton add;
    private KDWorkButton del;
    private KDWorkButton edit;
    private KDWorkButton browse;
    private KDWorkButton commit;
    private KDWorkButton cancel;
    private KDTable table;
    private KDExt _ext;
    private DatasetTypeChooser dsTypeDialog;
    private TextFileDatasetConfiger textFileDsConfig;
    private HashSet paths = new HashSet();
    private List datasets;

    static String getI18nTxtTypeName() {
        return DatesetManagementWizzard.getLocalText(KEY_TEXT_TYPE);
    }

    public DatesetManagementWizzard(Dialog parent, KDExt ext) {
        super(parent);
        this._ext = ext;
        this.initComponents();
        this.initTable();
        this.initListeners();
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(DatesetManagementWizzard.getLocalText(KEY_TITLE));
    }

    public List getExtDatasetList() {
        return this.datasets;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.table.removeRows();
            this.datasets = new ArrayList();
        }
        super.setVisible(b);
    }

    public static String getLocalText(String key) {
        return CtrlEXTMessages.getMLS(key, "NotFound");
    }

    private String getI18nTypeName(ExtDataSet extDataset) {
        if (extDataset.getDataSetType() == ExtDataSetType.TXT) {
            return DatesetManagementWizzard.getI18nTxtTypeName();
        }
        return "";
    }

    private String getNextDatasetName() {
        int scan = 0;
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            String name = ((ExtDataSet)this.table.getRow(i).getUserObject()).getName();
            if (!name.startsWith("ds_")) continue;
            try {
                int number = Integer.parseInt(name.substring(3));
                scan = number > scan ? number : scan;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return "ds_" + ++scan;
    }

    private void initComponents() {
        this.table = new KDTable();
        this.add = new KDWorkButton();
        this.del = new KDWorkButton();
        this.edit = new KDWorkButton();
        this.browse = new KDWorkButton();
        this.commit = new KDWorkButton();
        this.cancel = new KDWorkButton();
        this.add.setText(DatesetManagementWizzard.getLocalText(KEY_ADD));
        this.del.setText(DatesetManagementWizzard.getLocalText(KEY_DEL));
        this.edit.setText(DatesetManagementWizzard.getLocalText(KEY_EDIT));
        this.browse.setText(DatesetManagementWizzard.getLocalText(KEY_BROWSE));
        this.commit.setText(DatesetManagementWizzard.getLocalText(KEY_OK));
        this.cancel.setText(DatesetManagementWizzard.getLocalText(KEY_CANCEL));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.table, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.del, -1, 95, Short.MAX_VALUE).add(1, (Component)this.cancel, -1, 95, Short.MAX_VALUE).add(1, (Component)this.commit, -1, 95, Short.MAX_VALUE).add(1, (Component)this.add, -1, 95, Short.MAX_VALUE).add((Component)this.browse, -1, 95, Short.MAX_VALUE).add(1, (Component)this.edit, -1, 95, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.add, this.del, this.edit, this.browse, this.commit, this.cancel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.table, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.add).addPreferredGap(1).add((Component)this.del).addPreferredGap(1).add((Component)this.edit).addPreferredGap(1).add((Component)this.browse).addPreferredGap(0, 171, Short.MAX_VALUE).add((Component)this.commit).addPreferredGap(0).add((Component)this.cancel))).addContainerGap()));
        this.browse.setVisible(false);
    }

    private DatasetTypeChooser getDatasetTypeDialog() {
        if (this.dsTypeDialog == null) {
            this.dsTypeDialog = new DatasetTypeChooser((Dialog)((Object)this));
        }
        return this.dsTypeDialog;
    }

    private TextFileDatasetConfiger getTextFileDsConfiger() {
        if (this.textFileDsConfig == null) {
            this.textFileDsConfig = new TextFileDatasetConfiger((Dialog)((Object)this));
        }
        return this.textFileDsConfig;
    }

    private void initTable() {
        this.table.setPreferredSize(new Dimension(413, 357));
        this.table.getSelectManager().setSelectMode(10);
        int colCount = 3;
        for (int i = 0; i < colCount; ++i) {
            this.table.addColumn(i);
        }
        this.table.getColumn(1).setWidth(70);
        this.table.getColumn(1).getStyleAttributes().setLocked(true);
        this.table.getColumn(2).setWidth(190);
        this.table.getColumn(2).getStyleAttributes().setLocked(true);
        this.table.addHeadRow();
        this.table.getHeadRow(0).getCell(0).setValue((Object)DatesetManagementWizzard.getLocalText(KEY_DS_NAME));
        this.table.getHeadRow(0).getCell(1).setValue((Object)DatesetManagementWizzard.getLocalText(KEY_DS_TYPE));
        this.table.getHeadRow(0).getCell(2).setValue((Object)DatesetManagementWizzard.getLocalText(KEY_DS_DEFINE));
        this.table.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    String name = (String)e.getValue();
                    ((ExtDataSet)DatesetManagementWizzard.this.table.getRow(DatesetManagementWizzard.this.table.getSelectManager().getActiveRowIndex()).getUserObject()).setAlias(name);
                }
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getColIndex() != 0 && e.getType() == 1) {
                    DatesetManagementWizzard.this.edit.doClick();
                }
            }
        });
    }

    private void initListeners() {
        this.commit.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    ControlUtilities.checkFocusAndCommit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                int size = DatesetManagementWizzard.this.table.getRowCount();
                for (int i = 0; i < size; ++i) {
                    DatesetManagementWizzard.this.datasets.add(DatesetManagementWizzard.this.table.getRow(i).getUserObject());
                }
                DatesetManagementWizzard.this.setVisible(false);
                DatesetManagementWizzard.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatesetManagementWizzard.this.setVisible(false);
                DatesetManagementWizzard.this.dispose();
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetTypeChooser dtd = DatesetManagementWizzard.this.getDatasetTypeDialog();
                dtd.setLocationRelativeTo((Component)((Object)DatesetManagementWizzard.this));
                dtd.setVisible(true);
                if (dtd.getExtDataSetType() == ExtDataSetType.TXT) {
                    TextFileDatasetConfiger tfdc = DatesetManagementWizzard.this.getTextFileDsConfiger();
                    tfdc.setMultiSelectionEnabled(true);
                    tfdc.setFilePath("");
                    tfdc.setLocationRelativeTo(DatesetManagementWizzard.this.getParent());
                    tfdc.setVisible(true);
                    String returnStr = tfdc.getFilePath();
                    if (!StringUtils.isEmpty((String)returnStr)) {
                        StringBuilder sb = new StringBuilder();
                        String[] files = returnStr.split(";");
                        for (int i = 0; i < files.length; ++i) {
                            if (!DatesetManagementWizzard.this.paths.add(files[i])) {
                                sb.append(files[i]);
                                sb.append(DatesetManagementWizzard.getLocalText(DatesetManagementWizzard.KEY_MSG1));
                                continue;
                            }
                            Book book = MiscUtil.getActiveSpreadContext(DatesetManagementWizzard.this._ext).getBook();
                            ExtDataSet eds = book.getDataSetManager().getExtDataSetFactory().getDataSet(book, ExtDataSetType.TXT, DatesetManagementWizzard.this.getNextDatasetName(), files[i]);
                            IRow row = DatesetManagementWizzard.this.table.addRow();
                            row.setUserObject((Object)eds);
                            row.getCell(0).setValue((Object)eds.getName());
                            row.getCell(1).setValue((Object)DatesetManagementWizzard.this.getI18nTypeName(eds));
                            row.getCell(2).setValue((Object)eds.getDefine());
                        }
                        String message = sb.toString();
                        if (message.length() != 0) {
                            DatesetManagementWizzard.this.showMessage(message);
                        }
                    }
                }
            }
        });
        this.del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)DatesetManagementWizzard.this.table);
                for (int i = rows.length - 1; i >= 0; --i) {
                    DatesetManagementWizzard.this.paths.remove(((ExtDataSet)DatesetManagementWizzard.this.table.getRow(rows[i]).getUserObject()).getDefine().substring(5));
                    DatesetManagementWizzard.this.table.removeRow(rows[i]);
                }
            }
        });
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtDataSet eds;
                IRow row = DatesetManagementWizzard.this.table.getRow(DatesetManagementWizzard.this.table.getSelectManager().getActiveRowIndex());
                if (row != null && (eds = (ExtDataSet)row.getUserObject()).getDataSetType() == ExtDataSetType.TXT) {
                    TextFileDatasetConfiger tfdc = DatesetManagementWizzard.this.getTextFileDsConfiger();
                    tfdc.setMultiSelectionEnabled(false);
                    String origin = eds.getDefine().substring(5);
                    tfdc.setFilePath(origin);
                    tfdc.setLocationRelativeTo(DatesetManagementWizzard.this.getParent());
                    tfdc.setVisible(true);
                    String filePath = tfdc.getFilePath();
                    if (!StringUtils.isEmpty((String)filePath)) {
                        if (!DatesetManagementWizzard.this.paths.add(filePath)) {
                            if (!filePath.equals(origin)) {
                                DatesetManagementWizzard.this.showMessage(DatesetManagementWizzard.getLocalText(DatesetManagementWizzard.KEY_MSG2));
                            }
                            return;
                        }
                        DatesetManagementWizzard.this.paths.remove(origin);
                        Book book = MiscUtil.getActiveSpreadContext(DatesetManagementWizzard.this._ext).getBook();
                        eds = book.getDataSetManager().getExtDataSetFactory().getDataSet(book, ExtDataSetType.TXT, eds.getName(), filePath);
                        row.setUserObject((Object)eds);
                        row.getCell(2).setValue((Object)eds.getDefine());
                    }
                }
            }
        });
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private void showMessage(String message) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        MessageUtil.msgboxWarning((Component)((Object)this), message);
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this.paths.clear();
        return true;
    }
}

