/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.assembled;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.AbstractExtCtrl;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedListener;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorViewPicClickEvent;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorViewPicClickListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ComboColorExtCtrl
extends AbstractExtCtrl {
    private static final Logger logger = LogUtil.getPackageLogger(ComboColorExtCtrl.class);
    private KDComboColor comboColor = new KDComboColor(2, true);

    public ComboColorExtCtrl() {
        this.comboColor.addViewPicClickListener(new ComboColorViewPicClickListener(){

            public void clicked(ComboColorViewPicClickEvent evt) {
                ComboColorExtCtrl.this.fireFinishEdit();
            }
        });
        this.comboColor.addSelectedListener(new ComboColorSelectedListener(){

            public void selected(ComboColorSelectedEvent evt) {
                ComboColorExtCtrl.this.fireFinishEdit();
            }
        });
        this.comboColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.comboColor.setToolTipText(CtrlEXTMessages.getMLS("colorChoose", "\u9009\u62e9\u989c\u8272"));
        this.addUsedColorPersistence(this.comboColor);
    }

    public JComponent getCtrl() {
        return this.comboColor;
    }

    public String getExtResult() {
        Color c = this.comboColor.getColor();
        StringBuilder sb = new StringBuilder();
        sb.append("RGB(");
        sb.append(c.getRed());
        sb.append(',');
        sb.append(c.getGreen());
        sb.append(',');
        sb.append(c.getBlue());
        sb.append(')');
        return sb.toString();
    }

    public void setProcessString(String str) {
    }

    protected void addUsedColorPersistence(KDComboColor cbc) {
        cbc.addUsedColorPersistence(new KDComboColor.IUsedColorPersistence(){

            public void save(LinkedList<Color> usedColorList) {
                IXmlElement root = XmlUtil.createNode((String)"UsedColors");
                IXmlElement UsedColor = XmlUtil.createNode((String)"UsedColor");
                StringBuilder colorsStr = new StringBuilder();
                for (Color color : usedColorList) {
                    colorsStr.append(color.getRGB()).append(",");
                }
                UsedColor.addCData(colorsStr.toString());
                root.addChild(UsedColor);
                String filePth = GlobalLocator.getInstance().getHomeDir() + "\\UsedColor.xml";
                try {
                    XmlUtil.saveFile((IXmlElement)root, (File)new File(FilenameUtils.normalize((String)filePth)));
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }

            public LinkedList<Color> load() {
                String filePth = GlobalLocator.getInstance().getHomeDir() + File.separator + "UsedColor.xml";
                LinkedList<Color> usedColorList = new LinkedList<Color>();
                File f = new File(FilenameUtils.normalize((String)filePth));
                if (f.exists() && f.isFile()) {
                    try {
                        IXmlElement root = XmlUtil.loadRootElementFromFile((File)new File(FilenameUtils.normalize((String)filePth)));
                        if (root.getChild("UsedColor") != null && root.getChild("UsedColor").getText() != "") {
                            String colorStr = root.getChild("UsedColor").getText();
                            String[] color = colorStr.split(",");
                            for (int i = 0; i < color.length; ++i) {
                                if (!StringUtil.isNumber((String)color[i])) continue;
                                Color c = new Color(Integer.parseInt(color[i]));
                                usedColorList.add(c);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    catch (XmlParsingException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
                return usedColorList;
            }
        });
    }
}

