/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.config;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.config.Function;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FormulaConfigUtils {
    private static final Logger log = LogUtil.getLogger(FormulaConfigUtils.class);
    public static final String XmlNode_Group = "Group";
    public static final String XmlNode_Example = "example";
    public static final String XmlNode_Data = "data";
    public static final String XmlNode_Params = "params";
    public static final String XmlNode_Param = "param";
    public static final String XmlNode_Array = "array";
    public static final String XmlAttr_Text = "text";
    public static final String XmlAttr_Data = "data";
    public static final String XmlAttr_FuncName = "funcName";
    public static final String XmlAttr_WithParam = "withParam";
    public static final String XmlAttr_Tip = "tip";
    public static final String XmlAttr_Visible = "visible";
    public static final String XmlAttr_Name = "name";
    public static final String XmlAttr_Prompt = "prompt";
    public static final String ParamsInstrad_Regex = "\\[@params\\]";
    private static String BLANK = "\u3000";
    private static String TAB = "\u3000\u3000";

    public static List<Function> getFunction(Locale locale, Set<String> funcNames) {
        IXmlElement funcConfig = FormulaConfigUtils.readFuncConfig(locale);
        if (funcConfig == null) {
            return new ArrayList<Function>(1);
        }
        ArrayList<Function> functions = new ArrayList<Function>(10);
        List groups = funcConfig.searchChildren(XmlNode_Group);
        for (int i = 0; i < groups.size(); ++i) {
            IXmlElement nodeGroup = (IXmlElement)groups.get(i);
            for (IXmlElement node : nodeGroup.getChildren()) {
                String typeName = node.getAttribute(XmlAttr_Text);
                String nodeName = node.getName();
                if ("Nodes".equals(nodeName)) {
                    Iterator it = node.getChildren().iterator();
                    while (it.hasNext()) {
                        FormulaConfigUtils.parseNode(functions, (IXmlElement)it.next(), typeName, funcNames);
                    }
                    continue;
                }
                if (!"Node".equals(nodeName)) continue;
                FormulaConfigUtils.parseNode(functions, node, typeName, funcNames);
            }
        }
        return functions;
    }

    public static IXmlElement readFuncConfig(Locale locale) {
        try {
            String defaultPostfix = "en";
            String localePostfix = locale != null ? locale.toString() : Locale.getDefault().toString();
            InputStream configStream = null;
            while (configStream == null) {
                StringBuilder sb = new StringBuilder("FormulaWizard_");
                sb.append(localePostfix);
                sb.append(".xml");
                configStream = FormulaConfigUtils.class.getResourceAsStream(sb.toString());
                if (configStream != null) continue;
                if (defaultPostfix.equals(localePostfix)) {
                    throw new RuntimeException("FormulaWizard config file not found. " + Locale.getDefault());
                }
                int sepeartorIndex = localePostfix.lastIndexOf(95);
                if (sepeartorIndex < 0) {
                    localePostfix = defaultPostfix;
                    continue;
                }
                localePostfix = localePostfix.substring(0, sepeartorIndex);
            }
            return XmlUtil.loadXmlStream(configStream);
        }
        catch (Exception e) {
            log.error((Object)"Load wizard config failed!", (Throwable)e);
            return null;
        }
    }

    private static void parseNode(List<Function> functions, IXmlElement node, String typeName, Set<String> funcNames) {
        String funcName = node.getAttribute(XmlAttr_FuncName);
        if (StringUtil.isEmptyString((String)funcName)) {
            funcName = node.getAttribute(XmlAttr_Text);
        }
        if (CollectionUtils.isNotEmpty(funcNames) && !funcNames.contains(funcName)) {
            return;
        }
        IXmlElement nodeData = node.getChild("data");
        String data = nodeData == null ? node.getAttribute("data") : nodeData.getText().trim();
        Function function = new Function(data);
        function.setTip(node.getAttribute(XmlAttr_Tip));
        function.setExample(FormulaConfigUtils.getExample(node));
        function.setTypeName(typeName);
        function.setFuncName(funcName);
        boolean isWithParam = "true".equals(node.getAttribute(XmlAttr_WithParam));
        IXmlElement xmlParams = node.getChild(XmlNode_Params);
        if (xmlParams != null) {
            StringBuilder sb = new StringBuilder();
            FormulaConfigUtils.parseParams(xmlParams, sb, 0);
            if (sb.length() > 0) {
                function.setExample(function.getExample().replaceFirst(ParamsInstrad_Regex, sb.toString()));
                isWithParam = true;
            }
        }
        function.setMethodWithParam(isWithParam);
        functions.add(function);
    }

    private static void parseParams(IXmlElement xmlParams, StringBuilder sb, int tabNum) {
        String strVisible = xmlParams.getAttribute(XmlAttr_Visible);
        boolean isVisible = !"false".equals(strVisible);
        List params = xmlParams.searchChildren(XmlNode_Param);
        int c = params.size();
        for (int i = 0; i < c; ++i) {
            IXmlElement xmlParam = (IXmlElement)params.get(i);
            if (isVisible) {
                if (sb.length() > 0) {
                    sb.append(StringUtil.RETURN);
                }
                if (tabNum > 0) {
                    sb.append(StringUtil.makeRepeatString((String)TAB, (int)tabNum));
                }
            }
            FormulaConfigUtils.parseParam(xmlParam, isVisible ? sb : null, tabNum);
            IXmlElement xmlArray = xmlParam.getChild(XmlNode_Array);
            if (xmlArray == null) continue;
            FormulaConfigUtils.parseParams(xmlArray, sb, tabNum + 1);
        }
    }

    private static void parseParam(IXmlElement xmlParam, StringBuilder sb, int tabNum) {
        String name = xmlParam.getAttribute(XmlAttr_Name);
        String prompt = xmlParam.getAttribute(XmlAttr_Prompt);
        String desc = xmlParam.getText().trim();
        if (sb != null) {
            sb.append(TAB);
            if (tabNum > 0) {
                sb.append(StringUtil.makeRepeatString((String)"\u25cb", (int)tabNum));
                sb.append(BLANK);
            }
            sb.append(prompt == null ? name : prompt);
            sb.append(BLANK);
            sb.append(desc);
        }
    }

    private static String getExample(IXmlElement node) {
        IXmlElement nodeExam = node.getChild(XmlNode_Example);
        String example = nodeExam != null ? nodeExam.getText().trim() : "";
        return example;
    }
}

