/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.XmlConstants;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FilenameUtils;

class HTM
extends XmlConstants {
    static String TEMP_ITEM_IMAGES_PATH;
    private File file;
    private DefaultKingdeeTreeNode node;
    private PrintWriter pw;

    private static final String[] getKeyWord() {
        return new String[]{"\u529f\u80fd\uff1a", "\u8bed\u6cd5\uff1a", CtrlEXTMessages.getMLS("parametersWithColon", "\u53c2\u6570\uff1a"), "\u8fd4\u56de\u503c\uff1a", "\u793a\u4f8b\uff1a"};
    }

    HTM(File file, DefaultKingdeeTreeNode node) {
        this.file = file;
        this.node = node;
    }

    private List getNodeChildrenList() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        int childCount = this.node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            list.add(this.node.getChildAt(i));
        }
        return list;
    }

    public void parseNodesFile() throws FileNotFoundException {
        this.pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.file)));
        String nodeName = this.node.getText();
        this.printHead(nodeName);
        this.printStartTag(this.pw, BODY);
        this.printStartTag(this.pw, TABLE);
        this.printStartTag(this.pw, TR);
        this.printStartTag(this.pw, TD);
        this.printNoBorderTableHead();
        this.printStyleTD();
        this.printStartTag(this.pw, TD);
        this.printHref(CtrlEXTMessages.getMLS("functionReference", "\u51fd\u6570\u53c2\u8003"));
        this.printTitle(CtrlEXTMessages.getMLS("outline", "\u5927\u7eb2"));
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TABLE);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(HR);
        this.pw.println(RIGHT_BRACKET);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(BR);
        this.pw.print(RIGHT_BRACKET);
        List children = this.getNodeChildrenList();
        this.printStartTag(this.pw, HTM_CONSTANTS_UL);
        for (int i = 0; i < children.size(); ++i) {
            String name = ((DefaultKingdeeTreeNode)children.get(i)).getText();
            this.printStartTag(this.pw, HTM_CONSTANTS_LI);
            this.printHref(name);
            this.pw.print(name);
            this.printEndTag(this.pw, A);
        }
        this.printEndTag(this.pw, HTM_CONSTANTS_UL);
        this.printEndTag(this.pw, BODY);
        this.printEndTag(this.pw, HTML);
        this.pw.flush();
        this.pw.close();
    }

    public void parseGroupFile() throws FileNotFoundException {
        this.pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.file)));
        String nodeName = this.node.getText();
        this.printHead(nodeName);
        List children = this.getNodeChildrenList();
        this.printStartTag(this.pw, BODY);
        this.printStartTag(this.pw, HTM_CONSTANTS_UL);
        for (int i = 0; i < children.size(); ++i) {
            String name = ((DefaultKingdeeTreeNode)children.get(i)).getText();
            this.printStartTag(this.pw, HTM_CONSTANTS_LI);
            this.printHref(name);
            this.pw.print(name);
            this.printEndTag(this.pw, A);
        }
        this.printEndTag(this.pw, HTM_CONSTANTS_UL);
        this.printStartTag(this.pw, PRE);
        this.pw.println(CtrlEXTMessages.getMLS("creationDate", "\u521b\u5efa\u65e5\u671f\uff1a") + DateFormat.getDateInstance().format(new Date()));
        this.pw.println(CtrlEXTMessages.getMLS("version", "\u7248\u672c") + "\uff1a1.0");
        this.pw.println("(c) Copyright Kingdee contributors and others.  All rights reserved.");
        this.printEndTag(this.pw, PRE);
        this.printEndTag(this.pw, BODY);
        this.printEndTag(this.pw, HTML);
        this.pw.flush();
        this.pw.close();
    }

    public void parseNodeFile() throws FileNotFoundException {
        Object uo = this.node.getUserObject();
        if (uo == null || ((Formula)uo).getExample() == null) {
            return;
        }
        this.pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.file)));
        String example = ((Formula)this.node.getUserObject()).getExample();
        String nodeName = this.node.getText();
        String parentName = ((DefaultKingdeeTreeNode)this.node.getParent()).getText();
        String grandName = ((DefaultKingdeeTreeNode)this.node.getParent().getParent()).getText();
        this.printHead(nodeName);
        this.printBody(grandName, parentName, nodeName, example);
        this.printEndTag(this.pw, HTML);
        this.pw.flush();
        this.pw.close();
    }

    private void printHead(String nodeName) {
        this.pw.println(HTM_CONSTANTS_HEAD);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(HTML);
        this.pw.println(RIGHT_BRACKET);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(HEAD);
        this.pw.println(RIGHT_BRACKET);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(TITLE);
        this.pw.print(RIGHT_BRACKET);
        this.pw.print(nodeName);
        this.printEndTag(this.pw, TITLE);
        this.printEndTag(this.pw, HEAD);
    }

    private void printBody(String grandName, String parentName, String nodeName, String example) {
        this.printStartTag(this.pw, BODY);
        this.printStartTag(this.pw, TABLE);
        this.printStartTag(this.pw, TR);
        this.printStartTag(this.pw, TD);
        this.printNoBorderTableHead();
        this.printStyleTD();
        this.printStartTag(this.pw, TD);
        this.printHref(CtrlEXTMessages.getMLS("functionReference", "\u51fd\u6570\u53c2\u8003"));
        this.printTitle(CtrlEXTMessages.getMLS("outline", "\u5927\u7eb2"));
        this.printEndTag(this.pw, TD);
        this.printStartTag(this.pw, TD);
        this.printHref(parentName);
        this.printTitle(CtrlEXTMessages.getMLS("functionClassification", "\u51fd\u6570\u5206\u7c7b"));
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TABLE);
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TR);
        this.printEndTag(this.pw, TABLE);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(HR);
        this.pw.println(RIGHT_BRACKET);
        this.printExampleTable(nodeName, example);
        this.printEndTag(this.pw, BODY);
    }

    private void printExampleTable(String nodeName, String example) {
        example = StringUtil.replace((String)example, (String)"\n", (String)"<br>");
        int[] index = new int[5];
        String[] KEY_WORD = HTM.getKeyWord();
        index[0] = example.indexOf(KEY_WORD[0]);
        index[1] = example.indexOf(KEY_WORD[1]);
        index[2] = example.indexOf(KEY_WORD[2]);
        index[3] = example.indexOf(KEY_WORD[3]);
        index[4] = example.indexOf(KEY_WORD[4]);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            boolean flag = true;
            if (index[i] <= -1) continue;
            for (int j = i + 1; j < 5; ++j) {
                if (index[j] <= 0) continue;
                flag = false;
                buffer.append("<b>");
                buffer.append(KEY_WORD[i]);
                buffer.append("</b>");
                buffer.append(example.substring(index[i] + KEY_WORD[i].length(), index[j]));
                break;
            }
            if (!flag) continue;
            buffer.append("<b>");
            buffer.append(KEY_WORD[i]);
            buffer.append("</b>");
            buffer.append(example.substring(index[i] + KEY_WORD[i].length()));
            break;
        }
        example = buffer.toString();
        this.printNoBorderTableHead();
        this.printStartTag(this.pw, TR);
        this.printStartTag(this.pw, TD);
        this.printStartTag(this.pw, B);
        this.pw.print(nodeName);
        this.printEndTag(this.pw, B);
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TR);
        this.printStartTag(this.pw, TR);
        this.printStartTag(this.pw, TD);
        this.pw.print("<hr>");
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TR);
        this.printStartTag(this.pw, TR);
        this.printStartTag(this.pw, TD);
        this.pw.print(example);
        this.printEndTag(this.pw, TD);
        this.printEndTag(this.pw, TR);
        this.printImageTag(this.pw, nodeName);
        this.printEndTag(this.pw, TABLE);
    }

    private void printNoBorderTableHead() {
        this.printTableHead("0");
    }

    private void printTableHead(String border) {
        this.pw.print(LEFT_BRACKET);
        this.pw.print(TABLE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(BORDER);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print(border);
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(CELLPADDING);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("0");
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(CELLSPACING);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("3");
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(WIDTH);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("100%");
        this.pw.print(RIGHT_QUOTE);
        this.pw.println(RIGHT_BRACKET);
    }

    private void printTitle(String title) {
        this.pw.print(LEFT_BRACKET);
        this.pw.print(FONT);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(CLASS);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print(HTM_CONSTANTS_FONT_CLASS);
        this.pw.print(RIGHT_QUOTE);
        this.pw.println(RIGHT_BRACKET);
        this.printStartTag(this.pw, B);
        this.pw.print(title);
        this.printEndTag(this.pw, B);
        this.printEndTag(this.pw, FONT);
        this.printEndTag(this.pw, A);
        this.pw.println(HTM_CONSTANTS_NBSP);
        this.printEndTag(this.pw, TD);
    }

    private void printHref(String ref) {
        this.pw.print(LEFT_BRACKET);
        this.pw.print(A);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(HREF);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("items" + File.separator + ref + HTM_FILE_SUFF);
        this.pw.print(RIGHT_QUOTE);
        this.pw.println(RIGHT_BRACKET);
    }

    private void printStyleTD() {
        this.pw.print(LEFT_BRACKET);
        this.pw.print(TR);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(ALIGN);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("center");
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(VALIGN);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("top");
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(RIGHT_BRACKET);
        this.pw.print(LEFT_BRACKET);
        this.pw.print(TD);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(BGCOLOR);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("#EEEEFF");
        this.pw.print(RIGHT_QUOTE);
        this.pw.print(HTM_CONSTANTS_INDENT);
        this.pw.print(CLASS);
        this.pw.print(HTM_CONSTATNS_EQUAL);
        this.pw.print(LEFT_QUOTE);
        this.pw.print("NavBarCell1");
        this.pw.print(RIGHT_QUOTE);
        this.pw.println(RIGHT_BRACKET);
    }

    private void printStartTag(PrintWriter pw, String startTag) {
        pw.print(LEFT_BRACKET);
        pw.print(startTag);
        pw.println(RIGHT_BRACKET);
    }

    private void printEndTag(PrintWriter pw, String endTag) {
        pw.print(LEFT_BRACKET);
        pw.print(TAG_END);
        pw.print(endTag);
        pw.println(RIGHT_BRACKET);
    }

    private void printImageTag(PrintWriter pw, String imageRef) {
        File file;
        if (TEMP_ITEM_IMAGES_PATH != null && (file = new File(FilenameUtils.normalize((String)(TEMP_ITEM_IMAGES_PATH + imageRef)))).exists()) {
            this.printStartTag(pw, TR);
            this.printStartTag(pw, TD);
            pw.print("<img src=\"images\\");
            pw.print(file.getName());
            pw.print("\">");
            this.printEndTag(pw, TD);
            this.printEndTag(pw, TR);
        }
    }
}

