/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.ContentLayout;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.CustomUndoableEditSupport;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.ICtrlDependency;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.IPreChangeListener;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.InsideCollapsedException;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.UndoableChanging;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.ExprStringMapping;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import java.awt.Color;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEditSupport;
import org.apache.log4j.Logger;

class FuncCollapsableDocument
extends DefaultStyledDocument {
    private static final Logger log = LogUtil.getPackageLogger(FuncCollapsableDocument.class);
    static final String CollapsedFuncReplaceBy = "@";
    private ICtrlDependency _ctrlDependency;
    private ExprStringMapping _mappingTool;
    private IFuncUnit _rootFuncUnit;
    private boolean _isSyntaxError;
    private boolean _isUndoable = true;
    private boolean _isCompositeUndo;
    private UndoableEditListener _myUndoableListener;
    private UndoableEditSupport _undoSupport;
    private boolean _isCopying;
    private IPreChangeListener _preChangeListener;
    private ContentLayout.IParamWrapAsker _paramWrapAsker;
    private FuncCollapsableEditor.ISyntaxStatusListener _syntaxStatusListener;

    public FuncCollapsableDocument() {
        this.setDocumentFilter(new CustomDocumentFilter());
    }

    CustomDocumentFilter getCustomDocumentFilter() {
        return (CustomDocumentFilter)super.getDocumentFilter();
    }

    public void setCtrlDependency(ICtrlDependency l) {
        this._ctrlDependency = l;
    }

    ICtrlDependency getCtrlDependency() {
        return this._ctrlDependency;
    }

    public void setUndoableEditListener(UndoableEditListener l) {
        this._myUndoableListener = l;
        this._undoSupport = new CustomUndoableEditSupport();
        this._undoSupport.addUndoableEditListener(l);
    }

    public void setPreChangeListener(IPreChangeListener l) {
        this._preChangeListener = l;
    }

    private void firePreChange() {
        if (this._preChangeListener != null) {
            this._preChangeListener.willChange(this);
        }
    }

    private ExprStringMapping getMappingTool() {
        if (this._mappingTool == null) {
            this._mappingTool = new ExprStringMapping();
        }
        return this._mappingTool;
    }

    public void setSyntaxStatusListener(FuncCollapsableEditor.ISyntaxStatusListener l) {
        this._syntaxStatusListener = l;
    }

    public void setExprCreator(ExprStringMapping.IExprCreator creator) {
        this.getMappingTool().setExprCreator(creator);
    }

    void myWriteLock() {
        super.writeLock();
    }

    void myWriteUnlock() {
        super.writeUnlock();
    }

    IFuncUnit searchFuncUnitByPos(int pos) {
        if (this._rootFuncUnit == null) {
            return null;
        }
        return this.searchFuncUnitByPos(this._rootFuncUnit, pos);
    }

    private IFuncUnit searchFuncUnitByPos(IFuncUnit parent, int pos) {
        for (int i = parent.getChildrenCount() - 1; i >= 0; --i) {
            IFuncUnit child = parent.getChild(i);
            if (child.isCollapsed() || pos < child.getNameStartPos()) continue;
            if (pos < child.getNameStartPos() + child.getNameLength()) {
                return child;
            }
            return this.searchFuncUnitByPos(child, pos);
        }
        return null;
    }

    IFuncUnit searchBreadcrumb(int pos) {
        if (this._rootFuncUnit == null) {
            return null;
        }
        return this.searchBreadcrumb(this._rootFuncUnit, pos);
    }

    private IFuncUnit searchBreadcrumb(IFuncUnit parent, int pos) {
        for (int i = parent.getChildrenCount() - 1; i >= 0; --i) {
            IFuncUnit child = parent.getChild(i);
            if (child.isCollapsed() || pos <= child.getNameStartPos() || pos > child.getRpPos()) continue;
            IFuncUnit deeper = this.searchBreadcrumb(child, pos);
            return deeper == null ? child : deeper;
        }
        return null;
    }

    int searchAnotherBracketPos(int pos) {
        boolean isLeft;
        char ch;
        if (this._rootFuncUnit == null) {
            return -1;
        }
        try {
            ch = this.getText(pos, 1).charAt(0);
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            return -1;
        }
        if ('(' == ch || '{' == ch) {
            isLeft = true;
        } else if (')' == ch || '}' == ch) {
            isLeft = false;
        } else {
            return -1;
        }
        LinkedList<IFuncUnit> queue = new LinkedList<IFuncUnit>();
        queue.add(this._rootFuncUnit);
        while (!queue.isEmpty()) {
            IFuncUnit unit = (IFuncUnit)queue.removeFirst();
            if (unit != this._rootFuncUnit && (unit.isCollapsed() || unit.isInvalid(2L) || unit.isInvalid(4L) || unit.getNameStartPos() > pos || unit.getNameStartPos() + unit.getAllLength() < pos)) continue;
            if (unit != this._rootFuncUnit) {
                if (isLeft && pos == unit.getLpPos()) {
                    return unit.getRpPos();
                }
                if (!isLeft && pos == unit.getRpPos()) {
                    return unit.getLpPos();
                }
            }
            if (unit.getChildrenCount() <= 0) continue;
            int c = unit.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                queue.addLast(unit.getChild(i));
            }
        }
        return -1;
    }

    AttributeSet getNormalStyle() {
        Style style = this.getStyle("FCE_Normal");
        if (style == null) {
            style = this.createFuncStyle("FCE_Normal", new Object[]{Color.BLACK, Color.WHITE});
        }
        return style;
    }

    AttributeSet getFuncNameStyle() {
        Style style = this.getStyle("FCE_FuncName");
        if (style == null) {
            style = this.createFuncStyle("FCE_FuncName", new Object[]{Color.BLUE, Color.WHITE});
        }
        return style;
    }

    AttributeSet getFuncBracketStyle() {
        Style style = this.getStyle("FCE_FuncBracket");
        if (style == null) {
            style = this.createFuncStyle("FCE_FuncBracket", new Object[]{Color.WHITE, Color.BLUE});
        }
        return style;
    }

    AttributeSet getFuncCommaStyle() {
        Style style = this.getStyle("FCE_FuncComma");
        if (style == null) {
            style = this.createFuncStyle("FCE_FuncComma", new Object[]{Color.YELLOW, new Color(0, 153, 0)});
        }
        return style;
    }

    AttributeSet getInvalidBaseStyle() {
        Style style = this.getStyle("FCE_InvalidBase");
        if (style == null) {
            style = this.createFuncStyle("FCE_InvalidBase", new Object[]{Color.RED, Color.WHITE});
        }
        return style;
    }

    AttributeSet getInvalidBrightStyle() {
        Style style = this.getStyle("FCE_InvalidBright");
        if (style == null) {
            style = this.createFuncStyle("FCE_InvalidBright", new Object[]{Color.YELLOW, Color.RED});
        }
        return style;
    }

    AttributeSet getBracketPairStyle() {
        Style style = this.getStyle("FCE_BracketPair");
        if (style == null) {
            style = this.createFuncStyle("FCE_BracketPair", new Object[]{Color.BLACK, Color.YELLOW});
        }
        return style;
    }

    private Style createFuncStyle(String key, Object[] attrs) {
        Style style = this.addStyle(key, null);
        style.addAttribute(StyleConstants.Foreground, attrs[0]);
        style.addAttribute(StyleConstants.Background, attrs[1]);
        return style;
    }

    private boolean remapping() {
        String[] ctn;
        try {
            ctn = this.getRealText(0, this.getLength());
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            return false;
        }
        log.debug((Object)"\u516c\u5f0f\u5f15\u64ce\u91cd\u65b0\u6620\u5c04\u51fd\u6570\u4f4d\u7f6e");
        log.debug((Object)ctn[0]);
        this._isSyntaxError = !this.getMappingTool().parse(ctn[0], ctn[1]);
        int syntaxErrorPos = 0;
        SyntaxErrorException syntaxError = null;
        if (this._isSyntaxError) {
            syntaxError = this.getMappingTool().getSyntaxError();
            syntaxErrorPos = this.getMappingTool().getSyntaxErrorPos();
            syntaxErrorPos = FuncCollapsableDocument.toAccuratePos(syntaxErrorPos, ctn[0], ctn[1]);
        }
        if (this._syntaxStatusListener != null) {
            this._syntaxStatusListener.syntaxChecked(this._isSyntaxError, syntaxErrorPos, syntaxError);
        }
        if (this._isSyntaxError) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u8bed\u6cd5\u9519\u8bef\uff0c\u4f4d\u4e8e:" + syntaxErrorPos + "\u3002\t" + syntaxError));
            }
            return false;
        }
        IFuncUnit newRootFuncUnit = this.getMappingTool().getResult();
        if (this._rootFuncUnit != null) {
            log.debug((Object)"\u539f\u5148\u51fd\u6570\u96c6\u5408\uff1a");
            this.logAllUnit(this._rootFuncUnit);
            log.debug((Object)"\u4fdd\u6301\u539f\u5148\u6536\u8d77\u72b6\u6001\uff1a");
            this.keepCollapsedState(this._rootFuncUnit, newRootFuncUnit);
            log.debug((Object)"\u65b0\u72b6\u6001\u51fd\u6570\u96c6\u5408\uff1a");
            this.logAllUnit(newRootFuncUnit);
        }
        this._rootFuncUnit = newRootFuncUnit;
        return true;
    }

    private static int toAccuratePos(int pos, String ctn4Syntax, String ctn) {
        int delta = 0;
        int pOri = 0;
        int lenOri = ctn.length();
        while (pOri < lenOri && ctn.charAt(pOri) <= ' ') {
            ++pOri;
            ++delta;
        }
        int pStx = 0;
        while (pStx < pos) {
            if (ctn4Syntax.charAt(pStx) == ctn.charAt(pOri)) {
                ++pStx;
                ++pOri;
                continue;
            }
            ++pStx;
            --delta;
        }
        return pos + delta;
    }

    private void logAllUnit(IFuncUnit parent) {
        if (log.isDebugEnabled()) {
            int size = parent.getChildrenCount();
            for (int i = 0; i < size; ++i) {
                IFuncUnit child = parent.getChild(i);
                log.debug((Object)child);
                this.logAllUnit(child);
            }
        }
    }

    private void keepCollapsedState(IFuncUnit oldSetParent, IFuncUnit newRoot) {
        int size = oldSetParent.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IFuncUnit child = oldSetParent.getChild(i);
            this.keepCollapsedState(child, newRoot);
            if (!child.isCollapsed() || this.compareAndReplace(newRoot, newRoot, child)) continue;
            log.debug((Object)("\u6536\u8d77\u51fd\u6570\u627e\u4e0d\u5230\u66ff\u6362\u8282\u70b9 " + child));
        }
    }

    private boolean compareAndReplace(IFuncUnit newRoot, IFuncUnit newSetParent, IFuncUnit oldOne) {
        int size = newSetParent.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IFuncUnit child = newSetParent.getChild(i);
            if (child.getFuncName().equals(oldOne.getFuncName()) && child.getStartAtText() == oldOne.getStartAtText()) {
                child.replaceNode(oldOne);
                int delta = -(oldOne.getCollapsedText().length() - CollapsedFuncReplaceBy.length());
                this.collapseFuncUnit(newRoot, oldOne, false, child.getNameStartPos(), delta, false);
                return true;
            }
            if (!this.compareAndReplace(newRoot, child, oldOne)) continue;
            return true;
        }
        return false;
    }

    String getRealText() {
        try {
            return this.getRealText(0, this.getLength())[1];
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    private String[] getRealText(int offset, int length) throws BadLocationException {
        StringBuffer content = new StringBuffer(super.getText(offset, length));
        StringBuffer ctn4Syntax = new StringBuffer(content);
        if (this._rootFuncUnit != null) {
            FuncCollapsableDocument.getCollapsedText(offset, offset + length, content, ctn4Syntax, this._rootFuncUnit, false);
        }
        return new String[]{ctn4Syntax.toString().trim(), content.toString()};
    }

    private static void getCollapsedText(int fromPos, int toPos, StringBuffer ctn, StringBuffer ctn4Syntax, IFuncUnit parent, boolean isAncestorCollapsed) {
        for (int i = parent.getChildrenCount() - 1; i >= 0; --i) {
            IFuncUnit child = parent.getChild(i);
            if (child.isCollapsed()) {
                int pos = child.getCollapsedStartPos();
                if (!isAncestorCollapsed && (fromPos > pos || pos >= toPos)) continue;
                StringBuffer sb = new StringBuffer(child.getCollapsedText());
                StringBuffer sb4Syntax = new StringBuffer(child.getCollapsedText());
                FuncCollapsableDocument.getCollapsedText(fromPos, toPos, sb, sb4Syntax, child, true);
                if (!isAncestorCollapsed) {
                    pos -= fromPos;
                }
                int insteadLen = CollapsedFuncReplaceBy.length();
                ctn.replace(pos, pos + insteadLen, sb.toString());
                ctn4Syntax.replace(pos, pos + insteadLen, sb4Syntax.toString());
                ctn4Syntax.insert(pos, ' ');
                continue;
            }
            FuncCollapsableDocument.getCollapsedText(fromPos, toPos, ctn, ctn4Syntax, child, isAncestorCollapsed);
        }
    }

    public void collapseFuncUnit(IFuncUnit unit) {
        String txt;
        FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("willCollapse", "\u5373\u5c06\u6536\u8d77\uff1a"), unit);
        int len = unit.getAllLength();
        int targetPos = unit.getNameStartPos();
        try {
            txt = this.getText(targetPos, len);
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            return;
        }
        if (!this.innerRemove(targetPos, len)) {
            return;
        }
        int delta = -(len - CollapsedFuncReplaceBy.length());
        this.collapseFuncUnit(this._rootFuncUnit, unit, false, targetPos, delta, true);
        unit.setCollapsed(true);
        unit.setCollapsedText(txt);
        unit.setCollapsedStartPos(targetPos);
        this.fireInsteadCtrl(targetPos, unit.getCollapsedInsteadCtrl());
        FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("collapsed", "\u5df2\u6536\u8d77\uff1a"), unit);
    }

    private boolean collapseFuncUnit(IFuncUnit parent, IFuncUnit unit, boolean isMatched, int targetPos, int delta, boolean isModifySelf) {
        int size = parent.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IFuncUnit temp = parent.getChild(i);
            if (!isMatched && temp == unit) {
                isMatched = true;
                if (!isModifySelf) continue;
                FuncCollapsableDocument.changeDescendantRelative(unit, unit, targetPos, false);
                continue;
            }
            if (!temp.isCollapsed()) {
                isMatched = this.collapseFuncUnit(temp, unit, isMatched, targetPos, delta, isModifySelf);
            }
            if (!isMatched) continue;
            FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("collapseModification", "_\u6536\u8d77\u4fee\u6539\uff1a"), temp);
            temp.updateEditorPos(targetPos, delta);
            FuncCollapsableDocument.logDebug("_\u3000\uff1d\u300b", temp);
        }
        return isMatched;
    }

    private static void changeDescendantRelative(IFuncUnit parent, IFuncUnit unit, int targetPos, boolean isBack) {
        FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("changeToRelative", "_\u6539\u4e3a\u76f8\u5bf9\uff1a"), parent);
        if (parent == unit || !parent.isCollapsed()) {
            parent.relative(targetPos, isBack);
        } else {
            int c = targetPos * (isBack ? -1 : 1);
            parent.setCollapsedStartPos(parent.getCollapsedStartPos() - c);
        }
        FuncCollapsableDocument.logDebug("_\u3000\u3000\uff1d\u300b\u3000", parent);
        if (parent == unit || !parent.isCollapsed()) {
            for (int i = 0; i < parent.getChildrenCount(); ++i) {
                IFuncUnit child = parent.getChild(i);
                FuncCollapsableDocument.changeDescendantRelative(child, unit, targetPos, isBack);
            }
        }
    }

    public void expandFuncUnit(IFuncUnit unit) {
        FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("willExpand", "\u5373\u5c06\u5c55\u5f00\uff1a"), unit);
        String txt = unit.getCollapsedText();
        int targetPos = unit.getCollapsedStartPos();
        if (!this.innerReplace(targetPos, CollapsedFuncReplaceBy.length(), txt, null)) {
            return;
        }
        int delta = unit.getAllLength() - CollapsedFuncReplaceBy.length();
        this.expandFuncUnit(this._rootFuncUnit, unit, false, targetPos, delta);
        unit.setCollapsed(false);
        unit.setCollapsedStartPos(0);
        FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("expanded", "\u5df2\u5c55\u5f00\uff1a"), unit);
    }

    private boolean expandFuncUnit(IFuncUnit parent, IFuncUnit unit, boolean isMatched, int targetPos, int delta) {
        int size = parent.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IFuncUnit temp = parent.getChild(i);
            if (!isMatched && temp == unit) {
                isMatched = true;
                FuncCollapsableDocument.changeDescendantRelative(unit, unit, targetPos, true);
                this.insteadCtrlAfterExpand(unit);
                continue;
            }
            if (!temp.isCollapsed()) {
                isMatched = this.expandFuncUnit(temp, unit, isMatched, targetPos, delta);
            }
            if (!isMatched) continue;
            FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("expandModification", "_\u5c55\u5f00\u6539\u56de\uff1a"), temp);
            temp.updateEditorPos(targetPos, delta);
            FuncCollapsableDocument.logDebug("_\u3000\uff1d\u300b", temp);
        }
        return isMatched;
    }

    private void insteadCtrlAfterExpand(IFuncUnit parent) {
        for (int j = parent.getChildrenCount() - 1; j >= 0; --j) {
            IFuncUnit child = parent.getChild(j);
            if (child.isCollapsed()) {
                this.innerRemove(child.getCollapsedStartPos(), CollapsedFuncReplaceBy.length());
                this.fireInsteadCtrl(child.getCollapsedStartPos(), child.getCollapsedInsteadCtrl());
                continue;
            }
            this.insteadCtrlAfterExpand(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerReplace(int offset, int length, String text, AttributeSet attrs) {
        try {
            this.getCustomDocumentFilter().closeAdditional();
            this.closeUndoable();
            super.replace(offset, length, text, attrs);
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.openUndoable();
            this.getCustomDocumentFilter().openAdditional();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerRemove(int offset, int length) {
        try {
            this.getCustomDocumentFilter().closeAdditional();
            this.closeUndoable();
            super.remove(offset, length);
        }
        catch (BadLocationException ex) {
            log.error((Object)"", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.openUndoable();
            this.getCustomDocumentFilter().openAdditional();
        }
        return true;
    }

    private void fireInsteadCtrl(int pos, JComponent ctrl) {
        try {
            this.getCustomDocumentFilter().closeAdditional();
            this.closeUndoable();
            this._ctrlDependency.insertSubCtrl(pos, ctrl);
        }
        finally {
            this.openUndoable();
            this.getCustomDocumentFilter().openAdditional();
        }
    }

    private boolean isInsteadCtrl(AttributeSet attrs) {
        return attrs.containsAttribute("$ename", "component");
    }

    boolean isInsteadCtrl(int pos) {
        return this.isInsteadCtrl(this.getCharacterElement(pos).getAttributes());
    }

    JComponent getInsteadCtrl(int pos) {
        AttributeSet a = this.getCharacterElement(pos).getAttributes();
        return (JComponent)a.getAttribute(StyleConstants.ComponentAttribute);
    }

    static void logDebug(String text, Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(text + obj));
        }
    }

    private int changeEditorPos2TextPos(int editorPos) {
        if (this._rootFuncUnit == null) {
            return editorPos;
        }
        int textPos = editorPos;
        LinkedList<IFuncUnit> queue = new LinkedList<IFuncUnit>();
        queue.add(this._rootFuncUnit);
        while (!queue.isEmpty()) {
            IFuncUnit unit = (IFuncUnit)queue.removeFirst();
            if (unit.isCollapsed()) {
                if (unit.getCollapsedStartPos() >= editorPos) continue;
                textPos += this.getCollapsedReduceLength(unit);
                continue;
            }
            if (unit.getNameStartPos() >= editorPos) continue;
            int c = unit.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                queue.addLast(unit.getChild(i));
            }
        }
        return textPos;
    }

    private int getCollapsedReduceLength(IFuncUnit unit) {
        int len = 0;
        if (unit.isCollapsed()) {
            len = unit.getAllLength() - CollapsedFuncReplaceBy.length();
        }
        int c = unit.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            len += this.getCollapsedReduceLength(unit.getChild(i));
        }
        return len;
    }

    int changeTextPos2EditorPos(int textPos) throws InsideCollapsedException {
        if (this._rootFuncUnit == null) {
            return textPos;
        }
        int editorPos = textPos;
        LinkedList<IFuncUnit> queue = new LinkedList<IFuncUnit>();
        queue.add(this._rootFuncUnit);
        while (!queue.isEmpty()) {
            IFuncUnit unit = (IFuncUnit)queue.removeFirst();
            if (unit.getStartAtText() >= textPos) continue;
            if (unit.isCollapsed()) {
                int len = this.getCollapsedReduceLength(unit);
                if (unit.getStartAtText() + len + CollapsedFuncReplaceBy.length() > textPos) {
                    throw new InsideCollapsedException(unit);
                }
                editorPos -= len;
                continue;
            }
            int c = unit.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                queue.addLast(unit.getChild(i));
            }
        }
        return editorPos;
    }

    void openUndoable() {
        this._isUndoable = true;
    }

    void closeUndoable() {
        this._isUndoable = false;
    }

    private boolean isUndoable() {
        return this._isUndoable;
    }

    void openCompositeUndo() {
        this._isCompositeUndo = true;
        this._undoSupport.beginUpdate();
    }

    void closeCompositeUndo() {
        this._isCompositeUndo = false;
        this._undoSupport.endUpdate();
    }

    private void fireUndoable(UndoableChanging edit) {
        if (this._isCompositeUndo) {
            this._undoSupport.postEdit(edit);
        } else {
            this._myUndoableListener.undoableEditHappened(new UndoableEditEvent(this, edit));
        }
    }

    void openCopying() {
        this._isCopying = true;
    }

    void closeCopying() {
        this._isCopying = false;
    }

    boolean isCopying() {
        return this._isCopying;
    }

    String getSelectionRealText(int fromEditorPos, int toEditorPos) throws BadLocationException {
        return this.getRealText(fromEditorPos, toEditorPos - fromEditorPos)[1];
    }

    public void layoutWithTab() {
        if (this._rootFuncUnit == null) {
            return;
        }
        this.writeLock();
        try {
            boolean isFullCollect = this.remapping();
            ContentLayout cl = new ContentLayout(this, this._rootFuncUnit, isFullCollect);
            cl.setParamWrapAsker(this._paramWrapAsker);
            cl.layoutWithTab();
            this.remapping();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setParamWrapAsker(ContentLayout.IParamWrapAsker paramWrapAsker) {
        this._paramWrapAsker = paramWrapAsker;
    }

    class AutoInputHandler {
        private static final int STATE_NONE = 0;
        private static final int STATE_INPUT_LP = 1;
        private static final int STATE_REMOVE_LP = 2;
        private static final int STATE_INPUT_RP = 3;
        private int _state;
        private int _lastTextPos;

        AutoInputHandler() {
        }

        public void clear() {
            this._state = 0;
            this._lastTextPos = -1;
        }

        public String beforeInsert(int editorPos, String insertText) {
            if (insertText.length() == 1) {
                int textPos;
                char c = insertText.charAt(0);
                if (this._state == 1 && c == ')' && (textPos = FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos)) == this._lastTextPos + 1) {
                    this._lastTextPos = textPos;
                    this._state = 3;
                    return "";
                }
                if (c == '(') {
                    if (editorPos < FuncCollapsableDocument.this.getLength()) {
                        String nextStr;
                        try {
                            nextStr = FuncCollapsableDocument.this.getText(editorPos, 1);
                        }
                        catch (BadLocationException ex) {
                            log.error((Object)"", (Throwable)ex);
                            this.clear();
                            return insertText;
                        }
                        char nextChar = nextStr.charAt(0);
                        if (nextChar == '(' || nextChar == '\"' || nextChar >= '0' && nextChar <= '9' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= 'a' && nextChar <= 'z' || nextChar > '\u007f') {
                            this.clear();
                            return insertText;
                        }
                        if (FuncCollapsableDocument.CollapsedFuncReplaceBy.equals(nextStr) && FuncCollapsableDocument.this.isInsteadCtrl(editorPos)) {
                            this.clear();
                            return insertText;
                        }
                    }
                    this._lastTextPos = FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos);
                    this._state = 1;
                    return "()";
                }
            }
            this.clear();
            return insertText;
        }

        public void afterInsert() {
            if (this._state == 1 || this._state == 3) {
                try {
                    FuncCollapsableDocument.this.getCtrlDependency().setCaretPosition(FuncCollapsableDocument.this.changeTextPos2EditorPos(this._lastTextPos) + 1);
                }
                catch (InsideCollapsedException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }

        public int beforeRemove(int editorPos, int length) {
            int textPos;
            if (this._state == 1 && length == 1 && (textPos = FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos)) == this._lastTextPos) {
                this._state = 2;
                return 2;
            }
            this.clear();
            return length;
        }

        public void afterRemove() {
        }
    }

    class CustomDocumentFilter
    extends DocumentFilter {
        private boolean doRemapping = true;
        private boolean doSyncFunc = true;
        private AutoInputHandler autoInput = new AutoInputHandler();

        CustomDocumentFilter() {
        }

        public void openAdditional() {
            this.doSyncFunc = true;
            this.openRemapping();
        }

        public void closeAdditional() {
            this.doSyncFunc = false;
            this.closeRemapping();
        }

        public void openRemapping() {
            this.doRemapping = true;
        }

        public void closeRemapping() {
            this.doRemapping = false;
        }

        private boolean isDoAdditional() {
            return this.isDoSyncFunc() && this.isDoRemapping();
        }

        private boolean isDoSyncFunc() {
            return this.doSyncFunc;
        }

        private boolean isDoRemapping() {
            return this.doRemapping;
        }

        private AttributeSet getCorrectAttrs(AttributeSet attrs) {
            boolean isCtrl = false;
            if (attrs != null) {
                isCtrl = FuncCollapsableDocument.this.isInsteadCtrl(attrs);
            }
            if (attrs == null || !isCtrl) {
                attrs = FuncCollapsableDocument.this.getNormalStyle();
            }
            return attrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            FuncCollapsableDocument.this.writeLock();
            try {
                String insertText = this.autoInputBeforeInsert(offset, string);
                if (!StringUtil.isEmptyString((String)insertText)) {
                    FuncCollapsableDocument.this.firePreChange();
                    attr = this.getCorrectAttrs(attr);
                    super.insertString(fb, offset, insertText, attr);
                    int textPos = this.afterInserted(offset, insertText, -1);
                    this.remapping();
                    this.fireInsertUndoable(offset, textPos, insertText);
                }
                this.autoInputAfterInsert();
            }
            finally {
                FuncCollapsableDocument.this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            FuncCollapsableDocument.this.writeLock();
            try {
                length = this.autoInputBefreRemove(offset, length);
                FuncCollapsableDocument.this.firePreChange();
                String realText = this.beforeRemove(offset, length);
                super.remove(fb, offset, length);
                int textPos = this.afterRemoved(offset, length, realText);
                this.remapping();
                this.fireRemoveUndoable(offset, textPos, realText);
                this.autoInputAfterRemove();
            }
            finally {
                FuncCollapsableDocument.this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            FuncCollapsableDocument.this.writeLock();
            try {
                String insertText;
                if (length == 0) {
                    insertText = this.autoInputBeforeInsert(offset, text);
                } else {
                    this.autoInput.clear();
                    insertText = text;
                }
                if (!StringUtil.isEmptyString((String)insertText)) {
                    FuncCollapsableDocument.this.firePreChange();
                    attrs = this.getCorrectAttrs(attrs);
                    String removeRealText = this.beforeRemove(offset, length);
                    super.replace(fb, offset, length, insertText, attrs);
                    int textPos = this.afterRemoved(offset, length, removeRealText);
                    textPos = this.afterInserted(offset, insertText, textPos);
                    this.remapping();
                    this.fireReplaceUndoable(offset, textPos, removeRealText, insertText);
                }
                this.autoInputAfterInsert();
            }
            finally {
                FuncCollapsableDocument.this.writeUnlock();
            }
        }

        private String beforeRemove(int offset, int length) {
            if (this.isDoSyncFunc() && FuncCollapsableDocument.this._rootFuncUnit != null && length != 0) {
                try {
                    return FuncCollapsableDocument.this.getRealText(offset, length)[1];
                }
                catch (BadLocationException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
            return null;
        }

        private int afterRemoved(int offset, int length, String realText) {
            if (this.isDoSyncFunc() && FuncCollapsableDocument.this._rootFuncUnit != null && length != 0) {
                int textPos = FuncCollapsableDocument.this.changeEditorPos2TextPos(offset);
                int textLen = realText.length();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5728" + offset + "(" + textPos + ")\u5220\u9664" + length + "(" + textLen + ")\u5b57\u7b26"));
                }
                this.removeCollapsed(FuncCollapsableDocument.this._rootFuncUnit, offset, offset + length);
                this.changingPos(FuncCollapsableDocument.this._rootFuncUnit, offset, textPos, -length, -textLen, false);
                return textPos;
            }
            return -1;
        }

        private void removeCollapsed(IFuncUnit parent, int fromPos, int toPos) {
            for (int i = parent.getChildrenCount() - 1; i >= 0; --i) {
                IFuncUnit child = parent.getChild(i);
                if (child.isCollapsed()) {
                    int pos = child.getCollapsedStartPos();
                    if (pos < fromPos || pos >= toPos) continue;
                    parent.removeChild(child);
                    log.debug((Object)("\u5220\u6389\u4e86\uff1a" + child));
                    continue;
                }
                if (child.getNameStartPos() >= toPos) continue;
                this.removeCollapsed(child, fromPos, toPos);
            }
        }

        private int afterInserted(int offset, String txt, int textPos) {
            if (this.isDoSyncFunc() && FuncCollapsableDocument.this._rootFuncUnit != null) {
                if (textPos == -1) {
                    textPos = FuncCollapsableDocument.this.changeEditorPos2TextPos(offset);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5728" + offset + "(" + textPos + ")\u63d2\u5165\uff1a" + txt));
                }
                int len = txt.length();
                this.changingPos(FuncCollapsableDocument.this._rootFuncUnit, offset, textPos, len, len, false);
            }
            return textPos;
        }

        private void changingPos(IFuncUnit parent, int editorPos, int textPos, int editorDelta, int textDelta, boolean isAncestorCollapsed) {
            int size = parent.getChildrenCount();
            for (int i = 0; i < size; ++i) {
                IFuncUnit child = parent.getChild(i);
                FuncCollapsableDocument.logDebug(CtrlEXTMessages.getMLS("change", " \u53d8\u5316\uff1a"), child);
                child.checkInvalid(editorPos, editorDelta);
                if (!isAncestorCollapsed) {
                    child.updateEditorPos(editorPos - 1, editorDelta);
                }
                child.updateTextPos(textPos - 1, textDelta);
                FuncCollapsableDocument.logDebug(" \uff1d\uff1d\u300b", child);
                this.changingPos(child, editorPos, textPos, editorDelta, textDelta, isAncestorCollapsed || child.isCollapsed());
            }
        }

        private void remapping() {
            if (this.isDoRemapping()) {
                FuncCollapsableDocument.this.remapping();
            }
        }

        private void fireRemoveUndoable(int editorPos, int textPos, String realText) {
            if (FuncCollapsableDocument.this.isUndoable()) {
                textPos = textPos == -1 ? FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos) : textPos;
                FuncCollapsableDocument.this.fireUndoable(UndoableChanging.createRemove(FuncCollapsableDocument.this, textPos, realText));
            }
        }

        private void fireInsertUndoable(int editorPos, int textPos, String text) {
            if (FuncCollapsableDocument.this.isUndoable()) {
                textPos = textPos == -1 ? FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos) : textPos;
                FuncCollapsableDocument.this.fireUndoable(UndoableChanging.createInsert(FuncCollapsableDocument.this, textPos, text));
            }
        }

        private void fireReplaceUndoable(int editorPos, int textPos, String removeRealText, String insertText) {
            if (FuncCollapsableDocument.this.isUndoable()) {
                int n = textPos = textPos == -1 ? FuncCollapsableDocument.this.changeEditorPos2TextPos(editorPos) : textPos;
                if (removeRealText == null) {
                    FuncCollapsableDocument.this.fireUndoable(UndoableChanging.createInsert(FuncCollapsableDocument.this, textPos, insertText));
                } else {
                    FuncCollapsableDocument.this.fireUndoable(UndoableChanging.createReplace(FuncCollapsableDocument.this, textPos, removeRealText, insertText));
                }
            }
        }

        private String autoInputBeforeInsert(int editorPos, String insertText) {
            if (this.isDoAdditional()) {
                if (FuncCollapsableDocument.this.isUndoable() && !FuncCollapsableDocument.this.isCopying()) {
                    return this.autoInput.beforeInsert(editorPos, insertText);
                }
                this.autoInput.clear();
            }
            return insertText;
        }

        private void autoInputAfterInsert() {
            if (this.isDoAdditional() && FuncCollapsableDocument.this.isUndoable() && !FuncCollapsableDocument.this.isCopying()) {
                this.autoInput.afterInsert();
            }
        }

        private int autoInputBefreRemove(int editorPos, int length) {
            if (this.isDoAdditional()) {
                if (FuncCollapsableDocument.this.isUndoable() && !FuncCollapsableDocument.this.isCopying()) {
                    return this.autoInput.beforeRemove(editorPos, length);
                }
                this.autoInput.clear();
            }
            return length;
        }

        private void autoInputAfterRemove() {
            if (this.isDoAdditional() && FuncCollapsableDocument.this.isUndoable() && !FuncCollapsableDocument.this.isCopying()) {
                this.autoInput.afterRemove();
            }
        }
    }
}

