/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.AbstractParamBizModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.IParamBizModel;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComponent;

class ParamsList {
    private KDPanel _panAll = new KDPanel();
    private TableLayout _layout;

    public ParamsList() {
        this._panAll.setCustomInsets(new Insets(8, 8, 8, 8));
        this._panAll.setBackground(Color.WHITE);
    }

    public JComponent getCtrl() {
        return this._panAll;
    }

    public void setParams(int paramsCount) {
        this._panAll.removeAll();
        this._layout = TableLayout.splitRow((int)(paramsCount + 1));
        this._layout.getStyle().setMargin(6, 6, 0, 0);
        this._layout.rowStyle(paramsCount).setPriY(1);
        this._panAll.setLayout((LayoutManager)this._layout);
    }

    public void addParam(IParamBizModel mo, int paramIdx, ActionListener l) {
        if (mo == null) {
            mo = new UnknownParam();
        }
        KDWorkButton btn = new KDWorkButton();
        btn.setFocusable(false);
        btn.setText(mo.getName(paramIdx) + "  ");
        btn.setToolTipText(mo.getDescription());
        btn.addActionListener(l);
        KDLabel labDesc = new KDLabel();
        labDesc.setText(mo.getDescription());
        KDLabel labOption = new KDLabel(" *");
        labOption.setUserObject((Object)mo);
        labOption.setToolTipText(CtrlEXTMessages.getMLS("nonOmissibleParameters", "\u4e0d\u80fd\u7701\u7565\u7684\u53c2\u6570"));
        labOption.setForeground(Color.RED);
        this._layout.rowStyle(paramIdx).setMarginBottom(3);
        Table row = this._layout.cell(paramIdx).splitCol(3);
        row.colStyle(2).setPriX(1);
        this._panAll.add((Component)btn, (Object)row.cell(0));
        this._panAll.add((Component)labOption, (Object)row.cell(1));
        this._panAll.add((Component)labDesc, (Object)row.cell(2));
    }

    public void setCurrentIdx(int paramIdx) {
        int c = this._panAll.getComponentCount();
        for (int i = 0; i < c; i += 3) {
            KDWorkButton btn = (KDWorkButton)this._panAll.getComponent(i);
            if (i == paramIdx * 3) {
                btn.setFont(btn.getFont().deriveFont(1));
                btn.setText(btn.getText().trim());
                Rectangle rect = new Rectangle(btn.getSize());
                rect.x = btn.getX();
                rect.y = btn.getY();
                this._panAll.scrollRectToVisible(rect);
                continue;
            }
            btn.setFont(btn.getFont().deriveFont(0));
        }
    }

    public void postUpdate() {
        this._panAll.validate();
        this._panAll.repaint();
    }

    public void setCurrentCount(int paramsCount) {
        int c = paramsCount * 3;
        block3: for (int i = this._panAll.getComponentCount() - 1; i >= 0; --i) {
            Component ctrl = this._panAll.getComponent(i);
            switch (i % 3) {
                case 0: 
                case 2: {
                    ctrl.setEnabled(i < c);
                    continue block3;
                }
                default: {
                    if (i < c) {
                        ctrl.setVisible(false);
                        continue block3;
                    }
                    IParamBizModel mo = (IParamBizModel)((KDLabel)ctrl).getUserObject();
                    ctrl.setVisible(!mo.isOption());
                }
            }
        }
    }

    private static class UnknownParam
    extends AbstractParamBizModel {
        public UnknownParam() {
            this.setNameWithoutPostfix("\u3000???\u3000");
            this.setDescription(CtrlEXTMessages.getMLS("unrecognizedParameter", "\uff08\u4e0d\u53ef\u8bc6\u522b\u7684\u53c2\u6570\uff09"));
        }

        @Override
        public boolean isMatching(int paramsCount, int paramIdx, Map more) {
            return true;
        }
    }
}

