/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.exception.ValidateException;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.kpi.KPIDefine;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model.ExtMessage;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model.IndexDefine;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.util.ExtURL;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PropellingModel
implements Cloneable {
    private static Logger logger = Logger.getLogger(PropellingModel.class);
    private static int CANVAS_WIDTH = 640;
    private static int CANVAS_HEIGHT = 320;
    private static int IMG_SEP = 10;
    private static int VERTICAL_SEP = 64;
    private static int TITLE_PADDING_LEFT = 16;
    private static int TITLE_PADDING_TOP = 8;
    private static int HORIZONTAL_SEP_TOP = 10;
    private static int HORIZONTAL_SEP_BOTTOM = 48;
    private MessageType type = MessageType.TEXT_ONLY;
    private MetroLayoutType lType;
    private Expr preFormula;
    private Expr titleFormula;
    private Expr contentFormula;
    private String imagePath;
    private IndexDefine[] indexes;
    private Book book;
    private ArrayList<KPIDefine> defines = new ArrayList();
    public static final Color DEFAULT_NAME_FORECOLOR = new Color(234, 234, 234);
    public static final Color DEFAULT_VALUE_FORECOLOR = Color.WHITE;
    public static final Color[] DEFAULT_BG_COLOR = new Color[]{new Color(70, 159, 226), new Color(81, 192, 163), new Color(114, 112, 158), new Color(93, 125, 200)};

    public static final String getDefaultDataFormat() {
        return CtrlEXTMessages.getMLS("general", "G/\u901a\u7528\u683c\u5f0f");
    }

    public PropellingModel(Book book) {
        this.book = book;
    }

    public PropellingModel setMessageType(MessageType type) {
        this.type = type;
        return this;
    }

    public MessageType getMessageType() {
        return this.type;
    }

    public PropellingModel setMetroLayoutType(MetroLayoutType lType) {
        if (this.lType == lType) {
            return this;
        }
        this.lType = lType;
        this.switchMetroLayoutType();
        return this;
    }

    public MetroLayoutType getMetroLayoutType() {
        return this.lType;
    }

    public PropellingModel setTitleFormula(String titleFormula) {
        this.titleFormula = PropellingModel.parseFormula(this.book, titleFormula);
        return this;
    }

    public String getTitleFormula() {
        return PropellingModel.getFormula(this.book, this.titleFormula);
    }

    public PropellingModel setContentFormula(String contentFormula) {
        this.contentFormula = PropellingModel.parseFormula(this.book, contentFormula);
        return this;
    }

    public String getContentFormula() {
        return PropellingModel.getFormula(this.book, this.contentFormula);
    }

    public PropellingModel setPreFormula(String preFormula) {
        this.preFormula = PropellingModel.parseFormula(this.book, preFormula);
        return this;
    }

    public String getPreFormula() {
        return PropellingModel.getFormula(this.book, this.preFormula);
    }

    public PropellingModel setImagePath(String imagePath) {
        this.imagePath = imagePath;
        return this;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public IndexDefine getIndexDefine(int position) {
        return this.indexes[position];
    }

    public int metroSize() {
        return this.indexes == null ? 0 : this.indexes.length;
    }

    private void switchMetroLayoutType() {
        switch (this.lType) {
            case ANN: {
                this.indexes = new IndexDefine[1];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, IMG_SEP, CANVAS_WIDTH - IMG_SEP * 2 - VERTICAL_SEP * 2, CANVAS_HEIGHT / 2 - IMG_SEP * 2), this.book);
                this.indexes[0].getArea().y += (CANVAS_HEIGHT - this.indexes[0].getArea().height) / 2 - IMG_SEP;
                break;
            }
            case BOB0: {
                this.indexes = new IndexDefine[2];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, IMG_SEP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, CANVAS_HEIGHT / 2 - IMG_SEP * 2), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, IMG_SEP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, CANVAS_HEIGHT / 2 - IMG_SEP * 2), this.book);
                this.indexes[0].getArea().y += (CANVAS_HEIGHT - this.indexes[0].getArea().height) / 2 - IMG_SEP;
                this.indexes[1].getArea().y += (CANVAS_HEIGHT - this.indexes[0].getArea().height) / 2 - IMG_SEP;
                break;
            }
            case BOB1: {
                this.indexes = new IndexDefine[2];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, CANVAS_WIDTH - IMG_SEP * 2 - VERTICAL_SEP * 2, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle(IMG_SEP + VERTICAL_SEP, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, CANVAS_WIDTH - IMG_SEP * 2 - VERTICAL_SEP * 2, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                break;
            }
            case CAT0: {
                this.indexes = new IndexDefine[3];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, CANVAS_WIDTH - IMG_SEP * 2 - VERTICAL_SEP * 2, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle(IMG_SEP + VERTICAL_SEP, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[2] = new IndexDefine(2, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                break;
            }
            case CAT1: {
                this.indexes = new IndexDefine[3];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[2] = new IndexDefine(2, new Rectangle(IMG_SEP + VERTICAL_SEP, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, CANVAS_WIDTH - IMG_SEP * 2 - VERTICAL_SEP * 2, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                break;
            }
            case CAT2: {
                this.indexes = new IndexDefine[3];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, CANVAS_HEIGHT - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[2] = new IndexDefine(2, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                break;
            }
            case CAT3: {
                this.indexes = new IndexDefine[3];
                this.indexes[0] = new IndexDefine(1, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[1] = new IndexDefine(0, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, CANVAS_HEIGHT - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM), this.book);
                this.indexes[2] = new IndexDefine(2, new Rectangle(IMG_SEP + VERTICAL_SEP, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                break;
            }
            case DOG0: {
                this.indexes = new IndexDefine[4];
                this.indexes[0] = new IndexDefine(0, new Rectangle(IMG_SEP + VERTICAL_SEP, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[1] = new IndexDefine(1, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, HORIZONTAL_SEP_TOP, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[2] = new IndexDefine(2, new Rectangle(IMG_SEP + VERTICAL_SEP, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
                this.indexes[3] = new IndexDefine(3, new Rectangle((CANVAS_WIDTH + IMG_SEP) / 2, (CANVAS_HEIGHT + IMG_SEP + HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2, (CANVAS_WIDTH - IMG_SEP * 3) / 2 - VERTICAL_SEP, (CANVAS_HEIGHT - IMG_SEP - HORIZONTAL_SEP_TOP - HORIZONTAL_SEP_BOTTOM) / 2), this.book);
            }
        }
    }

    static Expr parseFormula(Book book, String newFormula) {
        if (newFormula == null || "".equals(newFormula)) {
            return null;
        }
        Expr expr = null;
        Sheet sheet0 = book.getSheet(0);
        Cell owner = sheet0.getCell(0, 0, true);
        if (!StringUtil.isEmptyString((String)newFormula) && !(expr = sheet0.getExpr(owner, newFormula)).isSyntaxError()) {
            ExtDataSetManager dm = book.getDataSetManager();
            expr = dm.replaceDSNode(owner, expr, null);
        }
        return expr;
    }

    static String getFormula(Book book, Expr expr) {
        if (expr == null) {
            return "";
        }
        Sheet sheet0 = book.getSheet(0);
        Cell owner = sheet0.getCell(0, 0, true);
        return expr.decode(book.getDeps().getExprContext(), owner);
    }

    public void validatePre() throws ValidateException {
        if (this.preFormula == null) {
            throw new ValidateException(0, CtrlEXTMessages.getMLS("alertExpressionNotSet", "\u9884\u8b66\u8868\u8fbe\u5f0f\u672a\u8bbe\u7f6e\uff01"));
        }
        if (this.preFormula.isSyntaxError()) {
            throw new ValidateException(1, CtrlEXTMessages.getMLS("alertExpressionValidationFailed", "\u9884\u8b66\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"));
        }
    }

    public void validateAll() throws ValidateException {
        this.validatePre();
        if (this.titleFormula == null) {
            throw new ValidateException(2, CtrlEXTMessages.getMLS("titleFormulaNotSet", "\u6807\u9898\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"));
        }
        if (this.titleFormula.isSyntaxError()) {
            throw new ValidateException(3, CtrlEXTMessages.getMLS("titleFormulaValidationFailed", "\u6807\u9898\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"));
        }
        if (this.contentFormula != null && this.contentFormula.isSyntaxError()) {
            throw new ValidateException(5, CtrlEXTMessages.getMLS("contentFormulaValidationFailed", "\u5185\u5bb9\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"));
        }
        switch (this.type) {
            case IMAGE: {
                if (!StringUtil.isEmptyString((String)this.imagePath)) break;
                throw new ValidateException(6, CtrlEXTMessages.getMLS("imagePathNotSet", "\u56fe\u7247\u8def\u5f84\u672a\u8bbe\u7f6e\uff01"));
            }
            case METRO: {
                for (IndexDefine define : this.indexes) {
                    define.validate();
                }
                break;
            }
            case TEXT_ONLY: {
                if (this.contentFormula != null) break;
                throw new ValidateException(4, CtrlEXTMessages.getMLS("contentFormulaNotSet", "\u5185\u5bb9\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"));
            }
        }
    }

    public byte[] serial() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IXmlElement root = XmlUtil.createNode((String)"PropellingModel");
        root.setAttribute("preFormula", this.getPreFormula());
        root.setAttribute("titleFormula", this.getTitleFormula());
        root.setAttribute("messageType", this.getMessageType().name());
        String contentFormula = this.getContentFormula();
        contentFormula = contentFormula.replace("\r", "\\r").replace("\n", "\\n");
        root.setAttribute("contentFormula", contentFormula);
        switch (this.type) {
            case IMAGE: {
                root.addCData(this.getImagePath());
                break;
            }
            case METRO: {
                root.setAttribute("layout", this.getMetroLayoutType().name());
                for (IndexDefine define : this.indexes) {
                    IXmlElement metro = XmlUtil.createNode((String)"metro");
                    metro.setAttribute("nameFormula", define.getNameFormula());
                    metro.setAttribute("dataFormula", define.getDataFormula());
                    metro.setAttribute("foregroundNameFormula", define.getForegroundNameFormula());
                    metro.setAttribute("foregroundValueFormula", define.getForegroundValueFormula());
                    metro.setAttribute("backgroundFormula", define.getBackgroundFormula());
                    String format = ":";
                    if (!StringUtil.isEmptyString((String)define.getDataFormat().getStringValue())) {
                        format = define.getDataFormat().getValue() + ":";
                    } else if (!StringUtil.isEmptyString((String)define.getDataFormat().getFormula())) {
                        format = ":" + define.getDataFormat().getFormula();
                    }
                    metro.setAttribute("dataFormat", format);
                    root.addChild(metro);
                }
                break;
            }
        }
        XmlUtil.save((IXmlElement)root, (OutputStream)out);
        return out.toByteArray();
    }

    public void load(byte[] data) throws IOException {
        IXmlElement root;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            root = XmlUtil.loadRootElement((InputStream)in);
        }
        catch (XmlParsingException e) {
            logger.error((Object)"------can not load PropellingModel------", (Throwable)e);
            return;
        }
        this.setPreFormula(root.getAttribute("preFormula"));
        this.setTitleFormula(root.getAttribute("titleFormula"));
        this.setMessageType(MessageType.valueOf(root.getAttribute("messageType")));
        String contentFormula = root.getAttribute("contentFormula");
        contentFormula = contentFormula.replace("\\r", "\r");
        contentFormula = contentFormula.replace("\\n", "\n");
        this.setContentFormula(contentFormula);
        switch (this.type) {
            case IMAGE: {
                this.setImagePath(root.getText());
                break;
            }
            case METRO: {
                this.setMetroLayoutType(MetroLayoutType.valueOf(root.getAttribute("layout")));
                int position = 0;
                for (Object c : root.getChildren()) {
                    if (!(c instanceof IXmlElement)) continue;
                    IXmlElement metro = (IXmlElement)c;
                    IndexDefine indexDefine = this.getIndexDefine(position).setNameFormula(metro.getAttribute("nameFormula")).setDataFormula(metro.getAttribute("dataFormula")).setForegroundNameFormula(metro.getAttribute("foregroundNameFormula")).setForegroundValueFormula(metro.getAttribute("foregroundValueFormula")).setBackgroundFormula(metro.getAttribute("backgroundFormula"));
                    String dataFormat = metro.getAttribute("dataFormat");
                    String[] format = dataFormat.split(":");
                    StringVFPair vfPair = new StringVFPair(null, null);
                    if (format.length > 0) {
                        if (!StringUtil.isEmptyString((String)format[0])) {
                            vfPair = new StringVFPair(format[0], null);
                        } else if (!StringUtil.isEmptyString((String)format[1])) {
                            vfPair = new StringVFPair(null, format[1]);
                        }
                    }
                    indexDefine.setDataFormat(vfPair);
                    ++position;
                }
                break;
            }
        }
    }

    public ExtMessage execute() throws SyntaxErrorException {
        byte[] picData;
        Cell exprOwner;
        ExprContext ctx = this.book.getDeps().getExprContext();
        Variant v = this.preFormula.execute(ctx, exprOwner = this.book.getSheet(0).getCell(0, 0, true));
        if (!v.booleanValue()) {
            return null;
        }
        String title = this.titleFormula.execute(ctx, exprOwner).toString();
        String content = "";
        if (this.contentFormula != null) {
            content = this.contentFormula.execute(ctx, exprOwner).toString();
        }
        switch (this.type) {
            case IMAGE: {
                try {
                    picData = ExtURL.parseModel(this.imagePath).getImageData();
                }
                catch (Exception e) {
                    logger.error((Object)"------can not open static image------", (Throwable)e);
                    picData = null;
                }
                break;
            }
            case METRO: {
                try {
                    picData = this.drawMetro();
                }
                catch (Exception e) {
                    logger.error((Object)"------can not draw metro image------", (Throwable)e);
                    picData = null;
                }
                break;
            }
            case TEXT_ONLY: {
                picData = null;
                break;
            }
            default: {
                throw new IllegalStateException("wrong message type!");
            }
        }
        return new ExtMessage(title, new Date(), picData, content, v.booleanValue());
    }

    public ArrayList<KPIDefine> toKPIModel() throws SyntaxErrorException {
        this.defines.clear();
        switch (this.type) {
            case METRO: {
                for (IndexDefine define : this.indexes) {
                    this.defines.add(define.toKPI());
                }
                break;
            }
        }
        return this.defines;
    }

    private byte[] drawMetro() throws Exception {
        BufferedImage image = new BufferedImage(CANVAS_WIDTH, CANVAS_HEIGHT, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (IndexDefine define : this.indexes) {
            Rectangle area = define.getArea();
            g2.setClip(area);
            Object[] values = define.execute();
            String indexTitle = values[0].toString();
            String indexValue = values[1].toString();
            Color foregroundName = (Color)values[2];
            Color foregroundValue = (Color)values[3];
            Color background = (Color)values[4];
            g2.setColor(background);
            g2.fillRect(define.getArea().x, define.getArea().y, define.getArea().width, define.getArea().height);
            Font titleFont = define.getTitleFont();
            g2.setFont(titleFont);
            g2.setColor(foregroundName);
            Rectangle2D rect = g2.getFontMetrics().getStringBounds(indexTitle, g2);
            int x = define.getArea().x + TITLE_PADDING_LEFT;
            int y = (int)rect.getHeight() + define.getArea().y + TITLE_PADDING_TOP;
            FontMetrics fm = g2.getFontMetrics(titleFont);
            if (fm.getStringBounds(indexTitle, g2).getWidth() > area.getWidth() - (double)x) {
                indexTitle = SwingUtilities.layoutCompoundLabel(fm, indexTitle, null, 0, 0, x, y, new Rectangle(0, 0, (int)area.getWidth() - TITLE_PADDING_LEFT, 0), new Rectangle(), (Rectangle)area.clone(), -1);
            }
            g2.drawString(indexTitle, x, y);
            g2.setColor(foregroundValue);
            g2.setFont(define.getValueFont());
            rect = g2.getFontMetrics().getStringBounds(indexValue, g2);
            x = (define.getArea().width - (int)rect.getWidth()) / 2 + define.getArea().x;
            y = (define.getArea().height - (int)rect.getHeight()) / 2 + y + 20;
            if (x < define.getArea().x) {
                x = define.getArea().x;
            }
            g2.drawString(indexValue, x, y);
        }
        g2.dispose();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", output);
        return output.toByteArray();
    }

    public PropellingModel clone() {
        PropellingModel ret = new PropellingModel(this.book);
        ret.contentFormula = this.contentFormula;
        ret.imagePath = this.imagePath;
        ret.lType = this.lType;
        ret.preFormula = this.preFormula;
        ret.titleFormula = this.titleFormula;
        ret.type = this.type;
        if (this.indexes != null) {
            ret.indexes = new IndexDefine[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                ret.indexes[i] = this.indexes[i].clone();
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Book book = Book.Manager.getNewBook();
        book.setAutoCalculate(false);
        PropellingModel model = new PropellingModel(book);
        model.setPreFormula("=true");
        model.setTitleFormula("=A3");
        model.setContentFormula("=B3");
        model.setMessageType(MessageType.METRO);
        for (MetroLayoutType type : MetroLayoutType.values()) {
            File file = new File("D:/pt/" + type.name() + ".png");
            if (!file.exists() && !file.createNewFile()) {
                logger.warn((Object)(file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
            }
            model.setMetroLayoutType(type);
            for (int j = 0; j < model.metroSize(); ++j) {
                IndexDefine define = model.getIndexDefine(j);
                define.setNameFormula("=A3");
                define.setDataFormula("=counta(TO(1,8))");
                define.setForegroundNameFormula("=if(c3=-1,rgb(234,234,234),rgb(234,234,234))");
                define.setForegroundValueFormula("=if(c3=-1,rgb(255,255,255),rgb(255,255,255))");
                define.setBackgroundFormula("=if(c3=0,rgb(128,160,255),rgb(128,160,255))");
                define.setDataFormat(new StringVFPair("0.00", null));
            }
            Sheet sheet0 = book.getSheet(0);
            sheet0.getCell(1, 0, true).setFormula("=to(1,10)");
            sheet0.getCell(1, 1, true).setFormula("B1");
            sheet0.getCell(1, 2, true).setFormula("C1");
            Cell cell20 = sheet0.getCell(2, 0, true);
            cell20.setFormula(CtrlEXTMessages.getMLS("expired", "\u5df2\u8d85\u671f>"));
            Cell cell21 = sheet0.getCell(2, 1, true);
            cell21.setFormula("100");
            Cell cell22 = sheet0.getCell(2, 2, true);
            cell22.setFormula("-1");
            book.calc(true);
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(model.execute().pic());
            }
        }
    }

    public static enum MetroLayoutType {
        ANN,
        BOB0,
        BOB1,
        CAT0,
        CAT1,
        CAT2,
        CAT3,
        DOG0;

    }

    public static enum MessageType {
        TEXT_ONLY,
        IMAGE,
        METRO;

    }
}

