/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.report;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ComboColorRenderer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.lfm.ExtThemeConfigurationFactory;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class GroupColorChooser
extends KDPanel
implements IWizardStep,
IReportComposer {
    private static Logger logger = LogUtil.getLogger(GroupColorChooser.class);
    public static final String KEY_GROUP_TYPE = "groupType";
    public static final String KEY_STATISTIC = "statistic";
    public static final String KEY_TOTAL = "total";
    public static final String KEY_SUM = "sum";
    public static final String KEY_MAX = "max";
    public static final String KEY_MIN = "min";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    private KDExt _ext = null;
    private IWizardStep prev = null;
    private KDLabel titleLabel = null;
    private KDComboColor chooser = null;
    private KDRadioButton radio1 = null;
    private KDRadioButton radio2 = null;
    private KDRadioButton radio3 = null;
    private KDButtonGroup group = null;
    private KDPanel groupPanel = null;
    private JScrollPane jScrollPane1;
    private KDComboColor[] colors = null;
    private KDPanel titlePanel = null;
    private Image[] images = new Image[3];
    private Image image;
    private KDTable table = new KDTable(2, 0, 0);
    private KDPanel imagePanel = new ImagePanel();
    private KDPanel[] imagePanels = new KDPanel[3];
    private Color[] defColors;
    private KDPanel titlePanel2 = new KDPanel();
    private ComboColorRenderer renderer = new ComboColorRenderer();
    private ExtDataSet currentDs;
    private boolean removeFlag = false;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlEXTMessages.getMLS(key, defaultStr);
    }

    public GroupColorChooser(KDExt ext) {
        this._ext = ext;
        this.initDemoPic();
        this.initComponents();
        this.initListeners();
    }

    @Override
    public boolean checkValid() {
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        return null;
    }

    @Override
    public IWizardStep getPrevStep() {
        this.prev = ((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getGroupReportComposer();
        return this.prev;
    }

    private void resetTable() {
        int count = this.table.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.table.removeRow(0);
        }
    }

    @Override
    public boolean prepare() {
        this.removeAll();
        this.resetTable();
        this.removeFlag = false;
        this.checkTree((GroupReportComposer)this.getPrevStep());
        GroupReportComposer composer = (GroupReportComposer)this.getPrevStep();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
        int count = root.getChildCount();
        this.colors = new KDComboColor[count];
        this.removeAll();
        this.setLayout(null);
        int size = this.defColors.length;
        if (count >= 1) {
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.colors[i] = new KDComboColor(this.defColors[i % size]);
                if (subNode.getChildCount() == 0) continue;
                IRow row = this.table.addRow();
                row.getCell(0).setValue(subNode.getUserObject());
                row.getCell(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.colors[i]));
                row.getCell(1).setValue((Object)this.defColors[i % size]);
                row.getCell(1).setRenderer((IBasicRender)this.renderer);
            }
        }
        this.jScrollPane1.setBounds(370, 40, 400, 471);
        this.setLayout(null);
        this.add((Component)this.titlePanel);
        this.add((Component)this.titlePanel2);
        this.add(this.jScrollPane1);
        return true;
    }

    private void initComponents() {
        this.imagePanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("sample", "\u6837\u4f8b")));
        this.imagePanel.setBounds(8, 110, 380, 350);
        this.imagePanels[0] = this.imagePanel;
        IRow row = this.table.addHeadRow();
        row.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("groupField", "\u5206\u7ec4\u5b57\u6bb5"));
        row.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("colorSettings", "\u989c\u8272\u8bbe\u7f6e"));
        this.table.getColumn(0).getStyleAttributes().setLocked(true);
        this.table.setBounds(8, 20, 331, 330);
        this.table.setAutoResize(true);
        this.jScrollPane1 = new JScrollPane();
        this.titleLabel = new KDLabel(CtrlEXTMessages.getMLS("backgroundColor", "\u80cc\u666f\u8272"));
        this.titlePanel = new KDPanel();
        this.titlePanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("headerRow", "\u6807\u9898\u884c")));
        this.defColors = (Color[])ExtThemeConfigurationFactory.getConfigurator().getColors(ExtThemeConfigurationFactory.getColorSpace(), CtrlEXTMessages.getMLS("reportWizardGroupSummary", "\u62a5\u8868\u5411\u5bfc--\u5206\u7ec4\u6c47\u603b\u578b"));
        this.chooser = new KDComboColor(this.defColors[0]);
        int length = this.defColors.length;
        Color[] temp = new Color[length - 1];
        System.arraycopy(this.defColors, 1, temp, 0, length - 1);
        this.defColors = temp;
        Dimension labelD = this.titleLabel.getPreferredSize();
        this.titleLabel.setBounds(25, 42, (int)labelD.getWidth(), (int)labelD.getHeight());
        Dimension prefer = this.chooser.getPreferredSize();
        this.chooser.setBounds(100, 40, (int)prefer.getWidth(), (int)prefer.getHeight());
        this.titlePanel.setLayout(null);
        this.titlePanel.add((Component)this.titleLabel);
        this.titlePanel.add((Component)this.chooser);
        this.titlePanel2.setLayout(null);
        this.titlePanel2.add((Component)this.table);
        this.titlePanel.setBounds(10, 40, 350, 100);
        this.titlePanel2.setBounds(10, 150, 350, 360);
        this.titlePanel2.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("groupFieldBackgroundColor", "\u5206\u7ec4\u5b57\u6bb5\u80cc\u666f\u8272")));
        this.radio1 = new KDRadioButton(CtrlEXTMessages.getMLS("alignStatisticsAndDetails", "\u7edf\u8ba1\u884c\u4e0e\u660e\u7ec6\u884c\u5bf9\u9f50"));
        this.radio2 = new KDRadioButton(CtrlEXTMessages.getMLS("alignStatisticsAndGroups", "\u7edf\u8ba1\u884c\u4e0e\u5206\u7ec4\u884c\u5bf9\u9f50"));
        this.radio3 = new KDRadioButton(CtrlEXTMessages.getMLS("showStatisticsFirst", "\u5148\u663e\u793a\u7edf\u8ba1\u884c"));
        this.group = new KDButtonGroup();
        this.groupPanel = new KDPanel();
        this.groupPanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("displayFormat", "\u663e\u793a\u683c\u5f0f")));
        this.group.add((AbstractButton)this.radio1);
        this.group.add((AbstractButton)this.radio2);
        this.group.add((AbstractButton)this.radio3);
        this.jScrollPane1.setName("jScrollPane1");
        this.groupPanel.setName("groupPanel");
        this.jScrollPane1.setViewportView((Component)this.groupPanel);
        this.groupPanel.setLayout(null);
        this.radio1.setBounds(15, 20, 150, 20);
        this.radio2.setBounds(15, 50, 150, 20);
        this.radio3.setBounds(15, 80, 150, 20);
        this.groupPanel.add((Component)this.radio1);
        this.groupPanel.add((Component)this.radio2);
        this.groupPanel.add((Component)this.radio3);
        this.groupPanel.add((Component)this.imagePanel);
        this.radio1.setSelected(true);
    }

    private void initDemoPic() {
        try (InputStream i1 = GroupColorChooser.class.getResourceAsStream("index1.jpg");
             InputStream i2 = GroupColorChooser.class.getResourceAsStream("index2.jpg");
             InputStream i3 = GroupColorChooser.class.getResourceAsStream("index3.jpg");){
            this.images[0] = ImageIO.read(i1);
            this.images[1] = ImageIO.read(i2);
            this.images[2] = ImageIO.read(i3);
            this.image = this.images[0];
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void initListeners() {
        this.radio1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GroupColorChooser.this.radio1.isSelected()) {
                    GroupColorChooser.this.groupPanel.remove((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.image = GroupColorChooser.this.images[0];
                    if (GroupColorChooser.this.imagePanels[0] == null) {
                        GroupColorChooser.this.imagePanel = new ImagePanel();
                        GroupColorChooser.this.imagePanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("sample", "\u6837\u4f8b")));
                        GroupColorChooser.this.imagePanel.setBounds(8, 110, 380, 350);
                        ((GroupColorChooser)GroupColorChooser.this).imagePanels[0] = GroupColorChooser.this.imagePanel;
                    } else {
                        GroupColorChooser.this.imagePanel = GroupColorChooser.this.imagePanels[0];
                    }
                    GroupColorChooser.this.groupPanel.add((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.groupPanel.repaint();
                }
            }
        });
        this.radio2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GroupColorChooser.this.radio2.isSelected()) {
                    GroupColorChooser.this.groupPanel.remove((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.image = GroupColorChooser.this.images[1];
                    if (GroupColorChooser.this.imagePanels[1] == null) {
                        GroupColorChooser.this.imagePanel = new ImagePanel();
                        GroupColorChooser.this.imagePanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("sample", "\u6837\u4f8b")));
                        GroupColorChooser.this.imagePanel.setBounds(8, 110, 380, 350);
                        ((GroupColorChooser)GroupColorChooser.this).imagePanels[1] = GroupColorChooser.this.imagePanel;
                    } else {
                        GroupColorChooser.this.imagePanel = GroupColorChooser.this.imagePanels[1];
                    }
                    GroupColorChooser.this.groupPanel.add((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.groupPanel.repaint();
                }
            }
        });
        this.radio3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GroupColorChooser.this.radio3.isSelected()) {
                    GroupColorChooser.this.groupPanel.remove((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.image = GroupColorChooser.this.images[2];
                    if (GroupColorChooser.this.imagePanels[2] == null) {
                        GroupColorChooser.this.imagePanel = new ImagePanel();
                        GroupColorChooser.this.imagePanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("sample", "\u6837\u4f8b")));
                        GroupColorChooser.this.imagePanel.setBounds(8, 110, 380, 350);
                        ((GroupColorChooser)GroupColorChooser.this).imagePanels[2] = GroupColorChooser.this.imagePanel;
                    } else {
                        GroupColorChooser.this.imagePanel = GroupColorChooser.this.imagePanels[2];
                    }
                    GroupColorChooser.this.groupPanel.add((Component)GroupColorChooser.this.imagePanel);
                    GroupColorChooser.this.groupPanel.repaint();
                }
            }
        });
    }

    private void checkTree(GroupReportComposer composer) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
        DefaultKingdeeTreeNode sum = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!(((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject() instanceof String)) continue;
            sum = (DefaultKingdeeTreeNode)root.getChildAt(i);
            break;
        }
        if (sum == null && root.getChildCount() > 0) {
            sum = composer.sum;
            composer.tree.insertNodeInto((MutableTreeNode)sum, (MutableTreeNode)root, root.getChildCount());
            this.removeFlag = true;
        }
    }

    private void resetTree(GroupReportComposer composer) {
        this.removeFlag = false;
        if (composer.sum == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
        DefaultKingdeeTreeNode sum = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!(((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject() instanceof String)) continue;
            sum = (DefaultKingdeeTreeNode)root.getChildAt(i);
            root.remove((MutableTreeNode)sum);
            break;
        }
        composer.sum = null;
    }

    @Override
    public void compose() {
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        GroupReportComposer composer = (GroupReportComposer)this.getPrevStep();
        Color choose = (Color)this.chooser.getValue();
        Color tempColor = new Color(Integer.parseInt("357692", 16));
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
        int nodeCount = node.getChildCount();
        boolean flag = false;
        for (int i = 0; i < nodeCount; ++i) {
            if (!this.hasSumRow((DefaultKingdeeTreeNode)node.getChildAt(i))) continue;
            flag = true;
        }
        if (!flag) {
            StyleAttributes titleSa = Styles.getEmptySA();
            titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            titleSa.setBold(true);
            titleSa.setBackground(choose);
            titleSa.setFontSize(12);
            composer.compose(true);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
            int count = root.getChildCount();
            for (int j = 0; j < composer.getFieldsCount() + count - 1; ++j) {
                sheet.getCell(0, j, true).setSSA((ShareStyleAttributes)titleSa);
            }
            if (composer.sum != null) {
                int rowCount = sheet.getRows().size();
                sheet.getRow(rowCount - 1, true).getCell(0, true).setFormula("");
                sheet.getRowRange(rowCount - 1, rowCount - 1).delete();
                this.resetTree(composer);
            }
            return;
        }
        if (this.radio1.isSelected()) {
            composer.compose(true);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
            int count = root.getChildCount();
            if (count <= 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() instanceof String) {
                return;
            }
            if (composer.addedFields == null) {
                return;
            }
            StyleAttributes titleSa = Styles.getEmptySA();
            titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            titleSa.setBold(true);
            titleSa.setFontSize(12);
            titleSa.setBackground(choose);
            StyleAttributes detailsSa = Styles.getEmptySA();
            detailsSa.setFontColor(tempColor);
            detailsSa.setFontSize(10);
            for (int j = 0; j < composer.getFieldsCount() + count - 1; ++j) {
                sheet.getCell(0, j, true).setSSA((ShareStyleAttributes)titleSa);
            }
            int integer = 0;
            int sumRowIndex = 0;
            Color co = null;
            for (int i = count - 2; i >= 0; --i) {
                boolean hasSubTotal;
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (this.hasSumRow(subNode)) {
                    ++sumRowIndex;
                    ++integer;
                    co = (Color)this.colors[i].getValue();
                    hasSubTotal = true;
                } else {
                    hasSubTotal = false;
                }
                if (!hasSubTotal) continue;
                for (int j = 0; j < sheet.getCols().size(); ++j) {
                    detailsSa.setBackground(co);
                    detailsSa.setFontColor(tempColor);
                    detailsSa.setHorizontalAlign(sheet.getCell(integer + 1, j, true).getSSA().getHorizontalAlign());
                    detailsSa.setNumberFormat(sheet.getCell(integer + 1, j, true).getSSA().getNumberFormat());
                    detailsSa.setFontSize(10);
                    sheet.getCell(integer + 1, j, true).setSSA((ShareStyleAttributes)detailsSa);
                    detailsSa.setBold(false);
                }
            }
            detailsSa.setFontColor(new Color(229, 113, 9));
            if (!this.removeFlag) {
                int rowIndex = composer.mergeScopes[0] + 2;
                for (int j = 0; j < composer.getFieldsCount() + count - 1; ++j) {
                    detailsSa.setNumberFormat(sheet.getCell(rowIndex, j, true).getSSA().getNumberFormat());
                    detailsSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                    sheet.getCell(rowIndex, j, true).setSSA((ShareStyleAttributes)detailsSa);
                }
                titleSa.setFontColor(new Color(229, 113, 9));
                titleSa.setFontSize(10);
                titleSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                sheet.getCell(rowIndex, 0, true).setSSA((ShareStyleAttributes)titleSa);
            }
            MiscUtil.getActiveSpreadContext(this._ext).repaint();
        } else if (this.radio2.isSelected()) {
            int j;
            int i;
            StyleAttributes titleSa = Styles.getEmptySA();
            titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            titleSa.setBold(true);
            titleSa.setBackground(choose);
            StyleAttributes sumTitle = Styles.getEmptySA();
            sumTitle.setFontColor(tempColor);
            sumTitle.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumTitle.setFontSize(10);
            StyleAttributes detailsSa = Styles.getEmptySA();
            detailsSa.setFontColor(tempColor);
            detailsSa.setFontSize(10);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
            int count = root.getChildCount();
            if (count == 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() instanceof String) {
                return;
            }
            if (composer.addedFields == null) {
                return;
            }
            composer.compose(false);
            int _count = 0;
            for (i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (subNode.getChildCount() == 0) continue;
                ++_count;
            }
            for (i = 0; i < composer.mergeScopes.length; ++i) {
                sheet.getMerger(true).insert(CellBlock.getCellBlock(1, i, composer.mergeScopes[i] == 0 ? 1 : composer.mergeScopes[i], i));
                int temp = 0;
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                for (GroupReportComposer.BinaryElement tele : composer.addedFields) {
                    for (int m = 0; m < subNode.getChildCount(); ++m) {
                        GroupReportComposer.TrinityElement te = (GroupReportComposer.TrinityElement)((DefaultKingdeeTreeNode)subNode.getChildAt(m)).getUserObject();
                        if (!te.equals(tele)) continue;
                        int col = count + temp - 2;
                        if (m != subNode.getChildCount() - 1) continue;
                        int colIndex = col;
                        for (int k = i; k < composer.getFieldsCount() + count - 1; ++k) {
                            if (sheet.getCell(composer.mergeScopes[i] + 1, k, true).getFormula() == null) continue;
                            colIndex = k;
                            break;
                        }
                        sheet.getMerger(true).insert(CellBlock.getCellBlock(composer.mergeScopes[i] + 1, i, composer.mergeScopes[i] + 1, colIndex));
                    }
                    ++temp;
                }
            }
            for (j = 0; j < composer.getFieldsCount() + count - 1; ++j) {
                sheet.getCell(0, j, true).setSSA((ShareStyleAttributes)titleSa);
            }
            for (i = 0; i < composer.mergeScopes.length; ++i) {
                if (composer.mergeScopes[i] == 0) continue;
                for (int j2 = 0; j2 < composer.getFieldsCount() + count - 1; ++j2) {
                    ShareStyleAttributes sheetStyle = sheet.getCell(composer.mergeScopes[i] + 1, j2, true).getSSA();
                    if (sheetStyle == null) {
                        sheetStyle = Styles.getEmptySA();
                    }
                    detailsSa.setNumberFormat(sheet.getCell(composer.mergeScopes[i] + 1, j2, true).getSSA().getNumberFormat());
                    detailsSa.setBackground((Color)this.colors[i].getValue());
                    sheet.getCell(composer.mergeScopes[i] + 1, j2, true).setSSA((ShareStyleAttributes)detailsSa);
                }
            }
            titleSa.setFontColor(new Color(229, 113, 9));
            if (!this.removeFlag && root.getChildAt(root.getChildCount() - 1).getChildCount() != 0) {
                for (j = 0; j < composer.getFieldsCount() + count - 1; ++j) {
                    detailsSa.setNumberFormat(sheet.getCell(_count + 1, j, true).getSSA().getNumberFormat());
                    detailsSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                    sheet.getCell(_count + 1, j, true).setSSA((ShareStyleAttributes)detailsSa);
                }
                titleSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                sheet.getCell(_count + 1, 0, true).setSSA((ShareStyleAttributes)titleSa);
            }
            int integer = 2;
            if (root.getChildAt(root.getChildCount() - 1).getChildCount() != 0) {
                --_count;
            }
            for (int i2 = 0; i2 < count - 1; ++i2) {
                Cell c;
                String ref;
                boolean hasSubTotal = false;
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i2);
                if (this.hasSumRow(subNode)) {
                    --integer;
                    hasSubTotal = true;
                }
                if (!hasSubTotal) continue;
                if (i2 == 0) {
                    ref = sheet.getCell(1, i2, true).getName(false, false);
                    c = sheet.getCell(_count + integer, i2, false);
                    c.setFormula(this.buildFormula(new String[]{"=disp(", ref, ") & \" ", GroupColorChooser.getLocalText(KEY_STATISTIC, CtrlEXTMessages.getMLS(KEY_STATISTIC, "\u7edf\u8ba1")), ":\""}));
                    c.getExtProps(true).setHead(ref, true);
                    sumTitle.setBackground((Color)this.colors[i2].getValue());
                    c.setSSA((ShareStyleAttributes)sumTitle);
                    sheet.getCell(_count + integer, 1, false).setFormula("");
                    continue;
                }
                ref = sheet.getCell(1, i2, true).getName(false, false);
                c = sheet.getCell(_count + integer, i2, false);
                c.setFormula(this.buildFormula(new String[]{"=disp(", ref, ") & \" ", GroupColorChooser.getLocalText(KEY_STATISTIC, CtrlEXTMessages.getMLS(KEY_STATISTIC, "\u7edf\u8ba1")), ":\""}));
                c.getExtProps(true).setHead(ref, true);
                sumTitle.setBackground((Color)this.colors[i2].getValue());
                c.setSSA((ShareStyleAttributes)sumTitle);
            }
            MiscUtil.getActiveSpreadContext(this._ext).repaint();
        } else if (this.radio3.isSelected()) {
            String ref;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)composer.tree.getModel().getRoot();
            int count = root.getChildCount();
            DatasetImporter importer = (DatasetImporter)this.getPrevStep().getPrevStep().getPrevStep();
            List selected = importer.getSelectedExtDataSets();
            this.currentDs = (ExtDataSet)selected.get(0);
            if (count == 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() instanceof String) {
                return;
            }
            if (composer.addedFields == null) {
                return;
            }
            composer.addedFields.removeAll(composer.groupFields);
            StyleAttributes titleSa = Styles.getEmptySA();
            titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            titleSa.setBold(true);
            StyleAttributes sumTitle = Styles.getEmptySA();
            sumTitle.setFontColor(tempColor);
            sumTitle.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumTitle.setFontSize(10);
            StyleAttributes detailsSa = Styles.getEmptySA();
            detailsSa.setFontColor(tempColor);
            detailsSa.setFontSize(10);
            boolean hasSumRow = false;
            if (composer.sumNode.getParent() != null) {
                --count;
                hasSumRow = true;
            }
            int index = 0;
            for (int i = 0; i < count; ++i) {
                boolean hasSubTotal;
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (this.hasSumRow(subNode)) {
                    ++index;
                    hasSubTotal = true;
                } else {
                    hasSubTotal = false;
                }
                GroupReportComposer.BinaryElement be = (GroupReportComposer.BinaryElement)subNode.getUserObject();
                Cell cell = sheet.getCell(0, i, true);
                cell.setFormula(GroupColorChooser.getLocalText(KEY_GROUP_TYPE, "\u7ec4\u522b ") + be.getColName());
                titleSa.setBackground((Color)this.chooser.getValue());
                cell.setSSA((ShareStyleAttributes)titleSa);
                cell = sheet.getCell(i + 1, i, true);
                if (cell != null) {
                    cell.setFormula(this.buildFormula(new String[]{"=group(", this.currentDs.getAlias(), " , ", be.getColName(), " , false)"}));
                    for (int k = i; k < composer.getFieldsCount() + count; ++k) {
                        Cell rowCell = sheet.getCell(i + 1, k, true);
                        StyleAttributes backgroundColorSa = Styles.getEmptySA();
                        backgroundColorSa.setBackground((Color)this.colors[i].getValue());
                        rowCell.setSSA((ShareStyleAttributes)backgroundColorSa);
                    }
                    Color temp = sumTitle.getBackground();
                    sumTitle.setBackground((Color)this.colors[i].getValue());
                    String ref1 = cell.getName(false, false);
                    sheet.getCell(i + 2, i, true).getExtProps(true).setHead(ref1, true);
                    sheet.getCell(i + 2, i + 1, true).getExtProps(true).setHead(ref1, true);
                    cell.setSSA((ShareStyleAttributes)sumTitle);
                    sumTitle.setBackground(temp);
                }
                int temp = 0;
                if (!hasSubTotal) continue;
                for (GroupReportComposer.BinaryElement tele : composer.addedFields) {
                    for (int m = 0; m < subNode.getChildCount(); ++m) {
                        GroupReportComposer.TrinityElement te = (GroupReportComposer.TrinityElement)((DefaultKingdeeTreeNode)subNode.getChildAt(m)).getUserObject();
                        if (!te.equals(tele)) continue;
                        ref = sheet.getCell(count + 1, count + temp, true).getName(false, false);
                        cell = sheet.getCell(i + 1, count + temp, true);
                        cell.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref, "))"}));
                        detailsSa.setNumberFormat(te.getI18nModeName() + "\\:0.00;" + te.getI18nModeName() + "\\:-0.00");
                        Color col = detailsSa.getBackground();
                        detailsSa.setBackground((Color)this.colors[i].getValue());
                        cell.setSSA((ShareStyleAttributes)detailsSa);
                        detailsSa.setBackground(col);
                    }
                    ++temp;
                }
            }
            detailsSa.setNumberFormat(null);
            boolean leadingComposed = false;
            int integer = count;
            for (GroupReportComposer.BinaryElement tele : composer.addedFields) {
                Cell cell = sheet.getCell(0, integer, true);
                cell.setFormula(tele.getColName());
                titleSa.setBackground((Color)this.chooser.getValue());
                cell.setSSA((ShareStyleAttributes)titleSa);
                if (!leadingComposed) {
                    cell = sheet.getCell(count + 1, integer, true);
                    cell.setFormula(this.buildFormula(new String[]{"=select(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                    cell.setSSA((ShareStyleAttributes)detailsSa);
                    leadingComposed = true;
                } else {
                    cell = sheet.getCell(count + 1, integer, true);
                    cell.setFormula(this.buildFormula(new String[]{"=field(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                    cell.setSSA((ShareStyleAttributes)detailsSa);
                }
                ++integer;
            }
            if (!this.removeFlag) {
                for (int k = 0; k < composer.getFieldsCount() + count; ++k) {
                    Cell rowCell = sheet.getCell(count + 2, k, true);
                    StyleAttributes backgroundColorSa = Styles.getEmptySA();
                    backgroundColorSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                    rowCell.setSSA((ShareStyleAttributes)backgroundColorSa);
                }
                titleSa.setFontColor(new Color(229, 113, 9));
                if (hasSumRow) {
                    Cell cell = sheet.getCell(count + 2, 0, true);
                    cell.setFormula(GroupColorChooser.getLocalText(KEY_TOTAL, "\u603b\u8ba1\uff1a"));
                    titleSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                    titleSa.setFontSize(10);
                    cell.setSSA((ShareStyleAttributes)titleSa);
                    int temp = 0;
                    for (GroupReportComposer.BinaryElement tele : composer.addedFields) {
                        for (int m = 0; m < composer.sumNode.getChildCount(); ++m) {
                            GroupReportComposer.TrinityElement te = (GroupReportComposer.TrinityElement)((DefaultKingdeeTreeNode)composer.sumNode.getChildAt(m)).getUserObject();
                            if (!te.equals(tele)) continue;
                            int col = count + temp;
                            ref = sheet.getCell(count + 1, col, true).getName(false, false);
                            Cell c = sheet.getCell(count + 2, col, true);
                            c.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref, "))"}));
                            detailsSa.setNumberFormat(te.getI18nModeName() + "\\: 0.00;" + te.getI18nModeName() + "\\: -0.00");
                            detailsSa.setBackground((Color)this.colors[this.colors.length - 1].getValue());
                            c.setSSA((ShareStyleAttributes)detailsSa);
                        }
                        ++temp;
                    }
                }
                for (int i = count - 1; i >= 0; --i) {
                    CellBlock b = CellBlock.getCellBlock(i + 2, i, count + 1, i);
                    sheet.getMerger(true).insert(b);
                }
            }
            MiscUtil.getActiveSpreadContext(this._ext).repaint();
        }
        sheet.getColSpans().setSpanAttribute(new Span(0, sheet.getMaxColIndex()), null, (Integer)110, Boolean.valueOf("true"), null, null, null);
        sheet.getRowSpans().setSpanAttribute(new Span(0, 0), null, (Integer)33, Boolean.valueOf("true"), null, null, null);
        if (this.removeFlag && (this.radio1.isSelected() || this.radio2.isSelected())) {
            int rowCount = sheet.getRows().size();
            sheet.getRow(rowCount - 1, true).getCell(0, true).setFormula("");
            sheet.getRowRange(rowCount - 1, rowCount - 1).delete();
            this.deleteWhiteRow();
            this.resetTree(composer);
        }
    }

    private String buildFormula(String[] ele) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ele.length; ++i) {
            sb.append(ele[i]);
        }
        return sb.toString();
    }

    private boolean hasSumRow(DefaultKingdeeTreeNode node) {
        int count = node.getChildCount();
        return count != 0;
    }

    private void deleteWhiteRow() {
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        int rowSize = sheet.getRows().size();
        int colSize = sheet.getCols().size();
        for (int i = 1; i < rowSize; ++i) {
            Row row = sheet.getRow(i, false);
            boolean hasContent = false;
            if (row != null) {
                for (int j = 0; j < colSize; ++j) {
                    if (row.getCell(j, false) == null || row.getCell(j, false).getFormula() == null || !row.getCell(j, false).getFormula().startsWith("=")) continue;
                    hasContent = true;
                    break;
                }
            }
            if (hasContent) continue;
            sheet.getRowRange(i, i).delete();
            rowSize = sheet.getRows().size();
            colSize = sheet.getCols().size();
            --i;
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawString(CtrlEXTMessages.getMLS("createGroupedSummaryReport", "\u5efa\u7acb\u5206\u7ec4\u6c47\u603b\u578b\u62a5\u8868 - (3)\u62a5\u8868\u6837\u5f0f\u53ca\u989c\u8272\u8bbe\u7f6e"), 20, 20);
        g.setColor(Color.lightGray);
        g.drawLine(15, 30, 765, 30);
    }

    private class ImagePanel
    extends KDPanel {
        int width;
        int height;

        private ImagePanel() {
        }

        public void paintComponent(Graphics g) {
            if (GroupColorChooser.this.image != null) {
                if (this.width != 0) {
                    g.clearRect(5, 60, this.width, this.height - 40);
                }
                this.width = GroupColorChooser.this.image.getWidth(null);
                this.height = GroupColorChooser.this.image.getHeight(null);
                g.drawImage(GroupColorChooser.this.image, 6, 30, null);
            }
        }
    }
}

