/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.report;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.NormalSelector;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporterWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ListColorChooser;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListReportComposer
extends KDPanel
implements IReportComposer,
IWizardStep {
    public static final String KEY_WIZARD_TIPS = "wizardTips";
    public static final String KEY_MSG_TITLE = "msgTitle";
    public static final String KEY_LABEL_CREATE = "createListReport";
    public static final String KEY_LABEL_AVAILABLE_FIELDS = "availableFields";
    public static final String KEY_CREATE_COL = "createCol";
    private KDLabel jLabel1;
    private KDSeparator jSeparator1;
    private ListReportSelector listReportSelector;
    private KDExt _ext;
    private DatasetImporter prev;
    private ExtDataSet currentDs;
    private ListColorChooser next;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlEXTMessages.getMLS(key, defaultStr);
    }

    public ListReportComposer(KDExt ext) {
        this._ext = ext;
        this.initComponents();
    }

    @Override
    public boolean prepare() {
        this.listReportSelector.getSelectableList().removeAllElements();
        DatasetImporter importer = (DatasetImporter)this.getPrevStep();
        List selected = importer.getSelectedExtDataSets();
        if (importer.getAllExtDataSets().size() == 0) {
            this.listReportSelector.getSelectedList().removeAllElements();
            return true;
        }
        if (selected.size() > 1) {
            this.showMessage(ListReportComposer.getLocalText(KEY_WIZARD_TIPS, "\u62a5\u8868\u5411\u5bfc\u53ea\u652f\u6301\u5355\u6570\u636e\u96c6\uff0c\u5411\u5bfc\u5c06\u4f7f\u7528\u6240\u9009\u7684\u7b2c\u4e00\u4e2a\u6570\u636e\u96c6\u5b8c\u6210\u540e\u7eed\u6b65\u9aa4\u3002"));
        }
        this.currentDs = (ExtDataSet)selected.get(0);
        String[] sawtooth = importer.getEditingInfo(this.currentDs);
        Object[] cols = MiscUtil.sortColumnsByIndex(this.currentDs.getColumns());
        for (int j = 0; j < cols.length; ++j) {
            String colEditingAlias = sawtooth[j + 1];
            this.listReportSelector.getSelectableList().addElement((Object)new TrinityListElement(colEditingAlias, colEditingAlias));
        }
        for (int i = this.listReportSelector.getSelectedList().getElementCount() - 1; i >= 0; --i) {
            Object o = this.listReportSelector.getSelectedList().getElement(i);
            if (this.listReportSelector.getSelectableList().getIndexOfElement(o) != -1) continue;
            this.listReportSelector.getSelectedList().removeElement(o);
        }
        this.listReportSelector.getSelectableList().setSelectedIndex(0);
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        if (this.next == null) {
            this.next = (ListColorChooser)((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getRowColorChooser();
        }
        return this.next;
    }

    @Override
    public IWizardStep getPrevStep() {
        if (this.prev == null) {
            this.prev = ((DatasetImporterWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_DatasetImporter)).getDatasetImporter();
        }
        return this.prev;
    }

    @Override
    public void compose() {
        ArrayList fields = this.getListFields();
        if (fields.isEmpty()) {
            return;
        }
        StyleAttributes titleSa = Styles.getEmptySA();
        titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        titleSa.setBold(true);
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        StyleAttributes detailSa = Styles.getEmptySA();
        detailSa.setFontSize(10);
        for (int i = 0; i < fields.size(); ++i) {
            TrinityListElement trinity = (TrinityListElement)fields.get(i);
            Cell cell = sheet.getCell(0, i, true);
            cell.setValue(new Variant(trinity.getText()));
            cell.setSSA((ShareStyleAttributes)titleSa);
            if (i == 0) {
                sheet.getCell(1, i, true).setFormula(this.buildFullFormula(this.currentDs.getAlias(), trinity.getColName()));
            } else {
                sheet.getCell(1, i, true).setFormula(this.buildSmartFormula(this.currentDs.getAlias(), trinity.getColName()));
            }
            sheet.getCell(1, i, false).setSSA((ShareStyleAttributes)detailSa);
        }
    }

    private String buildFullFormula(String dsName, String colName) {
        StringBuilder sb = new StringBuilder();
        sb.append("=select(");
        sb.append(dsName);
        sb.append(" , ");
        sb.append(colName);
        sb.append(')');
        return sb.toString();
    }

    private String buildSmartFormula(String dsName, String colName) {
        StringBuilder sb = new StringBuilder();
        sb.append("=field(");
        sb.append(dsName);
        sb.append(" , ");
        sb.append(colName);
        sb.append(')');
        return sb.toString();
    }

    public ArrayList getListFields() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.listReportSelector.getSelectedList().getElementCount(); ++i) {
            result.add(this.listReportSelector.getSelectedList().getElement(i));
        }
        return result;
    }

    private void showMessage(String message) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        MessageUtil.msgboxInfo((Component)((Object)this), message);
    }

    private void initComponents() {
        KDPanel mainPanel = new KDPanel();
        mainPanel.setCustomInsets(new Insets(10, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        KDPanel northPanel = new KDPanel();
        northPanel.setCustomInsets(new Insets(0, 0, 10, 0));
        northPanel.setLayout((LayoutManager)new BorderLayout());
        this.jSeparator1 = new KDSeparator();
        this.jLabel1 = new KDLabel();
        this.jLabel1.setText(ListReportComposer.getLocalText(KEY_LABEL_CREATE, "\u5efa\u7acb\u5217\u8868\u578b\u62a5\u8868 - \u9009\u62e9\u8981\u521b\u5efa\u7684\u5217"));
        northPanel.add((Component)this.jLabel1, (Object)"Center");
        northPanel.add((Component)this.jSeparator1, (Object)"South");
        mainPanel.add((Component)northPanel, (Object)"North");
        this.listReportSelector = new ListReportSelector();
        mainPanel.add((Component)((Object)this.listReportSelector), (Object)"Center");
    }

    @Override
    public boolean checkValid() {
        return true;
    }

    private static class ListReportSelector
    extends NormalSelector {
        private KDList listSelectable;
        private boolean isDoubleClick = false;

        public ListReportSelector() {
            this.initCtrl();
            this.initListeners();
        }

        private void initCtrl() {
            this.enableSelect(false);
            this.enableSelectAll(false);
            this.listSelectable = new KDList();
            this.listSelectable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.syncListViewButton();
                }
            });
            this.setSupplyTitle(ListReportComposer.getLocalText(ListReportComposer.KEY_LABEL_AVAILABLE_FIELDS, "\u53ef\u9009\u5b57\u6bb5"));
            this.setSelectedTitle(ListReportComposer.getLocalText(ListReportComposer.KEY_CREATE_COL, "\u521b\u5efa\u5217"));
            this.setSupplyCtrlNoScroll((JComponent)new KDScrollPane((Component)this.listSelectable));
            this.getSelected().syncBtn();
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            if (this.listSelectable.getSelectedIndex() == -1) {
                this.btnSelect.setEnabled(false);
            } else {
                this.btnSelect.setEnabled(true);
            }
            if (this.listSelectable.getElementCount() > 0) {
                this.btnSelectAll.setEnabled(true);
            } else {
                this.btnSelectAll.setEnabled(false);
            }
        }

        private void initListeners() {
            this.listSelectable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        isDoubleClick = true;
                        this.onSelect();
                    }
                }
            });
        }

        public KDList getSelectableList() {
            return this.listSelectable;
        }

        protected void onSelect() {
            Object[] leftSelectedList = this.listSelectable.getSelectedValues();
            int leftSelectedLSize = leftSelectedList.length;
            for (int i = 0; i < leftSelectedLSize; ++i) {
                Object ele = leftSelectedList[i];
                if (ele == null || this.getSelectedList().getIndexOfElement(ele) != -1) continue;
                this.getSelectedList().addElement(leftSelectedList[i]);
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
            if (leftSelectedLSize == 1 && !this.isDoubleClick) {
                int nextIndex = this.listSelectable.getIndexOfElement(leftSelectedList[0]) + 1;
                if (nextIndex < 0) {
                    nextIndex = 0;
                } else if (nextIndex >= this.listSelectable.getElementCount()) {
                    nextIndex = this.listSelectable.getElementCount() - 1;
                }
                this.listSelectable.setSelectedIndex(nextIndex);
            }
            this.isDoubleClick = false;
        }

        protected void onSelectAll() {
            int leftSelectedLSize = this.listSelectable.getElementCount();
            for (int i = 0; i < leftSelectedLSize; ++i) {
                Object ele = this.listSelectable.getElement(i);
                if (ele == null || this.getSelectedList().getIndexOfElement(ele) != -1) continue;
                this.getSelectedList().addElement(ele);
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
            this.listSelectable.setSelectedIndex(this.listSelectable.getElementCount() - 1);
        }
    }

    private static class TrinityListElement {
        private String text;
        private String colName;

        TrinityListElement(String text, String colName) {
            this.text = text;
            this.colName = colName;
        }

        public String getText() {
            return this.text;
        }

        public String getColName() {
            return this.colName;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TrinityListElement)) {
                return false;
            }
            TrinityListElement byObj = (TrinityListElement)obj;
            return this.text.equals(byObj.text) && this.colName.equals(byObj.colName);
        }
    }
}

