/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.report;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.PropertyEditorTrimView;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporterWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.CrossReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupColorChooser;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupReportColumnFilter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ListColorChooser;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ListReportComposer;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;

public class ReportComposerWizard
extends KDDialog
implements ISpreadWizzard {
    public static final String KEY_TITLE = "reportGenWizard";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_LAST = "last";
    public static final String KEY_NEXT = "next";
    public static final String KEY_DONE = "done";
    public static final String KEY_LIST_REPORT = "listReport";
    public static final String KEY_LIST_REPORT_DESC = "listReportDesc";
    public static final String KEY_GROUP_AND_STAT = "groupAndStatReport";
    public static final String KEY_GROUP_AND_STAT_DESC = "groupAndStatReportDesc";
    public static final String KEY_CROSS_REPORT = "crossReport";
    public static final String KEY_CROSS_REPORT_DESC = "crossReportDesc";
    public static final String KEY_CHOOSE_REPORT_TYPE = "chooseReportType";
    public static final String KEY_REPORT_TYPE = "reportType";
    public static final String KEY_LIST = "list";
    public static final String KEY_GROUP_STAT = "groupAndStat";
    public static final String KEY_CROSS_ANALYSIS = "crossAnalysis";
    public static final String KEY_REPORT_TYPE_DESCRIPTION = "reportTypeDescription";
    public static final int LIST_REPORT = 0;
    public static final int GROUP_REPORT = 1;
    public static final int CROSS_REPORT = 2;
    public static final int LIST_REPORT_COLOR = 3;
    public static final int GROUP_REPORT_COLOR = 4;
    private int colorType = 100;
    private int reportType = 0;
    private IWizardStep currentStep;
    private NavigatePanel navigatePanel;
    private ReportTypeDispatcher reportTypeDispatcher;
    private ListReportComposer listReportComposer;
    private GroupReportComposer groupReportComposer;
    private GroupReportColumnFilter groupColumnsFilter;
    private CrossReportComposer crossReportComposer;
    private ListColorChooser listColorChooser;
    private GroupColorChooser groupColorChooser;
    private DatasetImporter importer;
    private KDExt _ext;
    private boolean userCanceled;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlEXTMessages.getMLS(key, defaultStr);
    }

    public ReportComposerWizard(KDExt ext) {
        super((Frame)((Object)ext));
        this.setSize(785, 600);
        this.initComps();
        this._ext = ext;
        this.importer = ((DatasetImporterWizard)ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_DatasetImporter)).getDatasetImporter();
        this.setModal(true);
        this.setTitle(ReportComposerWizard.getLocalText(KEY_TITLE, "\u62a5\u8868\u751f\u6210\u5411\u5bfc"));
    }

    private void initComps() {
        this.reportTypeDispatcher = new ReportTypeDispatcher();
        this.navigatePanel = new NavigatePanel();
        this.currentStep = this.reportTypeDispatcher;
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.removeAll();
        c.add((Component)((Object)this.reportTypeDispatcher), "Center");
        c.add((Component)((Object)this.navigatePanel), "South");
        this.navigatePanel.config4FirstStep();
        this.currentStep = this.reportTypeDispatcher;
        this.userCanceled = false;
        return true;
    }

    public IWizardStep getStepOne() {
        return this.reportTypeDispatcher;
    }

    public IWizardStep getComposeStepOneByType() {
        switch (this.reportType) {
            case 0: {
                if (this.listReportComposer == null) {
                    this.listReportComposer = new ListReportComposer(this._ext);
                }
                return this.listReportComposer;
            }
            case 1: {
                if (this.groupColumnsFilter == null) {
                    this.groupColumnsFilter = new GroupReportColumnFilter(this._ext);
                }
                return this.groupColumnsFilter;
            }
            case 2: {
                if (this.crossReportComposer == null) {
                    this.crossReportComposer = new CrossReportComposer(this._ext);
                }
                return this.crossReportComposer;
            }
        }
        throw new IllegalArgumentException("bad argument");
    }

    public IWizardStep getGroupReportComposer() {
        if (this.groupReportComposer == null) {
            this.groupReportComposer = new GroupReportComposer(this._ext);
        }
        return this.groupReportComposer;
    }

    public IWizardStep getListReportComposer() {
        if (this.listReportComposer == null) {
            this.listReportComposer = new ListReportComposer(this._ext);
        }
        return this.listReportComposer;
    }

    public IWizardStep getCrossReportComposer() {
        if (this.crossReportComposer == null) {
            this.crossReportComposer = new CrossReportComposer(this._ext);
        }
        return this.crossReportComposer;
    }

    public IWizardStep getRowColorChooser() {
        if (this.listColorChooser == null) {
            this.listColorChooser = new ListColorChooser(this._ext);
        }
        return this.listColorChooser;
    }

    public IWizardStep getGroupColorChooser() {
        if (this.groupColorChooser == null) {
            this.groupColorChooser = new GroupColorChooser(this._ext);
        }
        return this.groupColorChooser;
    }

    public void nextStep() {
        if (!this.currentStep.checkValid()) {
            return;
        }
        IWizardStep next = this.currentStep.getNextStep();
        if (next != null && !next.prepare()) {
            return;
        }
        if (next != null) {
            Container c = this.getContentPane();
            c.remove((JPanel)((Object)this.currentStep));
            this.currentStep = next;
            c.add((JPanel)((Object)this.currentStep));
            if (next.getNextStep() == null) {
                this.navigatePanel.config4LastStep();
            } else {
                this.navigatePanel.config4MediumStep();
            }
            c.validate();
            ((JPanel)((Object)this.currentStep)).repaint();
        }
        if (this.currentStep instanceof ListColorChooser) {
            switch (this.reportType) {
                case 0: {
                    this.colorType = 3;
                    break;
                }
                case 1: {
                    this.colorType = 4;
                    break;
                }
                case 2: {
                    this.colorType = 4;
                    break;
                }
                default: {
                    this.colorType = 100;
                    break;
                }
            }
        } else if (this.currentStep instanceof GroupColorChooser) {
            switch (this.reportType) {
                case 0: {
                    this.colorType = 3;
                    break;
                }
                case 1: {
                    this.colorType = 4;
                    break;
                }
                case 2: {
                    this.colorType = 4;
                    break;
                }
                default: {
                    this.colorType = 100;
                }
            }
        }
    }

    public void prevStep() {
        this.colorType = 100;
        IWizardStep prev = this.currentStep.getPrevStep();
        if (prev != null) {
            Container c = this.getContentPane();
            c.remove((JPanel)((Object)this.currentStep));
            this.currentStep = prev;
            c.add((JPanel)((Object)this.currentStep));
            if (prev.getPrevStep() == null) {
                this.navigatePanel.config4FirstStep();
            } else {
                this.navigatePanel.config4MediumStep();
            }
            c.validate();
            ((JPanel)((Object)this.currentStep)).repaint();
        }
    }

    private void closeWizard() {
        if (!this.userCanceled) {
            SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
            Sheet sheet = context.getBook().getActiveSheet();
            sheet.getRange(0, 0, 1048575, 65535).delete();
            sheet.getRange(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex()).clear(true, true, true, true);
            this.importer.commitEdit();
            Color c = Color.black;
            switch (this.reportType) {
                case 0: {
                    if (this.colorType == 100) {
                        this.listReportComposer.compose();
                    } else {
                        this.listColorChooser.compose();
                    }
                    c = new Color(Integer.parseInt("CA", 16), Integer.parseInt("CF", 16), Integer.parseInt("D3", 16));
                    break;
                }
                case 1: {
                    if (this.colorType == 100) {
                        this.groupReportComposer.compose();
                    } else {
                        this.groupColorChooser.compose();
                    }
                    c = new Color(Integer.parseInt("A8ADB0", 16));
                    break;
                }
                case 2: {
                    this.crossReportComposer.compose();
                    c = new Color(Integer.parseInt("A8ADB0", 16));
                    break;
                }
            }
            this.setAllBorder(c);
            ((PropertyEditorTrimView)((TrimWidgetViewport)this._ext.getPerspective("Report Designer").getTrimWidget("PropertyEditor_Widget_ID")).getView()).refreshDatasetTree();
            context.repaint();
        } else {
            this.importer.cancelEdit();
        }
        this.setVisible(false);
    }

    private void setAllBorder(Color color) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.TOP, color);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.BOTTOM, color);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.LEFT, color);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.RIGHT, color);
        StyleAttributes saInner = Styles.getEmptySA();
        saInner.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        saInner.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.TOP, color);
        saInner.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        saInner.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.LEFT, color);
        Sheet sheet = context.getBook().getActiveSheet();
        Cell c00 = sheet.getCell(0, 0, true);
        ShareStyleAttributes ssa = c00.getSSA();
        sheet.getRange(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex()).setStyle(sa, saInner);
        c00.setSSA(ssa);
        sheet.clearStyleCache();
        Borders bdrs = sheet.getBorders();
        boolean hasBorder = !bdrs.isEmpty();
        com.kingdee.cosmic.ctrl.kds.model.struct.borders.Border bdrV = sheet.getDefaultBorder(true);
        com.kingdee.cosmic.ctrl.kds.model.struct.borders.Border bdrH = sheet.getDefaultBorder(false);
        int rowMax = sheet.getRows().getMaxIntMark();
        int colMax = sheet.getCols().getMaxIntMark();
        for (int r = 0; r <= rowMax; ++r) {
            for (int c = 0; c <= colMax; ++c) {
                Cell cll = sheet.getCell(r, c, false);
                if (cll != null || !hasBorder || sheet.getMergeBlock(r, c) != null || bdrs.getCellBorder(r, c, true) == bdrV && bdrs.getCellBorder(r, c, false) == bdrH) continue;
                sheet.getCell(r, c, true);
            }
        }
    }

    public class ReportTypeDispatcher
    extends KDPanel
    implements IWizardStep {
        private ButtonGroup buttonGroup1;
        private KDLabel jLabel1;
        private KDPanel jPanel1;
        private KDPanel jPanel2;
        private KDRadioButton listReport;
        private KDRadioButton groupReport;
        private KDRadioButton crossReport;
        private KDScrollPane jScrollPane1;
        private JSeparator jSeparator1;
        private KDTextArea jTextArea1;
        private String listReportInfo = ReportComposerWizard.getLocalText("listReport", "\u5217\u8868\u578b\u62a5\u8868\n") + ReportComposerWizard.getLocalText("listReportDesc", "\u672c\u62a5\u8868\u4e00\u884c\u884c\u5217\u51fa\u6570\u636e\uff0c\u6570\u636e\u884c\u6570\u4e0d\u56fa\u5b9a\u3002\n\u6b64\u7c7b\u578b\u62a5\u8868\u4e00\u822c\u7528\u505a\u5c55\u793a\u660e\u7ec6\u6570\u636e\u3002\n\u4f8b\u5982\uff1a\u91c7\u8d2d\u53d1\u7968\u660e\u7ec6\u8868\u3001\u9500\u552e\u51fa\u5e93\u660e\u7ec6\u8868\u3001\u804c\u5de5\u82b1\u540d\u518c\u3002");
        private String groupReportInfo = ReportComposerWizard.getLocalText("groupAndStatReport", "\u5206\u7ec4\u6c47\u603b\u62a5\u8868\n") + ReportComposerWizard.getLocalText("groupAndStatReportDesc", "\u6309\u67d0\u4e2a\u6216\u67d0\u51e0\u4e2a\u5b57\u6bb5\u5206\u7ec4\uff0c\u5e76\u4e3a\u6bcf\u4e2a\u5206\u7ec4\u63d0\u4f9b\u6c47\u603b\u8ba1\u7b97\u3002\n\u6b64\u7c7b\u578b\u62a5\u8868\u4e00\u822c\u7528\u505a\u5728\u660e\u7ec6\u6570\u636e\u7684\u57fa\u7840\u4e0a\u8fdb\u884c\u5206\u7ec4\u7136\u540e\u518d\u5bf9\u4e2a\u522b\u5b57\u6bb5\u8fdb\u884c\u6c47\u603b\u8ba1\u7b97\u3002\n\u4f8b\u5982\uff1a\u9500\u552e\u51fa\u5e93\u6c47\u603b\u8868\u3001\u8d39\u7528\u9884\u7b97\u5206\u7c7b\u6c47\u603b\u8868\u3002");
        private String crossReportInfo = ReportComposerWizard.getLocalText("crossReport", "\u4ea4\u53c9\u5206\u6790\u62a5\u8868\n") + ReportComposerWizard.getLocalText("crossReportDesc", "\u6570\u636e\u5728\u6a2a\u7eb52\u4e2a\u65b9\u5411\u6269\u5c55\uff0c\u884c\u548c\u5217\u4e0d\u56fa\u5b9a\uff0c\u884c\u548c\u5217\u4e0a\u5206\u522b\u6309\u4e00\u4e2a\u6216\u591a\u4e2a\u5b57\u6bb5\u8fdb\u884c\u5206\u7ec4\uff0c\u4e2d\u95f4\u4ea4\u53c9\u90e8\u5206\u4e3a\u4e00\u4e2a\u6216\u591a\u4e2a\u5b57\u6bb5\u6309\u884c\u548c\u5217\u7684\u5206\u7ec4\u8fdb\u884c\u7684\u6c47\u603b\u7edf\u8ba1\u3002\n\u6b64\u7c7b\u578b\u62a5\u8868\u4e00\u822c\u7528\u4ece\u884c\u52172\u4e2a\u89d2\u5ea6\u5c55\u793a\u4ea4\u53c9\u5206\u6790\u6570\u636e\u3002\n\u4f8b\u5982\uff1a\u5404\u7c7b\u4ea7\u54c1\u533a\u57df\u9500\u552e\u5206\u6790\u8868\u3001\u5404\u90e8\u95e8\u5404\u5c97\u4f4d\u85aa\u8d44\u6c47\u603b\u8868\u3002");

        public ReportTypeDispatcher() {
            this.initComponents();
            this.initListeners();
        }

        @Override
        public IWizardStep getNextStep() {
            return ReportComposerWizard.this.importer;
        }

        @Override
        public IWizardStep getPrevStep() {
            return null;
        }

        private void initListeners() {
            this.listReport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ReportTypeDispatcher.this.jTextArea1.setText(ReportTypeDispatcher.this.listReportInfo);
                        ReportComposerWizard.this.reportType = 0;
                    }
                }
            });
            this.groupReport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ReportTypeDispatcher.this.jTextArea1.setText(ReportTypeDispatcher.this.groupReportInfo);
                        ReportComposerWizard.this.reportType = 1;
                    }
                }
            });
            this.crossReport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ReportTypeDispatcher.this.jTextArea1.setText(ReportTypeDispatcher.this.crossReportInfo);
                        ReportComposerWizard.this.reportType = 2;
                    }
                }
            });
        }

        private void initComponents() {
            this.jSeparator1 = new JSeparator();
            this.jLabel1 = new KDLabel();
            this.jPanel1 = new KDPanel();
            this.listReport = new KDRadioButton();
            this.groupReport = new KDRadioButton();
            this.crossReport = new KDRadioButton();
            this.listReport.setSelected(true);
            this.buttonGroup1 = new ButtonGroup();
            this.buttonGroup1.add((AbstractButton)this.listReport);
            this.buttonGroup1.add((AbstractButton)this.groupReport);
            this.buttonGroup1.add((AbstractButton)this.crossReport);
            this.jPanel2 = new KDPanel();
            this.jScrollPane1 = new KDScrollPane();
            this.jTextArea1 = new KDTextArea();
            this.jTextArea1.setText(this.listReportInfo);
            this.jLabel1.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_CHOOSE_REPORT_TYPE, "\u9009\u62e9\u62a5\u8868\u7c7b\u578b"));
            this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_REPORT_TYPE, "\u62a5\u8868\u7c7b\u578b")));
            this.listReport.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_LIST, "\u5217\u8868"));
            this.groupReport.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_GROUP_STAT, "\u5206\u7ec4\u6c47\u603b"));
            this.crossReport.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_CROSS_ANALYSIS, "\u4ea4\u53c9\u5206\u6790"));
            GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
            this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
            jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(24, 24, 24).add((Component)this.listReport).addPreferredGap(0, 186, Short.MAX_VALUE).add((Component)this.groupReport).add(130, 130, 130).add((Component)this.crossReport).add(204, 204, 204)));
            jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(46, 46, 46).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.listReport).add((Component)this.crossReport).add((Component)this.groupReport)).addContainerGap(55, Short.MAX_VALUE)));
            this.jPanel2.setBorder((Border)BorderFactory.createTitledBorder(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_REPORT_TYPE_DESCRIPTION, "\u62a5\u8868\u7c7b\u578b\u8bf4\u660e")));
            this.jTextArea1.setColumns(20);
            this.jTextArea1.setEnabled(false);
            this.jTextArea1.setLineWrap(true);
            this.jTextArea1.setRows(5);
            this.jScrollPane1.setViewportView((Component)this.jTextArea1);
            GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
            this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
            jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 719, Short.MAX_VALUE).addContainerGap()));
            jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 278, Short.MAX_VALUE).addContainerGap()));
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 751, Short.MAX_VALUE)).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 15, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        }

        @Override
        public boolean checkValid() {
            return true;
        }

        @Override
        public boolean prepare() {
            return true;
        }
    }

    private class NavigatePanel
    extends KDPanel {
        private JButton cancel;
        private JButton prev;
        private JButton forward;
        private JButton finish;

        private NavigatePanel() {
            this.initComponents();
            this.initListeners();
        }

        private void initListeners() {
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportComposerWizard.this.userCanceled = true;
                    ReportComposerWizard.this.closeWizard();
                }
            });
            this.prev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportComposerWizard.this.prevStep();
                }
            });
            this.forward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportComposerWizard.this.nextStep();
                }
            });
            this.finish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportComposerWizard.this.closeWizard();
                }
            });
            ReportComposerWizard.this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ReportComposerWizard.this.userCanceled = true;
                    ReportComposerWizard.this.closeWizard();
                }
            });
        }

        private void initComponents() {
            this.cancel = new JButton();
            this.prev = new JButton();
            this.forward = new JButton();
            this.finish = new JButton();
            this.cancel.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_CANCEL, "\u53d6\u6d88"));
            this.prev.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_LAST, "\u4e0a\u4e00\u6b65"));
            this.forward.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_NEXT, "\u4e0b\u4e00\u6b65"));
            this.finish.setText(ReportComposerWizard.getLocalText(ReportComposerWizard.KEY_DONE, "\u5b8c\u6210"));
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(292, Short.MAX_VALUE).add((Component)this.cancel).addPreferredGap(0).add((Component)this.prev).addPreferredGap(0).add((Component)this.forward).addPreferredGap(0).add((Component)this.finish).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.prev).add((Component)this.forward).add((Component)this.finish)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        private void config4FirstStep() {
            this.cancel.setEnabled(true);
            this.prev.setEnabled(false);
            this.forward.setEnabled(true);
            this.finish.setEnabled(false);
        }

        private void config4MediumStep() {
            this.cancel.setEnabled(true);
            this.prev.setEnabled(true);
            this.forward.setEnabled(true);
            this.finish.setEnabled(false);
        }

        private void config4LastStep() {
            this.cancel.setEnabled(true);
            this.prev.setEnabled(true);
            this.forward.setEnabled(false);
            this.finish.setEnabled(true);
        }

        private void config4MediumStep2() {
            this.cancel.setEnabled(true);
            this.prev.setEnabled(true);
            this.forward.setEnabled(true);
            this.finish.setEnabled(true);
        }
    }
}

