/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.ui.SimpleDialog;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDFloatTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReportViewConstraintsWizard
extends SimpleDialog
implements ISpreadWizzard {
    private KDPanel constraintsPanel;
    private KDCheckBox editable;
    private KDCheckBox showFormula;
    private KDCheckBox rowCount;
    private KDCheckBox columnCount;
    private KDCheckBox hideEditable;
    private KDCheckBox hideToExcel;
    private KDCheckBox noChartTransferTip;
    private KDButtonGroup group;
    private ShowcaseConfig defaultConfig;
    private ShowcaseConfigCollection collection;
    private KDExt ext;
    private KDTextArea area = new KDTextArea();
    public static final String ROW_COUNT_OF_PAGE_REPORT = "ROW_COUNT_OF_PAGE_REPORT";
    public static final String HAS_ROW_COUNT_OF_PAGE = "HAS_ROW_COUNT_OF_PAGE";
    public static final String ROW_COUNT_OF_WEB_REPORT = "ROW_COUNT_OF_WEB_REPORT";
    public static final String EXPORT_HIDE_SHEETS = "EXPORT_HIDE_SHEETS";
    public static final String NEW_TAB_REPORT = "NEW_TAB_REPORT";
    public static final String PORTAL_IS_HIDE_MENUBAR = "PortalIsHideMenubarInReport";
    public static final int DEFAULT_ROW_PAGE = 15;
    public static final int DEFAULT_ROW_COUNT = 50;
    private KDCheckBox newTabRunRpt;
    private KDCheckBox treeGroup;
    private KDCheckBox portalExportFormula;
    private KDCheckBox portalHideToExcel;
    private KDCheckBox portalHideMunubarInReport;
    private KDCheckBox portalAutoRefresh;
    private KDFloatTextField portalFieldRefresh;
    private KDComboBox portalBoxRefresh;
    private KDCheckBox portalFullScreen;
    private KDCheckBox portalPopFilter;
    private boolean isCollectionSet = false;

    public ReportViewConstraintsWizard(KDExt ext) {
        super((Frame)((Object)ext));
        this.ext = ext;
        this.initComponents();
        this.initListeners();
        this.setSize(600, 520);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setTitle(CtrlEXTMessages.getMLS("reportDisplayProperties", "\u62a5\u8868\u663e\u793a\u5c5e\u6027"));
        this.initDefaultConfig();
        this.setComponent((Component)this.constraintsPanel);
    }

    private void initDefaultConfig() {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this.ext);
        Book book = context.getBook();
        ShowcaseConfig config = new ShowcaseConfig();
        String temp = (String)book.getUserObjectValue("ShowcaseConfigTemplet");
        if (!StringUtil.isEmptyString((String)temp)) {
            ShowcaseUtil.toShowcaseConfig(temp, config);
        }
        this.setDefaultShowcaseConfig(config);
    }

    private void initComponents() {
        KDPanel guiPanel = new KDPanel();
        guiPanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("client", "\u5ba2\u6237\u7aef")));
        TableLayout2 layout = new TableLayout2(10, 1);
        guiPanel.setLayout((LayoutManager)layout);
        this.editable = new KDCheckBox(CtrlEXTMessages.getMLS("editableResults", "\u7ed3\u679c\u53ef\u7f16\u8f91"));
        this.showFormula = new KDCheckBox(CtrlEXTMessages.getMLS("showAndExportFormulas", "\u663e\u793a\u5e76\u5bfc\u51fa\u516c\u5f0f"));
        this.rowCount = new KDCheckBox(CtrlEXTMessages.getMLS("hideRowNumbers", "\u4e0d\u663e\u793a\u884c\u53f7"));
        this.columnCount = new KDCheckBox(CtrlEXTMessages.getMLS("hideColumnLabels", "\u4e0d\u663e\u793a\u5217\u6807"));
        this.hideEditable = new KDCheckBox(CtrlEXTMessages.getMLS("draggableHiddenRowsAndColumns", "\u9690\u85cf\u7684\u884c,\u5217\u53ef\u62d6\u52a8"));
        this.hideToExcel = new KDCheckBox(CtrlEXTMessages.getMLS("exportHiddenSheetToExcel", "\u5bfc\u51fa\u9690\u85cf\u9875\u7b7e\u5230EXCEL"));
        this.noChartTransferTip = new KDCheckBox(CtrlEXTMessages.getMLS("noOldChartSwitchPrompt", "\u4e0d\u63d0\u793a\u65e7\u56fe\u8868\u5207\u6362"));
        this.newTabRunRpt = new KDCheckBox(CtrlEXTMessages.getMLS("openInNewTabOnFilterChange", "\u8fc7\u6ee4\u6761\u4ef6\u6539\u53d8\u65f6\u5728\u65b0\u9875\u7b7e\u4e2d\u6253\u5f00"));
        this.treeGroup = new KDCheckBox(CtrlEXTMessages.getMLS("showTreeReportGrouping", "\u663e\u793a\u6811\u578b\u62a5\u8868\u5206\u7ec4"));
        KDPanel selectModePanel = this.createSelectModePanel();
        guiPanel.add((Component)this.editable, (Object)TableLayout2.param((int)0, (int)0));
        guiPanel.add((Component)this.showFormula, (Object)TableLayout2.param((int)1, (int)0));
        guiPanel.add((Component)this.rowCount, (Object)TableLayout2.param((int)2, (int)0));
        guiPanel.add((Component)this.columnCount, (Object)TableLayout2.param((int)3, (int)0));
        guiPanel.add((Component)this.hideEditable, (Object)TableLayout2.param((int)4, (int)0));
        guiPanel.add((Component)this.hideToExcel, (Object)TableLayout2.param((int)5, (int)0));
        guiPanel.add((Component)this.newTabRunRpt, (Object)TableLayout2.param((int)6, (int)0));
        guiPanel.add((Component)this.treeGroup, (Object)TableLayout2.param((int)7, (int)0));
        guiPanel.add((Component)this.noChartTransferTip, (Object)TableLayout2.param((int)8, (int)0));
        guiPanel.add((Component)selectModePanel, (Object)TableLayout2.param((int)9, (int)0));
        KDPanel portalPanel = new KDPanel();
        portalPanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("portal", "\u95e8\u6237")));
        layout = new TableLayout2(6, 4);
        layout.setRatableHeight(0, 1);
        layout.setRatableHeight(1, 1);
        layout.setRatableHeight(2, 1);
        layout.setFixedHeight(3, 19);
        layout.setRatableHeight(4, 1);
        layout.setRatableHeight(5, 1);
        layout.setRatableWidth(0, 3);
        layout.setRatableWidth(1, 2);
        layout.setRatableWidth(2, 2);
        layout.setRatableWidth(3, 3);
        portalPanel.setLayout((LayoutManager)layout);
        this.portalExportFormula = new KDCheckBox(CtrlEXTMessages.getMLS("exportFormula", "\u5bfc\u51fa\u516c\u5f0f"));
        this.portalHideToExcel = new KDCheckBox(CtrlEXTMessages.getMLS("exportHiddenSheetToExcel", "\u5bfc\u51fa\u9690\u85cf\u9875\u7b7e\u5230EXCEL"));
        this.portalHideMunubarInReport = new KDCheckBox(CtrlEXTMessages.getMLS("hideMenuBarInReport", "\u9690\u85cf\u62a5\u8868\u91cc\u7684\u83dc\u5355\u680f"));
        this.portalFullScreen = new KDCheckBox(CtrlEXTMessages.getMLS("openFullscreen", "\u5168\u5c4f\u6253\u5f00"));
        this.portalPopFilter = new KDCheckBox(CtrlEXTMessages.getMLS("popUpFilterWindow", "\u5f39\u51fa\u8fc7\u6ee4\u7a97\u53e3"));
        this.portalAutoRefresh = new KDCheckBox(CtrlEXTMessages.getMLS("autoRefresh", "\u81ea\u52a8\u5237\u65b0"));
        this.portalFieldRefresh = new KDFloatTextField();
        this.portalFieldRefresh.setPrecision(2);
        this.portalFieldRefresh.setNegatived(false);
        this.portalFieldRefresh.setRemoveingZeroInEdit(true);
        this.portalBoxRefresh = new KDComboBox((Object[])this.createBoxItems());
        this.portalBoxRefresh.setSelectedIndex(2);
        portalPanel.add((Component)this.portalExportFormula, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)2));
        portalPanel.add((Component)this.portalHideToExcel, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)3));
        portalPanel.add((Component)this.portalHideMunubarInReport, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)2));
        portalPanel.add((Component)this.portalAutoRefresh, (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)1));
        portalPanel.add((Component)this.portalFieldRefresh, (Object)TableLayout2.param((int)3, (int)2));
        portalPanel.add((Component)this.portalBoxRefresh, (Object)TableLayout2.param((int)3, (int)3));
        portalPanel.add((Component)this.portalFullScreen, (Object)TableLayout2.param((int)4, (int)0, (int)4, (int)2));
        portalPanel.add((Component)this.portalPopFilter, (Object)TableLayout2.param((int)5, (int)0, (int)5, (int)2));
        KDScrollPane sp = new KDScrollPane((Component)this.area);
        this.area.setEnabled(false);
        String detailTextAppendParts = CtrlEXTMessages.getMLS("editable", "1.%s\uff1a\u6267\u884c\u540e\u7684\u62a5\u8868\u4e00\u822c\u4e3a\u4e0d\u53ef\u7f16\u8f91\u7684\uff0c\u5982\u679c\u9700\u8981\u8fdb\u884c\u4fee\u6539\uff0c\u53ef\u52fe\u9009\u6b64\u9879\u3002\n") + CtrlEXTMessages.getMLS("showFormula2", "2.%s\uff1a\u5982\u679c\u9700\u8981\u67e5\u770b\u6267\u884c\u540e\u5355\u5143\u683c\u7684\u516c\u5f0f\uff0c\u53ef\u52fe\u9009\u6b64\u9879\u3002\uff08\u5982\u9700\u8981\u5bfc\u51faExcel\u516c\u5f0f\u8bf7\u52fe\u9009\u6b64\u9879\u3002\uff09\n") + CtrlEXTMessages.getMLS("rowCount", "3.%s\uff1a\u52fe\u9009\u6b64\u9879\u53ef\u4ee5\u5bf9\u884c\u53f7\u8fdb\u884c\u9690\u85cf\u3002\n") + CtrlEXTMessages.getMLS("columnCount", "4.%s\uff1a\u52fe\u9009\u6b64\u9879\u53ef\u4ee5\u5bf9\u5217\u6807\u8fdb\u884c\u9690\u85cf\u3002\n") + CtrlEXTMessages.getMLS("hideEditable", "5.%s\uff1a\u53cd\u52fe\u9009\u6b64\u9879\u53ef\u4ee5\u5b8c\u5168\u9690\u85cf\u6267\u884c\u62a5\u8868\u7684\u90e8\u5206\u6570\u636e\uff0c\u7528\u6237\u65e0\u6cd5\u901a\u8fc7\u5176\u4ed6\u624b\u6bb5\u83b7\u53d6\u5230\u88ab\u9690\u85cf\u7684\u6570\u636e\u3002\u5982\u679c\u9700\u8981\u8fdb\u884c\u62a5\u8868\u5bfc\u51fa\uff0c\u800c\u5bfc\u51fa\u7684\u62a5\u8868\u5217\u6570\u8d85\u8fc7255\u5217\uff08Excel2003\u9650\u5236\uff09\uff0c\u53ef\u4ee5\u9690\u85cf\u90e8\u5206\u5217\uff0c\u53cd\u52fe\u9009\u6b64\u9879\u540e\u518d\u8fdb\u884c\u5bfc\u51fa \u3002\n") + CtrlEXTMessages.getMLS("hideToExcel", "6.%s\uff1a\u52fe\u9009\u6b64\u9879\u540e\uff0c\u62a5\u8868\u4e2d\u9690\u85cf\u9875\u7b7e\u80fd\u5bfc\u51fa\u5230Excel\u4e14\u5728Excel\u4e5f\u662f\u9690\u85cf\uff0c\u53cd\u52fe\u9009\u6b64\u9879\u5219\u4e0d\u5bfc\u51fa\u9690\u85cf\u9875\u7b7e\u3002\n") + CtrlEXTMessages.getMLS("newTabRunRpt", "7.%s\uff1a\u52fe\u9009\u6b64\u9879\u540e\uff0c\u5728GUI\u62a5\u8868\u6267\u884c\u754c\u9762\uff0c\u70b9\u51fb\u5de5\u5177\u680f\u7684\u3010\u8fc7\u6ee4\u3011\u6309\u94ae\u5f39\u51fa\u8fc7\u6ee4\u6761\u4ef6\u7a97\u53e3\uff0c\u6539\u53d8\u8fc7\u6ee4\u6761\u4ef6\u540e\u70b9\u51fb\u3010\u786e\u5b9a\u3011\u6309\u94ae\u4f1a\u5728\u65b0\u9875\u7b7e\u4e2d\u6253\u5f00\u62a5\u8868\u3002\n") + CtrlEXTMessages.getMLS("treeGroup", "8.%s\uff1a\u52fe\u9009\u6b64\u9879\u540e\uff0c\u663e\u793a\u6811\u578b\u62a5\u8868\u7684\u5de6\u4fa7\u6216\u4e0a\u4fa7\u5206\u7ec4\u3002\n") + CtrlEXTMessages.getMLS("portalHideMunubarInReport", "9.%s\uff1a\u52fe\u9009\u6b64\u9879\u540e\uff0c\u5728\u95e8\u6237\u4e0a\u8be5\u62a5\u8868\u4f1a\u9690\u85cf\u62a5\u8868\u91cc\u7684\u83dc\u5355\u680f\uff08\u5168\u5c4f\u3001\u8fc7\u6ee4\u3001\u5bfc\u51fa\u7b49\u6309\u94ae\uff09\u3002\n") + CtrlEXTMessages.getMLS("portalAutoRefresh", "10.%s\uff1a\u8bbe\u5b9a\u7684\u65f6\u95f4\u9891\u7387\u662f\u6307\u62a5\u8868\u672c\u6b21\u6267\u884c\u5b8c\u6bd5\u540e\uff0c\u8ddd\u79bb\u4e0b\u4e00\u6b21\u5f00\u59cb\u6267\u884c\u7684\u65f6\u95f4\u3002\n") + CtrlEXTMessages.getMLS("portalFullScreen", "11.%s\uff1a\u6b64\u9009\u9879\u548c'\u9690\u85cf\u62a5\u8868\u91cc\u7684\u83dc\u5355\u680f'\u4e92\u65a5\uff0c\u5426\u5219\u5168\u5c4f\u6253\u5f00\u540e\u65e0\u6cd5\u9000\u51fa\u5168\u5c4f\n") + CtrlEXTMessages.getMLS("portalPopFilter", "12.%s\uff1a\u4ec5\u5bf9\u672a\u52fe\u9009'\u4e0b\u6b21\u4ee5\u8be5\u65b9\u6848\u8fdb\u5165'\u6709\u6548\uff0c\u5982\u5df2\u52fe\u9009'\u4e0b\u6b21\u4ee5\u8be5\u65b9\u6848\u8fdb\u5165'\u5219\u4e0d\u5f39\u8fc7\u6ee4\u7a97\u53e3\n") + CtrlEXTMessages.getMLS("formulaAttention", "\n\u6ce8\u610f\uff1a\u5728\u52fe\u9009\u2018\u663e\u793a\u5e76\u5bfc\u51fa\u516c\u5f0f\u2019\u540c\u65f6\u53cd\u52fe\u9009\u2018\u9690\u85cf\u7684\u884c\uff0c\u5217\u53ef\u62d6\u52a8\u2019\u6216\u2018\u5bfc\u51fa\u9690\u85cf\u9875\u7b7e\u5230EXCEL\u2019\u7684\u60c5\u51b5\u4e0b\uff0c\u8fdb\u884cExcel\u5bfc\u51fa\uff0cExcel\u91cd\u7b97\u540e\u7684\u7ed3\u679c\u53ef\u80fd\u4e0e\u6269\u5c55\u62a5\u8868\u4e0d\u4e00\u81f4\u3002");
        StringBuilder detailText = new StringBuilder();
        detailText.append(String.format(detailTextAppendParts, this.editable.getText(), this.showFormula.getText(), this.rowCount.getText(), this.columnCount.getText(), this.hideEditable.getText(), this.hideToExcel.getText(), this.newTabRunRpt.getText(), this.treeGroup.getText(), this.portalHideMunubarInReport.getText(), this.portalAutoRefresh.getText(), this.portalFullScreen.getText(), this.portalPopFilter.getText()));
        this.area.setText(detailText.toString());
        this.constraintsPanel = new KDPanel();
        layout = new TableLayout2(3, 2);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 66);
        layout.setRatableHeight(2, 44);
        layout.setColSpacing(0, 10);
        layout.setRowSpacing(1, 5);
        this.constraintsPanel.setLayout((LayoutManager)layout);
        this.constraintsPanel.setCustomInsets(new Insets(10, 10, 10, 10));
        this.constraintsPanel.add((Component)guiPanel, (Object)TableLayout2.param((int)0, (int)0, (int)1, (int)0));
        this.constraintsPanel.add((Component)portalPanel, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)0));
        this.constraintsPanel.add((Component)sp, (Object)TableLayout2.param((int)1, (int)1, (int)2, (int)1));
        KDLabel label = new KDLabel(CtrlEXTMessages.getMLS("instructions", "\u4f7f\u7528\u8bf4\u660e"));
        this.constraintsPanel.add((Component)label, (Object)TableLayout2.param((int)0, (int)1, (int)0, (int)1));
    }

    private TextValuePair[] createBoxItems() {
        TextValuePair[] array = new TextValuePair[]{new TextValuePair("H", CtrlEXTMessages.getMLS("hour", "\u5c0f\u65f6")), new TextValuePair("M", CtrlEXTMessages.getMLS("minute", "\u5206")), new TextValuePair("S", CtrlEXTMessages.getMLS("second", "\u79d2"))};
        return array;
    }

    private KDPanel createSelectModePanel() {
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        KDLabel label = new KDLabel(CtrlEXTMessages.getMLS("browseMode", "  \u6d4f\u89c8\u6a21\u5f0f\uff1a\u9009\u4e2d"));
        label.setBounds(0, 5, 135, 20);
        KDRadioButton cellSelect = new KDRadioButton(CtrlEXTMessages.getMLS("cell", "\u5355\u5143\u683c"));
        cellSelect.setBounds(140, 5, 60, 20);
        KDRadioButton rowSelect = new KDRadioButton(CtrlEXTMessages.getMLS("row", "\u884c"));
        rowSelect.setBounds(205, 5, 60, 20);
        panel.add((Component)label);
        panel.add((Component)cellSelect);
        panel.add((Component)rowSelect);
        this.group = new KDButtonGroup();
        this.group.add((AbstractButton)cellSelect);
        this.group.add((AbstractButton)rowSelect);
        this.group.setValue(0);
        return panel;
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReportViewConstraintsWizard.this.setVisible(false);
                ReportViewConstraintsWizard.this.dispose();
            }
        });
        this.portalExportFormula.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportViewConstraintsWizard.this.showFormula.setSelected(((KDCheckBox)e.getSource()).isSelected());
            }
        });
        this.showFormula.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportViewConstraintsWizard.this.portalExportFormula.setSelected(((KDCheckBox)e.getSource()).isSelected());
            }
        });
        this.portalHideToExcel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportViewConstraintsWizard.this.hideToExcel.setSelected(((KDCheckBox)e.getSource()).isSelected());
            }
        });
        this.hideToExcel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportViewConstraintsWizard.this.portalHideToExcel.setSelected(((KDCheckBox)e.getSource()).isSelected());
            }
        });
        this.portalAutoRefresh.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportViewConstraintsWizard.this.portalBoxRefresh.setEnabled(ReportViewConstraintsWizard.this.portalAutoRefresh.isSelected());
                ReportViewConstraintsWizard.this.portalFieldRefresh.setEnabled(ReportViewConstraintsWizard.this.portalAutoRefresh.isSelected());
            }
        });
        this.portalFullScreen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ReportViewConstraintsWizard.this.portalFullScreen.isSelected()) {
                    ReportViewConstraintsWizard.this.portalHideMunubarInReport.setSelected(false);
                }
            }
        });
        this.portalHideMunubarInReport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ReportViewConstraintsWizard.this.portalHideMunubarInReport.isSelected()) {
                    ReportViewConstraintsWizard.this.portalFullScreen.setSelected(false);
                }
            }
        });
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void show() {
        Book book = MiscUtil.getActiveSpreadContext(this.ext).getBook();
        UserObject uo = book.getUserObject(EXPORT_HIDE_SHEETS);
        if (uo == null) {
            this.hideToExcel.setSelected(true);
        } else {
            this.hideToExcel.setSelected("true".equals(uo.getValue().toString()));
        }
        uo = book.getUserObject(NEW_TAB_REPORT);
        if (uo == null) {
            this.newTabRunRpt.setSelected(false);
        } else {
            this.newTabRunRpt.setSelected("true".equals(uo.getValue().toString()));
        }
        uo = book.getUserObject("SHOW_TREE_GROUP");
        if (uo == null) {
            this.treeGroup.setSelected(false);
        } else {
            this.treeGroup.setSelected(Boolean.parseBoolean(uo.getValue().toString()));
        }
        uo = book.getUserObject(PORTAL_IS_HIDE_MENUBAR);
        if (uo == null) {
            this.portalHideMunubarInReport.setSelected(false);
        } else {
            this.portalHideMunubarInReport.setSelected("true".equals(uo.getValue().toString()));
        }
        uo = book.getUserObject("ExtRpt_noChartTransferTip");
        if (null == uo) {
            this.noChartTransferTip.setSelected(false);
        } else {
            this.noChartTransferTip.setSelected(Boolean.parseBoolean(uo.getValue().toString()));
        }
        uo = book.getUserObject("PortalAutoRefresh");
        if (uo == null) {
            this.portalAutoRefresh.setSelected(false);
            this.portalBoxRefresh.setEnabled(false);
            this.portalFieldRefresh.setValue(null);
        } else {
            this.portalAutoRefresh.setSelected(true);
            String data = (String)uo.getValue();
            this.portalFieldRefresh.setValue((Object)Float.valueOf(data.substring(0, data.length() - 1)));
            char unit = data.charAt(data.length() - 1);
            switch (unit) {
                case 'H': {
                    this.portalBoxRefresh.setSelectedIndex(0);
                    break;
                }
                case 'M': {
                    this.portalBoxRefresh.setSelectedIndex(1);
                    break;
                }
                case 'S': {
                    this.portalBoxRefresh.setSelectedIndex(2);
                    break;
                }
                default: {
                    throw new RuntimeException("illegal time unit!");
                }
            }
        }
        uo = book.getUserObject("PortalFullScreen");
        if (uo == null) {
            this.portalFullScreen.setSelected(false);
        } else {
            this.portalFullScreen.setSelected("true".equalsIgnoreCase(uo.getValue().toString()));
        }
        uo = book.getUserObject("PortalPopFilter");
        if (uo == null) {
            this.portalPopFilter.setSelected(true);
        } else {
            this.portalPopFilter.setSelected("true".equalsIgnoreCase(uo.getValue().toString()));
        }
        this.editable.setSelected(this.defaultConfig.isEditable());
        this.showFormula.setSelected(this.defaultConfig.isShowFormula());
        this.rowCount.setSelected(this.defaultConfig.isRowCountVisible());
        this.columnCount.setSelected(this.defaultConfig.isColCountVisible());
        this.hideEditable.setSelected(this.defaultConfig.isHideEditable());
        if (this.defaultConfig.isCellSelect()) {
            this.group.setValue(0);
        } else {
            this.group.setValue(1);
        }
        this.portalExportFormula.setSelected(this.showFormula.isSelected());
        this.portalHideToExcel.setSelected(this.hideToExcel.isSelected());
        this.showDialog();
    }

    private boolean[] fetchUserSettings() {
        boolean editable = this.editable.isSelected();
        boolean showFormula = this.showFormula.isSelected();
        boolean rowCount = this.rowCount.isSelected();
        boolean columnCount = this.columnCount.isSelected();
        boolean hideEditable = this.hideEditable.isSelected();
        boolean cell = this.group.getValue() == 0;
        boolean isHideMenubarInPortal = this.portalHideMunubarInReport.isSelected();
        return new boolean[]{editable, showFormula, rowCount, columnCount, hideEditable, cell, isHideMenubarInPortal};
    }

    private void saveUserSetting() {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this.ext);
        Book book = context.getBook();
        if (this.defaultConfig != null) {
            this.updateConfig2(this.defaultConfig);
            this.defaultConfig.setRowSpans(null);
            this.defaultConfig.setColSpans(null);
            book.setUserObject("ShowcaseConfigTemplet", ShowcaseUtil.toShowcaseConfig(this.defaultConfig.toElement()));
            if (this.isCollectionSet) {
                this.collection.saveShowcaseConfig(this.defaultConfig);
            }
        } else {
            this.defaultConfig = new ShowcaseConfig();
            this.defaultConfig.setDefault(true);
            this.updateConfig2(this.defaultConfig);
            if (this.isCollectionSet) {
                this.collection.saveShowcaseConfig(this.defaultConfig);
            }
        }
        book.setUserObject(EXPORT_HIDE_SHEETS, this.hideToExcel.isSelected());
        book.setUserObject(NEW_TAB_REPORT, this.newTabRunRpt.isSelected());
        book.setUserObject(PORTAL_IS_HIDE_MENUBAR, this.portalHideMunubarInReport.isSelected());
        book.setUserObject("ExtRpt_noChartTransferTip", this.noChartTransferTip.isSelected());
        if (this.treeGroup.isSelected()) {
            book.setUserObject("SHOW_TREE_GROUP", Boolean.TRUE);
        } else {
            book.removeUserObject("SHOW_TREE_GROUP");
        }
        Number num = this.portalFieldRefresh.getNumberValue();
        if (this.portalAutoRefresh.isSelected() && num != null && !ArrayUtil.isEqual((Float)Float.valueOf(num.floatValue()), (Float)Float.valueOf(0.0f))) {
            String value = num.floatValue() + ((TextValuePair)this.portalBoxRefresh.getSelectedItem()).getValue();
            book.setUserObject("PortalAutoRefresh", value);
        } else {
            book.removeUserObject("PortalAutoRefresh");
        }
        if (this.portalFullScreen.isSelected()) {
            book.setUserObject("PortalFullScreen", Boolean.TRUE);
        } else {
            book.removeUserObject("PortalFullScreen");
        }
        if (this.portalPopFilter.isSelected()) {
            book.removeUserObject("PortalPopFilter");
        } else {
            book.setUserObject("PortalPopFilter", Boolean.FALSE);
        }
    }

    private void updateConfig2(ShowcaseConfig config) {
        if (config != null) {
            boolean[] user = this.fetchUserSettings();
            config.setEditable(user[0]);
            config.setShowFormula(user[1]);
            config.setRowCountVisible(user[2]);
            config.setColCountVisible(user[3]);
            config.setHideEditable(user[4]);
            config.setCellSelect(user[5]);
            config.setHideMenubarInPortal(user[6]);
        }
    }

    public ShowcaseConfigCollection getCollection() {
        return this.collection;
    }

    public void setCollection(ShowcaseConfigCollection collection) {
        this.collection = collection;
        this.isCollectionSet = true;
    }

    public void setDefaultShowcaseConfig(ShowcaseConfig config) {
        if (this.collection != null) {
            this.collection.setDefaultConfig(config);
        }
        this.defaultConfig = config;
    }

    public ShowcaseConfig getDefaultShowcaseConfig() {
        return this.defaultConfig;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        TableLayout layout = (TableLayout)parent.getLayout();
        layout.rowStyle(0).setMargin(0);
        parent.add(this.getComponent(), thisCell);
    }

    protected void onOk() {
        this.saveUserSetting();
        super.onOk();
    }

    private static class TextValuePair {
        private String value;
        private String text;

        public TextValuePair(String value, String text) {
            this.value = value;
            this.text = text;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.text;
        }
    }
}

