/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util;

import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.dd.ui.view.DataTrimView;
import com.kingdee.cosmic.ctrl.ext.pd.ui.views.params.ParametersTrimView;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.scview.ReportTrimView;
import com.kingdee.cosmic.ctrl.ext.util.ExtConsole;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.cosmic.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.cosmic.ctrl.kds.io.kds.InvalidCouponException;
import com.kingdee.cosmic.ctrl.kds.io.kds.KdsToBook;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprParams;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class MiscUtil {
    private static final Logger logger = LogUtil.getPackageLogger(MiscUtil.class);
    private static ExtConsole console;
    public static final int FATAL_LOG = 0;
    public static final int ERROR_LOG = 1;
    public static final int WARN_LOG = 2;
    public static final int INFO_LOG = 3;
    public static final int DEBUG_LOG = 4;
    public static char AND;
    public static char EQUAL;
    public static char SEPARATOR;
    public static String S_AND;
    public static String S_EQUAL;
    public static String S_SEPARATOR;
    public static String SIGN;
    private static final String ALERT_IE_VERSION_JS;
    private static final String[] SWT_KEYS;

    public static Object[] sortColumnsByIndex(SortedObjectArray soa) {
        Object[] cols = soa.toArray();
        Arrays.sort(cols, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int ret;
                try {
                    ret = ((ExtColumn)obj1).getIndex().compareTo(((ExtColumn)obj2).getIndex());
                }
                catch (SyntaxErrorException e) {
                    ret = -1;
                }
                return ret;
            }
        });
        return cols;
    }

    public static void fatal(String log) {
        MiscUtil.log(0, log);
    }

    public static void error(String log) {
        MiscUtil.log(1, log);
    }

    public static void warn(String log) {
        MiscUtil.log(2, log);
    }

    public static void info(String log) {
        MiscUtil.log(3, log);
    }

    public static void debug(String log) {
        MiscUtil.log(4, log);
    }

    public static void log(int level, String log) {
        if (!MiscUtil.shouldLog()) {
            return;
        }
        console.log(level, log);
    }

    public static void log(Throwable t) {
        if (console == null || !console.isShowing()) {
            return;
        }
        console.log(t);
    }

    public static boolean shouldLog() {
        return console != null && console.isShowing();
    }

    public static ExtConsole getExtConsole() {
        if (console == null) {
            console = new ExtConsole();
        } else if (!console.isShowing()) {
            console.clearRecorder();
        }
        return console;
    }

    public static void showConsole(KDExt ext) {
        if (console == null) {
            console = new ExtConsole(ext);
        } else if (!console.isShowing()) {
            console.clearRecorder();
            if (null != ext) {
                console.setExt(ext);
            }
        }
        console.show();
    }

    public static String getDocuments() {
        if (console == null) {
            return "";
        }
        return console.getDoctments();
    }

    public static String getLastExeDocuments() {
        String[] logs = MiscUtil.getDocuments().split(SIGN);
        String log = logs[0];
        if (logs.length > 1) {
            log = log + logs[logs.length - 1];
        }
        return log;
    }

    public static void centralizeFullScreenDialog(Dialog dialog) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        Insets insets = toolkit.getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        int x = 0 + insets.left;
        int y = 0 + insets.top;
        int w = d.width - insets.left - insets.right;
        int h = d.height - insets.top - insets.bottom;
        dialog.setBounds(x, y, w, h);
    }

    public static SpreadContext getActiveSpreadContext(KDExt _ext) {
        Perspective perspective = _ext.getActivePerspective();
        return MiscUtil.getPerspectiveSpreadContext(perspective);
    }

    public static SpreadContext getPerspectiveSpreadContext(Perspective perspective) {
        if (perspective == null) {
            return null;
        }
        if (perspective.getPerspectiveName().equals("Report Designer")) {
            return ((ReportTrimView)((TrimWidgetViewport)perspective.getTrimWidget("Report_Widget_ID")).getView()).getSpreadContext();
        }
        if (perspective.getPerspectiveName().equals("Parameter Designer")) {
            return ((ParametersTrimView)((TrimWidgetViewport)perspective.getTrimWidget("Parameters_Widget_ID")).getView()).getSpreadContext();
        }
        if (perspective.getPerspectiveName().equals("Data Designer")) {
            return ((DataTrimView)((TrimWidgetViewport)perspective.getTrimWidget("Data_Widget_ID")).getView()).getSpreadContext();
        }
        return null;
    }

    public static Book unpack(byte[] data) throws HighVersionException, InvalidCouponException, AuthorizationFailedException {
        byte[] magic = new byte[17];
        System.arraycopy(data, 0, magic, 0, 17);
        String magicString = new String(magic, StandardCharsets.UTF_8);
        if ("###KDSpread2.0###".equals(magicString) || "###KDSpread2.1###".equals(magicString)) {
            try {
                return BookIOUtil.unpack(data);
            }
            catch (InvalidCouponException e) {
                throw e;
            }
            catch (HighVersionException e) {
                throw e;
            }
            catch (AuthorizationFailedException e) {
                throw e;
            }
            catch (Throwable t) {
                MiscUtil.log(t);
                return null;
            }
        }
        try {
            return new KdsToBook().load(new ByteArrayInputStream(data));
        }
        catch (Throwable t) {
            MiscUtil.log(t);
            return null;
        }
    }

    public static String[] collectDefines(Book book) {
        ExtDataSetManager manager = book.getDataSetManager();
        int count = manager.size();
        ObjectArray oa = new ObjectArray(count);
        for (int i = 0; i < count; ++i) {
            ExtDataSet ds = manager.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            oa.append(ds.getDefine());
        }
        Object[] defines = new String[oa.size()];
        oa.toArray(defines, 0);
        return defines;
    }

    public static ExtDataSet[] collectExtDataSets(Book book) {
        ExtDataSetManager manager = book.getDataSetManager();
        int count = manager.size();
        ObjectArray oa = new ObjectArray(count);
        for (int i = 0; i < count; ++i) {
            ExtDataSet ds = manager.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            oa.append(ds);
        }
        Object[] datasets = new ExtDataSet[oa.size()];
        oa.toArray(datasets, 0);
        return datasets;
    }

    public static ExtDataSetType[] collectExtDataSetTypes(Book book) {
        HashSet<ExtDataSetType> set = new HashSet<ExtDataSetType>();
        ExtDataSetManager manager = book.getDataSetManager();
        int count = manager.size();
        for (int i = 0; i < count; ++i) {
            ExtDataSet ds = manager.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            set.add(ds.getDataSetType());
        }
        ExtDataSetType[] types = new ExtDataSetType[set.size()];
        Iterator it = set.iterator();
        int index = 0;
        while (it.hasNext()) {
            types[index++] = (ExtDataSetType)it.next();
        }
        return types;
    }

    public static boolean isExtUsed(NamedObjectNode no) {
        Variant value;
        if (!no.isVisible() && no.isUndefined() && (value = no.getValue()).isString()) {
            return value.toString().compareToIgnoreCase(no.getName()) == 0;
        }
        return false;
    }

    public static boolean isNamedObjectInsertable4Book(Book book, String name) {
        IExprNode[] nodes;
        ExprParams ep;
        if (StringUtil.isEmptyString((String)name)) {
            return false;
        }
        NamedObjectNode node = book.getNamedObject(name);
        if (node != null && !MiscUtil.isExtUsed(node) && !node.isUndefined()) {
            return false;
        }
        node = null;
        Dependents deps = book.getDeps();
        boolean old = deps.isA1Style();
        deps.setA1Style(true);
        Sheet sheet = book.getSheet(0);
        Expr expr = sheet.getExpr(null, name);
        deps.setA1Style(old);
        if (expr != null && !expr.isSyntaxError() && expr.getExprOps().getNodes().length == 1 && (ep = expr.getExprParams()) != null && (nodes = ep.getNodes())[0] instanceof NamedObjectNode) {
            node = (NamedObjectNode)nodes[0];
        }
        if (node == null) {
            return false;
        }
        sheet.getNames().remove(name);
        node.setSheet(null);
        book.getNames().insert(node);
        return true;
    }

    public static void handleFileCheckingException(Exception e, Component parent) {
        if (e instanceof HighVersionException) {
            MessageUtil.msgboxWarning(parent, CtrlEXTMessages.getMLS("lowVersionReaderTryOpenHighVersionFile", "\u8bd5\u56fe\u7528\u4f4e\u7248\u672c\u7684\u8bfb\u53d6\u5668\u6253\u5f00\u9ad8\u7248\u672c\u6587\u4ef6\u89c4\u683c\uff01 \u5f53\u524d\u8bfb\u53d6\u5668\u7248\u672c: [#1] \u76ee\u6807\u6587\u4ef6\u7248\u672c: [#2]").replace("#1", String.valueOf(((HighVersionException)e).getInterpretorVersion())).replace("#2", String.valueOf(((HighVersionException)e).getTargetVersion())));
            return;
        }
        if (e instanceof InvalidCouponException) {
            MessageUtil.msgboxWarning(parent, CtrlEXTMessages.getMLS("notValidStandardProductReport", "\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6807\u51c6\u4ea7\u54c1\u62a5\u8868\uff01"));
            return;
        }
        if (e instanceof AuthorizationFailedException) {
            MessageUtil.msgboxWarning(parent, e.getMessage());
            return;
        }
        if (e instanceof IOException) {
            MessageUtil.msgboxWarning(parent, CtrlEXTMessages.getMLS("ioExceptionReadingReportBinaryFile", "\u8bfb\u53d6\u62a5\u8868\u4e8c\u8fdb\u5236\u6587\u4ef6\u53d1\u751fIO\u5f02\u5e38\uff01"));
            return;
        }
    }

    public static void play(final URL url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int buffersize = 16000;
                    AudioInputStream audioStream = AudioSystem.getAudioInputStream(url);
                    AudioFormat audioFormat = audioStream.getFormat();
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                    SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                    line.open(audioFormat);
                    line.start();
                    int inBytes = 0;
                    byte[] audioData = new byte[buffersize];
                    while (inBytes != -1) {
                        inBytes = audioStream.read(audioData, 0, buffersize);
                        if (inBytes < 0) continue;
                        line.write(audioData, 0, inBytes);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static Dimension getPrintablePagePixelSize(Sheet sheet) {
        double head;
        double paperWidth = 8.267716535433072;
        double paperHeight = 11.692913385826772;
        PageIntervalInfo defaultMarginInfo = PageIntervalInfo.getDefault();
        double left = defaultMarginInfo.getLeft(25400);
        double right = defaultMarginInfo.getRight(25400);
        double top = defaultMarginInfo.getTop(25400);
        double bottom = defaultMarginInfo.getBottom(25400);
        double foot = head = 0.0;
        MediaSizeName mediasize = null;
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps != null && (mediasize = KDPrinterUtils.getMediaSizeNameByValue((int)ps.getPagesizeIndex(), (float)ps.getPagesizeX(), (float)ps.getPagesizeY())) != null) {
            float margin;
            MediaSize msz = MediaSize.getMediaSizeForName(mediasize);
            if (msz == null && mediasize == MediaSizeName.TABLOID) {
                msz = MediaSize.ISO.A4;
            }
            if (ps.isLandScape()) {
                double temp = paperWidth;
                paperWidth = paperHeight;
                paperHeight = temp;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getLeftMargin()), (Float)Float.valueOf(0.0f))) {
                left = margin;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getRightMargin()), (Float)Float.valueOf(0.0f))) {
                right = margin;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getTopMargin()), (Float)Float.valueOf(0.0f))) {
                top = margin;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getBottomMargin()), (Float)Float.valueOf(0.0f))) {
                bottom = margin;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getHeadMargin()), (Float)Float.valueOf(0.0f))) {
                head = margin;
            }
            if (!ArrayUtil.isEqual((Float)Float.valueOf(margin = ps.getFootMargin()), (Float)Float.valueOf(0.0f))) {
                foot = margin;
            }
            if (msz != null) {
                paperWidth = (double)msz.getX(25400) - left - right;
                paperHeight = (double)msz.getY(25400) - top - bottom - head - foot;
            } else {
                paperWidth = paperWidth - left - right;
                paperHeight = paperHeight - top - bottom - head - foot;
            }
        } else {
            paperWidth = paperWidth - left - right;
            paperHeight = paperHeight - top - bottom - head - foot;
        }
        return new Dimension((int)(paperWidth * (double)KDPrinterUtils.getPtsPerInch()), (int)(paperHeight * (double)KDPrinterUtils.getPtsPerInch()));
    }

    public static String generateExternalHyperlinkBody(Map<String, Object> param) {
        if (param == null) {
            return "";
        }
        return (String)param.get("DISPLAY_NAME");
    }

    public static String generateExternalHyperlink(Map<String, Object> param) {
        if (param == null) {
            return "";
        }
        return param.get("HYPERLINK_PREFIX") + MiscUtil.generateExternalHyperlinkBody(param);
    }

    public static void capacitateFiCalculation(SpreadContext context) {
        try {
            Method method = Class.forName("com.kingdee.eas.rpts.ctrlreport.util.ExtEASFusionUtil").getMethod("capacitateFiCalculation", SpreadContext.class);
            method.invoke(null, new Object[]{context});
        }
        catch (Throwable e) {
            MiscUtil.log(2, CtrlEXTMessages.getMLS("lightReportRuntimeEngineLoadFailed", "\u8f7b\u62a5\u8868\u8fd0\u884c\u5f15\u64ce\u672a\u80fd\u88c5\u8f7dEAS\u53d6\u6570\u516c\u5f0f\uff01"));
        }
    }

    public static void capacitateFiCalculation(Book book) {
        try {
            Method method = Class.forName("com.kingdee.eas.rpts.ctrlreport.util.ExtEASFusionUtil").getMethod("capacitateFiCalculation", Book.class);
            method.invoke(null, book);
        }
        catch (Throwable e) {
            MiscUtil.log(2, CtrlEXTMessages.getMLS("lightReportRuntimeEngineLoadFailed", "\u8f7b\u62a5\u8868\u8fd0\u884c\u5f15\u64ce\u672a\u80fd\u88c5\u8f7dEAS\u53d6\u6570\u516c\u5f0f\uff01"));
        }
    }

    public static boolean isExecutedBook(Book book) {
        return "TRUE".equals(book.getUserObjectValue("EXT_EXECUTED"));
    }

    public static ValidationList cloneValidations(Sheet sheet) {
        ValidationList srcList = sheet.getValidations();
        ValidationList ret = new ValidationList();
        for (int i = 0; i < srcList.size(); ++i) {
            Validation src = srcList.getValidation(i);
            ret.addValidation(MiscUtil.cloneValidation(src));
        }
        return ret;
    }

    public static Validation cloneValidation(Validation v) {
        MessagedValidate mv = v.getMessagedValidate();
        Validation ret = new Validation(v.getSheet(), mv == null ? null : (MessagedValidate)mv.clone(), MiscUtil.cloneSortedCellBlockArray(v.getBlocks()));
        ret.setEditorDefine(v.getEditorDefine());
        ret.setReportingValidation(v.isReportingValidation());
        return ret;
    }

    public static SortedCellBlockArray cloneSortedCellBlockArray(SortedCellBlockArray arr) {
        SortedCellBlockArray ret = new SortedCellBlockArray();
        ret.copyFrom(arr);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean switchJdkVersion(String detail, boolean isShowTip) {
        boolean isYes;
        if (!CtrlUtil.is64BitJVM() || !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("win")) {
            return false;
        }
        if (isShowTip && !(isYes = MessageUtil.msgboxYesNo(null, CtrlEXTMessages.getMLS("switchTo32BitJVM", "\u5f53\u524d\u73af\u5883\uff0864bit JVM\uff09\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd, \u662f\u5426\u5207\u6362\u4e3a32bit JVM\uff1f") + "\n" + CtrlEXTMessages.getMLS("autoSwitchConfirmation", "\u9009\u62e9\u3010\u662f\u3011\u5c06\u4f1a\u81ea\u52a8\u5207\u6362, \u4e0b\u6b21\u542f\u52a8\u5ba2\u6237\u7aef\u751f\u6548"), detail))) {
            return true;
        }
        String line = null;
        BufferedWriter bw = null;
        BufferedReader br = null;
        StringBuilder buf = new StringBuilder();
        String easHome = System.getProperty("EAS_HOME");
        String filePath = easHome + "/client/bin/set-client-env.bat";
        try {
            br = new BufferedReader(new FileReader(FilenameUtils.normalize((String)filePath)));
            while ((line = br.readLine()) != null) {
                if (line.indexOf("JAVA_HOME") >= 0) {
                    buf.append("SET JAVA_HOME=").append(easHome).append("/oracle-jdk1.6");
                } else {
                    buf.append(line);
                }
                buf.append(System.getProperty("line.separator"));
            }
            bw = new BufferedWriter(new FileWriter(FilenameUtils.normalize((String)filePath)));
            bw.write(buf.toString());
        }
        catch (Exception e) {
            MessageUtil.msgboxWarning(null, CtrlEXTMessages.getMLS("autoSwitchFailed", "\u81ea\u52a8\u5207\u6362\u5931\u8d25!\n\u53ef\u624b\u52a8\u4fee\u6539#1\u4e2d\u7684JAVA_HOME\u53d8\u91cf\u503c").replace("#1", filePath), detail);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    br = null;
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    bw = null;
                }
            }
        }
        return true;
    }

    public static boolean isUsing64SWTLib() {
        try {
            Class<?> cls = Class.forName("org.eclipse.swt.internal.Library");
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            Field filed = cls.getDeclaredField("IS_64");
            ReflectUtil.makeAccessible((Field)filed);
            return filed.getBoolean(object);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            return false;
        }
    }

    public static final String getAlertIEJS() {
        return ALERT_IE_VERSION_JS;
    }

    static {
        AND = (char)18;
        EQUAL = (char)19;
        SEPARATOR = (char)20;
        S_AND = new String(new byte[]{(byte)AND}, StandardCharsets.UTF_8);
        S_EQUAL = new String(new byte[]{(byte)EQUAL}, StandardCharsets.UTF_8);
        S_SEPARATOR = new String(new byte[]{(byte)SEPARATOR}, StandardCharsets.UTF_8);
        SIGN = "New ExtReport Log";
        ALERT_IE_VERSION_JS = "var sysObj = {};var browserInfo = navigator.userAgent.toLowerCase();var regular = /(msie|firefox|chrome|opera|version).*?([\\d.]+)/;var vsMsg = browserInfo.match(regular);sysObj.browserName = vsMsg[1].replace(/version/, \"'safari\");sysObj.versionInfo = vsMsg[2];if(sysObj.browserName === 'msie' && sysObj.versionInfo.substr(0,2) <= 8) {alert('" + CtrlEXTMessages.getMLS("ieVersionTooLow", "\u5f53\u524dIE\u6d4f\u89c8\u5668\u7248\u672c\u8fc7\u4f4e\u8bf7\u5347\u7ea7\u5230IE9\u4ee5\u4e0a\u7248\u672c\u83b7\u5f97\u66f4\u597d\u4f53\u9a8c\u3002") + "');}";
        SWT_KEYS = new String[]{"org/eclipse/swt/browser"};
    }
}

