/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class URLUtils {
    private static final Logger logger = LogUtil.getPackageLogger(URLUtils.class);

    public static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            logger.error((Object)"err", (Throwable)exception);
            return null;
        }
    }

    public static String encodeURL(String s) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            encodedString = URLEncoder.encode(s);
        }
        return encodedString.replaceAll("\\+", "%20");
    }

    public static String encodeBase64(String s) {
        return Base64.encode(s.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64(String s) {
        return Arrays.toString(Base64.decode(s));
    }

    public static String escapeXML(String s) {
        if (s != null && s.length() != 0) {
            StringBuilder sb = new StringBuilder((int)((double)s.length() * 1.1));
            block7: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        sb.append("&quot;");
                        continue block7;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
        return s;
    }
}

