/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util.formula;

import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.config.FormulaConfigUtils;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.config.Function;
import com.kingdee.cosmic.ctrl.ext.util.formula.SyntaxCheckResult;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.Parser;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FormulaUtils {
    private static Set<String> dateTimeFuncNames;
    private static Map<Long, String> syntaxErrMap;

    public static SyntaxCheckResult checkFormula(String formulaStr, Locale locale) {
        Sheet sheet = new Sheet(Book.Manager.getNewBook(), "MiniFunctionWizard");
        Sheet.ParserHelper formulaOwner = sheet.getParserHelper();
        Dependents deps = sheet.getDeps();
        Parser psr = deps.getParser();
        Object result = psr.parse(formulaOwner, formulaStr);
        SyntaxCheckResult checkResult = new SyntaxCheckResult();
        if (result instanceof Variant && ((Variant)result).isError()) {
            Exception ex = (Exception)((Variant)result).getValue();
            if (ex instanceof SyntaxErrorException) {
                SyntaxErrorException syntaxEx = (SyntaxErrorException)ex;
                checkResult.setErrorCode(syntaxEx.getErrorCode());
                String syntaxErrorMsg = FormulaUtils.getSyntaxErrorMsg(syntaxEx, locale);
                checkResult.setErrorMsg(syntaxErrorMsg);
                checkResult.setErrorPos(psr.getTokenPos());
            }
        } else {
            Variant executeValue = psr.getExpr().execute(deps.getExprContext(), formulaOwner);
            try {
                checkResult.setExecuteValue(executeValue.toDate());
            }
            catch (Exception e) {
                checkResult.setErrorCode(0x1000000L);
                checkResult.setErrorMsg(CtrlEXTMessages.getMLS("expressionResultNotDate", "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u7ed3\u679c\u4e0d\u662f\u4e00\u4e2a\u65e5\u671f\u7c7b\u578b"));
                checkResult.setErrorPos(0);
            }
        }
        return checkResult;
    }

    private static String getSyntaxErrorMsg(SyntaxErrorException syntaxEx, Locale locale) {
        String msgKey = syntaxErrMap.get(syntaxEx.getErrorCode());
        if (msgKey == null) {
            return syntaxEx.getMessage();
        }
        String result = KDExt.getLocalText(syntaxErrMap.get(syntaxEx.getErrorCode()), "", locale);
        StringBuilder sb = new StringBuilder();
        sb.append(result);
        if (syntaxEx.getErrorCode() != 8L && syntaxEx.getExtData() != null && !StringUtil.isEmptyString((String)syntaxEx.getExtData().toString())) {
            sb.append(' ');
            sb.append('\"');
            sb.append(syntaxEx.getExtData());
            sb.append('\"');
        }
        return sb.toString();
    }

    public static List<Function> getDateTimeFunction(Locale locale) {
        return FormulaConfigUtils.getFunction(locale, dateTimeFuncNames);
    }

    private static HashSet<String> createFuncNameSet(String[] funcNames) {
        if (funcNames == null || funcNames.length == 0) {
            return new HashSet<String>(1);
        }
        HashSet<String> funcNameSet = new HashSet<String>(funcNames.length);
        for (int i = 0; i < funcNames.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)funcNames[i])) continue;
            funcNameSet.add(funcNames[i]);
        }
        return funcNameSet;
    }

    static {
        String[] dateTimeFunc = new String[]{"NOW", "DATE", "DATETIME", "YEAR", "MONTH", "DAY", "FIRSTDAY", "LASTDAY", "NEXTDAY", "HOUR", "MINUTE", "SECOND"};
        dateTimeFuncNames = FormulaUtils.createFuncNameSet(dateTimeFunc);
        syntaxErrMap = new HashMap<Long, String>(16);
        syntaxErrMap.put(1L, "unknownSyntaxError");
        syntaxErrMap.put(2L, "divisionByZero");
        syntaxErrMap.put(4L, "valueOverflow");
        syntaxErrMap.put(8L, "mismatchParamCount");
        syntaxErrMap.put(16L, "mismatchParamType");
        syntaxErrMap.put(32L, "paramNeg");
        syntaxErrMap.put(64L, "badValue");
        syntaxErrMap.put(128L, "badFunction");
        syntaxErrMap.put(256L, "badSymbol");
        syntaxErrMap.put(512L, "badReference");
        syntaxErrMap.put(1024L, "tooMore");
        syntaxErrMap.put(2048L, "shouldBe");
        syntaxErrMap.put(4096L, "overEnd");
        syntaxErrMap.put(8192L, "noOperand");
        syntaxErrMap.put(16384L, "missing");
        syntaxErrMap.put(32768L, "circle");
        syntaxErrMap.put(65536L, "stackOverFlow");
        syntaxErrMap.put(131072L, "badID");
        syntaxErrMap.put(524288L, "invalidValue");
        syntaxErrMap.put(262144L, "badCellRef");
        syntaxErrMap.put(0x1000000L, "badDateValue");
    }
}

