/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util.manage.calculation;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.log.LogManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class ThreadDefine
implements Serializable {
    private static DateFormat format = DateFormat.getDateTimeInstance(1, 1);
    long id = 0L;
    boolean isLocal;
    String message;
    String userName = "";
    String reportName = "";
    String userIp = "";
    Date startTime;
    Date endTime;
    Date currentTime;
    transient StringBuilder sb;
    transient Thread calculatingThread;
    transient Dependents def;

    public ThreadDefine(Thread calculationThread, Dependents def) {
        this.def = def;
        this.calculatingThread = calculationThread;
        this.id = calculationThread.getId();
        this.isLocal = !LogManager.REMOTE_FOUND;
    }

    public long getCalculationId() {
        return this.id;
    }

    public void setThreadMessage(String message) {
        this.message = message;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getThreadMessage() {
        this.sb = new StringBuilder();
        String threadType = this.isLocal ? CtrlEXTMessages.getMLS("localGUICalculationThread", "\u672c\u5730GUI\u8ba1\u7b97\u7ebf\u7a0b") : CtrlEXTMessages.getMLS("serverCalculationThread", "\u670d\u52a1\u7aef\u8ba1\u7b97\u7ebf\u7a0b");
        String template = CtrlEXTMessages.getMLS("threadId", "%s\u8ba1\u7b97\u7ebf\u7a0bID:[%s]<br>") + CtrlEXTMessages.getMLS("threadInitiatorUser", "\u8ba1\u7b97\u7ebf\u7a0b\u53d1\u8d77\u7528\u6237:[%s]<br>") + CtrlEXTMessages.getMLS("threadInitiatorUserIP", "\u8ba1\u7b97\u7ebf\u7a0b\u53d1\u8d77\u7528\u6237IP\u5730\u5740:[%s]<br>") + CtrlEXTMessages.getMLS("reportName", "\u62a5\u8868\u540d\u79f0:[%s]<br>") + CtrlEXTMessages.getMLS("threadStartTime", "\u8ba1\u7b97\u7ebf\u7a0b\u5f00\u59cb\u65f6\u95f4:[%s]");
        this.sb.append(String.format(template, threadType, this.id, this.userName, this.userIp, this.reportName, format.format(this.startTime)));
        if (this.endTime != null) {
            this.sb.append("<br>");
            this.sb.append(CtrlEXTMessages.getMLS("threadEndTime", "\u8ba1\u7b97\u7ebf\u7a0b\u7ed3\u675f\u65f6\u95f4:"));
            this.sb.append("[").append(format.format(this.endTime)).append("].");
        } else {
            this.sb.append("<br>");
            this.sb.append(CtrlEXTMessages.getMLS("threadConsumedTime", "\u8ba1\u7b97\u7ebf\u7a0b\u5df2\u6d88\u8017\u65f6\u95f4:"));
            long elapseTime = new Date().getTime() - this.startTime.getTime();
            this.sb.append(CtrlEXTMessages.getMLS("milliseconds", "[#1(\u6beb\u79d2)].").replace("#1", String.valueOf(elapseTime)));
        }
        if (this.message != null) {
            this.sb.append("<br>");
            this.sb.append(CtrlEXTMessages.getMLS("threadInfo", "\u7ebf\u7a0b\u4fe1\u606f"));
            this.sb.append(":<br>");
            this.sb.append(this.message);
        }
        return this.sb.toString();
    }

    public void clear() {
        this.calculatingThread = null;
        this.def = null;
        this.sb = null;
    }

    public void interrupt() {
        if (this.def != null) {
            this.def.setUserInterrupted(true);
        }
    }

    public String toString() {
        this.sb = new StringBuilder();
        String template = CtrlEXTMessages.getMLS("threadIDReportName", "%s\u8ba1\u7b97\u7ebf\u7a0bID:[%s], \u62a5\u8868\u540d\u79f0:[%s]");
        this.sb.append(String.format(template, this.isLocal ? CtrlEXTMessages.getMLS("local", "\u672c\u5730") : CtrlEXTMessages.getMLS("remote", "\u8fdc\u7a0b"), this.id, this.reportName));
        return this.sb.toString();
    }

    public boolean equals(Object another) {
        if (!(another instanceof ThreadDefine)) {
            return false;
        }
        return this.calculatingThread == ((ThreadDefine)another).calculatingThread;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }
}

