/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util.manage.calculation.log;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.ThreadDefine;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.model.CalcThreadModel;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.model.CalculationChangedListener;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.server.CalcServer;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogManager {
    public static final boolean REMOTE_FOUND = System.getProperty("EAS_SERVER") == null;
    public static final CalcThreadModel model = new CalcThreadModel();
    private static CalcServer server;
    private static Logger logger;

    public static synchronized void startServer() {
        try {
            if (REMOTE_FOUND && (server == null || server.isClosed())) {
                server = new CalcServer(63333);
                Thread serverThread = new Thread(CtrlEXTMessages.getMLS("extReportCalculationThreadMonitoring", "Ext \u62a5\u8868\u8ba1\u7b97\u7ebf\u7a0b\u76d1\u63a7")){

                    @Override
                    public void run() {
                        while (server != null && !server.isClosed()) {
                            try {
                                Socket c = server.accept();
                                model.addRemoteListener(c);
                                model.fireChange(c);
                            }
                            catch (IOException ex) {
                                logger.log(Priority.ERROR, (Object)CtrlEXTMessages.getMLS("clientRegistrationFailed", "\u5ba2\u6237\u7aef\u6ce8\u518c\u5931\u8d25"));
                            }
                        }
                    }
                };
                serverThread.setDaemon(true);
                serverThread.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void logEnQueue(String userIp, String userName, String reportName, Dependents def) {
        Thread current = Thread.currentThread();
        ThreadDefine td = new ThreadDefine(current, def);
        td.setUserIp(userIp);
        td.setUserName(userName);
        td.setReportName(reportName);
        td.setStartTime(new Date());
        model.addCalculatingThread(td);
    }

    public static synchronized void logDeQueue(String userIp, String userName, String reportName, Dependents def) {
        Thread current = Thread.currentThread();
        ThreadDefine td = new ThreadDefine(current, def);
        td.setUserIp(userIp);
        td.setUserName(userName);
        td.setReportName(reportName);
        model.addCalculatedThread(td);
    }

    public static synchronized void logDeQueueInterrupted(String userIp, String userName, String reportName, Dependents def) {
        Thread current = Thread.currentThread();
        ThreadDefine td = new ThreadDefine(current, def);
        td.setThreadMessage(CtrlEXTMessages.getMLS("reportCalculationExceptionExit", "\u62a5\u8868\u8ba1\u7b97\u5f02\u5e38\u9000\u51fa"));
        td.setUserIp(userIp);
        td.setUserName(userName);
        td.setReportName(reportName);
        model.addInterruptedThread(td);
    }

    public static void addLocalListener(CalculationChangedListener listener) {
        model.addLocalListener(listener);
        model.fireChange();
    }

    public static void removeLocalListener(CalculationChangedListener listener) {
        model.removeLocalListener(listener);
    }

    public static void removeRemoteListener(Socket client) {
        model.removeRemoteListener(client);
    }

    public static void stopServer() {
        try {
            if (server != null && !server.isClosed()) {
                server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void interruptedThread(ThreadDefine t) {
        model.interruptedThread(t);
    }

    static {
        logger = Logger.getLogger(LogManager.class);
    }
}

