/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util.manage.calculation.server;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.ThreadDefine;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.log.LogManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class ClientWatcher
extends Thread {
    private static Logger logger = Logger.getLogger(ClientWatcher.class);
    private static int clientCount = 1;
    Socket client;

    ClientWatcher(Socket s) {
        super(CtrlEXTMessages.getMLS("clientThreadMonitoring", "\u5ba2\u6237\u7aef\u7ebf\u7a0b\u76d1\u63a7:") + clientCount++);
        this.client = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.client != null && this.client.isConnected() && !this.client.isClosed()) {
                ObjectInputStream in = new ObjectInputStream(this.client.getInputStream());
                Object command = in.readObject();
                if (command instanceof ThreadDefine) {
                    ThreadDefine t = (ThreadDefine)command;
                    LogManager.interruptedThread(t);
                    ObjectOutputStream out = new ObjectOutputStream(this.client.getOutputStream());
                    out.writeObject("interrupted");
                    out.flush();
                    continue;
                }
                if (!"close".equals(command)) continue;
                this.client.close();
                this.client = null;
            }
        }
        catch (IOException e) {
            logger.log(Priority.ERROR, (Object)CtrlEXTMessages.getMLS("readClientCommandFailed", "\u8bfb\u53d6\u5ba2\u6237\u7aef\u547d\u4ee4\u5931\u8d25"));
            logger.log(Priority.ERROR, (Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Priority.ERROR, (Object)CtrlEXTMessages.getMLS("readClientCommandFailed", "\u8bfb\u53d6\u5ba2\u6237\u7aef\u547d\u4ee4\u5931\u8d25"));
            logger.log(Priority.ERROR, (Object)e);
        }
        finally {
            LogManager.removeRemoteListener(this.client);
        }
    }
}

