/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.core;

import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.core.OutlineGroupColHeaderUI;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import java.awt.Point;

public final class OutlineGroupColHeader
extends SpreadView {
    private int armedColId = -1;

    public OutlineGroupColHeader(KDSpread spread) {
        this._spread = spread;
        this.updateUI();
    }

    @Override
    public void setLocation(int x, int y) {
        x = -x;
        y = -y;
        Point point = new Point(x, y);
        int col = SheetBaseMath.colAtPoint(this.getSpread().getBook().getActiveSheet(), point);
        if (col < 0) {
            col = 0;
        }
        x = SheetBaseMath.getColX(this.getSpread().getBook().getActiveSheet(), col);
        x = -x;
        y = -y;
        super.setLocation(x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(OutlineGroupColHeaderUI.createUI(this));
    }

    @Override
    public int getViewType() {
        return 4;
    }

    @Override
    public void scrollCellVisible(int row, int col) {
        if (this.getAutoscrolls()) {
            int newC;
            SpreadView view = OutlineGroupColHeader.scrollerDispatchCol(this, col);
            if (view != this) {
                view.scrollCellVisible(0, col);
            }
            if ((newC = this.calcFirstColByVisibleCol(col)) != this.getFirstCol()) {
                this.getSpread().setViewCol(this, newC);
            }
        }
    }

    public int getArmedColId() {
        return this.armedColId;
    }

    public void setArmedColId(int armedColId) {
        this.armedColId = armedColId;
        this.repaint();
    }
}

