/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.core;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.ISheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetProxy;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.collection.CellBlockDestMap;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.cosmic.ctrl.swing.KDBusiMaskField;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDColorChooser;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.layout.GroupLayout;

public final class TabbedBar
extends JComponent {
    private static final long serialVersionUID = 6956065887976060693L;
    public static final byte NORMAL = 0;
    public static final byte KEEP = 1;
    public static final byte FORBIDDEN = 2;
    public static final String KEY_CANNOT_DELETE_ALL_VISIBLE_SHEETS = "cannotDeleteAllVisibleSheets";
    public static final String KEY_DELETE_CONFIRM = "deleteConfirm";
    private static final String KEY_SHEET_NAME_CANNOT_BE_EMPTY = "sheetNameCannotBeEmpty";
    private static final String KEY_SHEET_NAME_CONFLICT = "sheetNameConflict";
    private static final String KEY_INVALID_CHARACTER_IN_SHEET_NAME = "invalidCharacterInSheetName";
    public static final String KEY_INSERT = "insert";
    public static final String KEY_DELETE = "delete";
    public static final String KEY_RENAME = "rename";
    public static final String Key_Sheet_MoveAndCopy = "moveOrCopySheet";
    public static final String Key_Sheet_MultiSelect = "multiSelectSheets";
    public static final String Key_Sheet_SelectAll = "selectAllSheets";
    public static final String Key_Sheet_SetTabColor = "sheetTabColor";
    private static final String KEY_MOVE_LAST = "moveLast";
    private static final String KEY_MOVE_PROMPT1 = "moveSelectedSheetTo";
    private static final String KEY_MOVE_PROMPT2 = "beforeSelectedSheets";
    private static final String KEY_OK = "ok";
    private static final String KEY_ALL_SELECTED = "allSelected";
    private static final String KEY_ALL_CLEARED = "allCleared";
    private static final String KEY_CANCEL = "cancel";
    private static final String KEY_CREATE_COPY = "createCopy";
    public static final String KEY_ACTIVE_DOCUMENT = "activeDocument";
    public static final String KEY_OTHER_SHEETS = "otherSheets";
    private static final int FIRST = 0;
    private static final int PREVIOUS = 1;
    private static final int NEXT = 2;
    private static final int LAST = 3;
    private static final Style InfoStyle;
    private byte _tabbedBarSelMode;
    private int _tabbedBarKeepIndex = -1;
    private int tabMaxCharsCount = 31;
    private String tabInvalidCharacters = ":/?\\*[]!\uff1a\uff1f\u3010\u3011\uff01";
    private KDSpread _spread;
    private MouseHandler _mouseHandler;
    private KDBusiMaskField _editField;
    private Color _borderColor;
    private int _barHeight;
    private int _tabSpaceWidth;
    private int _fontAscent;
    private int _leftBorderWidth = 1;
    private int _startIndex = 0;
    private int _editIndex = -1;
    private ITabbedBarPopupProvider _provider;
    private WizzardSheetMoveAndCopy _dgMoveAndCopy;
    private WizzardSheetMultiSelect _multiSelect;
    private WizzardOtherSheets _dgOtherSheets;
    private KDPopupMenu _arrowPopup;
    private static final int INSERT_CODE = -2;
    private static final int INSERT_WIDTH = 25;

    public TabbedBar(KDSpread spread) {
        this._spread = spread;
        this._borderColor = new Color(128, 128, 128);
        this.setFont(new Font(CtrlEXTMessages.getMLS("font", "\u5fae\u8f6f\u96c5\u9ed1"), 0, 13));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int _fontHeight = fm.getHeight();
        this._fontAscent = fm.getAscent() - 1;
        this._barHeight = _fontHeight + 1;
        this._tabSpaceWidth = this._barHeight / 2 + 1;
        this.setPreferredSize(new Dimension(2000, this._barHeight));
        this._mouseHandler = new MouseHandler();
        this.addMouseListener(this._mouseHandler);
        this.addMouseMotionListener(this._mouseHandler);
    }

    public void setSelectMode(byte mode) {
        this._tabbedBarSelMode = mode;
    }

    public byte getSelectMode() {
        return this._tabbedBarSelMode;
    }

    public int getKeepIndex() {
        return this._tabbedBarKeepIndex;
    }

    public void setKeepIndex(int index) {
        this._tabbedBarKeepIndex = index;
    }

    public void setMaxTabCharsCount(int count) {
        this.tabMaxCharsCount = count;
    }

    public int getMaxTabCharsCount() {
        return this.tabMaxCharsCount;
    }

    public String getTabInvalidCharacters() {
        return this.tabInvalidCharacters;
    }

    public void settabInvalidCharacters(String invalidChars) {
        this.tabInvalidCharacters = invalidChars;
    }

    public void select(int index) {
        byte selMode = this.getSelectMode();
        if (selMode == 2) {
            return;
        }
        if (selMode != 1) {
            int actIndex;
            Book book = this._spread.getBook();
            ISheet sheet = book.getISheet(actIndex = book.visibleIndexToIndex(index));
            if (!sheet.isSelected()) {
                for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                    book.getISheet(i).setSelected(false);
                }
                book.activeSheet(actIndex);
            } else if (book.getActiveSheetIndex() != actIndex) {
                if (book.isAllSheetSelected()) {
                    for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                        book.getISheet(i).setSelected(false);
                    }
                }
                book.activeSheet(actIndex);
            }
        }
        this.setStartIndex(this.calcStartIndex(index));
    }

    public void select(String title) {
        if (StringUtil.isEmptyString((String)title)) {
            return;
        }
        Book book = this._spread.getBook();
        this.select(book.indexToVisibleIndex(this.getIndexByTitle(title)));
    }

    public void showTabColorWizzard() {
        Color initColor = this.getBackgroundAt(this.getActivedIndex());
        final KDColorChooser colorChooser = new KDColorChooser(initColor);
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = colorChooser.getColor();
                TabbedBar.this.setBackgroundAt(TabbedBar.this.getActivedIndex(), color);
            }
        };
        JDialog dialog = JColorChooser.createDialog(this, TabbedBar.getLocalText(Key_Sheet_SetTabColor), true, (JColorChooser)colorChooser, okListener, null);
        dialog.setDefaultCloseOperation(2);
        int sx = this.getTabStartX(this.getActivedIndex());
        Point p = this.getLocationOnScreen();
        p.x += sx;
        CtrlSwingUtilities.locateWindowToComponent((Window)dialog, (Point)p, (Component)this, (int)1);
        dialog.setVisible(true);
        dialog.dispose();
        dialog = null;
    }

    public void selectAllSheets() {
        Book book = this._spread.getBook();
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            ISheet sheet = book.getISheet(i);
            if (sheet.isHide() || sheet.isSelected()) continue;
            sheet.setSelected(true);
        }
        this.repaint();
    }

    public void showMoveAndCopySheetWizzard() {
        if (this._dgMoveAndCopy == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this._dgMoveAndCopy = window instanceof Frame ? new WizzardSheetMoveAndCopy((Frame)window) : new WizzardSheetMoveAndCopy((Dialog)window);
        }
        Point p = this.getLocationOnScreen();
        int sx = this.getTabStartX(this.getActivedIndex());
        p.x += sx;
        CtrlSwingUtilities.locateWindowToComponent((Window)((Object)this._dgMoveAndCopy), (Point)p, (Component)this, (int)1);
        this._dgMoveAndCopy.setVisible(true);
    }

    public void showMultiSelectSheetWizzard() {
        if (this._multiSelect == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this._multiSelect = window instanceof Frame ? new WizzardSheetMultiSelect((Frame)window) : new WizzardSheetMultiSelect((Dialog)window);
        }
        Point p = this.getLocationOnScreen();
        int sx = this.getTabStartX(this.getActivedIndex());
        p.x += sx;
        CtrlSwingUtilities.locateWindowToComponent((Window)((Object)this._multiSelect), (Point)p, (Component)this, (int)1);
        this._multiSelect.setVisible(true);
    }

    public void showOtherSheetsWizzard() {
        if (this._dgOtherSheets == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this._dgOtherSheets = window instanceof Frame ? new WizzardOtherSheets((Frame)window) : new WizzardOtherSheets((Dialog)window);
        }
        Point p = this.getLocationOnScreen();
        int sx = this.getTabStartX(this.getActivedIndex());
        p.x += sx;
        CtrlSwingUtilities.locateWindowToComponent((Window)((Object)this._dgOtherSheets), (Point)p, (Component)this, (int)1);
        this._dgOtherSheets.setVisible(true);
    }

    public void insertSheets() {
        Book book = this._spread.getBook();
        int insCount = 0;
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            if (!book.getISheet(i).isSelected()) continue;
            book.getISheet(i).setSelected(false);
            ++insCount;
        }
        book.startGroup();
        int avIndex = book.getActiveSheetIndex();
        for (int i = 0; i < insCount; ++i) {
            book.insertSheet(avIndex, null);
        }
        book.endGroup();
    }

    public void insertSheetAtLast() {
        Book book = this._spread.getBook();
        int sheetCount = book.getSheetCount();
        for (int i = sheetCount - 1; i >= 0; --i) {
            if (!book.getISheet(i).isSelected()) continue;
            book.getISheet(i).setSelected(false);
        }
        book.insertSheet(sheetCount, null);
    }

    public void removeSheets() {
        boolean value;
        int i;
        Book book = this._spread.getBook();
        if (book.isAllSheetSelected()) {
            this.showErrorDialog(TabbedBar.getLocalText(KEY_CANNOT_DELETE_ALL_VISIBLE_SHEETS));
            return;
        }
        boolean needConfirm = false;
        for (i = book.getSheetCount() - 1; i >= 0; --i) {
            ISheet sheet = book.getISheet(i);
            if (!sheet.isSelected() || !sheet.hasData()) continue;
            needConfirm = true;
            break;
        }
        if (needConfirm && !(value = MessageUtil.msgboxOkCancel(SwingUtilities.getWindowAncestor(this), TabbedBar.getLocalText(KEY_DELETE_CONFIRM)))) {
            return;
        }
        book.startGroup();
        for (i = book.getSheetCount() - 1; i >= 0; --i) {
            if (!book.getISheet(i).isSelected()) continue;
            book.removeSheet(i, false);
        }
        book.endGroup();
    }

    public void startEditing() {
        Book book = this._spread.getBook();
        int index = book.indexToVisibleIndex(book.getActiveSheetIndex());
        this.startEditing(index);
    }

    public boolean stopEditing() {
        if (this._editIndex < 0) {
            return true;
        }
        KDBusiMaskField editor = this.getEditor();
        String title = editor.getText();
        if ("".equals(title)) {
            this.showErrorDialog(TabbedBar.getLocalText(KEY_SHEET_NAME_CANNOT_BE_EMPTY));
            editor.grabFocus();
            editor.selectAll();
            return false;
        }
        Sheet.ReturnCode rc = this.setTitleAt(this.getActivedIndex(), title);
        if (rc == Sheet.DuplicateName) {
            this.showErrorDialog(TabbedBar.getLocalText(KEY_SHEET_NAME_CONFLICT));
            editor.requestFocus();
            editor.selectAll();
            return false;
        }
        if (rc == Sheet.InvalidName) {
            this.showErrorDialog(TabbedBar.getLocalText(KEY_INVALID_CHARACTER_IN_SHEET_NAME));
            editor.requestFocus();
            editor.selectAll();
            return false;
        }
        editor.setVisible(false);
        this._editIndex = -1;
        return true;
    }

    public void setPopupMenuProvider(ITabbedBarPopupProvider provider) {
        this._provider = provider;
    }

    void syncSheetList() {
        if (this._arrowPopup != null) {
            this._arrowPopup.removeAll();
            Book book = this._spread.getBook();
            int count = book.getVisibleSheetCount();
            int vCount = Math.min(count, 15);
            for (int i = 0; i < vCount; ++i) {
                this._arrowPopup.add((Action)new GotoAction(book.getVisibleISheet(i).getSheetName()));
            }
            if (count > 15) {
                this._arrowPopup.add((Action)new OtherSheetsAction(TabbedBar.getLocalText(KEY_OTHER_SHEETS)));
            }
        }
    }

    void syncSheetActive() {
        if (this.getActivedIndex() < this._startIndex) {
            this.setStartIndex(this.getActivedIndex());
        }
    }

    private void selectTo(int index) {
        int min;
        if (this.getSelectMode() != 0) {
            return;
        }
        Book book = this._spread.getBook();
        int actIndex = book.visibleIndexToIndex(index);
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            book.getISheet(i).setSelected(false);
        }
        int max = Math.max(actIndex, book.getActiveSheetIndex());
        for (int i = min = Math.min(actIndex, book.getActiveSheetIndex()); i <= max; ++i) {
            ISheet sheet = book.getISheet(i);
            if (sheet.isHide()) continue;
            sheet.setSelected(true);
        }
        if (max > min) {
            book.getActiveSheet().getSheetOption().getSelection().syncAllSelected();
        }
        this.setStartIndex(this.calcStartIndex(index));
    }

    private void selectWith(int index) {
        int actIndex;
        if (this.getSelectMode() != 0) {
            return;
        }
        Book book = this._spread.getBook();
        ISheet sheet = book.getISheet(actIndex = book.visibleIndexToIndex(index));
        if (!sheet.isSelected()) {
            sheet.setSelected(true);
            book.getActiveSheet().getSheetOption().getSelection().syncAllSelected();
        } else if (book.getActiveSheetIndex() != actIndex) {
            sheet.setSelected(false);
        }
        this.setStartIndex(this.calcStartIndex(index));
    }

    private boolean canShowArrowPop() {
        return this.getSelectMode() != 2;
    }

    private boolean canShowTabPop() {
        return !this.isProtected() && this.getSelectMode() == 0;
    }

    private boolean canPressArrow() {
        return true;
    }

    private boolean canEditTab() {
        return !this.isProtected() && this.getSelectMode() == 0;
    }

    private boolean isProtected() {
        Book book = this._spread.getBook();
        return !book.getProtection().allowOperatorStruct();
    }

    private int getTabCount() {
        Book book = this._spread.getBook();
        return book.getVisibleSheetCount();
    }

    private int getTabWidth(int index) {
        Rectangle2D rect = this.getFontMetrics(this.getFont()).getStringBounds(this.getTitleAt(index), this.getGraphics());
        int width = (int)rect.getWidth() + 4;
        return width;
    }

    private Color getBackgroundAt(int index) {
        Book book = this._spread.getBook();
        Color color = book.getVisibleISheet(index).getTabColor();
        return color == null ? this.getBackground() : color;
    }

    private boolean setBackgroundAt(int index, Color color) {
        Book book = this._spread.getBook();
        book.getVisibleISheet(index).setTabColor(color);
        return true;
    }

    private boolean hasBackgroundAt(int index) {
        Book book = this._spread.getBook();
        return book.getVisibleISheet(index).getTabColor() != null;
    }

    private String getTitleAt(int index) {
        Book book = this._spread.getBook();
        return book.getVisibleISheet(index).getSheetName();
    }

    private boolean isSheetInfo(int index) {
        Book book = this._spread.getBook();
        return book.getVisibleISheet(index) instanceof SheetProxy;
    }

    private Sheet.ReturnCode setTitleAt(int editIndex, String newName) {
        Book book = this._spread.getBook();
        Sheet sheet = book.getVisibleSheet(editIndex);
        Sheet.ReturnCode rc = sheet.setName(newName);
        if (rc == Sheet.Ok) {
            this.repaint();
        }
        return rc;
    }

    private int getActivedIndex() {
        Book book = this._spread.getBook();
        return book.indexToVisibleIndex(book.getActiveSheetIndex());
    }

    private boolean isSelected(int index) {
        Book book = this._spread.getBook();
        return book.getVisibleISheet(index).isSelected();
    }

    private void moveSheetsTo(int visibleIndex) {
        int i;
        int i2;
        Book book = this._spread.getBook();
        if (visibleIndex == book.indexToVisibleIndex(book.getActiveSheetIndex())) {
            return;
        }
        ISheet sheet = book.getVisibleISheet(visibleIndex);
        int insertPos = book.getSheetCount();
        if (sheet != null) {
            insertPos = book.getSheetIndexByName(sheet.getSheetName());
        }
        boolean isSkip = book.isSkipListeners();
        book.setSkipListeners(true);
        int sheetCount = book.getSheetCount();
        int oriInsertPos = insertPos;
        ObjectArray sheetsClone = new ObjectArray(sheetCount);
        sheetsClone.appendAll(book.getSheets());
        Span spChange = new Span(-1, -1);
        Span sp = new Span(0, 0);
        ObjectArray selectedSheets = new ObjectArray();
        for (i2 = sheetCount - 1; i2 >= 0; --i2) {
            Sheet sh = (Sheet)sheetsClone.getAt(i2);
            if (!sh.isSelected()) continue;
            selectedSheets.append(sh);
            if (spChange.getEnd() < 0) {
                spChange.setPos(i2, i2);
            } else {
                spChange.setStart(i2);
            }
            sheetsClone.removeByPos(i2);
            if (i2 >= insertPos) continue;
            --insertPos;
        }
        int size = selectedSheets.size();
        for (i2 = 0; i2 < size; ++i2) {
            sheetsClone.insert(insertPos, selectedSheets.get(i2));
        }
        ObjectArray blocks = new ObjectArray();
        CellBlockDestMap deps3D = book.get3DBlockDeps();
        Iterator ii = deps3D.iterator();
        while (ii.hasNext()) {
            CellBlock3DNode cb = (CellBlock3DNode)ii.next();
            sp.setPos(cb.getSheet().getIndex(), cb.getSheet2().getIndex());
            if (!sp.isIntersect(spChange) && !sp.contains(oriInsertPos)) continue;
            cb.queue();
            blocks.append(cb);
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            deps3D.removeBlock((CellBlock3DNode)blocks.get(i));
        }
        book.getSheets().clear();
        book.getSheets().appendAll(sheetsClone);
        book.updateSheetIndex();
        for (i = blocks.size() - 1; i >= 0; --i) {
            CellBlock3DNode cb = (CellBlock3DNode)blocks.get(i);
            Sheet sh = cb.getSheet();
            if (sh.getIndex() > cb.getSheet2().getIndex()) {
                cb.setSheet2(sh);
            }
            deps3D.insertBlock(cb);
        }
        if (book.isAutoCalculate()) {
            book.calcQueue();
        }
        book.setSkipListeners(isSkip);
        book.setActiveSheet(insertPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySheetsTo(int visibleIndex) {
        Book book = this._spread.getBook();
        ArrayList<Sheet> srcSheets = new ArrayList<Sheet>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ISheet sh = book.getISheet(i);
            if (!sh.isSelected()) continue;
            sh.setSelected(false);
            srcSheets.add(book.getSheet(i));
        }
        ISheet sheet = book.getVisibleISheet(visibleIndex);
        int index = book.getSheetCount();
        if (sheet != null) {
            index = book.getSheetIndexByName(sheet.getSheetName());
        }
        Window window = SwingUtilities.getWindowAncestor(this._spread);
        IExtCallback extCallback = null;
        if (window instanceof KDExt) {
            extCallback = ((KDExt)((Object)window)).getExtCallback();
        }
        try {
            KDExt.threadExtCallback.set(extCallback);
            book.startGroup();
            for (int i = srcSheets.size() - 1; i >= 0; --i) {
                Sheet srcSheet = (Sheet)srcSheets.get(i);
                Sheet copySheet = new Sheet(book, book.getNewSheetName(srcSheet.getSheetName(), true));
                copySheet.copySheetFrom(srcSheet);
                book.insertSheet(index, copySheet);
            }
            book.endGroup();
        }
        finally {
            KDExt.threadExtCallback.remove();
        }
    }

    public static String getLocalText(String key) {
        return CtrlEXTMessages.getMLS(key, "NotFound");
    }

    private int getIndexByTitle(String title) {
        Book book = this._spread.getBook();
        return book.getSheetIndexByName(title);
    }

    private int getTabStartX(int index, int startIndex) {
        int startX = this.getArrowWidth() * 4 + this._leftBorderWidth - 1;
        int tabCount = this.getTabCount();
        for (int tabIndex = startIndex; tabIndex < tabCount; ++tabIndex) {
            startX += this._tabSpaceWidth;
            if (tabIndex == index) break;
            startX += this.getTabWidth(tabIndex);
        }
        return startX;
    }

    private int getTabStartX(int index) {
        return this.getTabStartX(index, this._startIndex);
    }

    private int getArrowWidth() {
        return this._barHeight - 1;
    }

    private KDPopupMenu getArrowPopupMenu() {
        if (this._arrowPopup == null) {
            this._arrowPopup = new KDPopupMenu();
            this.syncSheetList();
        }
        return this._arrowPopup;
    }

    private void startEditing(int index) {
        this._editIndex = index;
        this.getEditor().setText(this.getTitleAt(index));
        int x = this.getTabStartX(index);
        int width = this.getTabWidth(index);
        this.getEditor().setBounds(x, 0, width + 1, this._barHeight - 1);
        this.getEditor().setVisible(true);
        this.getEditor().grabFocus();
        this.getEditor().selectAll();
    }

    private int direction(int x, int type) {
        int rs = x;
        if (type != 0) {
            rs = this._tabSpaceWidth - 1 - x;
        }
        return rs;
    }

    private void showErrorDialog(String message) {
        MessageUtil.msgboxWarning(SwingUtilities.getWindowAncestor(this), message);
    }

    private void setStartIndex(int index) {
        int size = this.getTabCount();
        if (index < 0 || index >= size) {
            return;
        }
        if (index > this._startIndex) {
            int barWidth = this.getWidth();
            if (this.getWidth() >= this.getActiveWidth()) {
                return;
            }
            if (index == size - 1) {
                for (int i = size - 1; i >= this._startIndex; --i) {
                    int width = this.getActiveWidth(i);
                    if (barWidth >= width) continue;
                    this._startIndex = i < size - 1 ? i + 1 : size - 1;
                    return;
                }
            }
        }
        this._startIndex = index;
        this.repaint();
    }

    private int getActiveWidth() {
        return this.getActiveWidth(this._startIndex);
    }

    private int getActiveWidth(int startIndex) {
        int lastTab = this.getTabCount() - 1;
        int length = this.getTabStartX(lastTab, startIndex);
        int tabWidth = this.getTabWidth(lastTab);
        int currentWidth = length + tabWidth + this._tabSpaceWidth;
        return currentWidth;
    }

    private KDBusiMaskField getEditor() {
        if (this._editField == null) {
            this._editField = new KDBusiMaskField();
            this._editField.setOpaque(true);
            this._editField.setBorder(null);
            this._editField.setFont(this.getFont());
            this._editField.setDigit(false);
            this._editField.setLetter(false);
            this._editField.setCharsCount(this.getMaxTabCharsCount());
            this._editField.setInvalidCharacters(this.getTabInvalidCharacters());
            this._editField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedBar.this.stopEditing();
                }
            });
            this._editField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), KEY_RENAME);
            this._editField.getActionMap().put(KEY_RENAME, new AbstractAction(){
                private static final long serialVersionUID = -479387146255652337L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TabbedBar.this._editIndex >= 0) {
                        TabbedBar.this.getEditor().setVisible(false);
                        TabbedBar.this._editIndex = -1;
                        TabbedBar.this._spread.requestFocus();
                    }
                }
            });
        }
        this.add((Component)this._editField);
        return this._editField;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Color oldColor = g.getColor();
        g.setColor(this._borderColor);
        g.drawLine(0, 0, this.getWidth() - this._leftBorderWidth, 0);
        g.setColor(oldColor);
        g.translate(this._leftBorderWidth, 1);
        this.paintArrowArea(g);
        g.translate(-this._leftBorderWidth, -1);
        int x = this.getArrowWidth() * 4 + this._leftBorderWidth;
        int y = 0;
        g.translate(x, y);
        this.paintTabArea(g);
        g.translate(-x, -y);
    }

    private int calcStartIndex(int endIndex) {
        int i;
        if (endIndex < this._startIndex) {
            return endIndex;
        }
        int w = this.getVisibleRect().width;
        int cuwX = this.getTabStartX(endIndex) + this.getTabWidth(endIndex);
        if (cuwX < (w -= this.getArrowWidth() * 4 + this._leftBorderWidth)) {
            return this._startIndex;
        }
        for (i = endIndex; i >= 0 && (w -= this.getTabWidth(i) + this._tabSpaceWidth) > 5; --i) {
        }
        if (++i > this.getTabCount() - 1) {
            i = this.getTabCount() - 1;
        }
        return Math.max(0, i);
    }

    private void paintTabArea(Graphics g) {
        int tabCount = this.getTabCount();
        int x = 0;
        int y = 0;
        g.setFont(this.getFont());
        for (int tabIndex = this._startIndex; tabIndex < tabCount; ++tabIndex) {
            if (tabIndex == this._startIndex) {
                this.paintTabSplit(g, x, y, tabIndex, true);
                x += this._tabSpaceWidth;
            }
            this.paintOneTab(g, x, y, tabIndex);
            int tabWidth = this.getTabWidth(tabIndex);
            this.paintTabSplit(g, x += tabWidth, y, tabIndex, false);
            x += this._tabSpaceWidth;
        }
        if (this._spread.getBook().getUserObjectValue("EXT_EXECUTED") == null) {
            this.paintInsertSplit(g, x - 10, y, true);
            this.paintInsertTab(g, x, y);
            this.paintInsertSplit(g, x + 25, y, false);
        }
    }

    private void paintInsertSplit(Graphics g, int x, int y, boolean isFirst) {
        g.translate(x, y);
        g.setColor(Color.BLACK);
        if (isFirst) {
            g.drawLine(5, 10, this.direction(this._tabSpaceWidth - 2, 0), this._barHeight - 1);
        } else {
            g.drawLine(this.direction(0, 1), 1, this.direction(this._tabSpaceWidth - 2, 1), this._barHeight - 1);
        }
        g.translate(-x, -y);
    }

    private void paintInsertTab(Graphics g, int x, int y) {
        g.setColor(Color.black);
        g.drawString("+", x + 10, this._fontAscent + 1);
        g.setColor(this._borderColor);
        g.drawLine(x - 1, this._barHeight - 1, x + 25, this._barHeight - 1);
    }

    private void paintTabSplit(Graphics g, int x, int y, int tabIndex, boolean isFirst) {
        int tabCount = this.getTabCount();
        boolean isSelect = this.isSelected(tabIndex);
        boolean isNextSelect = tabIndex == this.getActivedIndex() - 1;
        Color oldColor = g.getColor();
        g.translate(x, y);
        if (isFirst) {
            this.fillWithLines(g, tabIndex, Color.WHITE, 0);
            if (this._mouseHandler._dragIndex == tabIndex) {
                this.paintTriangle2(g, this._tabSpaceWidth / 2 + 1, this._barHeight / 2, 1, Color.BLACK, 9);
            }
        } else if (tabIndex >= this._startIndex && tabIndex < tabCount - 1 && isNextSelect) {
            this.fillWithLines(g, tabIndex, this._borderColor, 1);
            this.fillWithLines(g, tabIndex + 1, Color.WHITE, 0);
            if (this._mouseHandler._dragIndex == tabIndex + 1) {
                this.paintTriangle2(g, 0, this._barHeight / 2, 2, Color.BLACK, 9);
                this.paintTriangle2(g, this._tabSpaceWidth / 2 + 1, this._barHeight / 2, 1, Color.BLACK, 9);
            }
        } else if (tabIndex >= this._startIndex && tabIndex < tabCount - 1 && !isNextSelect) {
            if (isSelect) {
                this.fillWithLines(g, tabIndex + 1, Color.WHITE, 0);
                this.fillWithLines(g, tabIndex, this._borderColor, 1);
            } else if (!isNextSelect) {
                this.fillWithLines(g, tabIndex + 1, Color.WHITE, 0);
                this.fillWithLines(g, tabIndex, this._borderColor, 1);
            }
            if (this._mouseHandler._dragIndex == tabIndex + 1) {
                this.paintTriangle2(g, 0, this._barHeight / 2, 2, Color.BLACK, 9);
                this.paintTriangle2(g, this._tabSpaceWidth / 2 + 1, this._barHeight / 2, 1, Color.BLACK, 9);
            }
        } else if (tabIndex == tabCount - 1) {
            this.fillWithLines(g, tabIndex, this._borderColor, 1);
        }
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    private void paintArrowArea(Graphics g) {
        int x1 = 0;
        int y1 = 0;
        Color oldColor = g.getColor();
        int x2 = this.getArrowWidth() - 1;
        for (int i = 0; i < 4; ++i) {
            if (i == this._mouseHandler._moveArrawIndex || i == this._mouseHandler._pressArrowIndex) {
                if (i == this._mouseHandler._moveArrawIndex) {
                    g.setColor(new Color(182, 189, 210));
                    g.fillRect(x1, y1, x2, x2);
                } else {
                    g.setColor(new Color(133, 146, 181));
                    g.fillRect(x1, y1, x2, x2);
                }
                g.setColor(new Color(10, 36, 106));
                g.drawRect(x1, y1, x2, x2);
            } else if (i == 3) {
                g.setColor(this._borderColor);
                g.drawLine(x1 + x2, y1, x1 + x2, x2);
            }
            this.paintTriangle(g, x1, y1, i, Color.black, this.getArrowWidth());
            x1 += this.getArrowWidth();
        }
        g.setColor(oldColor);
    }

    private void fillWithLines(Graphics g, int tabIndex, Color secondLineColor, int type) {
        boolean isSelect = this.isSelected(tabIndex);
        g.setColor(Color.BLACK);
        g.drawLine(this.direction(0, type), 1, this.direction(this._tabSpaceWidth - 2, type), this._barHeight - 1);
        g.setColor(secondLineColor);
        g.drawLine(this.direction(1, type), 1, this.direction(this._tabSpaceWidth - 1, type), this._barHeight - 1);
        Color tabColor = this.getBackgroundAt(tabIndex);
        if (!isSelect) {
            g.setColor(this._borderColor);
            g.drawLine(0, 0, this._tabSpaceWidth - 1, 0);
            g.setColor(tabColor);
            for (int i = 2; i <= this._tabSpaceWidth; ++i) {
                g.drawLine(this.direction(i, type), 1, this.direction(this._tabSpaceWidth - 1, type), this._barHeight - i);
            }
        } else {
            if (tabIndex == this.getActivedIndex()) {
                g.setColor(Color.white);
            } else {
                g.setColor(this._borderColor);
            }
            g.drawLine(0, 0, this._tabSpaceWidth - 1, 0);
            g.setColor(Color.white);
            for (int i = 1; i <= this._tabSpaceWidth; ++i) {
                g.drawLine(this.direction(i, type), 1, this.direction(this._tabSpaceWidth - 1, type), this._barHeight - i);
            }
        }
        g.setColor(this._borderColor);
        g.drawLine(this.direction(this._tabSpaceWidth - 1, type), this._barHeight - 1, this.direction(this._tabSpaceWidth - 1, type), this._barHeight - 1);
    }

    private void paintOneTab(Graphics g, int x, int y, int tabIndex) {
        int yOfYUV;
        Color oldcolor;
        String title = this.getTitleAt(tabIndex);
        Color backGround = this.getBackgroundAt(tabIndex);
        int width = this.getTabWidth(tabIndex);
        boolean isSelected = this.isSelected(tabIndex);
        if (isSelected) {
            oldcolor = g.getColor();
            if (this.getActivedIndex() == tabIndex) {
                g.setColor(Color.white);
            } else {
                g.setColor(this._borderColor);
            }
            g.drawLine(x, y, x + width, y);
            g.setColor(Color.white);
            g.fillRect(x, y + 1, width + 1, this._barHeight - 1);
            g.setColor(Color.BLACK);
            g.drawLine(x, this._barHeight - 2, x + width, this._barHeight - 2);
            g.setColor(oldcolor);
        } else {
            oldcolor = g.getColor();
            g.setColor(backGround);
            g.fillRect(x, y + 1, width + 1, this._barHeight - 1);
            g.setColor(oldcolor);
        }
        Font oldFont = g.getFont();
        boolean boldFont = this.isSheetInfo(tabIndex);
        if (boldFont) {
            g.setFont((Font)InfoStyle.getKDFont());
        }
        if ((yOfYUV = Math.round((float)backGround.getRed() * 0.299f + (float)backGround.getGreen() * 0.587f + (float)backGround.getBlue() * 0.114f)) <= 128 && !isSelected) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(Color.BLACK);
        }
        g.drawString(title, boldFont ? x + 1 : x + 2, this._fontAscent + 1);
        g.setFont(oldFont);
        if (this.getActivedIndex() == tabIndex && this.hasBackgroundAt(tabIndex)) {
            g.setColor(backGround);
        } else {
            g.setColor(this._borderColor);
        }
        g.drawLine(x - 1, this._barHeight - 1, x + width + 1, this._barHeight - 1);
    }

    private void paintTriangle(Graphics g, int rectX, int rectY, int type, Color arrowColor, int width) {
        int x = rectX + width / 3 + 1;
        int y = rectY + width / 2 - 1;
        this.paintTriangle2(g, x, y, type, arrowColor, width);
    }

    private void paintTriangle2(Graphics g, int x, int y, int type, Color arrowColor, int width) {
        Color oldColor = g.getColor();
        int j = 0;
        int size = Math.max(width / 3, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        g.setColor(arrowColor);
        switch (type) {
            case 0: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                    if (i != size - 1) continue;
                    g.drawLine(-2, mid - i, -2, mid + i);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                break;
            }
            case 2: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
            case 3: {
                j = 0;
                for (int i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    if (i == size - 1) {
                        g.drawLine(size + 1, mid - i, size + 1, mid + i);
                    }
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    static {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setBold(true);
        InfoStyle = Styles.getStyle((ShareStyleAttributes)sa);
    }

    public static interface ITabbedBarPopupProvider {
        public JPopupMenu getCtrlPopup();
    }

    private class WizzardOtherSheets
    extends KDDialog {
        private KDList _sheetList;
        private KDButton _okBtn;
        private KDButton _cancelBtn;

        public WizzardOtherSheets(Frame owner) {
            super(owner, TabbedBar.getLocalText(TabbedBar.KEY_ACTIVE_DOCUMENT), true);
            this.initComps();
            this.initListeners();
            this.pack();
        }

        public WizzardOtherSheets(Dialog dialog) {
            super(dialog, TabbedBar.getLocalText(TabbedBar.KEY_ACTIVE_DOCUMENT) + ':', true);
            this.initComps();
            this.initListeners();
            this.pack();
        }

        public void show() {
            this._sheetList.removeAllElements();
            Book book = TabbedBar.this._spread.getBook();
            int count = book.getVisibleSheetCount();
            for (int i = 0; i < count; ++i) {
                this._sheetList.addElement((Object)book.getVisibleISheet(i).getSheetName());
            }
            this._sheetList.setSelectedIndex(book.indexToVisibleIndex(book.getActiveSheetIndex()));
            super.show();
        }

        private void initComps() {
            Container panel = this.getContentPane();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.createNorthPanel(), "North");
            panel.add((Component)this.createListPanel(), "Center");
            panel.add((Component)this.createCtrlPanel(), "South");
            this.setContentPane(panel);
        }

        private KDPanel createNorthPanel() {
            KDPanel topPanel = new KDPanel();
            topPanel.setLayout((LayoutManager)new BorderLayout());
            topPanel.add((Component)new KDLabel(TabbedBar.getLocalText(TabbedBar.KEY_ACTIVE_DOCUMENT)));
            return topPanel;
        }

        private KDPanel createListPanel() {
            KDPanel listPanel = new KDPanel();
            listPanel.setLayout((LayoutManager)new BorderLayout());
            this._sheetList = new KDList();
            this._sheetList.setFixedCellHeight(15);
            this._sheetList.setVisibleRowCount(15);
            KDScrollPane sp = new KDScrollPane((Component)this._sheetList);
            listPanel.add((Component)sp, (Object)"Center");
            return listPanel;
        }

        private KDPanel createCtrlPanel() {
            KDPanel ctrlPanel = new KDPanel();
            ctrlPanel.setLayout((LayoutManager)new BoxLayout((Container)ctrlPanel, 0));
            this._okBtn = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_OK));
            this._cancelBtn = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_CANCEL));
            ctrlPanel.add(Box.createHorizontalGlue());
            ctrlPanel.add((Component)this._okBtn);
            ctrlPanel.add(Box.createHorizontalGlue());
            ctrlPanel.add((Component)this._cancelBtn);
            ctrlPanel.add(Box.createHorizontalGlue());
            return ctrlPanel;
        }

        private void initListeners() {
            this._sheetList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        TabbedBar.this.select(WizzardOtherSheets.this._sheetList.getSelectedIndex());
                        WizzardOtherSheets.this.setVisible(false);
                        WizzardOtherSheets.this.dispose();
                    }
                }
            });
            this._cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardOtherSheets.this.setVisible(false);
                    WizzardOtherSheets.this.dispose();
                }
            });
            this._okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedBar.this.select(WizzardOtherSheets.this._sheetList.getSelectedIndex());
                    WizzardOtherSheets.this.setVisible(false);
                    WizzardOtherSheets.this.dispose();
                }
            });
        }
    }

    private class WizzardSheetMoveAndCopy
    extends KDDialog {
        private KDList _sheetList;
        private KDCheckBox _copyComb;
        private KDButton _okBtn;
        private KDButton _cancelBtn;

        public WizzardSheetMoveAndCopy(Frame owner) {
            super(owner, TabbedBar.getLocalText(TabbedBar.Key_Sheet_MoveAndCopy), true);
            this.setSize(195, 235);
            this.initComps();
            this.initListeners();
        }

        public WizzardSheetMoveAndCopy(Dialog dialog) {
            super(dialog, TabbedBar.getLocalText(TabbedBar.Key_Sheet_MoveAndCopy), true);
            this.setSize(195, 235);
            this.initComps();
            this.initListeners();
        }

        public void show() {
            this._sheetList.removeAllElements();
            Book book = TabbedBar.this._spread.getBook();
            int count = book.getVisibleSheetCount();
            for (int i = 0; i < count; ++i) {
                this._sheetList.addElement((Object)book.getVisibleSheet(i).getSheetName());
            }
            this._sheetList.addElement((Object)TabbedBar.getLocalText(TabbedBar.KEY_MOVE_LAST));
            this._sheetList.setSelectedIndex(0);
            super.show();
        }

        private void initComps() {
            Container panel = this.getContentPane();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.createNorthPanel(), "North");
            panel.add((Component)this.createListPanel(), "Center");
            panel.add((Component)this.createCtrlPanel(), "South");
            this.setContentPane(panel);
        }

        private KDPanel createNorthPanel() {
            KDPanel topPanel = new KDPanel();
            topPanel.setLayout((LayoutManager)new BorderLayout());
            topPanel.add((Component)new KDLabel(TabbedBar.getLocalText(TabbedBar.KEY_MOVE_PROMPT1)), (Object)"North");
            topPanel.add((Component)new KDLabel(TabbedBar.getLocalText(TabbedBar.KEY_MOVE_PROMPT2)), (Object)"Center");
            return topPanel;
        }

        private KDPanel createListPanel() {
            KDPanel listPanel = new KDPanel();
            listPanel.setLayout((LayoutManager)new BorderLayout());
            this._sheetList = new KDList();
            this._sheetList.setFixedCellHeight(15);
            this._sheetList.setVisibleRowCount(6);
            KDScrollPane sp = new KDScrollPane((Component)this._sheetList);
            listPanel.add((Component)sp, (Object)"Center");
            this._copyComb = new KDCheckBox(TabbedBar.getLocalText(TabbedBar.KEY_CREATE_COPY));
            listPanel.add((Component)this._copyComb, (Object)"South");
            return listPanel;
        }

        private KDPanel createCtrlPanel() {
            KDPanel ctrlPanel = new KDPanel();
            ctrlPanel.setLayout((LayoutManager)new BoxLayout((Container)ctrlPanel, 0));
            this._okBtn = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_OK));
            this._cancelBtn = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_CANCEL));
            ctrlPanel.add(Box.createHorizontalGlue());
            ctrlPanel.add((Component)this._okBtn);
            ctrlPanel.add(Box.createHorizontalGlue());
            ctrlPanel.add((Component)this._cancelBtn);
            ctrlPanel.add(Box.createHorizontalGlue());
            return ctrlPanel;
        }

        private void initListeners() {
            this._cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardSheetMoveAndCopy.this.setVisible(false);
                    WizzardSheetMoveAndCopy.this.dispose();
                }
            });
            this._okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int toIndex = WizzardSheetMoveAndCopy.this._sheetList.getSelectedIndex();
                    if (WizzardSheetMoveAndCopy.this._copyComb.isSelected()) {
                        TabbedBar.this.copySheetsTo(toIndex);
                    } else {
                        TabbedBar.this.moveSheetsTo(toIndex);
                    }
                    WizzardSheetMoveAndCopy.this.setVisible(false);
                    WizzardSheetMoveAndCopy.this.dispose();
                }
            });
        }
    }

    public static class DisplayTableModel
    extends AbstractTableModel {
        ArrayList data;
        Boolean[] rowSelected;

        DisplayTableModel(ArrayList data, Boolean[] sheetSelected) {
            this.data = data;
            this.rowSelected = new Boolean[data.size()];
            this.rowSelected = sheetSelected;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.rowSelected[rowIndex] = (Boolean)value;
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.rowSelected[rowIndex];
            }
            if (columnIndex == 1) {
                return this.data.get(rowIndex);
            }
            return null;
        }
    }

    private class WizzardSheetMultiSelect
    extends KDDialog {
        private KDButton submit;
        private KDButton cancel;
        private KDWorkButton allSelected;
        private KDWorkButton allCleared;
        private JTable table;
        private KDScrollPane jPanel1;

        public WizzardSheetMultiSelect(Frame owner) {
            super(owner, TabbedBar.getLocalText(TabbedBar.Key_Sheet_MultiSelect), true);
            this.submit = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_OK));
            this.cancel = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_CANCEL));
            this.allSelected = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_SelectAll.gif"));
            this.allCleared = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_deleteall.gif"));
            this.table = new JTable();
            this.jPanel1 = new KDScrollPane((Component)this.table);
            this.setSize(240, 300);
            this.initComps();
            this.initListeners();
        }

        public WizzardSheetMultiSelect(Dialog dialog) {
            super(dialog, TabbedBar.getLocalText(TabbedBar.Key_Sheet_MultiSelect), true);
            this.submit = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_OK));
            this.cancel = new KDButton(TabbedBar.getLocalText(TabbedBar.KEY_CANCEL));
            this.allSelected = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_SelectAll.gif"));
            this.allCleared = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_deleteall.gif"));
            this.table = new JTable();
            this.jPanel1 = new KDScrollPane((Component)this.table);
            this.setSize(240, 300);
            this.initComps();
            this.initListeners();
        }

        public void show() {
            ISheet sheet;
            Book book = TabbedBar.this._spread.getBook();
            int visibleSheetCount = book.getVisibleSheetCount();
            ArrayList<String> sheetNames = new ArrayList<String>(visibleSheetCount);
            Boolean[] sheetSelected = new Boolean[visibleSheetCount];
            for (int i = 0; i < visibleSheetCount && (sheet = book.getISheet(book.visibleIndexToIndex(i))) != null; ++i) {
                sheetNames.add(sheet.getSheetName());
                sheetSelected[i] = sheet.isSelected();
            }
            this.table.setModel(new DisplayTableModel(sheetNames, sheetSelected));
            super.show();
        }

        private void initComps() {
            this.submit.setLimitedSize(false);
            this.cancel.setLimitedSize(false);
            this.allSelected.setToolTipText(TabbedBar.getLocalText(TabbedBar.KEY_ALL_SELECTED));
            this.allCleared.setToolTipText(TabbedBar.getLocalText(TabbedBar.KEY_ALL_CLEARED));
            this.table.setTableHeader(null);
            this.table.setRowHeight(18);
            JPanel contentPane = (JPanel)this.getContentPane();
            GroupLayout layout = new GroupLayout((Container)contentPane);
            contentPane.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.submit).add(18, 18, 18).add((Component)this.cancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allSelected, -2, 28, -2).addPreferredGap(1).add((Component)this.allCleared, -2, 28, -2))).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allCleared, -2, 24, -2).add((Component)this.allSelected, -2, 24, -2)).addPreferredGap(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.submit).add((Component)this.cancel)).addContainerGap()));
        }

        private void initListeners() {
            this.allSelected.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = WizzardSheetMultiSelect.this.table.getRowCount();
                    for (int i = 0; i < rowCount; ++i) {
                        WizzardSheetMultiSelect.this.table.setValueAt(Boolean.valueOf("true"), i, 0);
                    }
                    WizzardSheetMultiSelect.this.table.repaint();
                }
            });
            this.allCleared.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = WizzardSheetMultiSelect.this.table.getRowCount();
                    for (int i = 0; i < rowCount; ++i) {
                        WizzardSheetMultiSelect.this.table.setValueAt(Boolean.valueOf("false"), i, 0);
                    }
                    WizzardSheetMultiSelect.this.table.repaint();
                }
            });
            this.submit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Book book = TabbedBar.this._spread.getBook();
                    int rowCount = WizzardSheetMultiSelect.this.table.getRowCount();
                    int lastSelectedIndex = -1;
                    for (int i = 0; i < rowCount; ++i) {
                        if (((Boolean)WizzardSheetMultiSelect.this.table.getValueAt(i, 0)).booleanValue()) {
                            book.getISheet(book.visibleIndexToIndex(i)).setSelected(true);
                            lastSelectedIndex = i;
                            continue;
                        }
                        book.getISheet(book.visibleIndexToIndex(i)).setSelected(false);
                    }
                    book.setActiveSheet(book.visibleIndexToIndex(lastSelectedIndex));
                    book.getActiveSheet().getSheetOption().getSelection().syncAllSelected();
                    TabbedBar.this.repaint();
                    WizzardSheetMultiSelect.this.setVisible(false);
                    WizzardSheetMultiSelect.this.dispose();
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardSheetMultiSelect.this.setVisible(false);
                    WizzardSheetMultiSelect.this.dispose();
                }
            });
        }
    }

    private class OtherSheetsAction
    extends AbstractAction {
        public OtherSheetsAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedBar.this.showOtherSheetsWizzard();
        }
    }

    private class GotoAction
    extends AbstractAction {
        public GotoAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedBar.this.select(e.getActionCommand());
        }
    }

    private class MouseHandler
    implements MouseInputListener {
        private int _pressIndex = -1;
        private int _moveArrawIndex = -1;
        private int _pressArrowIndex = -1;
        private int _dragIndex = -1;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int arrowIndex = this.getArrowAtLocation(e.getX(), e.getY());
            if (arrowIndex >= 0) {
                if (this._moveArrawIndex != arrowIndex) {
                    this._moveArrawIndex = arrowIndex;
                    TabbedBar.this.repaint();
                }
                this._pressArrowIndex = -1;
            } else {
                if (this._moveArrawIndex != -1) {
                    this._moveArrawIndex = -1;
                    TabbedBar.this.repaint();
                }
                this._pressArrowIndex = -1;
            }
            int tabIndex = this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex == -2 && TabbedBar.this._spread.getBook().getUserObjectValue("EXT_EXECUTED") == null) {
                TabbedBar.this.setToolTipText(CtrlEXTMessages.getMLS("insertWorksheet", "\u63d2\u5165\u5de5\u4f5c\u8868"));
            } else {
                TabbedBar.this.setToolTipText(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            if (!TabbedBar.this.stopEditing()) {
                return;
            }
            int x = e.getX();
            int arrowIndex = this.getArrowAtLocation(x, y = e.getY());
            if (arrowIndex >= 0) {
                if (SwingUtilities.isRightMouseButton(e) && TabbedBar.this.canShowArrowPop()) {
                    TabbedBar.this.getArrowPopupMenu().show((Component)TabbedBar.this, x, y);
                } else if (TabbedBar.this.canPressArrow()) {
                    this.setPressArrowIndex(arrowIndex);
                    this._moveArrawIndex = -1;
                    TabbedBar.this.repaint();
                }
            } else {
                int tabIndex = this.getTabAtLocation(x, y);
                if (tabIndex >= 0 && tabIndex < TabbedBar.this.getTabCount()) {
                    JPopupMenu pop;
                    this._pressIndex = tabIndex;
                    if (e.isShiftDown()) {
                        TabbedBar.this.selectTo(tabIndex);
                    } else if (e.isControlDown()) {
                        TabbedBar.this.selectWith(tabIndex);
                    } else {
                        TabbedBar.this.select(tabIndex);
                    }
                    if (!TabbedBar.this.canShowTabPop()) {
                        this._pressIndex = -1;
                    }
                    if (SwingUtilities.isRightMouseButton(e) && (pop = this.getTabPopupMenu()) != null) {
                        try {
                            pop.show(TabbedBar.this, x, y);
                        }
                        catch (IllegalComponentStateException illegalComponentStateException) {
                            // empty catch block
                        }
                        KDMenuItem unHideItem = (KDMenuItem)pop.getClientProperty("Sheet_Unhide");
                        Book book = TabbedBar.this._spread.getBook();
                        if (book.getSheetCount() > book.getVisibleSheetCount()) {
                            unHideItem.setEnabled(true);
                        } else {
                            unHideItem.setEnabled(false);
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._pressIndex != -1) {
                TabbedBar.this.setCursor(Cursor.getPredefinedCursor(13));
                this._dragIndex = this.getTabAtLocation(e.getX(), e.getY());
                TabbedBar.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int arrowIndex = this.getArrowAtLocation(e.getX(), e.getY());
            if (arrowIndex >= 0) {
                this._moveArrawIndex = -1;
                this._pressArrowIndex = -1;
                TabbedBar.this.repaint();
            } else {
                if (this._dragIndex >= 0 && this._pressIndex >= 0) {
                    TabbedBar.this.moveSheetsTo(this._dragIndex);
                    TabbedBar.this.repaint();
                } else {
                    this._pressIndex = -1;
                }
                this._dragIndex = -1;
            }
            TabbedBar.this.setCursor(Cursor.getDefaultCursor());
            int tabIndex = this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex == -2 && e.getButton() == 1 && TabbedBar.this._spread.getBook().getUserObjectValue("EXT_EXECUTED") == null) {
                TabbedBar.this.insertSheetAtLast();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int tabIndex;
            if (!TabbedBar.this.canEditTab()) {
                return;
            }
            if (TabbedBar.this.isProtected()) {
                return;
            }
            if (!(e.getClickCount() != 2 || e.isControlDown() && e.isShiftDown() || (tabIndex = this.getTabAtLocation(e.getX(), e.getY())) < 0 || tabIndex >= TabbedBar.this.getTabCount())) {
                TabbedBar.this.startEditing(TabbedBar.this.getActivedIndex());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int arrowIndex = this.getArrowAtLocation(e.getX(), e.getY());
            if (arrowIndex >= 0) {
                this._moveArrawIndex = -1;
                this._pressArrowIndex = -1;
                TabbedBar.this.repaint();
            }
        }

        private JPopupMenu getTabPopupMenu() {
            if (TabbedBar.this._provider != null) {
                return TabbedBar.this._provider.getCtrlPopup();
            }
            return null;
        }

        private void setPressArrowIndex(int type) {
            this._pressArrowIndex = type;
            switch (type) {
                case 0: {
                    TabbedBar.this.setStartIndex(0);
                    break;
                }
                case 1: {
                    TabbedBar.this.setStartIndex(TabbedBar.this._startIndex - 1);
                    break;
                }
                case 2: {
                    TabbedBar.this.setStartIndex(TabbedBar.this._startIndex + 1);
                    break;
                }
                case 3: {
                    TabbedBar.this.setStartIndex(TabbedBar.this.getTabCount() - 1);
                    break;
                }
            }
        }

        private int getArrowAtLocation(int x, int y) {
            int index = -1;
            int arrowAreaWidth = TabbedBar.this.getArrowWidth() * 4 + TabbedBar.this._leftBorderWidth;
            int arrowWidth = TabbedBar.this.getArrowWidth();
            if (x <= arrowAreaWidth && y < arrowWidth + TabbedBar.this._leftBorderWidth) {
                for (int i = 0; i < 4; ++i) {
                    int width = arrowWidth * (i + 1) + TabbedBar.this._leftBorderWidth;
                    if (x > width) continue;
                    index = i;
                    break;
                }
            }
            return index;
        }

        private int getTabAtLocation(int x, int y) {
            int arrowsWidth;
            int width = arrowsWidth = TabbedBar.this.getArrowWidth() * 4 + TabbedBar.this._leftBorderWidth;
            if (x < arrowsWidth || y > TabbedBar.this._barHeight) {
                return -1;
            }
            for (int i = TabbedBar.this._startIndex; i < TabbedBar.this.getTabCount(); ++i) {
                width = i == TabbedBar.this._startIndex ? width + TabbedBar.this._tabSpaceWidth + TabbedBar.this.getTabWidth(i) + TabbedBar.this._tabSpaceWidth / 2 : width + TabbedBar.this._tabSpaceWidth / 2 + TabbedBar.this.getTabWidth(i) + TabbedBar.this._tabSpaceWidth / 2;
                if (x <= arrowsWidth || x > width) continue;
                return i;
            }
            int endWidth = width + TabbedBar.this._tabSpaceWidth + 25 + TabbedBar.this._tabSpaceWidth / 2;
            if (x > width && x <= endWidth) {
                return -2;
            }
            return TabbedBar.this.getTabCount() + 1;
        }
    }
}

