/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.exec;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecutionContext {
    private static Logger log = LogUtil.getPackageLogger(ExecutionContext.class);
    private Book _book;
    private Map _params;
    private Map _cacheObj;
    private IRptRuntimeCallback runtimeCallback;
    private boolean _isUseDemoData;
    private boolean _isUserInterrupted = false;
    private long maxCellNum;

    public ExecutionContext(Book book) {
        this._book = book;
        long defaultMaxCellNum = 2000000L;
        try {
            String maxCellNumProperty = System.getProperty("qingrpt.book.cell.maxnum", String.valueOf(defaultMaxCellNum));
            this.maxCellNum = Long.parseLong(maxCellNumProperty);
        }
        catch (Exception e) {
            this.maxCellNum = defaultMaxCellNum;
        }
    }

    public boolean isUserInterrupted() {
        if (!this._isUserInterrupted) {
            boolean bl = this._isUserInterrupted = this.runtimeCallback != null && this.runtimeCallback.isInterrupted();
            if (!this._isUserInterrupted) {
                long cellNum = this._book.getCellNum();
                if (cellNum > this.maxCellNum) {
                    this._isUserInterrupted = true;
                    String msg = this._book.getName() + CtrlEXTMessages.getMLS("calculationCellExceedsConfiguredSize", "\u8ba1\u7b97\u5355\u5143\u683c\u8d85\u51fa\u914d\u7f6e\u5927\u5c0f") + this.maxCellNum;
                    throw new RuntimeException(msg);
                }
                if (this.runtimeCallback != null && this.runtimeCallback.isLowMem()) {
                    this._isUserInterrupted = true;
                    throw new RuntimeException(CtrlEXTMessages.getMLS("serverMemoryInsufficientStoppingCalculation", "\u670d\u52a1\u5668\u5185\u5b58\u4e0d\u8db3\uff0c\u505c\u6b62\u8ba1\u7b97"));
                }
            }
        }
        return this._isUserInterrupted;
    }

    public void registerDataSetFactories(Map factories) {
        ExtDataSetManager datasetManager = this._book.getDataSetManager();
        ExtDataSetFactory sheetDataFactory = datasetManager.getExtDataSetFactory();
        for (Map.Entry entry : factories.entrySet()) {
            ExtDataSetType type = (ExtDataSetType)entry.getKey();
            sheetDataFactory.registerFactory(type, (IExtDataSetFactory)entry.getValue());
        }
    }

    public Map getDataSetFactories() {
        ExtDataSetManager datasetManager = this._book.getDataSetManager();
        ExtDataSetFactory sheetDataFactory = datasetManager.getExtDataSetFactory();
        return sheetDataFactory.getFactorys();
    }

    public void attachDataSetParameters(Map parameters) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        if (parameters != null) {
            this._params.putAll(parameters);
        }
        Iterator it = this._params.entrySet().iterator();
        while (it.hasNext()) {
            IParameter value = (IParameter)it.next().getValue();
            this._book.insertValuedNameObject(value.getParameterPrefix() + value.getName(), value.getValue());
        }
    }

    public void attachDataSetOutputParameters(Map parameters) {
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            IParameter value = (IParameter)it.next().getValue();
            this._book.insertValuedNameObject("@" + value.getName(), value.getValue());
        }
    }

    public Map getDataSetParameters() {
        return this._params;
    }

    public void setDataSetParameters(Map params) {
        this._params = params;
    }

    public IParameter getDataSetParameter(String pName) {
        if (this._params == null) {
            return null;
        }
        return (IParameter)this._params.get(pName);
    }

    public void copyCacheObjectFrom(ExecutionContext ctx) {
        this._cacheObj = ctx._cacheObj;
    }

    public Object getDataSetCacheObject(Object key) {
        if (this._cacheObj == null) {
            return null;
        }
        return this._cacheObj.get(key);
    }

    public void registerDataSetCacheObject(Object key, Object cacheObj) {
        if (this._cacheObj == null) {
            this._cacheObj = new HashMap();
        }
        this._cacheObj.put(key, cacheObj);
    }

    public void unRegisterDataSetCacheObject(Object key) {
        if (this._cacheObj == null) {
            return;
        }
        this._cacheObj.remove(key);
    }

    public void registerDataSetCacheObject(Map cacheMap) {
        if (cacheMap == null || cacheMap.isEmpty()) {
            return;
        }
        if (this._cacheObj == null) {
            this._cacheObj = new HashMap();
        }
        this._cacheObj.putAll(cacheMap);
    }

    public void setRptRuntimeCallback(IRptRuntimeCallback rptRun) {
        this.runtimeCallback = rptRun;
    }

    public IRptRuntimeCallback getRptRuntimeCallback() {
        return this.runtimeCallback;
    }

    public Book getBook() {
        return this._book;
    }

    public String getReportId() {
        if (this.runtimeCallback != null) {
            return this.runtimeCallback.getReportId();
        }
        return null;
    }

    public boolean isUseDemoData() {
        return this._isUseDemoData;
    }

    public void setUseDemoData(boolean isUseDemoData) {
        this._isUseDemoData = isUseDemoData;
    }
}

