/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.collection;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellPropAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;

public class SortedExtPropFormulasArray
extends SortedObjectArray {
    private static final long serialVersionUID = -1699146717530264568L;
    private Sheet _sheet;
    private ICalculable _owner;

    public SortedExtPropFormulasArray(Sheet sheet, ICalculable owner) {
        super(3);
        this._sheet = sheet;
        this._owner = owner;
    }

    @Override
    public Object clone() {
        SortedExtPropFormulasArray array = (SortedExtPropFormulasArray)super.clone();
        for (int i = 0; i < this._count; ++i) {
            array._array[i] = ((ICalculableProps)this._array[i]).clone();
        }
        return array;
    }

    public Object cloneSuper() {
        return super.clone();
    }

    public ICalculableProps get(CellPropAction action) {
        int pos = this.search(action);
        return pos < 0 ? null : (ICalculableProps)this.get(pos);
    }

    public void insert(CellPropAction action, String formula) {
        if (StringUtil.isEmptyString((String)formula)) {
            return;
        }
        int pos = this.search(action);
        if (pos < 0) {
            this.insert(pos, new CommonCalculableProps(action, this._sheet.getExpr(this._owner, formula)));
        } else {
            Expr expr;
            ICalculableProps curr = (ICalculableProps)this.get(pos);
            if (!curr.getFormula(this._sheet.getDeps().getExprContext(), this._owner).equals(formula) && !(expr = this._sheet.getExpr(this._owner, formula)).isSyntaxError()) {
                curr.setExpr(expr);
            }
        }
    }

    public ICalculableProps remove(CellPropAction action) {
        int pos = this.search(action);
        return pos < 0 ? null : (ICalculableProps)this.removeByPos(pos);
    }

    public int search(CellPropAction action) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this._array[mid];
            int cmp = ((ICalculableProps)midVal).getAction().getIntKey() - action.getIntKey();
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

