/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.collection.test;

import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.test.ISpanProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import java.security.SecureRandom;

public class SortedSegmentArray
extends SortedObjectArray {
    private static final long serialVersionUID = 8991366467312982473L;
    private static final DefaultSpanProvider _defaultSpanProvider = new DefaultSpanProvider();
    protected int _maxIndex;
    private ISpanProvider _provider = _defaultSpanProvider;

    public SortedSegmentArray(int maxIndex) {
        this._maxIndex = maxIndex;
    }

    public int searchSpan(int pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = ((Span)this._array[mid]).compareToPos(pos);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private boolean splitSpan(int dstPos, int splitIndex, boolean bStart) {
        Span olsSpan = (Span)this._array[dstPos];
        if (olsSpan.getExtent() == 1 || splitIndex == (bStart ? olsSpan.getStart() : olsSpan.getEnd())) {
            return false;
        }
        Span newSpan = this._provider.cloneFrom(olsSpan);
        olsSpan.setEnd(bStart ? splitIndex - 1 : splitIndex);
        newSpan.setStart(bStart ? splitIndex : splitIndex + 1);
        super.insert(dstPos + 1, newSpan);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Span makeContinuousSpans(int dstStart, int dstEnd) {
        int pos = this.searchSpan(dstStart);
        int pos2 = this.searchSpan(dstEnd);
        if (pos < 0) {
            if (pos == pos2) {
                super.insert(pos, this._provider.getDefaultSpan(dstStart, dstEnd));
                pos2 = pos = -(pos + 1);
                return new Span(pos, pos2);
            }
            int end = ((pos = -(pos + 1)) < this._count ? ((Span)this._array[pos]).getStart() : dstEnd) - 1;
            super.insert(pos, this._provider.getDefaultSpan(dstStart, end));
            pos2 = pos2 < 0 ? --pos2 : ++pos2;
        } else {
            Span sp;
            if (pos == pos2 && (sp = (Span)this._array[pos]).getStart() == dstStart && sp.getEnd() == dstEnd) return new Span(pos, pos2);
            if (this.splitSpan(pos, dstStart, true)) {
                ++pos;
                pos2 = pos2 < 0 ? --pos2 : ++pos2;
            }
        }
        if (pos2 < 0) {
            pos2 = -(pos2 + 1);
            Span prev = (Span)this._array[pos2 - 1];
            super.insert(pos2, this._provider.getDefaultSpan(prev.getEnd() + 1, dstEnd));
        } else {
            this.splitSpan(pos2, dstEnd, false);
        }
        Span sp = (Span)this._array[pos];
        for (int i = pos + 1; i <= pos2; ++i) {
            Span next = (Span)this._array[i];
            if (!sp.followBy(next)) {
                super.insert(i, this._provider.getDefaultSpan(sp.getEnd() + 1, next.getStart() - 1));
                ++pos2;
                ++i;
            }
            sp = next;
        }
        return new Span(pos, pos2);
    }

    public void setSpanContent(int dstStart, int dstEnd, Object value, boolean clearEmpty, SortedSegmentArray aChanged) {
        if (dstStart > dstEnd) {
            return;
        }
        Span list = this.makeContinuousSpans(dstStart, dstEnd);
        boolean bState = aChanged != null;
        int end = list.getEnd();
        for (int i = list.getStart(); i <= end; ++i) {
            Span spCopy = this._provider.put((Span)this._array[i], value, bState);
            if (spCopy == null) continue;
            aChanged.insert(spCopy);
        }
        this.merge(list, clearEmpty);
    }

    public void merge(Span list, boolean clearEmpty) {
        int end;
        int start = list.getStart() - 1;
        if (start < 0) {
            start = 0;
        }
        if ((end = list.getEnd() + 1) >= this._count) {
            end = this._count - 1;
        }
        if (start <= end) {
            Span span = (Span)this._array[end];
            for (int i = end - 1; i >= start; --i) {
                Span prev = (Span)this._array[i];
                if (prev.followBy(span) && this._provider.contentEquals(prev, span)) {
                    span.setStart(prev.getStart());
                    this.removeByPos(i);
                    --end;
                    continue;
                }
                span = prev;
            }
        }
        if (clearEmpty) {
            this.clearEmpty(start, end);
        }
    }

    private void clearEmpty(int pos, int pos2) {
        while (pos2 >= pos) {
            Span span = (Span)this._array[pos2];
            if (this._provider.isDefaultSpan(span)) {
                this.removeByPos(pos2);
            }
            --pos2;
        }
    }

    public Object[] insertSpace(int start, int end, boolean bState) {
        if (start > end) {
            return null;
        }
        int pos = this.searchSpan(start);
        if (pos < 0) {
            pos = -(pos + 1);
        } else if (this.splitSpan(pos, start, true)) {
            ++pos;
        }
        int offset = end - start + 1;
        int lastKeepIndex = this._maxIndex - offset + 1;
        int lastKeepPos = this.searchSpan(lastKeepIndex);
        if (lastKeepPos >= 0) {
            this.splitSpan(lastKeepPos, lastKeepIndex, false);
        } else {
            lastKeepPos = -lastKeepPos - 2;
        }
        Object[] outSpans = this.removeByPos(lastKeepPos + 1, this._count - 1, bState);
        while (pos < this._count) {
            ((Span)this._array[pos]).offset(offset);
            ++pos;
        }
        return outSpans;
    }

    public static void main(String[] args) {
        int i;
        int count = 500000;
        SecureRandom r = new SecureRandom();
        int[] a = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            a[i2] = Math.abs(r.nextInt(count));
        }
        SortedSegmentArray sa = new SortedSegmentArray(Integer.MAX_VALUE);
        long t = System.currentTimeMillis();
        for (i = 0; i < count; i += 2) {
            sa.setSpanContent(a[i], a[i + 1], null, false, null);
        }
        System.out.println("SA Set: " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        for (i = 0; i < count; i += 10) {
            sa.insertSpace(a[i], a[i + 1], false);
        }
        System.out.println("Insert Set: " + (System.currentTimeMillis() - t));
    }

    static final class DefaultSpanProvider
    implements ISpanProvider {
        DefaultSpanProvider() {
        }

        @Override
        public Span getDefaultSpan(int start, int end) {
            return new Span(start, end);
        }

        @Override
        public boolean isDefaultSpan(Span span) {
            return false;
        }

        @Override
        public Span cloneFrom(Span span) {
            return (Span)span.clone();
        }

        @Override
        public Span put(Span dst, Object value, boolean bState) {
            return null;
        }

        @Override
        public boolean contentEquals(Span src, Span dst) {
            return true;
        }
    }
}

