/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.AdjustIntRateInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IntRateBaseInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.LoanInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.LoanInterestEntryInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.LoanInterestInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.RepaymentBillInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.SubBeginDateInfo;
import com.kingdee.cosmic.ctrl.kds.model.util.DateHelper;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

abstract class AbstractIntStragety {
    protected static final String ACCORD_INTRATE_ID = "lJlpCQEQEADgAAc+wKgSjiR9knQ=";
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final String DAY = "DAY";
    protected LoanInfo _loan;
    protected RepaymentBillInfo _repayInfo = null;
    protected ObjectArray _adjIntRates = null;
    protected ObjectArray _intRateBases = null;
    protected ObjectArray _repays = null;
    protected boolean _isPrediction;
    protected Date _beginDate;
    protected Date _endDate;

    AbstractIntStragety() {
    }

    public LoanInterestInfo calInt() {
        this._beginDate = DateHelper.truncateDate(this.getBeginDate(this._beginDate));
        this._endDate = DateHelper.truncateDate(this.getEndDate(this._endDate));
        if (this._beginDate.compareTo(this._endDate) > 0) {
            return null;
        }
        SortedObjectArray subBeginDateList = this.getSubBeginDateList(this._beginDate, this._endDate);
        Date subBeginDate = this._beginDate;
        Date subEndDate = this._endDate;
        BigDecimal intPrinciple = Variant.zeroBigDecimal;
        String intRateType = null;
        int convertDays = 0;
        BigDecimal intRate = Variant.zeroBigDecimal;
        int punishType = 0;
        BigDecimal punishIntRate = Variant.zeroBigDecimal;
        Date expiredDate = this._loan.getExpiredDate();
        boolean isCalPunishInt = false;
        int seq = 0;
        LoanInterestInfo intInfo = new LoanInterestInfo();
        LoanInterestEntryInfo intEntryInfo = null;
        AdjustIntRateInfo adjInfo = null;
        SubBeginDateInfo subDateInfo = null;
        boolean notRepayWithSub = true;
        int size = subBeginDateList.size();
        for (int i = 0; i < size; ++i) {
            Object obj = subBeginDateList.get(i);
            subEndDate = DateHelper.getBeforeDay((Date)obj);
            subDateInfo = obj instanceof SubBeginDateInfo ? (SubBeginDateInfo)obj : null;
            intPrinciple = this.getSubIntPrinciple(subBeginDate);
            adjInfo = this.getValidAdjInfo(subBeginDate);
            intRateType = this.getSubIntRateType(subBeginDate, adjInfo);
            convertDays = this.getSubConvertDays(subBeginDate, adjInfo);
            if (notRepayWithSub) {
                intRate = subBeginDate.compareTo(this._beginDate) == 0 && subDateInfo != null ? this.getIntRateAsFirstSub(this._beginDate, adjInfo) : this.getSubIntRate(subBeginDate, adjInfo);
            }
            notRepayWithSub = subDateInfo == null || !subDateInfo.isOnlyPrinciple();
            punishType = this.getSubPunishType(subBeginDate, adjInfo);
            punishIntRate = this.getSubPunishIntRate(subBeginDate, adjInfo);
            isCalPunishInt = this.isCalPunishInt(subEndDate);
            intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateType);
            intInfo.getEntries().append(intEntryInfo);
            subBeginDate = (Date)obj;
        }
        adjInfo = this.getValidAdjInfo(subBeginDate);
        ++seq;
        subEndDate = this._endDate;
        intPrinciple = this.getSubIntPrinciple(subBeginDate);
        intRateType = this.getSubIntRateType(subBeginDate, adjInfo);
        convertDays = this.getSubConvertDays(subBeginDate, adjInfo);
        if (notRepayWithSub) {
            intRate = subBeginDate.compareTo(this._beginDate) == 0 && subDateInfo != null ? this.getIntRateAsFirstSub(this._beginDate, adjInfo) : this.getSubIntRate(subBeginDate, adjInfo);
        }
        punishType = this.getSubPunishType(subBeginDate, adjInfo);
        punishIntRate = this.getSubPunishIntRate(subBeginDate, adjInfo);
        isCalPunishInt = this.isCalPunishInt(subEndDate);
        intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateType);
        intInfo.getEntries().append(intEntryInfo);
        intInfo = this.buildIntInfo(this._beginDate, this._endDate, intInfo);
        return intInfo;
    }

    private LoanInterestInfo buildIntInfo(Date beginDate, Date endDate, LoanInterestInfo intInfo) {
        intInfo.repayInfo = this._repayInfo;
        intInfo.loanInfo = this._loan;
        int size = intInfo.getEntries().size();
        LoanInterestEntryInfo intEntryInfo = (LoanInterestEntryInfo)intInfo.getEntries().get(size - 1);
        intInfo.intCalType = this.getIntCalType();
        int intCalType = intInfo.intCalType;
        if (intCalType != 1 && intCalType != 4 && intCalType == 2) {
            BigDecimal repatAmt = intInfo.repayInfo.getRepayAmt();
            BigDecimal bigDecimal = intInfo.loanInfo.getLoanBalance();
        }
        return intInfo;
    }

    public BigDecimal getTotalPunishInterest(ObjectArray intEntryColl) {
        BigDecimal totalInt = Variant.zeroBigDecimal;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(((LoanInterestEntryInfo)intEntryColl.get((int)i)).punishInterest);
        }
        return totalInt;
    }

    public BigDecimal getTotalInterest(ObjectArray intEntryColl) {
        BigDecimal totalInt = Variant.zeroBigDecimal;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(((LoanInterestEntryInfo)intEntryColl.get((int)i)).interest);
        }
        return totalInt;
    }

    public Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public BigDecimal calIntertest(BigDecimal intPrinciple, BigDecimal intRate, int covertDays, int days, String intRateTypeExp) {
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(covertDays));
        BigDecimal bDays = new BigDecimal(String.valueOf(days));
        BigDecimal interest = intPrinciple.multiply(intRate).multiply(bDays);
        BigDecimal temp = Variant.zeroBigDecimal;
        temp = intRateTypeExp.equals(YEAR) ? bConvertDay.multiply(Variant.oneHundredBigDecimal) : bConvertDay.multiply(Variant.oneThousandBigDecimal);
        interest = interest.divide(temp, 5, 4);
        return interest;
    }

    private LoanInterestEntryInfo buildIntEntryInfo(int seq, Date subBeginDate, Date subEndDate, Date expiredDate, BigDecimal intPrinciple, BigDecimal intRate, int convertDays, BigDecimal punishIntRate, boolean isCalPunishInt, int punishType, String intRateTypeExp) {
        int days = this.getDiffDays(subBeginDate, subEndDate);
        LoanInterestEntryInfo intEntryInfo = new LoanInterestEntryInfo();
        intEntryInfo.interest = this.calIntertest(intPrinciple, intRate, convertDays, days, intRateTypeExp);
        int overdueDays = 0;
        BigDecimal punishInterest = Variant.zeroBigDecimal;
        if (isCalPunishInt) {
            if (subEndDate.compareTo(expiredDate) > 0) {
                overdueDays = this.getOverdueDays(subBeginDate, subEndDate, expiredDate);
                punishInterest = AbstractIntStragety.calPunishInt(intPrinciple, intRate, punishIntRate, overdueDays, convertDays, punishType, intRateTypeExp);
            } else {
                overdueDays = 0;
                punishInterest = Variant.zeroBigDecimal;
            }
        }
        intEntryInfo.punishInterest = punishInterest;
        return intEntryInfo;
    }

    public static BigDecimal calPunishInt(BigDecimal intPrinciple, BigDecimal intRate, BigDecimal punishIntRate, int overdueDays, int convertDays, int punishType, String intRateTypeExp) {
        BigDecimal bOverdueDays = new BigDecimal(String.valueOf(overdueDays));
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(convertDays));
        intRate = YEAR.equals(intRateTypeExp) ? intRate.divide(Variant.oneHundredBigDecimal, 5, 4) : intRate.divide(Variant.oneThousandBigDecimal, 5, 4);
        if (punishType == 1) {
            return intPrinciple.multiply(intRate).multiply(punishIntRate).multiply(bOverdueDays).divide(bConvertDay.multiply(Variant.oneHundredBigDecimal), 5, 4);
        }
        if (punishType == 2) {
            return intPrinciple.multiply(punishIntRate).multiply(bOverdueDays).divide(Variant.oneThousandBigDecimal, 5, 4);
        }
        return Variant.zeroBigDecimal;
    }

    public int getOverdueDays(Date beginDate, Date endDate, Date expiredDate) {
        Date bigDate = beginDate.compareTo(expiredDate) > 0 ? beginDate : expiredDate;
        return this.getDiffDays(bigDate, endDate);
    }

    private String getAdjustIntBillIdExt(Date subBeginDate) {
        if (this._adjIntRates == null || this._adjIntRates.isEmpty()) {
            return "";
        }
        AdjustIntRateInfo info = (AdjustIntRateInfo)this._adjIntRates.get(0);
        Date preDate = info.getAdjustDate();
        int size = this._adjIntRates.size();
        for (int i = 1; i < size; ++i) {
            AdjustIntRateInfo adj = (AdjustIntRateInfo)this._adjIntRates.get(i);
            if (subBeginDate.compareTo(preDate) >= 0 && subBeginDate.compareTo(adj.getAdjustDate()) < 0) {
                return info.getId();
            }
            info = adj;
            preDate = info.getAdjustDate();
        }
        if (subBeginDate.compareTo(preDate) >= 0) {
            return info.getId();
        }
        return "";
    }

    public int getDiffDays(Date beginDate, Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return (int)diff + 1;
    }

    private int getSubPunishType(Date subBeginDate, AdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate)) {
            return this._loan.getPunishIntRateType();
        }
        return adjInfo.getPunishIntRateType();
    }

    private BigDecimal getSubPunishIntRate(Date subBeginDate, AdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate)) {
            return this._loan.getPunishIntRate();
        }
        return adjInfo.getPunishIntRateAfterAdj();
    }

    private BigDecimal getIntRateAsFirstSub(Date beginDate, AdjustIntRateInfo adjInfo) {
        Date firstAdjDate = this._loan.getFirstRateAdjustDate();
        if (beginDate.compareTo(firstAdjDate) > 0) {
            int rateAdjustPeriod = this._loan.getRateAdjustPeriod();
            Calendar firstCalendar = Calendar.getInstance();
            firstCalendar.setTime(firstAdjDate);
            int flashDay = firstCalendar.get(5);
            Date limitDate = firstAdjDate;
            while (firstAdjDate.compareTo(beginDate) <= 0) {
                limitDate = firstCalendar.getTime();
                firstCalendar = this.timeOfNextPeriod(firstCalendar, flashDay, rateAdjustPeriod);
                firstAdjDate = firstCalendar.getTime();
            }
            return this.getSubIntRate(limitDate, adjInfo);
        }
        return this.getSubIntRate(beginDate, adjInfo);
    }

    private BigDecimal getSubIntRate(Date subBeginDate, AdjustIntRateInfo adjInfo) {
        if (this.isAccordIntRate()) {
            if (this.isLessFirstAdjust(subBeginDate)) {
                return this._loan.getIntRate();
            }
            return adjInfo.getIntRateAfterAdj();
        }
        BigDecimal intRateBase = this.getIntRateBase(subBeginDate);
        BigDecimal floatPoint = this._loan.getFloatPoint();
        int floatAction = this._loan.getFloatAction();
        if (floatAction > 0) {
            if (floatAction == 1) {
                return intRateBase.multiply(Variant.oneBigDecimal.add(floatPoint.divide(Variant.oneHundredBigDecimal, 5, 4)));
            }
            return intRateBase.add(floatPoint);
        }
        return intRateBase.multiply(Variant.oneBigDecimal.add(floatPoint.divide(Variant.oneHundredBigDecimal, 5, 4)));
    }

    public BigDecimal getIntRateBase(Date beginDate) {
        if (this._intRateBases == null || this._intRateBases.isEmpty()) {
            return null;
        }
        IntRateBaseInfo info = (IntRateBaseInfo)this._intRateBases.get(0);
        Date preDate = info.getEffectiveDate();
        BigDecimal yearRate = info.getYearRate();
        int size = this._intRateBases.size();
        for (int i = 1; i < size; ++i) {
            info = (IntRateBaseInfo)this._intRateBases.get(i);
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(info.getEffectiveDate()) < 0) {
                return yearRate;
            }
            preDate = info.getEffectiveDate();
            yearRate = info.getYearRate();
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return yearRate;
        }
        return null;
    }

    private int getSubConvertDays(Date subBeginDate, AdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate)) {
            return this._loan.getConvertDays();
        }
        return adjInfo.getConvertDays();
    }

    private String getSubIntRateType(Date subBeginDate, AdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate)) {
            return this._loan.getIntRateType();
        }
        return adjInfo.getIntRateType();
    }

    protected boolean isLessFirstAdjust(Date beginDate) {
        if (this._adjIntRates == null || this._adjIntRates.isEmpty()) {
            return true;
        }
        return beginDate.compareTo(((AdjustIntRateInfo)this._adjIntRates.get(0)).getAdjustDate()) < 0;
    }

    public AdjustIntRateInfo getValidAdjInfo(Date beginDate) {
        if (this._adjIntRates == null || this._adjIntRates.isEmpty()) {
            return null;
        }
        AdjustIntRateInfo info = (AdjustIntRateInfo)this._adjIntRates.get(0);
        Date preDate = info.getAdjustDate();
        int size = this._adjIntRates.size();
        for (int i = 1; i < size; ++i) {
            AdjustIntRateInfo curr = (AdjustIntRateInfo)this._adjIntRates.get(i);
            Date currDate = curr.getAdjustDate();
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(currDate) < 0) {
                return info;
            }
            info = curr;
            preDate = currDate;
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return info;
        }
        return null;
    }

    private SortedObjectArray getSubBeginDateList(Date beginDate, Date endDate) {
        int i;
        int size;
        SortedObjectArray list = new SortedObjectArray();
        Date subBeginDate = null;
        if (this.isAccordIntRate()) {
            if (this._adjIntRates != null) {
                size = this._adjIntRates.size();
                for (i = 0; i < size; ++i) {
                    subBeginDate = DateHelper.truncateDate(((AdjustIntRateInfo)this._adjIntRates.get(i)).getAdjustDate());
                    if (!this.isBetween(beginDate, endDate, subBeginDate)) continue;
                    list.insert(subBeginDate);
                }
            }
        } else {
            Date firstRateAdjustDate = DateHelper.truncateDate(this._loan.getFirstRateAdjustDate());
            int rateAdjustPeriod = this._loan.getRateAdjustPeriod();
            if (rateAdjustPeriod <= 0) {
                int size2 = this._intRateBases.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    subBeginDate = DateHelper.truncateDate(((IntRateBaseInfo)this._intRateBases.get(i2)).getEffectiveDate());
                    if (!this.isBetween(beginDate, endDate, subBeginDate)) continue;
                    list.insert(subBeginDate);
                }
            } else {
                return this.getSubBeginDateListWithPeriod(firstRateAdjustDate, rateAdjustPeriod);
            }
        }
        size = this._repays.size();
        for (i = 0; i < size; ++i) {
            RepaymentBillInfo repay = (RepaymentBillInfo)this._repays.get(i);
            subBeginDate = DateHelper.truncateDate(repay.getRepayDate());
            if (!this.isBetween(beginDate, endDate, subBeginDate) || this.isNotSubWithRepay(repay)) continue;
            list.insert(subBeginDate);
        }
        return list;
    }

    SortedObjectArray getSubBeginDateListWithPeriod(Date firstRateAdjustDate, int rateAdjustPeriod) {
        SortedObjectArray list = new SortedObjectArray();
        Calendar cal = Calendar.getInstance();
        cal.setTime(firstRateAdjustDate);
        int flashDay = cal.get(5);
        Calendar preCalendar = Calendar.getInstance();
        preCalendar.setTime(this._beginDate);
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.setTime(firstRateAdjustDate);
        while (this._beginDate.compareTo(nextCalendar.getTime()) >= 0) {
            nextCalendar = this.timeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod);
        }
        while (nextCalendar.getTime().compareTo(this._endDate) <= 0) {
            if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime())) {
                SubBeginDateInfo subDateInfo = new SubBeginDateInfo(DateHelper.truncateDate(nextCalendar.getTime()));
                list.insert(subDateInfo);
            }
            preCalendar.setTime(nextCalendar.getTime());
            nextCalendar = this.timeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod);
        }
        int size = this._repays.size();
        for (int i = 0; i < size; ++i) {
            RepaymentBillInfo repay = (RepaymentBillInfo)this._repays.get(i);
            Date subBeginDate = DateHelper.truncateDate(repay.getRepayDate());
            if (!this.isBetween(this._beginDate, this._endDate, subBeginDate) || this.isNotSubWithRepay(repay)) continue;
            SubBeginDateInfo subDateInfo = new SubBeginDateInfo(subBeginDate);
            subDateInfo.setOnlyPrinciple(true);
            list.insert(subDateInfo);
        }
        return list;
    }

    protected boolean hasRateInFlash(Date preDate, Date nextDate) {
        preDate = DateHelper.truncateDate(preDate);
        nextDate = DateHelper.truncateDate(nextDate);
        int iSize = this._intRateBases.size();
        for (int i = 0; i < iSize; ++i) {
            Date intRateDate = DateHelper.truncateDate(((IntRateBaseInfo)this._intRateBases.get(i)).getEffectiveDate());
            if (intRateDate.compareTo(preDate) <= 0 || intRateDate.compareTo(nextDate) > 0) continue;
            return true;
        }
        return false;
    }

    protected Calendar timeOfNextPeriod(Calendar nextCalendar, int flashDay, int rateAdjustPeriod) {
        Calendar tmp = (Calendar)nextCalendar.clone();
        if (flashDay >= 29) {
            tmp.add(2, rateAdjustPeriod);
            int days = DateHelper.daysOfMonth(tmp.get(1), tmp.get(2) + 1);
            if (days >= flashDay) {
                tmp.set(5, flashDay);
            } else {
                tmp.set(5, days);
            }
        } else {
            tmp.add(2, rateAdjustPeriod);
        }
        return tmp;
    }

    private boolean isAccordIntRate() {
        return this._loan.getIntRateType().equals(ACCORD_INTRATE_ID);
    }

    protected boolean isRepayWithInt(RepaymentBillInfo repayInfo) {
        return !repayInfo.isCalInt() || repayInfo.isRepayWithInt();
    }

    private boolean isBetween(Date beginDate, Date endDate, Date date) {
        return date.compareTo(beginDate) > 0 && date.compareTo(endDate) <= 0;
    }

    protected BigDecimal getTotalRepayAmtWithoutInt(Date subBeginDate) {
        BigDecimal repayTotalAmt = Variant.zeroBigDecimal;
        RepaymentBillInfo repayInfo = null;
        for (int i = this._repays.size() - 1; i >= 0; --i) {
            repayInfo = (RepaymentBillInfo)this._repays.get(i);
            if (this.isRepayWithInt(repayInfo) || repayInfo.getRepayDate().compareTo(subBeginDate) <= 0) continue;
            repayTotalAmt = repayTotalAmt.add(repayInfo.getRepayAmt());
        }
        return repayTotalAmt;
    }

    protected abstract Date getBeginDate(Date var1);

    protected abstract Date getEndDate(Date var1);

    protected abstract boolean isNotSubWithRepay(RepaymentBillInfo var1);

    protected abstract BigDecimal getSubIntPrinciple(Date var1);

    protected abstract boolean isCalPunishInt(Date var1);

    protected abstract int getIntCalType();
}

