/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;

public class DataConvert {
    public static Variant getDateTime(String data) {
        Variant var;
        try {
            Date d = Util.FMT_DATETIME.get().parse(data);
            var = new Variant(d, 12);
        }
        catch (ParseException e) {
            var = Variant.nullVariant;
        }
        return var;
    }

    public static Variant getDate(String data) {
        Date d = Util.stringToDate(data);
        return d == null ? Variant.nullVariant : new Variant(d, 12);
    }

    public static Variant getTime(String data) {
        Variant var;
        try {
            Date d = Util.FMT_TIME.get().parse(data);
            var = new Variant(d, 12);
        }
        catch (ParseException e) {
            var = Variant.nullVariant;
        }
        return var;
    }

    public static Variant getDay(String data) {
        Variant var;
        try {
            Date d = Util.FMT_MONTHDAY.get().parse(data);
            var = new Variant(d, 12);
        }
        catch (ParseException e) {
            var = Variant.nullVariant;
        }
        return var;
    }

    public static boolean isZeroTime(Date date) {
        long ms = date.getTime();
        return ms % 3600000L == 0L;
    }

    public static boolean isZeroSecond(Date date) {
        long ms = date.getTime();
        return ms % 60000L == 0L;
    }

    public static String getDateString(Date date) {
        return Util.FMT_DATE.get().format(date);
    }

    public static String getDateTimeString(Date date) {
        return Util.FMT_FULLDATETIME.get().format(date);
    }

    public static String getShortDateTimeString(Date date) {
        return Util.FMT_DATETIME.get().format(date);
    }

    public static IDataConvert[] getConvertArray(ExtDataSet ds) {
        IDataConvert[] convertArray = new IDataConvert[12];
        Book book = ds.getBook();
        SortedObjectArray cols = ds.getColumns();
        IDataConvert[] convert = new IDataConvert[cols.size()];
        for (int i = 0; i < convert.length; ++i) {
            ExtColumn col = (ExtColumn)cols.get(i);
            int colIndex = (Integer)col.getIndex().getValue();
            int dataType = col.getDataType();
            IDataConvert c = convertArray[dataType];
            if (c == null) {
                convertArray[dataType] = c = DataConvert.getIDataConvert(book, dataType);
            }
            convert[colIndex] = c;
        }
        return convert;
    }

    private static IDataConvert getIDataConvert(Book book, int dataType) {
        BASE_Convert convert;
        switch (dataType) {
            case 5: {
                convert = new DECIMAL_Convert(book);
                break;
            }
            case 10: {
                convert = new OBJECT_String(book);
                break;
            }
            case 6: {
                convert = new DATE_Convert(book);
                break;
            }
            case 7: {
                convert = new TIME_Convert(book);
                break;
            }
            case 8: {
                convert = new BOOLEAN_Convert(book);
                break;
            }
            case 9: {
                convert = new OBJECT_Convert(book);
                break;
            }
            case 0: {
                convert = new BYTE_Convert(book);
                break;
            }
            case 1: {
                convert = new SHORT_Convert(book);
                break;
            }
            case 2: {
                convert = new INT_Convert(book);
                break;
            }
            case 3: {
                convert = new LONG_Convert(book);
                break;
            }
            case 11: {
                convert = new FLOAT_Convert(book);
                break;
            }
            default: {
                convert = new DOUBLE_Convert(book);
            }
        }
        return convert;
    }

    public static class OBJECT_String
    extends BASE_Convert {
        OBJECT_String(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            return new Variant(data, 11);
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 11);
        }
    }

    public static class OBJECT_Convert
    extends BASE_Convert {
        OBJECT_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            return new Variant(data, 11);
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 17);
        }
    }

    public static class BOOLEAN_Convert
    extends BASE_Convert {
        BOOLEAN_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            return Boolean.parseBoolean(data) ? Variant.trueVariant : Variant.falseVariant;
        }

        @Override
        Variant _convertObject(Object data) {
            return (Boolean)data != false ? Variant.trueVariant : Variant.falseVariant;
        }
    }

    public static class TIME_Convert
    extends BASE_Convert {
        TIME_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            return this._book.getBufferedVariant(DataConvert.getDateTime(data));
        }

        @Override
        Variant _convertObject(Object data) {
            return this._book.getBufferedVariant(new Variant(data, 12));
        }
    }

    public static class DATE_Convert
    extends BASE_Convert {
        DATE_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            return this._book.getBufferedVariant(DataConvert.getDate(data));
        }

        @Override
        Variant _convertObject(Object data) {
            return this._book.getBufferedVariant(new Variant(data, 12));
        }
    }

    public static class DECIMAL_Convert
    extends BASE_Convert {
        DECIMAL_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(new BigDecimal(data), 10);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 10);
        }
    }

    public static class DOUBLE_Convert
    extends BASE_Convert {
        DOUBLE_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Double.parseDouble(data));
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 6);
        }
    }

    public static class FLOAT_Convert
    extends BASE_Convert {
        FLOAT_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Float.parseFloat(data));
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 5);
        }
    }

    public static class LONG_Convert
    extends BASE_Convert {
        LONG_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Long.valueOf(data), 4);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 4);
        }
    }

    public static class INT_Convert
    extends BASE_Convert {
        INT_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Integer.valueOf(data), 3);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 3);
        }
    }

    public static class SHORT_Convert
    extends BASE_Convert {
        SHORT_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Short.valueOf(data), 2);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 2);
        }
    }

    public static class BYTE_Convert
    extends BASE_Convert {
        BYTE_Convert(Book book) {
            super(book);
        }

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Byte.valueOf(data), 1);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return var;
        }

        @Override
        Variant _convertObject(Object data) {
            return new Variant(data, 1);
        }
    }

    public static abstract class BASE_Convert
    implements IDataConvert {
        private WeakHashSet _buffer;
        protected Book _book;

        protected BASE_Convert(Book book) {
            this._book = book;
            this._buffer = book.getDeps().getVariantBuffer();
        }

        abstract Variant _convertString(String var1);

        abstract Variant _convertObject(Object var1);

        @Override
        public Variant convertString(String data) {
            if (data == null) {
                return Variant.nullVariant;
            }
            return (Variant)this._buffer.add(this._convertString(data));
        }

        @Override
        public Variant convertObject(Object data) {
            if (data == null) {
                return Variant.nullVariant;
            }
            return (Variant)this._buffer.add(this._convertObject(data));
        }
    }

    public static interface IDataConvert {
        public Variant convertString(String var1);

        public Variant convertObject(Object var1);
    }
}

