/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtIndex;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtQSWriteFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtQSWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.FileFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.AbstractResultSetStub;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.QSResultSetStub;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.ResultSetFactory;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtDataSet
implements Comparable,
IExprNode,
Cloneable {
    private static final Logger log = Logger.getLogger(ExtDataSet.class);
    public static final ExtDataSet EMPTY_DATASET = new ExtDataSet(null, "", "", ExtDataSetType.TXT);
    protected String _name;
    private String _alias;
    private String _upperAlias;
    protected String _define;
    private Variant _varThis;
    protected SortedObjectArray _columns;
    private int _dataCols;
    protected Variant[][] _data;
    private int _dataRows;
    private int qsRows = -1;
    protected Book _book;
    private ExtRow _currRow;
    private ExtRow _nullRow;
    private ExtGroup _defGroup;
    private ExtGroup _currGroup;
    private ExtGroup _nullGroup;
    private boolean _isManualNullGroup;
    private boolean _isDynamicFields;
    private int _intersectMark;
    private Object[] _intersectBuffer;
    private SortedObjectArray _indexs;
    private String _meta;
    private ResultSet resultSetStub;
    private DataConvert.IDataConvert[] convert;

    public ExtDataSet(Book book, String name, String define, ExtDataSetType dt) {
        this._book = book;
        this.setName(name);
        this._upperAlias = name.toUpperCase(Locale.ENGLISH);
        this._define = dt.getPrefixedString(define);
        this._varThis = new Variant(this, 17);
        this._columns = new SortedObjectArray();
        this._indexs = new SortedObjectArray();
        this._intersectMark = Integer.MIN_VALUE;
    }

    public Object clone() {
        ExtDataSet ds = null;
        try {
            ds = (ExtDataSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ds;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtDataSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExtDataSet ds = (ExtDataSet)obj;
        return this._book == ds._book && this._name.equals(ds._name) && this._define.equals(ds._define);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void clear() {
        this._data = null;
        this._currGroup = null;
        this._currRow = null;
    }

    public boolean isEmpty() {
        if (this.qsRows > 0) {
            return this.getQsFileNames() == null || this.getQsFileNames().length == 0;
        }
        return this._data == null;
    }

    public void setManualNullGroup(boolean isManualNull) {
        this._isManualNullGroup = isManualNull;
    }

    public boolean isManualNullGroup() {
        return this._isManualNullGroup;
    }

    public boolean isDynamicFields() {
        return this._isDynamicFields;
    }

    public void setDynamicFields(boolean isDynamic) {
        this._isDynamicFields = isDynamic;
    }

    public void updateDataSet() {
        this._book.getDataSetManager().updateDataSet(this);
    }

    public String toString() {
        return this.getAlias();
    }

    public int compareTo(Object obj) {
        if (obj instanceof ExtDataSet) {
            return this._upperAlias.compareTo(((ExtDataSet)obj)._upperAlias);
        }
        return this._upperAlias.compareTo(((String)obj).toUpperCase(Locale.ENGLISH));
    }

    public Book getBook() {
        return this._book;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAlias() {
        if (StringUtil.isEmptyString((String)this._alias)) {
            return this._name;
        }
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
        this._upperAlias = this._alias.toUpperCase(Locale.ENGLISH);
    }

    public ExtDataSetType getDataSetType() {
        return ExtDataSetType.getExtDataSetType(this._define);
    }

    public String getDefine() {
        return this._define;
    }

    public void setDefine(String define) {
        this._define = define;
    }

    public String getMeta() {
        return this._meta;
    }

    public void setMeta(String meta) {
        this._meta = meta;
    }

    public int getQsRows() {
        return this.qsRows;
    }

    public void setQsRows(int qsRows) {
        this.qsRows = qsRows;
    }

    public boolean isUseQS() {
        return this.qsRows > 0;
    }

    public ExtGroup getCurrentGroup() {
        return this._currGroup;
    }

    public void setCurrentGroup(ExtGroup group) {
        this._currGroup = group;
    }

    public ExtRow getCurrentRow() {
        return this._currRow;
    }

    public void setCurrentRow(ExtRow row) {
        this._currRow = row;
    }

    public String[] getQsFileNames() {
        if (this.resultSetStub != null) {
            QSResultSetStub resultSetStubHandler = (QSResultSetStub)Proxy.getInvocationHandler(this.resultSetStub);
            return resultSetStubHandler.getQsFileNames().toArray(new String[0]);
        }
        return new String[0];
    }

    public ExtMetaInfo getMetaInfo() {
        if (this.resultSetStub != null) {
            AbstractResultSetStub resultSetStubHandler = (AbstractResultSetStub)Proxy.getInvocationHandler(this.resultSetStub);
            return resultSetStubHandler.getMetaInfo();
        }
        return null;
    }

    public void setResultSetStub(ResultSet resultSetStub) {
        this.resultSetStub = resultSetStub;
    }

    public void resetCurrent() {
        this._currGroup = this._isManualNullGroup ? this.getNullGroup() : null;
        this._currRow = null;
    }

    public void resumeCurrent() {
        if (this._currGroup == null) {
            this._currGroup = this.getDefaultGroup();
            if (this._currRow == null && this._currGroup != null) {
                this._currRow = this._currGroup.getFirstRow();
            }
        }
    }

    public ExtGroup getNullGroup() {
        if (this._nullGroup == null) {
            this._nullGroup = new ExtGroup(this, new ExtRow[0]);
        }
        return this._nullGroup;
    }

    public ExtRow getNullRow() {
        if (this._nullRow == null) {
            this._nullRow = new ExtRow(this, -1);
            this._nullRow.setValue(Variant.nullVariant);
        }
        return this._nullRow;
    }

    public SortedObjectArray getColumns() {
        return this._columns;
    }

    public ExtColumn[] getColumnsArray() {
        ExtColumn[] columns = new ExtColumn[this._columns.size()];
        for (int i = 0; i < columns.length; ++i) {
            ExtColumn col;
            columns[((Integer)col.getIndex().getValue()).intValue()] = col = (ExtColumn)this._columns.get(i);
        }
        return columns;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public ExtColumn addColumn(ExtColumn col) {
        return (ExtColumn)this._columns.insert(col);
    }

    public final Variant getColumnIndex(String alias) {
        Variant index = Variant.intMinValue;
        int pos = this._columns.search(alias);
        if (pos >= 0) {
            index = ((ExtColumn)this._columns.get(pos)).getIndex();
        }
        return index;
    }

    public final Variant getColumnIndexByName(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return Variant.intMinValue;
        }
        String alias = name.toUpperCase(Locale.ENGLISH);
        int size = this.getColumnCount();
        for (int i = 0; i < size; ++i) {
            ExtColumn col = (ExtColumn)this._columns.getAt(i);
            if (!col.getName().equals(name)) continue;
            alias = col.getUpperAlias();
            break;
        }
        return this.getColumnIndex(alias);
    }

    public int getDataColumns() {
        return this._dataCols;
    }

    public int getDataRows() {
        return this._dataRows;
    }

    public void setDataRows(int dataRows) {
        this._dataRows = dataRows;
    }

    public void clearQSInfo() {
        FileFactory.clearDsTemp(this);
        this.resultSetStub = null;
    }

    public void clearData() {
        this._data = null;
    }

    public String getQsFileName(int index) {
        return this.getQsFileNames()[index];
    }

    public void matchColumnAlias(Object[] oldCols) {
        for (int i = 0; i < oldCols.length; ++i) {
            ExtColumn oldCol = (ExtColumn)oldCols[i];
            int pos = this._columns.search(oldCol.getName().toUpperCase());
            if (pos >= 0) {
                ExtColumn newCol = (ExtColumn)this._columns.get(pos);
                oldCol.setIndex(newCol.getIndex());
                oldCol.setDataType(newCol.getDataType());
                continue;
            }
            oldCol.setIndex(Variant.intMinValue);
        }
        this._columns.setArray(oldCols, oldCols.length);
    }

    private DataConvert.IDataConvert[] getConvert() {
        if (this.convert == null) {
            this.convert = DataConvert.getConvertArray(this);
        }
        return this.convert;
    }

    public Variant[] getRowData(int rowIndex) {
        if (rowIndex < 0) {
            return new Variant[]{Variant.nullVariant};
        }
        if (this.isUseQS()) {
            DataConvert.IDataConvert[] convert = this.getConvert();
            try {
                Variant[] rowData = new Variant[convert.length];
                if (this.resultSetStub.absolute(rowIndex + 1)) {
                    Object[] data = (Object[])this.resultSetStub.getObject(-1);
                    for (int i = 0; i < convert.length; ++i) {
                        rowData[i] = convert[i].convertObject(data[i]);
                    }
                    return rowData;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._data[rowIndex];
    }

    public Variant[] getRowData(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return new Variant[]{Variant.nullVariant};
        }
        if (this.isUseQS()) {
            DataConvert.IDataConvert[] convert = this.getConvert();
            try {
                if (this.resultSetStub.absolute(rowIndex + 1)) {
                    Object data = this.resultSetStub.getObject(colIndex + 1);
                    Variant variant = convert[colIndex].convertObject(data);
                    return new Variant[]{variant};
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new Variant[]{this._data[rowIndex][colIndex]};
    }

    public Variant getVT(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return Variant.nullVariant;
        }
        if (this.isUseQS()) {
            DataConvert.IDataConvert[] convert = this.getConvert();
            try {
                if (this.resultSetStub.absolute(rowIndex + 1)) {
                    Object data = this.resultSetStub.getObject(colIndex + 1);
                    return convert[colIndex].convertObject(data);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._data[rowIndex][colIndex];
    }

    public Map<Integer, Variant> getRowData(Integer[] rowIndArr, int colInd, boolean sorted) {
        if (rowIndArr == null || rowIndArr.length == 0) {
            return null;
        }
        if (!sorted) {
            Arrays.sort((Object[])rowIndArr);
        }
        HashMap<Integer, Variant> result = new HashMap<Integer, Variant>(rowIndArr.length);
        for (int i = 0; i < rowIndArr.length; ++i) {
            Variant[] rowData = this.getRowData(rowIndArr[i], colInd);
            result.put(rowIndArr[i], rowData[0]);
        }
        return result;
    }

    public Object[] getRowObj(int rowIndex) {
        if (rowIndex < 0) {
            return new Variant[]{Variant.nullVariant};
        }
        DataConvert.IDataConvert[] convert = this.getConvert();
        if (this.isUseQS()) {
            try {
                Object[] rowData = new Object[convert.length];
                if (this.resultSetStub.absolute(rowIndex + 1)) {
                    for (int i = 0; i < convert.length; ++i) {
                        rowData[i] = this.resultSetStub.getObject(i + 1);
                    }
                    return rowData;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._data[rowIndex];
    }

    public Variant[][] getData() {
        return this._data;
    }

    public void copyDs(int[] arrSrcPos, int[] arrLength, ExtDataSet targetDs) {
        int rowCount = 0;
        IExtQSWriter qsWrapProxy = null;
        ArrayList<String> files = new ArrayList<String>(8);
        try {
            for (int i = 0; i < arrSrcPos.length; ++i) {
                for (int j = 0; j < arrLength[i]; ++j) {
                    if (rowCount++ % this.qsRows == 0) {
                        if (qsWrapProxy != null) {
                            qsWrapProxy.finish();
                        }
                        qsWrapProxy = ExtQSWriteFactory.getExtQSWrite(this.getMetaInfo());
                        files.add(qsWrapProxy.getQSFileName());
                    }
                    Object[] rowObj = this.getRowObj(arrSrcPos[i] + j);
                    if (qsWrapProxy == null) continue;
                    qsWrapProxy.write(rowObj);
                }
            }
            if (qsWrapProxy != null) {
                qsWrapProxy.finish();
            }
        }
        catch (Exception e) {
            log.error((Object)"errmsg", (Throwable)e);
        }
        ResultSet rs = ResultSetFactory.createQSResultSet(this.getMetaInfo(), -1, rowCount, files);
        targetDs.setResultSetStub(rs);
        targetDs.setQsRows(this.qsRows);
        targetDs.setCurrentGroup(this.getSubGroup(rowCount, targetDs));
    }

    public void setData(ObjectArray dataArray) {
        Variant[][] data;
        if (dataArray == null || dataArray.isEmpty()) {
            data = null;
        } else {
            int cols = ((Variant[])dataArray.get(0)).length;
            data = new Variant[dataArray.size()][cols];
            dataArray.toArray((Object[])data, 0);
        }
        this.setData(data);
    }

    public void setData(Variant[][] dataArray) {
        FileFactory.clearDsTemp(this);
        ExtColumn[] columnsArray = this.getColumnsArray();
        ExtMetaInfo metaInfo = this.createMetaInfo(columnsArray);
        if (dataArray == null || dataArray.length == 0) {
            this._dataCols = this.getColumnCount();
            if (this.isUseQS()) {
                this.resultSetStub = ResultSetFactory.createQSResultSet(metaInfo, this.qsRows, 0, null);
            } else {
                this._data = dataArray == null ? new Variant[0][this._dataCols] : dataArray;
            }
        } else {
            this._dataCols = dataArray[0].length;
            this._dataRows = dataArray.length;
            if (this.isUseQS()) {
                this.writeQSData(dataArray, metaInfo, columnsArray);
            } else {
                this._data = dataArray;
            }
        }
        this.setCurrentGroup();
    }

    public void setCurrentGroup() {
        ExtGroup defGrp = this.getDefaultGroup();
        this.setCurrentGroup(defGrp);
        if (defGrp != null) {
            this.setCurrentRow(defGrp.getFirstRow());
            this._intersectBuffer = new Object[defGrp.size()];
        }
    }

    private void writeQSData(Variant[][] dataArray, ExtMetaInfo metaInfo, ExtColumn[] columnsArray) {
        IExtQSWriter extQSWriter = null;
        ArrayList<String> files = new ArrayList<String>(8);
        try {
            int i;
            for (i = 0; i < dataArray.length; ++i) {
                Object[] row = new Object[columnsArray.length];
                for (int j = 0; j < columnsArray.length; ++j) {
                    row[j] = dataArray[i][j].getValue();
                }
                if (i % this.qsRows == 0) {
                    if (extQSWriter != null) {
                        extQSWriter.finish();
                    }
                    extQSWriter = ExtQSWriteFactory.getExtQSWrite(metaInfo);
                    files.add(extQSWriter.getQSFileName());
                }
                extQSWriter.write(row);
            }
            if (extQSWriter != null) {
                extQSWriter.finish();
            }
            this.resultSetStub = ResultSetFactory.createQSResultSet(metaInfo, this.qsRows, i, files);
        }
        catch (Exception e) {
            log.error((Object)"errmsg", (Throwable)e);
        }
    }

    private ExtMetaInfo createMetaInfo(ExtColumn[] columnsArray) {
        ExtMetaInfo metaInfo = new ExtMetaInfo();
        for (int i = 0; i < columnsArray.length; ++i) {
            ExtColumn column = columnsArray[i];
            metaInfo.addField(column.getAlias(), column.getName(), column.getOrigType());
        }
        return metaInfo;
    }

    public ExtGroup getDefaultGroup() {
        if (this._defGroup == null) {
            if (this.isEmpty()) {
                this._dataCols = this._columns.size();
            } else {
                ExtRow[] rows = new ExtRow[this._dataRows];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = new ExtRow(this, i);
                }
                this._defGroup = new ExtGroup(this, rows);
            }
        }
        return this._defGroup;
    }

    public ExtGroup getSubGroup(int dataRows, ExtDataSet ds) {
        ExtRow[] rows = new ExtRow[dataRows];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = new ExtRow(ds, i);
        }
        return new ExtGroup(ds, rows);
    }

    Variant[] select(ExtGroup group, ExprContext ctx, Variant selExp) {
        Variant[] values = new Variant[group.size()];
        ExtRow[] rows = group.getRows();
        if (selExp.getVt() == 3) {
            int colIndex = (Integer)selExp.getValue();
            if (group.getDataSet().isUseQS()) {
                HashMap<Integer, Integer> rowIndMap = new HashMap<Integer, Integer>(group.size());
                int i = group.getFrom();
                int end = group.getTo();
                int v = 0;
                while (i < end) {
                    rowIndMap.put(v, rows[i].index());
                    ++i;
                    ++v;
                }
                Map<Integer, Variant> rowData = this.getRowData(rowIndMap.values().toArray(new Integer[0]), colIndex, false);
                int i2 = group.getFrom();
                int end2 = group.getTo();
                int v2 = 0;
                while (i2 < end2) {
                    values[v2] = rowData.get(rowIndMap.get(v2));
                    ++i2;
                    ++v2;
                }
            } else {
                int i = group.getFrom();
                int end = group.getTo();
                int v = 0;
                while (i < end) {
                    values[v] = this._data[rows[i].index()][colIndex];
                    ++i;
                    ++v;
                }
            }
        } else {
            Expr expr = (Expr)selExp.getValue();
            ICalculable owner = ctx.getExprOwner();
            boolean traceMode = ctx.isTraceMode();
            ctx.setTraceMode(false);
            Book book = ctx.getBook();
            int i = group.getFrom();
            int end = group.getTo();
            int v = 0;
            while (i < end) {
                this._currRow = rows[i];
                Variant value = expr.execute(ctx, owner).getVariant();
                values[v] = book.getBufferedVariant(value);
                ++i;
                ++v;
            }
            ctx.setTraceMode(traceMode);
        }
        return values;
    }

    ExtGroup distinct(ExtGroup srcGroup, ExprContext ctx, Object[] disExps) {
        if (srcGroup.isNullGroup()) {
            return srcGroup;
        }
        Object[] rows = srcGroup.getRows();
        Object[] exps = new Object[disExps.length - 2];
        for (int i = 2; i < disExps.length; ++i) {
            Variant disExp = (Variant)disExps[i];
            exps[i - 2] = disExp.getValue();
        }
        ObjectArray keep = new ObjectArray(srcGroup.size());
        Variant[] values = srcGroup.getValues();
        boolean enumGroup = values.length == 1;
        Variant[] aPrev = new Variant[exps.length];
        ICalculable owner = ctx.getExprOwner();
        int i = srcGroup.getFrom();
        int end = srcGroup.getTo();
        int v = srcGroup.getValueFrom();
        while (i < end) {
            ExtRow row = rows[i];
            boolean equals = true;
            boolean traceMode = ctx.isTraceMode();
            ctx.setTraceMode(false);
            for (int j = 0; j < aPrev.length; ++j) {
                Variant var;
                Object disExp = exps[j];
                Variant varPrev = aPrev[j];
                if (disExp instanceof Integer) {
                    var = this.getVT(row.index(), (Integer)disExp);
                } else {
                    this._currRow = row;
                    var = ((Expr)disExp).execute(ctx, owner);
                }
                if (equals && varPrev != null && var.equals(varPrev)) continue;
                equals = false;
                aPrev[j] = var;
            }
            ctx.setTraceMode(traceMode);
            if (!equals) {
                row.setValue(values[enumGroup ? 0 : v]);
                keep.append(row);
            }
            ++i;
            ++v;
        }
        int keepSize = keep.size();
        if (keepSize < srcGroup.size()) {
            rows = new ExtRow[keepSize];
            keep.toArray(rows, 0);
            ExtGroup group = new ExtGroup(srcGroup.getDataSet(), (ExtRow[])rows);
            Variant[] values2 = new Variant[keepSize];
            for (int i2 = 0; i2 < rows.length; ++i2) {
                values2[i2] = ((ExtRow)rows[i2]).getActualValue();
            }
            group.setValues(values2);
            return group;
        }
        return srcGroup;
    }

    Variant field(ExprContext ctx, Variant selExp, ExtRow currentRow) {
        Variant ret;
        if (selExp.getVt() == 3) {
            int colIndex = (Integer)selExp.getValue();
            ret = this.getVT(currentRow.index(), colIndex);
        } else {
            Expr expr = (Expr)selExp.getValue();
            ICalculable owner = ctx.getExprOwner();
            this._currRow = currentRow;
            boolean traceMode = ctx.isTraceMode();
            ctx.setTraceMode(false);
            ret = expr.execute(ctx, owner);
            ctx.setTraceMode(traceMode);
        }
        return ret;
    }

    public Variant field(int colIndex) {
        return this.getVT(this._currRow.index(), colIndex);
    }

    public Variant field(ExtRow row, int colIndex) {
        return this.getVT(row.index(), colIndex);
    }

    public Variant field(int rowIndex, int colIndex) {
        return this.getVT(rowIndex, colIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant calc(ExprContext ctx, Variant selExp) throws SyntaxErrorException {
        if (this._currRow == null || this._currRow.isNullRow()) {
            return Variant.nullVariant;
        }
        int vt = selExp.getVt();
        if (vt == 3) {
            int colIndex = (Integer)selExp.getValue();
            return this.getVT(this._currRow.index(), colIndex);
        }
        if (vt == 17) {
            ExtGroup group = this._currGroup;
            ExtRow row = this._currRow;
            try {
                Variant variant = Expr.execute(ctx, selExp);
                return variant;
            }
            finally {
                this._currGroup = group;
                this._currRow = row;
            }
        }
        return selExp;
    }

    public ExtGroup intersect(ExtGroup g, ExtGroup g2, ExtRow oriRow) {
        int maxCount = g.size();
        if (maxCount > g2.size()) {
            ExtGroup t = g;
            g = g2;
            g2 = t;
            maxCount = g.size();
        }
        ObjectArray al = null;
        boolean oriKeeped = false;
        if (maxCount > 0) {
            int i;
            int mark = this._intersectMark++;
            int end = g.getTo();
            ExtRow[] rows = g.getRows();
            for (i = g.getFrom(); i < end; ++i) {
                rows[i].setMark(mark);
            }
            al = new ObjectArray(this._intersectBuffer, 0);
            int count = 0;
            rows = g2.getRows();
            end = g2.getTo();
            for (i = g2.getFrom(); i < end; ++i) {
                ExtRow row = rows[i];
                if (row.getMark() != mark) continue;
                al.append(row);
                if (row == oriRow) {
                    oriKeeped = true;
                }
                if (++count == maxCount) break;
            }
        }
        if (al == null || al.isEmpty()) {
            return this.getNullGroup();
        }
        Object[] rows = new ExtRow[al.size()];
        al.toArray(rows, 0);
        ExtGroup group = new ExtGroup(this, (ExtRow[])rows);
        if (oriKeeped) {
            group.setMarkRow(oriRow);
        }
        return group;
    }

    ExtIndex getExtIndex(int[] indexCols, boolean create) {
        long key = 0L;
        int len = Math.min(8, indexCols.length);
        for (int i = 0; i < len; ++i) {
            key |= ((long)indexCols[i] & 0xFFL) << (7 - i << 3);
        }
        ExtIndex ei = null;
        int pos = this._indexs.search(key);
        if (pos >= 0) {
            ei = (ExtIndex)this._indexs.get(pos);
        } else if (create) {
            int upIndex = -(pos + 1);
            if (upIndex < this._indexs.size()) {
                ExtIndex e = (ExtIndex)this._indexs.get(upIndex);
                int[] existCols = e.getIndexCols();
                boolean equals = true;
                int cSize = Math.min(existCols.length, indexCols.length);
                for (int c = 0; c < cSize; ++c) {
                    if (existCols[c] == indexCols[c]) continue;
                    equals = false;
                    break;
                }
                if (equals) {
                    ei = e;
                }
            }
            if (ei == null) {
                for (int i = upIndex - 1; i >= 0; --i) {
                    ExtIndex e = (ExtIndex)this._indexs.get(i);
                    int[] existCols = e.getIndexCols();
                    boolean equals = true;
                    int cSize = Math.min(existCols.length, indexCols.length);
                    for (int c = 0; c < cSize; ++c) {
                        if (existCols[c] == indexCols[c]) continue;
                        equals = false;
                        break;
                    }
                    if (!equals) continue;
                    ei = (ExtIndex)this._indexs.removeByPos(i);
                    ei.init(this, indexCols, key);
                    this._indexs.insert(ei);
                    break;
                }
                if (ei == null) {
                    ei = new ExtIndex(this, indexCols, key);
                    this._indexs.insert(ei);
                }
            }
        }
        return ei;
    }

    public Variant getVarThis() {
        return this._varThis;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant var = ctx.isTraceMode() ? new TraceVariant(this._varThis, ctx) : this._varThis;
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this.getAlias();
    }

    @Override
    public int getExprType() {
        return 524288;
    }

    static {
        EMPTY_DATASET.setCurrentGroup(EMPTY_DATASET.getNullGroup());
        EMPTY_DATASET.setManualNullGroup(true);
    }
}

