/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.DirUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileSysUtil {
    private static Logger log = LogUtil.getPackageLogger(FileSysUtil.class);
    public static final String JVM_DIRECTORY_PATH_NAME = "QingAnalysis.TempDir";
    private static String BASE_DIRECTORY = null;

    public static String getBaseDirectory() {
        return BASE_DIRECTORY;
    }

    public static String getAbsoluteFilePath(String path) {
        return BASE_DIRECTORY + path;
    }

    public static File createRelativeDir(String relativePath) {
        String absoluteFilePath = FileSysUtil.getAbsoluteFilePath(relativePath);
        return FileSysUtil.createAbsolutePathDir(absoluteFilePath);
    }

    public static File createAbsolutePathDir(String absoluteFilePath) {
        File file = new File(FilenameUtils.normalize((String)absoluteFilePath));
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    private static void moveTempDirFile() {
        String folder = System.getProperty("java.io.tmpdir");
        String tempDir = folder.endsWith(File.separator) ? folder + "QingAnalysisTempDirectory" : folder + File.separator + "QingAnalysisTempDirectory";
        File dir = new File(FilenameUtils.normalize((String)tempDir));
        if (!dir.exists() || !dir.isDirectory() || tempDir.equals(BASE_DIRECTORY)) {
            return;
        }
        try {
            DirUtil.moveDir(tempDir, BASE_DIRECTORY);
        }
        catch (IOException e) {
            log.error((Object)("\u4ece" + tempDir + "\u8f6c\u79fb\u5230" + BASE_DIRECTORY + "\u5931\u8d25"), (Throwable)e);
        }
    }

    static {
        BASE_DIRECTORY = System.getProperty(JVM_DIRECTORY_PATH_NAME);
        if (BASE_DIRECTORY == null || "".equals(BASE_DIRECTORY.trim())) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("qinganAnalysisTempDirNotFound", "\u672a\u627e\u5230QingAnalysis.TempDir\uff0c\u8bf7\u5728\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e"));
        }
        File file = new File(FilenameUtils.normalize((String)BASE_DIRECTORY));
        if (file.isDirectory() && !file.exists()) {
            file.mkdirs();
        }
        FileSysUtil.moveTempDirFile();
    }
}

