/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class LocalExtFileWriter
implements IExtFileWriter {
    private static final Logger logger = LogUtil.getPackageLogger(LocalExtFileWriter.class);
    private File _file;

    public LocalExtFileWriter(String filePath) {
        this._file = new File(FilenameUtils.normalize((String)filePath));
    }

    @Override
    public ExtOutputStream getOutputStream() throws IOException {
        File parentFile = this._file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (this._file.exists()) {
            throw new IOException("Duplicate Key :" + this._file.getName());
        }
        return new ExtOutputStream(new BufferedOutputStream(new FileOutputStream(this._file), 1024));
    }

    @Override
    public void close(Exception e) {
        if (e != null && !this._file.delete()) {
            logger.warn((Object)(this._file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
        }
    }
}

