/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.exception.FieldDuplicateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ExtMetaInfo {
    public static final String ROWID = "_ROWID_";
    private List<String> fieldNames = new ArrayList<String>(8);
    private List<String> fieldDisplayNames = new ArrayList<String>(8);
    private List<Integer> fieldDataTypes = new ArrayList<Integer>(8);

    public ExtMetaInfo() {
    }

    public ExtMetaInfo(List<String> fieldNames, List<String> fieldDisplayNames, List<Integer> fieldDataTypes) {
        this.fieldNames = fieldNames;
        this.fieldDisplayNames = fieldDisplayNames;
        this.fieldDataTypes = fieldDataTypes;
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public List<Integer> getFieldDataTypes() {
        if (this.fieldDataTypes == null) {
            return null;
        }
        return Collections.unmodifiableList(this.fieldDataTypes);
    }

    public void addField(String fieldName, String fieldDisplayName, Integer dataType) {
        if (this.fieldNames.contains(fieldName)) {
            throw new FieldDuplicateException(fieldName);
        }
        this.fieldNames.add(fieldName == null ? "" : fieldName);
        this.fieldDisplayNames.add(fieldDisplayName == null ? "" : fieldDisplayName);
        if (dataType == null) {
            this.fieldDataTypes.add(12);
        } else {
            this.fieldDataTypes.add(dataType);
        }
    }

    public int getSize() {
        return this.fieldNames.size();
    }

    public String getFieldName(int index) {
        return this.fieldNames.get(index);
    }

    public String getFieldDisplayName(int index) {
        return this.fieldDisplayNames.get(index);
    }

    public Integer getFieldDataType(int index) {
        return this.fieldDataTypes.get(index);
    }

    public ExtMetaInfo initSelectedField(List<Integer> interestingFieldIndexs, Set<String> fields) {
        interestingFieldIndexs.clear();
        boolean hasROWID = false;
        Iterator<String> fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            int idx;
            String fieldName = fieldIterator.next();
            if (fieldName.equals(ROWID)) {
                hasROWID = true;
            }
            if ((idx = this.fieldNames.indexOf(fieldName)) >= 0) {
                interestingFieldIndexs.add(idx);
                continue;
            }
            fieldIterator.remove();
        }
        ExtMetaInfo itertorExtMetaInfo = new ExtMetaInfo();
        if (interestingFieldIndexs.size() > 0) {
            for (int index = 0; index < interestingFieldIndexs.size(); ++index) {
                int fieldIndex = interestingFieldIndexs.get(index);
                itertorExtMetaInfo.addField(this.fieldNames.get(fieldIndex), this.getFieldDisplayName(fieldIndex), this.getFieldDataType(fieldIndex));
            }
        }
        if (hasROWID) {
            itertorExtMetaInfo.addField(ROWID, ROWID, 4);
        }
        Collections.sort(interestingFieldIndexs);
        return itertorExtMetaInfo;
    }
}

