/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.IExtDataWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.ExtDataPersistenceException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.ExtStorageWriterWraper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import q.storage.columnar.api.impl.QingStorageRecord;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.io.api.Binary;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataSourceWriter
implements IExtDataWriter {
    private static Map<Integer, RecordSetter> RECORDSETTERMAP = new HashMap<Integer, RecordSetter>();
    public static final int BIGDECIMAL_LENGTH = 16;
    public static final String QS = ".QS";
    public static final String EXTRAMETA_DATA_KEY = ".metadata.";
    private ExtStorageWriterWraper _recordWriter;
    private boolean _hasData;
    private ExtMetaInfo _extMetaInfo;
    private IExtFile _dataFile;
    private MessageType _recordSchema;
    private List<Integer> _tempFieldTypesForWrite;
    private int _tempFieldTypesForWriteSize;
    private boolean finishedWriteData = false;

    public QSDataSourceWriter(IExtFile dataFile) {
        this._dataFile = dataFile;
    }

    @Override
    public void start(ExtMetaInfo extMetaInfo) {
        this._extMetaInfo = extMetaInfo;
        this._tempFieldTypesForWrite = extMetaInfo.getFieldDataTypes();
        this._tempFieldTypesForWriteSize = this._tempFieldTypesForWrite.size();
    }

    private MessageType createMessageType() {
        if (this._extMetaInfo == null) {
            return null;
        }
        PrimitiveType[] columns = new PrimitiveType[this._tempFieldTypesForWriteSize];
        for (int index = 0; index < this._tempFieldTypesForWriteSize; ++index) {
            Integer dataType = this._tempFieldTypesForWrite.get(index);
            String fieldId = this.getFieldID(index);
            columns[index] = 91 == dataType || 92 == dataType || 93 == dataType || 4 == dataType || -6 == dataType || 5 == dataType || -5 == dataType ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, fieldId) : (2 == dataType || 6 == dataType || 8 == dataType || 7 == dataType || 3 == dataType ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 16, fieldId) : new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, fieldId));
        }
        return new MessageType("envelope", (Type[])columns);
    }

    private String getFieldID(int index) {
        return index + "";
    }

    private void start() throws ExtDataPersistenceException {
        if (this._recordWriter != null) {
            return;
        }
        if (this._extMetaInfo == null) {
            throw new ExtDataPersistenceException("no metainfo");
        }
        this._recordSchema = this.createMessageType();
        this._recordWriter = new ExtStorageWriterWraper(this._dataFile, this._recordSchema, this._extMetaInfo);
    }

    @Override
    public void writeData(Object[] row) throws ExtDataPersistenceException, InterruptedException {
        if (this._recordWriter == null) {
            this.start();
        }
        this._hasData = true;
        QingStorageRecord record = this.createQingStorageRecord(row);
        try {
            this._recordWriter.write(record);
        }
        catch (Exception e) {
            throw new ExtDataPersistenceException(e);
        }
    }

    protected QingStorageRecord createQingStorageRecord(Object[] row) throws ExtDataPersistenceException {
        QingStorageRecord record = new QingStorageRecord((GroupType)this._recordSchema);
        for (int index = 0; index < this._tempFieldTypesForWriteSize; ++index) {
            Integer dataType;
            RecordSetter recordSetter;
            Object oValue = row[index];
            if (oValue == null || (recordSetter = RECORDSETTERMAP.get(dataType = this._tempFieldTypesForWrite.get(index))) == null) continue;
            recordSetter.addRecord(record, index, oValue);
        }
        return record;
    }

    @Override
    public void finishWriteData() throws ExtDataPersistenceException {
        if (this.finishedWriteData) {
            return;
        }
        this.finishedWriteData = true;
        ExtDataPersistenceException dataSourcePersistenceException = null;
        if (!this._hasData) {
            try {
                this.start();
            }
            catch (ExtDataPersistenceException e) {
                dataSourcePersistenceException = e;
            }
        }
        if (this._recordWriter != null) {
            this._recordWriter.finishWriteData();
        }
        if (dataSourcePersistenceException != null) {
            throw dataSourcePersistenceException;
        }
    }

    @Override
    public void close(Exception exception) {
        if (this._recordWriter != null) {
            this._recordWriter.close(exception);
            this._recordWriter = null;
        }
    }

    static {
        DateRecordSetter dateRecordSetter = new DateRecordSetter();
        RECORDSETTERMAP.put(91, dateRecordSetter);
        RECORDSETTERMAP.put(92, dateRecordSetter);
        RECORDSETTERMAP.put(93, dateRecordSetter);
        IntRecordSetter intRecordSetter = new IntRecordSetter();
        RECORDSETTERMAP.put(4, intRecordSetter);
        RECORDSETTERMAP.put(-6, intRecordSetter);
        RECORDSETTERMAP.put(5, intRecordSetter);
        RECORDSETTERMAP.put(-5, intRecordSetter);
        NumberRecordSetter numberRecordSetter = new NumberRecordSetter();
        RECORDSETTERMAP.put(2, numberRecordSetter);
        RECORDSETTERMAP.put(6, numberRecordSetter);
        RECORDSETTERMAP.put(8, numberRecordSetter);
        RECORDSETTERMAP.put(7, numberRecordSetter);
        RECORDSETTERMAP.put(3, numberRecordSetter);
        StringRecordSetter stringRecordSetter = new StringRecordSetter();
        RECORDSETTERMAP.put(16, stringRecordSetter);
        RECORDSETTERMAP.put(-7, stringRecordSetter);
        RECORDSETTERMAP.put(1, stringRecordSetter);
        RECORDSETTERMAP.put(12, stringRecordSetter);
        RECORDSETTERMAP.put(-15, stringRecordSetter);
        RECORDSETTERMAP.put(-9, stringRecordSetter);
        RECORDSETTERMAP.put(-1, stringRecordSetter);
        RECORDSETTERMAP.put(-16, stringRecordSetter);
        RECORDSETTERMAP.put(-2, stringRecordSetter);
        RECORDSETTERMAP.put(-3, stringRecordSetter);
        RECORDSETTERMAP.put(-4, stringRecordSetter);
        RECORDSETTERMAP.put(2004, stringRecordSetter);
        RECORDSETTERMAP.put(2005, stringRecordSetter);
    }

    static class StringRecordSetter
    implements RecordSetter {
        StringRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) {
            String value = "";
            value = oValue instanceof byte[] ? new String((byte[])oValue, StandardCharsets.ISO_8859_1) : oValue.toString();
            if (value.length() > 0) {
                record.add(index, value);
            }
        }
    }

    static class NumberRecordSetter
    implements RecordSetter {
        NumberRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws ExtDataPersistenceException {
            BigDecimal v = null;
            if (oValue instanceof BigDecimal) {
                v = (BigDecimal)oValue;
            } else if (oValue instanceof Number) {
                v = new BigDecimal(oValue.toString());
            } else {
                throw new ExtDataPersistenceException("Expected " + oValue + " to be a Number,but a " + oValue.getClass().getName());
            }
            byte[] encode = null;
            try {
                encode = QingStorageUtils.encodeBigDecimal((BigDecimal)v, (int)16);
            }
            catch (Exception e) {
                throw new ExtDataPersistenceException("can not encode bigDecimal to byte[]:" + oValue, e);
            }
            record.add(index, Binary.fromConstantByteArray((byte[])encode));
        }
    }

    static class IntRecordSetter
    implements RecordSetter {
        IntRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws ExtDataPersistenceException {
            Long v = null;
            try {
                if (oValue instanceof Long) {
                    v = (Long)oValue;
                } else if (oValue instanceof Short) {
                    v = ((Short)oValue).longValue();
                } else if (oValue instanceof Integer) {
                    v = ((Integer)oValue).longValue();
                } else if (oValue instanceof BigInteger) {
                    v = ((BigInteger)oValue).longValue();
                } else if (oValue instanceof Byte) {
                    v = ((Byte)oValue).longValue();
                } else if (oValue instanceof BigDecimal) {
                    v = ((BigDecimal)oValue).longValue();
                }
            }
            catch (Exception e) {
                throw new ExtDataPersistenceException("can not encode bigDecimal to byte[]:" + oValue, e);
            }
            if (v == null) {
                throw new ExtDataPersistenceException("Expected " + oValue + " to be a Number, but a " + oValue.getClass().getName());
            }
            record.add(index, v.longValue());
        }
    }

    static class DateRecordSetter
    implements RecordSetter {
        DateRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws ExtDataPersistenceException {
            if (oValue instanceof Long) {
                record.add(index, ((Long)oValue).longValue());
            } else if (oValue instanceof Date) {
                long value = ((Date)oValue).getTime();
                record.add(index, value);
            } else if (oValue instanceof Calendar) {
                long value = ((Calendar)oValue).getTimeInMillis();
                record.add(index, value);
            } else {
                throw new ExtDataPersistenceException("Expected " + oValue + " to be a Date,but a " + oValue.getClass().getName() + " at column index:" + index);
            }
        }
    }

    static interface RecordSetter {
        public void addRecord(QingStorageRecord var1, int var2, Object var3) throws ExtDataPersistenceException;
    }
}

