/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.resultset;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.AbstractExtDataSetPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetColPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetRowPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.AbstractResultSetStub;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.QSResultSetVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.ResultSetMetaDataStub;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QSResultSetStub
extends AbstractResultSetStub {
    private final int qsRows;
    private HashMap<CachePageKey, SoftReference<ExtDataSetRowPage>> cacheRowPages;
    private HashMap<CachePageKey, SoftReference<ExtDataSetColPage>> cacheColPages;
    private static final String CACHE_KEY_SEPARATOR = "#";
    private List<String> qsFileNames;

    public QSResultSetStub(ExtMetaInfo metaInfo, int qsRows, int total, List<String> qsFileNames) {
        this.metaInfo = metaInfo;
        this.totalRows = total;
        this.resultSetMetaData = ResultSetMetaDataStub.createStub(metaInfo);
        this.qsRows = qsRows;
        this.qsFileNames = qsFileNames;
    }

    public String getQsFileNames(int index) {
        return this.qsFileNames.get(index);
    }

    public List<String> getQsFileNames() {
        return this.qsFileNames;
    }

    public int getQsRows() {
        return this.qsRows;
    }

    @Override
    public AbstractExtDataSetPage searchNextPage(int rowIndex, int colIndex) {
        AbstractExtDataSetPage page;
        if (colIndex == -1 ? (page = this.getRowPage(rowIndex)) != null : (page = this.getColPage(rowIndex, colIndex)) != null) {
            return page;
        }
        QSResultSetVisitor resultSetVisitor = QSResultSetVisitor.newVisitor(rowIndex, this, this.metaInfo, colIndex);
        return resultSetVisitor.getPage();
    }

    @Override
    protected void close() {
        this.cacheRowPages = null;
        this.cacheColPages = null;
    }

    private ExtDataSetColPage getColPage(int rowIndex, int colIndex) {
        if (this.cacheColPages != null) {
            Set<Map.Entry<CachePageKey, SoftReference<ExtDataSetColPage>>> entrySet = this.cacheColPages.entrySet();
            for (Map.Entry<CachePageKey, SoftReference<ExtDataSetColPage>> entry : entrySet) {
                ExtDataSetColPage page;
                CachePageKey key = entry.getKey();
                if (colIndex < key.getStartCol() || colIndex > key.getEndCol() || rowIndex < key.getStartRow() || rowIndex >= key.getEndRow()) continue;
                if (entry.getValue() == null || (page = entry.getValue().get()) == null) break;
                return page;
            }
        }
        return null;
    }

    private ExtDataSetRowPage getRowPage(int rowIndex) {
        if (this.cacheRowPages != null) {
            Set<Map.Entry<CachePageKey, SoftReference<ExtDataSetRowPage>>> entrySet = this.cacheRowPages.entrySet();
            for (Map.Entry<CachePageKey, SoftReference<ExtDataSetRowPage>> entry : entrySet) {
                ExtDataSetRowPage page;
                CachePageKey key = entry.getKey();
                if (rowIndex < key.getStartRow() || rowIndex >= key.getEndRow()) continue;
                if (entry.getValue() == null || (page = entry.getValue().get()) == null) break;
                return page;
            }
        }
        return null;
    }

    public void appendToCachePages(AbstractExtDataSetPage page, int startCol, int endCol, boolean isRow) {
        int startRow = page.getStart();
        int endRow = page.getEnd();
        CachePageKey key = new CachePageKey(startRow, endRow, startCol, endCol);
        if (isRow) {
            if (this.cacheRowPages == null) {
                this.cacheRowPages = new HashMap(8);
            }
            this.cacheRowPages.put(key, new SoftReference<ExtDataSetRowPage>((ExtDataSetRowPage)page));
        } else {
            if (this.cacheColPages == null) {
                this.cacheColPages = new HashMap(8);
            }
            this.cacheColPages.put(key, new SoftReference<ExtDataSetColPage>((ExtDataSetColPage)page));
        }
    }

    private static class CachePageKey {
        int startRow;
        int endRow;
        int startCol;
        int endCol;

        public CachePageKey(int startRow, int endRow, int startCol, int endCol) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.startCol = startCol;
            this.endCol = endCol;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public void setEndRow(int endRow) {
            this.endRow = endRow;
        }

        public int getStartCol() {
            return this.startCol;
        }

        public void setStartCol(int startCol) {
            this.startCol = startCol;
        }

        public int getEndCol() {
            return this.endCol;
        }

        public void setEndCol(int endCol) {
            this.endCol = endCol;
        }

        public String toString() {
            return this.startRow + QSResultSetStub.CACHE_KEY_SEPARATOR + this.endRow + QSResultSetStub.CACHE_KEY_SEPARATOR + this.startCol + QSResultSetStub.CACHE_KEY_SEPARATOR + this.endCol;
        }
    }
}

