/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.resultset;

import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.AbstractExtDataSetPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetColPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetRowPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.FileFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtTempFileType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.api.IExtDataIterator;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.AbstractExtDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.QSDataSourceVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.AbstractResultSetStub;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.QSResultSetStub;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QSResultSetVisitor {
    private static final Logger log = Logger.getLogger(QSResultSetVisitor.class);
    private QSResultSetStub resultSetStub;
    private IExtDataIterator dataIterator;
    private Set<String> fields;
    private int curRow;
    private int endRow;
    private ExtMetaInfo metaInfo;
    private int colIndex;

    public static QSResultSetVisitor newVisitor(int fromRow, AbstractResultSetStub resultSetStub, ExtMetaInfo metaInfo, int colIndex) {
        return new QSResultSetVisitor(fromRow, resultSetStub, metaInfo, colIndex);
    }

    private QSResultSetVisitor(int fromRow, AbstractResultSetStub resultSetStub, ExtMetaInfo metaInfo, int colIndex) {
        this.resultSetStub = (QSResultSetStub)resultSetStub;
        this.metaInfo = metaInfo;
        this.colIndex = colIndex;
        this.calcRowInterval(fromRow);
    }

    private void calcRowInterval(int fromRow) {
        int qsRows = this.resultSetStub.getQsRows();
        int totalRows = this.resultSetStub.getTotalRows();
        if (this.colIndex == -1) {
            this.curRow = fromRow / qsRows * qsRows;
            this.endRow = Math.min(this.curRow + qsRows, totalRows);
        } else {
            this.curRow = fromRow / ExtConst.PAGE_MAX_CELLS * ExtConst.PAGE_MAX_CELLS;
            this.endRow = Math.min(this.curRow + ExtConst.PAGE_MAX_CELLS, totalRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractExtDataSetPage getPage() {
        AbstractExtDataSetPage page;
        int start = this.curRow;
        int cols = 0;
        if (this.colIndex == -1) {
            page = new ExtDataSetRowPage(start, this.endRow);
            try {
                cols = this.resultSetStub.getResultSetMetaData().getColumnCount();
            }
            catch (SQLException sQLException) {}
        } else {
            page = new ExtDataSetColPage(start, this.endRow, this.colIndex);
            cols = 1;
        }
        page.setMetaInfo(this.metaInfo);
        Object[][] objData = new Object[page.getRowCount()][cols];
        try {
            int rowIndex = start;
            while (this.hasNextRow(rowIndex, page)) {
                int row = rowIndex - start;
                Map<String, Object> objectMap = this.dataIterator.nextRow();
                if (cols == 1) {
                    Object data;
                    String fieldName = this.metaInfo.getFieldName(this.colIndex).toUpperCase(Locale.ENGLISH);
                    objData[row][0] = data = objectMap.get(fieldName);
                } else {
                    for (int i = 0; i < cols; ++i) {
                        Object data;
                        String fieldName = this.metaInfo.getFieldName(i).toUpperCase(Locale.ENGLISH);
                        objData[row][i] = data = objectMap.get(fieldName);
                    }
                }
                ++rowIndex;
            }
            page.setObjData((Object[])objData);
            if (this.colIndex == -1) {
                this.resultSetStub.appendToCachePages(page, 1, cols, true);
            } else {
                this.resultSetStub.appendToCachePages(page, this.colIndex, this.colIndex, false);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u4eceQS\u83b7\u53d6\u9875\u6570\u636e\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            this.close();
        }
        return page;
    }

    private boolean hasNextRow(int index, AbstractExtDataSetPage page) throws AbstractExtDataException, InterruptedException {
        if (index >= this.resultSetStub.getTotalRows()) {
            return false;
        }
        if (index >= page.getEnd()) {
            return false;
        }
        if (this.dataIterator == null) {
            this.dataIterator = this.newFileVisitor(index);
            int start = page.getStart();
            int qsRows = this.resultSetStub.getQsRows();
            int targetInd = (int)Math.floor((double)start / (double)qsRows);
            int offset = start - qsRows * targetInd;
            for (int i = 0; i < offset; ++i) {
                this.dataIterator.hasNextRow();
            }
        }
        if (!this.dataIterator.hasNextRow()) {
            this.dataIterator = this.newFileVisitor(index);
            return this.dataIterator.hasNextRow();
        }
        return true;
    }

    public void close() {
        this.fields = null;
        this.curRow = 0;
        if (this.dataIterator != null) {
            this.dataIterator.close();
        }
    }

    private IExtDataIterator newFileVisitor(int fromRow) throws AbstractExtDataException, InterruptedException {
        int targetIndex = fromRow / this.resultSetStub.getQsRows();
        IExtFileVisitor qingFileVisitor = FileFactory.newFileVisitor(ExtTempFileType.TEMP_QS, this.resultSetStub.getQsFileNames(targetIndex));
        QSDataSourceVisitor qsDataSourceVisitor = new QSDataSourceVisitor(qingFileVisitor);
        this.metaInfo = qsDataSourceVisitor.getMetaInfo();
        if (this.fields == null) {
            this.fields = new HashSet<String>(16);
            List<String> fieldNames = this.metaInfo.getFieldNames();
            this.fields.addAll(fieldNames);
        }
        IExtDataIterator iterator = qsDataSourceVisitor.iterator();
        iterator.init(this.fields);
        return iterator;
    }
}

