/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.frame;

import com.kingdee.cosmic.ctrl.kds.frame.CompositeScrollBarPane;
import com.kingdee.cosmic.ctrl.kds.frame.LayoutCell;
import com.kingdee.cosmic.ctrl.kds.frame.MultiViewPane;
import com.kingdee.cosmic.ctrl.kds.frame.MvpLayoutInfoManager;
import com.kingdee.cosmic.ctrl.kds.frame.MvpScrollBar;
import com.kingdee.cosmic.ctrl.kds.frame.MvpScrollBarManager;
import com.kingdee.cosmic.ctrl.kds.frame.MvpViewManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

class MvpLayoutManager
implements LayoutManager {
    MvpLayoutManager() {
    }

    @Override
    public void layoutContainer(Container parent) {
        MultiViewPane mvp = (MultiViewPane)parent;
        MvpViewManager vm = mvp.getViewManager();
        MvpLayoutInfoManager lim = mvp.getLayoutInfoManager();
        MvpScrollBarManager spManager = mvp.getScrollBarManager();
        int paneWidth = spManager.getVScrollPanelWidth();
        int paneHeight = spManager.getHScrollPanelHeight();
        Rectangle rect = this.getContentBounds(mvp);
        rect.height -= paneHeight;
        rect.width -= paneWidth;
        if (rect.height <= 0 || rect.width <= 0) {
            return;
        }
        this.adjustLayoutInfo(mvp, rect);
        int vCount = mvp.getVerticalCount();
        int hCount = mvp.getHorizonCount();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int xsp = -1;
        int ysp = -1;
        for (int i = 0; i < vCount; ++i) {
            LayoutCell vCell = lim.getVertical(i);
            y = vCell.getStart();
            h = vCell.getSpan();
            for (int j = 0; j < hCount; ++j) {
                CompositeScrollBarPane sp;
                Rectangle r;
                LayoutCell hCell = lim.getHorizon(j);
                x = hCell.getStart();
                w = hCell.getSpan();
                JViewport vp = vm.getViewport(i, j);
                if (vp.isVisible()) {
                    vp.setBounds(x, y, w, h);
                }
                if (j == hCount - 1) {
                    if (i == 0 && lim.isVSplitButtonVisible()) {
                        ysp = y + 6;
                        r = lim.getVSplitButtonRect();
                        r.x = x + w;
                        r.y = y;
                        r.width = paneWidth;
                        r.height = 6;
                    }
                    if ((sp = spManager.getVScrollPanel(i)) != null) {
                        if (ysp != -1) {
                            sp.setBounds(x + w, ysp, paneWidth, h + y - ysp);
                            ysp = -1;
                        } else {
                            sp.setBounds(x + w, y, paneWidth, h);
                        }
                        sp.validate();
                        this.syncScrollPaneWithViewport(mvp, sp.getScrollBar(), vp);
                    } else if (ysp == -1) {
                        ysp = y;
                    }
                }
                if (i != vCount - 1) continue;
                if (j == hCount - 1 && lim.isHSplitButtonVisible()) {
                    r = lim.getHSplitButtonRect();
                    r.x = x + (w -= 6);
                    r.y = y + h;
                    r.width = 6;
                    r.height = paneHeight;
                }
                if ((sp = spManager.getHScrollPanel(j)) != null) {
                    if (xsp != -1) {
                        sp.setBounds(xsp, y + h, w + x - xsp, paneHeight);
                        xsp = -1;
                    } else {
                        sp.setBounds(x, y + h, w, paneHeight);
                    }
                    sp.validate();
                    this.syncScrollPaneWithViewport(mvp, sp.getScrollBar(), vp);
                    continue;
                }
                if (xsp != -1) continue;
                xsp = x;
            }
        }
    }

    void adjustLayoutInfo(MultiViewPane mvp, Rectangle rect) {
        this.adjustLayoutSuper(mvp, rect, 1);
        this.adjustLayoutSuper(mvp, rect, 0);
    }

    private void adjustLayoutSuper(MultiViewPane mvp, Rectangle rect, int orientation) {
        MvpLayoutInfoManager lim = mvp.getLayoutInfoManager();
        MvpViewManager vm = mvp.getViewManager();
        int tempSpan = 0;
        int inset = 0;
        if (orientation == 1) {
            tempSpan = rect.height;
            inset = mvp.getInsets().top;
        } else {
            tempSpan = rect.width;
            inset = mvp.getInsets().left;
        }
        LayoutCell layoutCell0 = lim.getLayoutCell(orientation, 0);
        LayoutCell layoutCell1 = lim.getLayoutCell(orientation, 1);
        LayoutCell layoutCell2 = lim.getLayoutCell(orientation, 2);
        LayoutCell layoutCell3 = lim.getLayoutCell(orientation, 3);
        int start = 0;
        int span = 0;
        if (layoutCell0 != null && layoutCell0.isVisible()) {
            start = 0;
            span = orientation == 1 ? vm.getViewport((int)0, (int)(mvp.getHorizonCount() - 1)).getPreferredSize().height : vm.getViewport((int)(mvp.getVerticalCount() - 1), (int)0).getPreferredSize().width;
            layoutCell0.setStart(start);
            layoutCell0.setSpan(span);
        } else if (layoutCell0 != null) {
            layoutCell0.setStart(start);
            layoutCell0.setSpan(span);
        }
        start += span;
        span = 0;
        if (layoutCell1 != null && layoutCell1.isVisible()) {
            span = orientation == 1 ? vm.getViewport((int)1, (int)(mvp.getHorizonCount() - 1)).getPreferredSize().height : vm.getViewport((int)(mvp.getVerticalCount() - 1), (int)1).getPreferredSize().width;
            layoutCell1.setStart(start);
            layoutCell1.setSpan(span);
        } else if (layoutCell1 != null) {
            layoutCell1.setStart(start);
            layoutCell1.setSpan(span);
        }
        start += span;
        if (layoutCell3 != null && layoutCell3.isVisible()) {
            layoutCell2.setStart(start);
            span = layoutCell2.getSpan();
            start += span;
            if (layoutCell2.getSplitType() == 1) {
                layoutCell3.setStart(start + 6);
                layoutCell3.setSpan(tempSpan - start + inset - 6);
            } else if (layoutCell2.getSplitType() == 2) {
                layoutCell3.setStart(start + 1);
                layoutCell3.setSpan(tempSpan - start + inset - 1);
            }
        } else {
            span = tempSpan - start;
            layoutCell2.setStart(start);
            layoutCell2.setSpan(span);
        }
    }

    public Rectangle getContentBounds(MultiViewPane mvp) {
        Rectangle rect = new Rectangle();
        Insets insets = mvp.getInsets();
        rect.y = insets.top;
        rect.x = insets.left;
        rect.height = mvp.getHeight() - insets.bottom - insets.top;
        rect.width = mvp.getWidth() - insets.right - insets.left;
        return rect;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    protected void syncScrollPaneWithViewport(MultiViewPane _mvp, MvpScrollBar bar1, JViewport vp) {
        int value;
        if (bar1 == null) {
            return;
        }
        MvpViewManager vm = _mvp.getViewManager();
        int orientation = bar1.getOrientation();
        boolean bFreeze = _mvp.isFreezed();
        Dimension extentSize = vp.getExtentSize();
        Point mainp = vm.getViewport(_mvp.getVerticalCount() - 1, _mvp.getHorizonCount() - 1).getViewPosition();
        int n = value = orientation == 1 ? mainp.y : mainp.x;
        if (bFreeze) {
            JScrollBar bar;
            int min;
            int extent = 0;
            int vCount = _mvp.getVerticalCount() - 1;
            int hCount = _mvp.getHorizonCount() - 1;
            if (orientation == 1) {
                vp = _mvp.getViewManager().getViewport(vCount, hCount);
                min = vp.getViewPosition().y;
                bar = _mvp.getScrollBarManager().getVScrollBar(vCount);
                extent = extentSize.height;
            } else {
                vp = _mvp.getViewManager().getViewport(vCount, hCount);
                min = vp.getViewPosition().x;
                bar = _mvp.getScrollBarManager().getHScrollBar(hCount);
                extent = extentSize.width;
            }
            int max = min > bar.getMaximum() ? min : bar.getMaximum();
            bar.setValues(value, extent, bar.getMinimum(), max);
        } else if (bar1.getOrientation() == 1) {
            extentSize = vp.getExtentSize();
            Point viewPosition = vp.getViewPosition();
            int max = bar1.getMaximum(viewPosition.y);
            bar1.setValues(viewPosition.y, extentSize.height, bar1.getMinimum(), max);
        } else {
            extentSize = vp.getExtentSize();
            Point viewPosition = vp.getViewPosition();
            int max = bar1.getMaximum(viewPosition.x);
            bar1.setValues(viewPosition.x, extentSize.width, bar1.getMinimum(), max);
        }
    }
}

