/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.frame;

import com.kingdee.cosmic.ctrl.kds.frame.MultiViewPane;
import com.kingdee.cosmic.ctrl.kds.frame.MvpChildView;
import com.kingdee.cosmic.ctrl.kds.frame.MvpScrollBarUI;
import com.kingdee.cosmic.ctrl.swing.KDScrollBar;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

class MvpScrollBar
extends KDScrollBar {
    protected MultiViewPane _mvp;

    public MvpScrollBar(MultiViewPane mvp, int orientation) {
        super(orientation);
        this._mvp = mvp;
    }

    public void updateUI() {
        this.setUI(MvpScrollBarUI.createUI((JComponent)((Object)this)));
    }

    public int getUnitIncrement(int direction) {
        if (this.orientation == 0) {
            int hIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int vCount = this._mvp.getVerticalCount();
            JViewport vp = this._mvp.getViewManager().getViewport(vCount - 1, hIndex);
            JComponent view = this._mvp.getViewManager().getView(vCount - 1, hIndex);
            if (view instanceof Scrollable) {
                return ((Scrollable)((Object)view)).getScrollableUnitIncrement(vp.getViewRect(), 0, direction);
            }
        } else {
            int vIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int hCount = this._mvp.getHorizonCount();
            JViewport vp = this._mvp.getViewManager().getViewport(vIndex, hCount - 1);
            JComponent view = this._mvp.getViewManager().getView(vIndex, hCount - 1);
            if (view instanceof Scrollable) {
                return ((Scrollable)((Object)view)).getScrollableUnitIncrement(vp.getViewRect(), 1, direction);
            }
        }
        return super.getUnitIncrement(direction);
    }

    public int getBlockIncrement(int direction) {
        if (this.orientation == 0) {
            int hIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int vCount = this._mvp.getVerticalCount();
            JViewport vp = this._mvp.getViewManager().getViewport(vCount - 1, hIndex);
            JComponent view = this._mvp.getViewManager().getView(vCount - 1, hIndex);
            if (view instanceof Scrollable) {
                return ((Scrollable)((Object)view)).getScrollableBlockIncrement(vp.getViewRect(), 0, direction);
            }
        } else {
            int vIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int hCount = this._mvp.getHorizonCount();
            JViewport vp = this._mvp.getViewManager().getViewport(vIndex, hCount - 1);
            JComponent view = this._mvp.getViewManager().getView(vIndex, hCount - 1);
            if (view instanceof Scrollable) {
                return ((Scrollable)((Object)view)).getScrollableBlockIncrement(vp.getViewRect(), 1, direction);
            }
        }
        return super.getBlockIncrement(direction);
    }

    public int getMaximum() {
        return this.getMaximum(this.getValue());
    }

    public int getMaximum(int value) {
        if (this.orientation == 0) {
            int hIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int vCount = this._mvp.getVerticalCount();
            JComponent view = this._mvp.getViewManager().getView(vCount - 1, hIndex);
            JViewport vp = this._mvp.getViewManager().getViewport(vCount - 1, hIndex);
            if (view instanceof MvpChildView) {
                int w = ((MvpChildView)view).getMaxVisibleWidth(value);
                if (value == this.getMinimum()) {
                    w += 70;
                }
                return w;
            }
            if (view != null) {
                return view.getWidth();
            }
            return vp == null ? value : vp.getWidth();
        }
        int vIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
        int hCount = this._mvp.getHorizonCount();
        JViewport vp = this._mvp.getViewManager().getViewport(vIndex, hCount - 1);
        JComponent view = this._mvp.getViewManager().getView(vIndex, hCount - 1);
        if (view instanceof MvpChildView) {
            int h = ((MvpChildView)view).getMaxVisibleHeight(value);
            if (value == this.getMinimum()) {
                h += 20;
            }
            return h;
        }
        if (view != null) {
            return view.getHeight();
        }
        return vp == null ? value : vp.getHeight();
    }

    public int getRealMaximum() {
        if (this.orientation == 0) {
            int hIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
            int vCount = this._mvp.getVerticalCount();
            JComponent view = this._mvp.getViewManager().getView(vCount - 1, hIndex);
            JViewport vp = this._mvp.getViewManager().getViewport(vCount - 1, hIndex);
            if (view != null) {
                return view.getWidth();
            }
            return vp.getWidth();
        }
        int vIndex = MultiViewPane.getComponentIndex((JComponent)((Object)this), "ViewIndex");
        int hCount = this._mvp.getHorizonCount();
        JViewport vp = this._mvp.getViewManager().getViewport(vIndex, hCount - 1);
        JComponent view = this._mvp.getViewManager().getView(vIndex, hCount - 1);
        if (view != null) {
            return view.getHeight();
        }
        return vp.getHeight();
    }

    public void setValue(int value) {
        int newValue = Math.max(value, this.getMinimum());
        int realMax = this.getRealMaximum();
        if (newValue + this.getVisibleAmount() > realMax && realMax > 0) {
            newValue = realMax - this.getVisibleAmount();
        }
        int newMax = this.getMaximum(newValue);
        this.setValues(newValue, this.getVisibleAmount(), this.getMinimum(), newMax);
    }
}

