/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade;

import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.plaf.PaintUtil;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LittleArrowButtonItem
extends KDPanel {
    private static final int BG_INIT = 0;
    private static final int BG_ROLLVER = 1;
    private static final int BG_DISABLE = 2;
    private static int leftAreaWidth = 22;
    private static int menuWidth = 200;
    private int menuHeight = 20;
    protected static Icon initArrowIcon;
    protected static Icon selectedArrowIcon;
    protected static Icon disabledArrowIcon;
    private JComponent wrappedComp;
    private boolean isMouseOver;
    private boolean selfRender = true;
    private MouseListener littleArrowButtonItemMouseListener;

    public LittleArrowButtonItem(JComponent wrappedComp) {
        this.wrappedComp = wrappedComp;
        Dimension preferredSize = wrappedComp.getPreferredSize();
        this.menuHeight = (int)preferredSize.getHeight();
        menuWidth = Math.max((int)preferredSize.getWidth() + leftAreaWidth, menuWidth);
        this.littleArrowButtonItemMouseListener = new LittleArrowButtonItemMouseListener();
        this.addMouseListener(this.littleArrowButtonItemMouseListener);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(null);
        this.add(this.wrappedComp);
        this.wrappedComp.setBounds(300, 0, 0, 0);
        if (!(this.wrappedComp instanceof JButton) && !(this.wrappedComp instanceof JSeparator)) {
            this.selfRender = false;
            Dimension preferredSize = this.wrappedComp.getPreferredSize();
            this.wrappedComp.setBounds(28, 0, preferredSize.width, preferredSize.height);
        }
    }

    public boolean isVisible() {
        return this.wrappedComp.isVisible();
    }

    public Dimension getPreferredSize() {
        if (this.wrappedComp instanceof JSeparator) {
            return new Dimension(menuWidth, 4);
        }
        return new Dimension(menuWidth, this.menuHeight);
    }

    public JComponent getWrappedComponent() {
        return this.wrappedComp;
    }

    protected void paintComponent(Graphics g) {
        this.paintBackground(g);
        this.paintSelfComponent(g);
    }

    protected void paintSelfComponent(Graphics g) {
        if (this.wrappedComp instanceof JSeparator) {
            g.setColor(UIManager.getColor("MenuItem.separatorShadow"));
            g.drawLine(leftAreaWidth + 2, 2, menuWidth, 2);
            g.setColor(UIManager.getColor("MenuItem.separatorDarkShadow"));
            g.drawLine(leftAreaWidth + 2, 3, menuWidth, 3);
            return;
        }
        if (this.selfRender) {
            KDWorkButton btn = (KDWorkButton)this.wrappedComp;
            if (this.wrappedComp.isEnabled()) {
                Icon icon = btn.getIcon();
                String text = btn.getText();
                if (this.isMouseOver) {
                    g.setColor(UIManager.getColor("MenuItem.selectionForeground"));
                    if (icon != null) {
                        icon.paintIcon((Component)((Object)this), g, 2, 2);
                    }
                    if (text != null) {
                        g.drawString(text, 30, 14);
                    }
                } else {
                    g.setColor(UIManager.getColor("MenuItem.foreground"));
                    if (icon != null) {
                        icon.paintIcon((Component)((Object)this), g, 2, 2);
                    }
                    if (text != null) {
                        g.drawString(text, 30, 14);
                    }
                }
            } else {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                Icon icon = btn.getDisabledIcon();
                String text = btn.getText();
                if (icon != null) {
                    icon.paintIcon((Component)((Object)this), g, 2, 2);
                }
                if (text != null) {
                    g.drawString(text, 30, 14);
                }
            }
        }
    }

    protected void paintBackground(Graphics g) {
        Color oldColor = g.getColor();
        if (this.wrappedComp.isEnabled()) {
            if (this.isMouseOver) {
                g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                g.fillRect(leftAreaWidth, 0, menuWidth, this.menuHeight);
                this.paintLeftBackground(g, 1);
                this.paintMiddleSeparator(g, 1);
                if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                    selectedArrowIcon.paintIcon((Component)((Object)this), g, menuWidth - 16, 2);
                }
            } else {
                g.setColor(UIManager.getColor("MenuItem.background"));
                g.fillRect(leftAreaWidth, 0, menuWidth, this.menuHeight);
                this.paintLeftBackground(g, 0);
                this.paintMiddleSeparator(g, 0);
                if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                    initArrowIcon.paintIcon((Component)((Object)this), g, menuWidth - 16, 2);
                }
            }
        } else {
            g.setColor(UIManager.getColor("MenuItem.disabledBackground"));
            g.fillRect(leftAreaWidth, 0, menuWidth, this.menuHeight);
            this.paintLeftBackground(g, 2);
            this.paintMiddleSeparator(g, 2);
            if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                disabledArrowIcon.paintIcon((Component)((Object)this), g, menuWidth - 16, 2);
            }
        }
        g.setColor(oldColor);
    }

    protected void paintLeftBackground(Graphics g, int state) {
        Rectangle rect = new Rectangle(0, 0, leftAreaWidth, this.menuHeight);
        switch (state) {
            case 1: {
                PaintUtil.drawShadow((Graphics)g, (float)1.0f, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftRollBgShadow"), (float)leftAreaWidth, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftRollBgDarkShadow"), (Shape)rect, (int)0);
                break;
            }
            case 2: {
                PaintUtil.drawShadow((Graphics)g, (float)1.0f, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftDisableShadow"), (float)leftAreaWidth, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftDisableDarkShadow"), (Shape)rect, (int)0);
                break;
            }
            default: {
                PaintUtil.drawShadow((Graphics)g, (float)1.0f, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftBgShadow"), (float)leftAreaWidth, (float)1.0f, (Color)UIManager.getColor("MenuItem.leftBgDarkShadow"), (Shape)rect, (int)0);
            }
        }
    }

    protected void paintMiddleSeparator(Graphics g, int state) {
        int h = this.menuHeight;
        switch (state) {
            case 1: {
                g.setColor(UIManager.getColor("MenuItem.separatorRollShadow"));
                g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorRollDarkShadow"));
                g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
                break;
            }
            case 2: {
                g.setColor(UIManager.getColor("MenuItem.separatorDisableShadow"));
                g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorDisableDarkShadow"));
                g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
                break;
            }
            default: {
                g.setColor(UIManager.getColor("MenuItem.separatorShadow"));
                g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                g.setColor(UIManager.getColor("MenuItem.separatorDarkShadow"));
                g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
            }
        }
    }

    static {
        leftAreaWidth = (Integer)UIManager.get("MenuItem.leftAreaWidth") + 3;
        initArrowIcon = new ImageIcon(KDResourceManager.getImage((String)"toolbar_group_arrowhead3.gif"));
        selectedArrowIcon = new ImageIcon(KDResourceManager.getImage((String)"toolbar_group_arrowhead1.gif"));
        disabledArrowIcon = new ImageIcon(KDResourceManager.getImage((String)"toolbar_group_arrowhead2.gif"));
    }

    private class LittleArrowButtonItemMouseListener
    extends MouseAdapter {
        private LittleArrowButtonItemMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!(LittleArrowButtonItem.this.wrappedComp instanceof JSeparator)) {
                LittleArrowButtonItem.this.isMouseOver = true;
                LittleArrowButtonItem.this.repaint();
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
            if (LittleArrowButtonItem.this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isAssitButton()) {
                if (!((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isEnabled()) {
                    return;
                }
                KDPopupMenu pm = ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).getAssistPopup();
                pm.setInvoker((Component)LittleArrowButtonItem.this.wrappedComp);
                Point p = LittleArrowButtonItem.this.getLocationOnScreen();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                if ((double)(p.x + LittleArrowButtonItem.this.getWidth()) + pm.getPreferredSize().getWidth() <= (double)d.width) {
                    pm.setLocation(p.x + LittleArrowButtonItem.this.getWidth(), p.y);
                } else {
                    pm.setLocation(p.x - (int)pm.getPreferredSize().getWidth(), p.y);
                }
                pm.setVisible(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!(LittleArrowButtonItem.this.wrappedComp instanceof JSeparator)) {
                LittleArrowButtonItem.this.isMouseOver = false;
                LittleArrowButtonItem.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (LittleArrowButtonItem.this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isAssitButton() && ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isEnabled()) {
                KDPopupMenu pm = ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).getAssistPopup();
                pm.setInvoker((Component)LittleArrowButtonItem.this.wrappedComp);
                if (pm.isShowing()) {
                    return;
                }
                Point p = LittleArrowButtonItem.this.getLocationOnScreen();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                if ((double)(p.x + LittleArrowButtonItem.this.getWidth()) + pm.getPreferredSize().getWidth() <= (double)d.width) {
                    pm.setLocation(p.x + LittleArrowButtonItem.this.getWidth(), p.y);
                } else {
                    pm.setLocation(p.x - (int)pm.getPreferredSize().getWidth(), p.y);
                }
                pm.setVisible(true);
            } else if (LittleArrowButtonItem.this.wrappedComp instanceof JButton && LittleArrowButtonItem.this.wrappedComp.isEnabled()) {
                SwingUtilities.getWindowAncestor((Component)((Object)LittleArrowButtonItem.this)).hide();
                ((JButton)LittleArrowButtonItem.this.wrappedComp).doClick();
            }
        }
    }
}

