/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormat;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormatList;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.util.Condition;
import com.kingdee.cosmic.ctrl.kds.model.util.IntArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class WizzardConditionalFormat
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private ConditionalPanel[] conditionalPanelPool = new ConditionalPanel[3];
    private ButtonPanel buttonPanel;
    private Condition[] _oldConditions;
    private ShareStyleAttributes[] _oldSas;
    private DeleteWindow deleteWindow;

    public WizzardConditionalFormat(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardConditionalFormat(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    private void initComps() {
        this.conditionalPanelPool[0] = new ConditionalPanel(this._context);
        this.conditionalPanelPool[1] = new ConditionalPanel(this._context);
        this.conditionalPanelPool[2] = new ConditionalPanel(this._context);
        this.conditionalPanelPool[0].styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(F)...");
        this.conditionalPanelPool[1].styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(O)...");
        this.conditionalPanelPool[2].styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(R)...");
        this.buttonPanel = new ButtonPanel();
        this.deleteWindow = new DeleteWindow((Dialog)((Object)this));
    }

    private void resetBorderTitles() {
        Component comp;
        int i;
        String[] texts = new String[]{MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(F)...", MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(O)...", MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(R)..."};
        Container c = this.getContentPane();
        int j = 1;
        for (i = 0; i < c.getComponentCount() - 1; ++i) {
            comp = c.getComponent(i);
            if (!comp.isVisible()) continue;
            ((ConditionalPanel)((Object)comp)).setBorder(BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " " + j + "(" + j + ")"));
            ((ConditionalPanel)((Object)comp)).styleConfig.setText(texts[j - 1]);
            ++j;
        }
        for (i = 0; i < c.getComponentCount() - 1; ++i) {
            comp = c.getComponent(i);
            if (comp.isVisible()) continue;
            ((ConditionalPanel)((Object)comp)).setBorder(BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " " + j + "(" + j + ")"));
            ((ConditionalPanel)((Object)comp)).styleConfig.setText(texts[j - 1]);
            ++j;
        }
    }

    private ConditionalPanel[] getVisibleConditionalPanels() {
        Container c = this.getContentPane();
        ArrayList<Component> al = new ArrayList<Component>();
        for (int i = 0; i < c.getComponentCount() - 1; ++i) {
            Component comp = c.getComponent(i);
            if (!comp.isVisible()) continue;
            al.add(comp);
        }
        ConditionalPanel[] cps = new ConditionalPanel[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            cps[i] = (ConditionalPanel)((Object)al.get(i));
        }
        return cps;
    }

    private int getVisibleConditionalPanelCount() {
        int i = 0;
        for (int j = 0; j < this.conditionalPanelPool.length; ++j) {
            if (!this.conditionalPanelPool[j].isVisible()) continue;
            ++i;
        }
        return i;
    }

    private ConditionalPanel[] getVisibleConditionalPanelsInRightOrder() {
        ConditionalPanel[] cons = new ConditionalPanel[this.getVisibleConditionalPanelCount()];
        Container c = this.getContentPane();
        int index = 0;
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component comp = c.getComponent(i);
            if (!(comp instanceof ConditionalPanel) || !comp.isVisible()) continue;
            cons[index++] = (ConditionalPanel)((Object)comp);
        }
        return cons;
    }

    private ConditionalPanel getInvisibleConditionalPanelFromPool() {
        if (!this.conditionalPanelPool[0].isVisible()) {
            return this.conditionalPanelPool[0];
        }
        if (!this.conditionalPanelPool[1].isVisible()) {
            return this.conditionalPanelPool[1];
        }
        if (!this.conditionalPanelPool[2].isVisible()) {
            return this.conditionalPanelPool[2];
        }
        return null;
    }

    private void layoutComps() {
        Container con = this.getContentPane();
        con.setLayout(new BoxLayout(con, 1));
        this.setResizable(false);
        ConditionalPanel cp1 = this.conditionalPanelPool[0];
        ConditionalPanel cp2 = this.conditionalPanelPool[1];
        ConditionalPanel cp3 = this.conditionalPanelPool[2];
        cp1.setBorder(BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 1(1)"));
        cp2.setBorder(BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 2(2)"));
        cp3.setBorder(BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 3(3)"));
        cp1.styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(F)...");
        cp2.styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(O)...");
        cp3.styleConfig.setText(MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f") + "(R)...");
        con.add((Component)((Object)cp1));
        con.add((Component)((Object)cp2));
        con.add((Component)((Object)cp3));
        con.add((Component)((Object)this.buttonPanel));
    }

    private void initListeners() {
        ((JPanel)this.getContentPane()).putClientProperty("NoIgnoringEsc", new Object());
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(49, 8), "focusCP1");
        this.rootPane.getActionMap().put("focusCP1", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardConditionalFormat.this.getVisibleConditionalPanels()[0].requestFocus();
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(50, 8), "focusCP2");
        this.rootPane.getActionMap().put("focusCP2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
                if (cps.length > 1) {
                    cps[1].requestFocus();
                }
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(51, 8), "focusCP3");
        this.rootPane.getActionMap().put("focusCP3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
                if (cps.length > 2) {
                    cps[2].requestFocus();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                for (int i = 0; i < WizzardConditionalFormat.this.conditionalPanelPool.length; ++i) {
                    WizzardConditionalFormat.this.conditionalPanelPool[i].clear();
                }
            }
        });
    }

    private void closeDialog() {
        for (int i = 0; i < this.conditionalPanelPool.length; ++i) {
            this.conditionalPanelPool[i].clear();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        if (this._context.getSpread().getBook().getSelectSheets().size() > 1) {
            MessageUtil.msgboxInfo((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_GROUP_MultiSheet_Deny", "\u4e0d\u80fd\u5bf9\u591a\u8868\u9875\u9009\u62e9\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"));
            return false;
        }
        this._oldConditions = null;
        this._oldSas = null;
        Range rg = this._context.getRangeManager().getSelectionRange();
        ConditionalFormatList cfl = this._context.getBook().getActiveSheet().getConditionalFormats();
        IntArray intersects = new IntArray();
        boolean allSeted = cfl.calcIntersects(rg, intersects);
        int count = intersects.size();
        if (count > 1) {
            boolean b = MessageUtil.msgboxOkCancel((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG1", "\u9009\u5b9a\u533a\u57df\u5305\u542b\u591a\u79cd\u6761\u4ef6\u683c\u5f0f\uff0c\u662f\u5426\u6e05\u9664\u5f53\u524d\u8bbe\u7f6e\u5e76\u7ee7\u7eed!"));
            if (!b) {
                return false;
            }
        } else if (count == 1) {
            if (!allSeted) {
                int ret = MessageUtil.msgboxYesNoCancel((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG2", "\u9009\u5b9a\u533a\u57df\u67d0\u4e9b\u5355\u5143\u683c\u672a\u8bbe\u7f6e\u6761\u4ef6\u683c\u5f0f\uff0c\u662f\u5426\u5bf9\u5176\u5b9e\u65bd\u5f53\u524d\u7684\u6570\u636e\u6709\u6548\u6027\u8bbe\u7f6e"));
                if (0 == ret) {
                    ConditionalFormat cf = cfl.getConditionalFormat(intersects.get(0));
                    this._oldConditions = cf.getConditions();
                    this._oldSas = cf.getSSAs();
                } else if (2 == ret) {
                    return false;
                }
            } else {
                ConditionalFormat cf = cfl.getConditionalFormat(intersects.get(0));
                this._oldConditions = cf.getConditions();
                this._oldSas = cf.getSSAs();
            }
        }
        this.updateByConditionalFormat(this._oldConditions, this._oldSas);
        return true;
    }

    private void updateByConditionalFormat(Condition[] conditions, ShareStyleAttributes[] sas) {
        this.layoutComps();
        int conditionCount = conditions == null ? 0 : conditions.length;
        switch (conditionCount) {
            case 0: {
                this.conditionalPanelPool[0].setVisible(true);
                this.conditionalPanelPool[1].setVisible(false);
                this.conditionalPanelPool[2].setVisible(false);
                ++conditionCount;
                break;
            }
            case 1: {
                this.conditionalPanelPool[0].setVisible(true);
                this.conditionalPanelPool[1].setVisible(false);
                this.conditionalPanelPool[2].setVisible(false);
                this.conditionalPanelPool[0].configPanel(conditions[0], sas[0]);
                break;
            }
            case 2: {
                this.conditionalPanelPool[0].setVisible(true);
                this.conditionalPanelPool[1].setVisible(true);
                this.conditionalPanelPool[2].setVisible(false);
                this.conditionalPanelPool[0].configPanel(conditions[0], sas[0]);
                this.conditionalPanelPool[1].configPanel(conditions[1], sas[1]);
                break;
            }
            case 3: {
                this.conditionalPanelPool[0].setVisible(true);
                this.conditionalPanelPool[1].setVisible(true);
                this.conditionalPanelPool[2].setVisible(true);
                this.conditionalPanelPool[0].configPanel(conditions[0], sas[0]);
                this.conditionalPanelPool[1].configPanel(conditions[1], sas[1]);
                this.conditionalPanelPool[2].configPanel(conditions[2], sas[2]);
            }
        }
        this.setSize(540, 150 + 85 * (conditionCount - 1));
        this.setLocationRelativeTo(this.getParent());
    }

    private void reformatAllCells(Sheet sheet, SortedCellBlockArray scba) {
        CellBlock cb = null;
        for (int i = 0; i < scba.size(); ++i) {
            cb = scba.getBlock(i);
            Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                ci.next().setFormatted(false);
            }
        }
        this._context.getSpread().repaintPartial(sheet, scba, true, true);
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton add;
        private KDButton del;
        private KDButton ok;
        private KDButton cancel;

        public ButtonPanel() {
            this.initComps();
            this.layoutComps();
            this.initListeners();
        }

        private void initComps() {
            this.add = new KDButton(MultiLanguageKeys.getLocalText("KEY_CONDITION_ADD", "\u6dfb\u52a0") + "(A) >>");
            this.del = new KDButton(MultiLanguageKeys.getLocalText("KEY_DELETE", "\u5220\u9664") + "(D)...");
            this.ok = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
        }

        private void layoutComps() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(525, 40));
            this.add((Component)this.add);
            this.add((Component)this.del);
            this.add((Component)this.ok);
            this.add((Component)this.cancel);
            this.add.setBounds(135, 15, 90, 20);
            this.del.setBounds(235, 15, 90, 20);
            this.ok.setBounds(335, 15, 90, 20);
            this.cancel.setBounds(435, 15, 90, 20);
        }

        private void initListeners() {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ButtonPanel.this.ok) {
                        ArrayList<Condition> conditionAL = new ArrayList<Condition>();
                        ArrayList<ShareStyleAttributes> saAL = new ArrayList<ShareStyleAttributes>();
                        ConditionalPanel[] rightCps = WizzardConditionalFormat.this.getVisibleConditionalPanelsInRightOrder();
                        for (int i = 0; i < rightCps.length; ++i) {
                            int check = rightCps[i].assembleCondition();
                            if (Condition.isOk(check)) {
                                conditionAL.add(rightCps[i].condition);
                                saAL.add(rightCps[i].ssa);
                                continue;
                            }
                            if (Condition.isSyntaxError(check)) {
                                WizzardConditionalFormat.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG3", "\u5b57\u6bb5\u7684\u8f93\u5165\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01"), 64);
                                return;
                            }
                            if (!Condition.isValueError(check)) continue;
                            WizzardConditionalFormat.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG4", "\u6240\u9700\u7684\u6700\u5927\u503c\u6216\u6700\u5c0f\u503c\u6570\u503c\u4e22\u5931\u3002"), 64);
                            return;
                        }
                        int size = conditionAL.size();
                        Condition[] conditions = new Condition[size];
                        ShareStyleAttributes[] sas = new ShareStyleAttributes[size];
                        for (int i = 0; i < size; ++i) {
                            conditions[i] = (Condition)conditionAL.get(i);
                            sas[i] = (ShareStyleAttributes)saAL.get(i);
                        }
                        Sheet sheet = WizzardConditionalFormat.this._context.getBook().getActiveSheet();
                        SortedCellBlockArray scba = sheet.getSheetOption().getSelection().toSortedBlocks();
                        WizzardConditionalFormat.this.reformatAllCells(sheet, scba);
                        sheet.getConditionalFormats().insertConditionalFormat(conditions, sas, scba);
                        WizzardConditionalFormat.this.closeDialog();
                    } else if (e.getSource() == ButtonPanel.this.cancel) {
                        WizzardConditionalFormat.this.closeDialog();
                    } else if (e.getSource() == ButtonPanel.this.add) {
                        ConditionalPanel cp = WizzardConditionalFormat.this.getInvisibleConditionalPanelFromPool();
                        if (cp == null) {
                            return;
                        }
                        Container c = WizzardConditionalFormat.this.getContentPane();
                        cp.setVisible(true);
                        c.add((Component)((Object)cp), c.getComponentCount() - 2);
                        WizzardConditionalFormat.this.resetBorderTitles();
                        WizzardConditionalFormat.this.setSize(540, 150 + 85 * (WizzardConditionalFormat.this.getVisibleConditionalPanelCount() - 1));
                    } else if (e.getSource() == ButtonPanel.this.del) {
                        ConditionalPanel[] cps = WizzardConditionalFormat.this.deleteWindow.showDeleteWindow();
                        for (int i = 0; i < cps.length; ++i) {
                            if (cps[i] == null) continue;
                            cps[i].clear();
                            cps[i].setVisible(false);
                        }
                        int vcp = WizzardConditionalFormat.this.getVisibleConditionalPanelCount();
                        ConditionalPanel pool = WizzardConditionalFormat.this.getInvisibleConditionalPanelFromPool();
                        if (vcp == 0 && pool != null) {
                            pool.setVisible(true);
                            ++vcp;
                        }
                        WizzardConditionalFormat.this.resetBorderTitles();
                        WizzardConditionalFormat.this.setSize(540, 150 + 85 * (vcp - 1));
                    }
                }
            };
            this.add.addActionListener(al);
            this.del.addActionListener(al);
            this.ok.addActionListener(al);
            this.cancel.addActionListener(al);
            InputMap im = this.add.getInputMap(2);
            ActionMap am = this.add.getActionMap();
            im.put(KeyStroke.getKeyStroke(65, 8), "add");
            am.put("add", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.add.doClick();
                }
            });
            im = this.del.getInputMap(2);
            am = this.del.getActionMap();
            im.put(KeyStroke.getKeyStroke(68, 8), "del");
            am.put("del", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.del.doClick();
                }
            });
            im = WizzardConditionalFormat.this.rootPane.getInputMap(2);
            am = WizzardConditionalFormat.this.rootPane.getActionMap();
            im.put(KeyStroke.getKeyStroke(70, 8), "style1");
            am.put("style1", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
                    if (cps.length > 0) {
                        cps[0].styleConfig.doClick();
                    }
                }
            });
            im = WizzardConditionalFormat.this.rootPane.getInputMap(2);
            am = WizzardConditionalFormat.this.rootPane.getActionMap();
            im.put(KeyStroke.getKeyStroke(79, 8), "style2");
            am.put("style2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
                    if (cps.length > 1) {
                        cps[1].styleConfig.doClick();
                    }
                }
            });
            im = WizzardConditionalFormat.this.rootPane.getInputMap(2);
            am = WizzardConditionalFormat.this.rootPane.getActionMap();
            im.put(KeyStroke.getKeyStroke(82, 8), "style3");
            am.put("style3", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
                    if (cps.length > 2) {
                        cps[2].styleConfig.doClick();
                    }
                }
            });
        }
    }

    private class ConditionalPanel
    extends KDPanel {
        private SpreadContext _context;
        private KDComboBox type;
        private KDComboBox op;
        private RangeSelector _tfCustom;
        private KDLabel and;
        private RangeSelector _tfCustom2;
        private KDLabel tip1;
        private KDLabel tip2;
        private PreviewPanel previewPanel;
        private KDButton styleConfig;
        private ShareStyleAttributes ssa;
        private Condition condition;

        private ConditionalPanel(SpreadContext _context) {
            this._context = _context;
            this.initComps();
            this.layoutComps();
            this.initListeners();
        }

        private void configPanel(Condition condition, ShareStyleAttributes ssa) {
            this.ssa = ssa;
            this._tfCustom.setText(condition.getMin());
            this._tfCustom2.setText(condition.getMax());
            this.op.setSelectedIndex(condition.getQualifierIndex());
            this.type.setSelectedIndex(condition.getTypeIndex());
            this.previewPanel.repaint();
        }

        private int assembleCondition() {
            this.condition = new Condition();
            Sheet sheet = this._context.getBook().getActiveSheet();
            this.condition.setTypeIndex(this.type.getSelectedIndex());
            this.condition.setQualifierIndex(this.op.getSelectedIndex());
            int check = this.condition.setMinMax(this._tfCustom.getText(), this._tfCustom2.getText(), sheet);
            return check;
        }

        private void clear() {
            this.type.setSelectedIndex(0);
            this.op.setSelectedIndex(0);
            this._tfCustom.setText("");
            this._tfCustom2.setText("");
            this.ssa = null;
            this.previewPanel.repaint();
        }

        public void requestFocus() {
            this.type.requestFocusInWindow();
        }

        private void initComps() {
            this.type = new KDComboBox((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_CONDITION_VALUE", "\u5355\u5143\u683c\u6570\u503c"), MultiLanguageKeys.getLocalText("KEY_FORMULA", "\u516c\u5f0f")});
            this.op = new KDComboBox((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_VALIDATION_between", "\u4ecb\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_notbetween", "\u672a\u4ecb\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_equal", "\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_notequal", "\u4e0d\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_greater", "\u5927\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_less", "\u5c0f\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_greaterorequal", "\u5927\u4e8e\u6216\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_lessorequal", "\u5c0f\u4e8e\u6216\u7b49\u4e8e")});
            this._tfCustom = this._context.getFacadeManager().createRangeSelector("");
            this._tfCustom.setWithOpreatorEqual(true);
            this.and = new KDLabel(MultiLanguageKeys.getLocalText("KEY_CONDITION_TOGETHER", "\u4e0e"));
            this._tfCustom2 = this._tfCustom;
            this._tfCustom2.setWithOpreatorEqual(true);
            this.tip1 = new KDLabel();
            this.tip1.setText(MultiLanguageKeys.getLocalText("KEY_CONDITION_TIP1", "\u6761\u4ef6\u4e3a\u771f\u65f6\uff0c\u5f85\u7528"));
            this.tip2 = new KDLabel();
            this.tip2.setText(MultiLanguageKeys.getLocalText("KEY_CONDITION_TIP2", "\u683c\u5f0f\u5982\u53f3\u56fe\u6240\u793a:"));
            this.previewPanel = new PreviewPanel();
            this.styleConfig = new KDButton();
        }

        private void layoutComps() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(525, 85));
            this.add((Component)this.type);
            this.add((Component)this.op);
            this.add(this._tfCustom);
            this.add((Component)this.and);
            this.add(this._tfCustom2);
            this.add((Component)this.tip1);
            this.add((Component)this.tip2);
            this.add((Component)((Object)this.previewPanel));
            this.add((Component)this.styleConfig);
            this.type.setBounds(10, 20, 105, 20);
            this.op.setBounds(125, 20, 105, 20);
            this._tfCustom.setBounds(240, 20, 120, 20);
            this.and.setBounds(380, 20, 20, 20);
            this._tfCustom2.setBounds(405, 20, 120, 20);
            this.tip1.setBounds(10, 45, 105, 15);
            this.tip2.setBounds(10, 60, 105, 15);
            this.previewPanel.setBounds(125, 45, 250, 30);
            this.styleConfig.setBounds(405, 50, 90, 20);
        }

        private void initListeners() {
            this.type.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (ConditionalPanel.this.type.getSelectedIndex() == 0) {
                            if (ConditionalPanel.this.op.getSelectedIndex() == 0 || ConditionalPanel.this.op.getSelectedIndex() == 1) {
                                ConditionalPanel.this.op.setVisible(true);
                                ConditionalPanel.this.and.setVisible(true);
                                ConditionalPanel.this._tfCustom2.setVisible(true);
                                ConditionalPanel.this._tfCustom.setBounds(240, 20, 120, 20);
                            } else {
                                ConditionalPanel.this.op.setVisible(true);
                                ConditionalPanel.this._tfCustom.setBounds(240, 20, 285, 20);
                            }
                        } else {
                            ConditionalPanel.this.op.setVisible(false);
                            ConditionalPanel.this.and.setVisible(false);
                            ConditionalPanel.this._tfCustom2.setVisible(false);
                            ConditionalPanel.this._tfCustom.setBounds(125, 20, 400, 20);
                        }
                    }
                }
            });
            this.op.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (ConditionalPanel.this.op.getSelectedIndex() == 0 || ConditionalPanel.this.op.getSelectedIndex() == 1) {
                            ConditionalPanel.this.and.setVisible(true);
                            ConditionalPanel.this._tfCustom2.setVisible(true);
                            ConditionalPanel.this._tfCustom.setBounds(240, 20, 120, 20);
                        } else {
                            ConditionalPanel.this.and.setVisible(false);
                            ConditionalPanel.this._tfCustom2.setVisible(false);
                            ConditionalPanel.this._tfCustom.setBounds(240, 20, 285, 20);
                        }
                    }
                }
            });
            this.styleConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LazyStyleDesigner sd = new LazyStyleDesigner();
                    sd.setPanels(new String[]{"font", "interior"});
                    StyleAttributes sa = null;
                    if (ConditionalPanel.this.ssa == null) {
                        sa = Styles.getDefaultSA();
                    } else {
                        sa = Styles.getSA((ShareStyleAttributes)ConditionalPanel.this.ssa);
                        sa.append((ShareStyleAttributes)Styles.getDefaultStyle(), false);
                        sa.clearDirtyFlag();
                    }
                    sd.setSA(sa);
                    sd.setTitle(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE", "\u5355\u5143\u683c\u683c\u5f0f:"));
                    sd.setLocationRelativeTo((Component)((Object)WizzardConditionalFormat.this));
                    sd.showDialog();
                    boolean needFire = false;
                    if (sd.isChanged()) {
                        StyleAttributes saTemp = ConditionalPanel.this.ssa == null ? Styles.getEmptySA() : Styles.getSA((ShareStyleAttributes)ConditionalPanel.this.ssa);
                        saTemp.setOwner(null);
                        saTemp.clearDirtyFlag();
                        saTemp.replaceDirty((ShareStyleAttributes)sd.getSA());
                        ConditionalPanel.this.ssa = ConditionalPanel.this._context.getBook().getSSA(saTemp);
                        needFire = true;
                    }
                    sd.dispose();
                    if (needFire) {
                        ConditionalPanel.this.previewPanel.repaint();
                    }
                }
            });
        }

        private class PreviewPanel
        extends KDPanel {
            private TextRender tr = new TextRender(CtrlEXTMessages.getMLS("previewString", "\u8f7b\u62a5\u8868"), StyleDesignerUtil.getStyle4Paint());

            private PreviewPanel() {
                this.setBackground(Color.white);
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (ConditionalPanel.this.ssa != null) {
                    this.paintViewBackground(g);
                    this.paintViewText(g);
                }
            }

            private void paintViewBackground(Graphics g) {
                if (ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.PATTERN) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.PATTERN_COLOR) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.BACKGROUND_COLOR)) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g;
                int x = 5;
                int y = 5;
                int w = this.getWidth() - 10;
                int h = this.getHeight() - 10;
                Pattern pattern = ConditionalPanel.this.ssa.getPattern();
                if (pattern != null && pattern.equals(Pattern.getPattern((int)0))) {
                    g2.setBackground(this.getBackground());
                    g2.clearRect(x, y, w, h);
                } else {
                    Paint paint = ConditionalPanel.this._context.getBook().getStyle(ConditionalPanel.this.ssa).getFillPaint();
                    g2.setPaint(paint);
                    g2.fillRect(x, y, w, h);
                }
                g2.setColor(Color.BLACK);
                g2.drawRect(x, y, w, h);
            }

            private void paintViewText(Graphics g) {
                if (ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_COLOR) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_STRIKETHROUGH) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_UNDERLINE) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_NAME) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_SIZE) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_BOLD) || ConditionalPanel.this.ssa.isUnsureValue(ShareStyleAttributes.FONT_ITALIC)) {
                    return;
                }
                Rectangle rect = new Rectangle(this.getWidth(), this.getHeight());
                this.tr.setCellStyle(ConditionalPanel.this._context.getBook().getStyle(ConditionalPanel.this.ssa));
                this.tr.draw(g, (Shape)rect);
            }
        }
    }

    private class DeleteWindow
    extends KDDialog {
        private KDPanel panel;
        private KDCheckBox[] cbs;
        private KDButton submit;
        private KDButton cancel;
        private ConditionalPanel[] result;

        private DeleteWindow(Dialog w) {
            super(w);
            this.panel = new KDPanel();
            this.cbs = new KDCheckBox[]{new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 1(1)"), new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 2(2)"), new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_CONDITION", "\u6761\u4ef6") + " 3(3)")};
            this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
            this.result = new ConditionalPanel[3];
            this.panel.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION_BORDER", "\u9009\u5b9a\u8981\u5220\u9664\u7684\u6761\u4ef6")));
            this.setModal(true);
            this.layoutComps();
            this.addListeners();
        }

        void layoutComps() {
            Container c = this.getContentPane();
            c.setLayout(null);
            c.add((Component)this.panel);
            c.add((Component)this.submit);
            c.add((Component)this.cancel);
            this.panel.setLayout((LayoutManager)new BoxLayout((Container)this.panel, 1));
            this.panel.add((Component)this.cbs[0]);
            this.panel.add((Component)this.cbs[1]);
            this.panel.add((Component)this.cbs[2]);
            this.panel.setBounds(2, 0, 200, 100);
            this.submit.setBounds(30, 110, 80, 20);
            this.cancel.setBounds(120, 110, 80, 20);
            this.setResizable(false);
            this.setSize(210, 160);
        }

        void addListeners() {
            this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(49, 8), "focusCP1");
            this.rootPane.getActionMap().put("focusCP1", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeleteWindow.this.cbs[0].setSelected(!DeleteWindow.this.cbs[0].isSelected());
                    DeleteWindow.this.cbs[0].requestFocusInWindow();
                }
            });
            this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(50, 8), "focusCP2");
            this.rootPane.getActionMap().put("focusCP2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeleteWindow.this.cbs[1].setSelected(!DeleteWindow.this.cbs[1].isSelected());
                    DeleteWindow.this.cbs[1].requestFocusInWindow();
                }
            });
            this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(51, 8), "focusCP3");
            this.rootPane.getActionMap().put("focusCP3", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeleteWindow.this.cbs[2].setSelected(!DeleteWindow.this.cbs[2].isSelected());
                    DeleteWindow.this.cbs[2].requestFocusInWindow();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    for (int i = 0; i < DeleteWindow.this.cbs.length; ++i) {
                        DeleteWindow.this.cbs[i].setSelected(false);
                    }
                }
            });
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = e.getSource();
                    if (o == DeleteWindow.this.submit) {
                        DeleteWindow.this.closeDialog();
                    } else if (o == DeleteWindow.this.cancel) {
                        for (int i = 0; i < DeleteWindow.this.cbs.length; ++i) {
                            DeleteWindow.this.cbs[i].setSelected(false);
                        }
                        DeleteWindow.this.closeDialog();
                    }
                }
            };
            this.submit.addActionListener(al);
            this.cancel.addActionListener(al);
        }

        private ConditionalPanel[] showDeleteWindow() {
            int i;
            for (int i2 = 0; i2 < this.cbs.length; ++i2) {
                this.cbs[i2].setSelected(false);
                this.result[i2] = null;
            }
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
            ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
            for (i = 0; i < cps.length; ++i) {
                if (!this.cbs[i].isSelected()) continue;
                this.result[i] = cps[i];
            }
            for (i = 0; i < this.cbs.length; ++i) {
                this.cbs[i].setSelected(false);
            }
            return this.result;
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

