/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDNumberTextField;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class WizzardEmbedObjectConfig
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private EmbedObject embed;
    private ButtonPanel btnPanel;
    private PropertiesPanel propsPanel;
    private KDTabbedPane tabbedPane;

    public WizzardEmbedObjectConfig(Dialog w, SpreadContext context) {
        super(w);
        this._context = context;
        this.initComps();
    }

    public WizzardEmbedObjectConfig(Frame w, SpreadContext context) {
        super(w);
        this._context = context;
        this.initComps();
    }

    private void initComps() {
        this.setSize(500, 360);
        this.btnPanel = new ButtonPanel();
        this.tabbedPane = new KDTabbedPane();
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.tabbedPane, "Center");
        c.add((Component)((Object)this.btnPanel), "South");
        this.propsPanel = new PropertiesPanel(this._context);
        this.tabbedPane.addTab(CtrlEXTMessages.getMLS("prop", "\u5c5e\u6027"), (Component)((Object)this.propsPanel));
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        EmbedhLayer elayer = this._context.getBook().getActiveSheet().getEmbedments(false);
        if (elayer == null) {
            return false;
        }
        this.embed = elayer.getActiveSelectedEmbed();
        if (this.embed == null) {
            return false;
        }
        this.propsPanel.x.setNumberValue((Number)this.embed.getX());
        this.propsPanel.y.setNumberValue((Number)this.embed.getY());
        this.propsPanel.width.setNumberValue((Number)this.embed.getWidth());
        this.propsPanel.height.setNumberValue((Number)this.embed.getHeight());
        switch (this.embed.getAnchorMode()) {
            case 0: {
                this.propsPanel.anchorTwoCell.setSelected(true);
                this.propsPanel.anchorCellLT.setText(this.embed.getAnchorCellLT());
                this.propsPanel.anchorCellRB.setText(this.embed.getAnchorCellRB());
                break;
            }
            case 1: {
                this.propsPanel.anchorOneCell.setSelected(true);
                this.propsPanel.anchorCellLT.setText(this.embed.getAnchorCellLT());
                break;
            }
            case 2: {
                this.propsPanel.anchorAbsolute.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad embed anchor mode");
            }
        }
        return true;
    }

    public static class PropertiesPanel
    extends KDPanel {
        public KDRadioButton anchorTwoCell;
        public KDRadioButton anchorOneCell;
        public KDRadioButton anchorAbsolute;
        public RangeSelector anchorCellLT;
        public RangeSelector anchorCellRB;
        private KDPanel anchorCell;
        private SpreadContext _context;
        public KDNumberTextField x;
        public KDNumberTextField y;
        public KDNumberTextField width;
        public KDNumberTextField height;

        public PropertiesPanel(SpreadContext context) {
            this._context = context;
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.setLayout(null);
            ButtonGroup btnGroup = new ButtonGroup();
            this.anchorTwoCell = new KDRadioButton(CtrlEXTMessages.getMLS("resizeWithCell", "\u5927\u5c0f\u3001\u4f4d\u7f6e\u968f\u5355\u5143\u683c\u800c\u53d8"));
            this.anchorOneCell = new KDRadioButton(CtrlEXTMessages.getMLS("fixedSizePositionWithCell", "\u5927\u5c0f\u56fa\u5b9a\uff0c\u4f4d\u7f6e\u968f\u5355\u5143\u683c\u800c\u53d8"));
            this.anchorAbsolute = new KDRadioButton(CtrlEXTMessages.getMLS("fixedSizeAndPosition", "\u5927\u5c0f\u3001\u4f4d\u7f6e\u5747\u56fa\u5b9a"));
            btnGroup.add((AbstractButton)this.anchorTwoCell);
            btnGroup.add((AbstractButton)this.anchorOneCell);
            btnGroup.add((AbstractButton)this.anchorAbsolute);
            KDPanel locations = new KDPanel();
            locations.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("objectPosition", "\u5bf9\u8c61\u4f4d\u7f6e")));
            TableLayout2 locationsLayout = new TableLayout2(5, 3);
            locations.setLayout((LayoutManager)locationsLayout);
            locations.setBounds(10, 10, 270, 140);
            locationsLayout.setFixedHeight(0, 8);
            int[] rowsLocation = new int[]{1, 2, 3};
            locationsLayout.setFixedHeight(rowsLocation, 20);
            locationsLayout.setRatableHeight(4, 100);
            int[] rowsSapcingLocation = new int[]{1, 2};
            locationsLayout.setRowsSpacing(rowsSapcingLocation, 4);
            locationsLayout.setFixedWidth(0, 8);
            locationsLayout.setRatableWidth(1, 100);
            locationsLayout.setFixedWidth(2, 8);
            locations.add((Component)this.anchorTwoCell, (Object)TableLayout2.param((int)1, (int)1));
            locations.add((Component)this.anchorOneCell, (Object)TableLayout2.param((int)2, (int)1));
            locations.add((Component)this.anchorAbsolute, (Object)TableLayout2.param((int)3, (int)1));
            this.add((Component)locations);
            this.anchorCell = new KDPanel();
            this.anchorCellLT = new RangeSelector(this._context);
            this.anchorCellRB = new RangeSelector(this._context);
            this.anchorCell.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("anchoredCell", "\u951a\u5b9a\u7684\u5355\u5143\u683c")));
            this.add((Component)this.anchorCell);
            KDPanel pointSize = new KDPanel();
            pointSize.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("positionSize", "\u4f4d\u7f6e/\u5bbd\u9ad8")));
            TableLayout2 pointSizeLayout = new TableLayout2(6, 3);
            pointSize.setLayout((LayoutManager)pointSizeLayout);
            pointSize.setBounds(300, 10, 220, 140);
            this.x = new KDNumberTextField();
            this.x.setToolTipText(CtrlEXTMessages.getMLS("range0To1500", "\u8303\u56f4\uff1a0~1500"));
            this.x.setGroupingUsed(false);
            this.x.setMinimumNumber((Number)0);
            this.x.setMaximumNumber((Number)1500);
            this.y = new KDNumberTextField();
            this.y.setToolTipText(CtrlEXTMessages.getMLS("range0To1500", "\u8303\u56f4\uff1a0~1500"));
            this.y.setGroupingUsed(false);
            this.y.setMinimumNumber((Number)0);
            this.y.setMaximumNumber((Number)1500);
            this.width = new KDNumberTextField();
            this.width.setToolTipText(CtrlEXTMessages.getMLS("range20To2000", "\u8303\u56f4\uff1a20~2000"));
            this.width.setGroupingUsed(false);
            this.width.setMinimumNumber((Number)20);
            this.width.setMaximumNumber((Number)2000);
            this.height = new KDNumberTextField();
            this.height.setToolTipText(CtrlEXTMessages.getMLS("range20To1500", "\u8303\u56f4\uff1a20~1500"));
            this.height.setGroupingUsed(false);
            this.height.setMinimumNumber((Number)20);
            this.height.setMaximumNumber((Number)1500);
            pointSizeLayout.setFixedHeight(0, 8);
            int[] rowsPointSize = new int[]{1, 2, 3, 4};
            pointSizeLayout.setFixedHeight(rowsPointSize, 20);
            pointSizeLayout.setRatableHeight(5, 100);
            int[] rowsSapcingPointSize = new int[]{1, 2, 3};
            pointSizeLayout.setRowsSpacing(rowsSapcingPointSize, 4);
            pointSizeLayout.setFixedWidth(0, 8);
            pointSizeLayout.setRatableWidth(1, 100);
            pointSizeLayout.setFixedWidth(2, 8);
            pointSize.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.x, (String)CtrlEXTMessages.getMLS("xAxis", "\u6a2a\u5750\u6807"), (int)80), (Object)TableLayout2.param((int)1, (int)1));
            pointSize.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.y, (String)CtrlEXTMessages.getMLS("yAxis", "\u7eb5\u5750\u6807"), (int)80), (Object)TableLayout2.param((int)2, (int)1));
            pointSize.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.width, (String)CtrlEXTMessages.getMLS("width", "\u5bbd\u5ea6"), (int)80), (Object)TableLayout2.param((int)3, (int)1));
            pointSize.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.height, (String)CtrlEXTMessages.getMLS("height", "\u9ad8\u5ea6"), (int)80), (Object)TableLayout2.param((int)4, (int)1));
            this.add((Component)pointSize);
        }

        private void initListeners() {
            this.anchorTwoCell.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (anchorTwoCell.isSelected()) {
                        anchorCell.removeAll();
                        anchorCell.setVisible(true);
                        TableLayout2 anchorCellLayout = new TableLayout2(4, 3);
                        anchorCell.setLayout((LayoutManager)anchorCellLayout);
                        anchorCellLayout.setFixedHeight(0, 8);
                        int[] rowsAnchorCell = new int[]{1, 2};
                        anchorCellLayout.setFixedHeight(rowsAnchorCell, 20);
                        anchorCellLayout.setRatableHeight(3, 100);
                        anchorCellLayout.setRowSpacing(1, 4);
                        anchorCellLayout.setFixedWidth(0, 8);
                        anchorCellLayout.setRatableWidth(1, 100);
                        anchorCellLayout.setFixedWidth(2, 8);
                        anchorCell.setBounds(10, 160, 270, 88);
                        anchorCell.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)anchorCellLT, (String)CtrlEXTMessages.getMLS("topLeft", "\u5de6\u4e0a\u89d2"), (int)80), (Object)TableLayout2.param((int)1, (int)1));
                        anchorCell.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)anchorCellRB, (String)CtrlEXTMessages.getMLS("bottomRight", "\u53f3\u4e0b\u89d2"), (int)80), (Object)TableLayout2.param((int)2, (int)1));
                        anchorCell.revalidate();
                    }
                }
            });
            this.anchorOneCell.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (anchorOneCell.isSelected()) {
                        anchorCell.removeAll();
                        anchorCell.setVisible(true);
                        TableLayout2 anchorCellLayout = new TableLayout2(3, 3);
                        anchorCell.setLayout((LayoutManager)anchorCellLayout);
                        anchorCellLayout.setFixedHeight(0, 8);
                        anchorCellLayout.setFixedHeight(1, 20);
                        anchorCellLayout.setRatableHeight(2, 100);
                        anchorCellLayout.setFixedWidth(0, 8);
                        anchorCellLayout.setRatableWidth(1, 100);
                        anchorCellLayout.setFixedWidth(2, 8);
                        anchorCell.setBounds(10, 160, 220, 64);
                        anchorCell.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)anchorCellLT, (String)CtrlEXTMessages.getMLS("topLeft", "\u5de6\u4e0a\u89d2"), (int)80), (Object)TableLayout2.param((int)1, (int)1));
                        anchorCell.revalidate();
                    }
                }
            });
            this.anchorAbsolute.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (anchorAbsolute.isSelected()) {
                        anchorCell.removeAll();
                        anchorCell.setVisible(false);
                    }
                }
            });
        }
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton cancel;
        private KDButton ok;

        ButtonPanel() {
            this.setPreferredSize(new Dimension(500, 35));
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.cancel = new KDButton();
            this.ok = new KDButton();
            this.cancel.setText(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
            this.ok.setText(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(392, Short.MAX_VALUE).add((Component)this.ok).addPreferredGap(1).add((Component)this.cancel).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.ok)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        private void initListeners() {
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardEmbedObjectConfig.this.setVisible(false);
                }
            });
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorTwoCell.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(0);
                        WizzardEmbedObjectConfig.this.embed.setAnchorCellLT(((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorCellLT.getText());
                        WizzardEmbedObjectConfig.this.embed.setAnchorCellRB(((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorCellRB.getText());
                    } else if (((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorOneCell.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(1);
                        WizzardEmbedObjectConfig.this.embed.setAnchorCellLT(((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorCellLT.getText());
                    } else if (((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.anchorAbsolute.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(2);
                    }
                    int x = ((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.x.getNumberValue().intValue();
                    int y = ((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.y.getNumberValue().intValue();
                    int w = ((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.width.getNumberValue().intValue();
                    int h = ((WizzardEmbedObjectConfig)WizzardEmbedObjectConfig.this).propsPanel.height.getNumberValue().intValue();
                    WizzardEmbedObjectConfig.this.embed.setBounds(x, y, w, h);
                    WizzardEmbedObjectConfig.this.setVisible(false);
                    WizzardEmbedObjectConfig.this._context.repaint();
                }
            });
        }
    }
}

